/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.app.ActivityManagerNative;
import android.app.IUiModeManager;
import android.app.ProgressDialog;
import android.app.UiModeManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.media.AudioManager;
import android.media.IAudioService;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.LocalPowerManager;
import android.os.Message;
import android.os.MessageQueue;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UEventObserver;
import android.os.Vibrator;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.view.IApplicationToken;
import android.view.IWindowManager;
import android.view.InputChannel;
import android.view.InputHandler;
import android.view.InputQueue;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.WindowManagerPolicy;
import android.view.WindowOrientationListener;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.android.internal.app.ShutdownThread;
import com.android.internal.policy.PolicyManager;
import com.android.internal.policy.impl.GlobalActions;
import com.android.internal.policy.impl.KeyguardViewManager;
import com.android.internal.policy.impl.KeyguardViewMediator;
import com.android.internal.policy.impl.RecentApplicationsDialog;
import com.android.internal.policy.impl.ShortcutManager;
import com.android.internal.statusbar.IStatusBarService;
import com.android.internal.telephony.ITelephony;
import com.android.internal.view.BaseInputHandler;
import com.android.internal.widget.PointerLocationView;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class PhoneWindowManager
implements WindowManagerPolicy {
    static final String TAG = "WindowManager";
    static final boolean DEBUG = false;
    static final boolean localLOGV = false;
    static final boolean DEBUG_LAYOUT = false;
    static final boolean DEBUG_FALLBACK = false;
    static final boolean SHOW_STARTING_ANIMATIONS = true;
    static final boolean SHOW_PROCESSES_ON_ALT_MENU = false;
    static final boolean ENABLE_CAR_DOCK_HOME_CAPTURE = true;
    static final boolean ENABLE_DESK_DOCK_HOME_CAPTURE = false;
    static final int LONG_PRESS_POWER_NOTHING = 0;
    static final int LONG_PRESS_POWER_GLOBAL_ACTIONS = 1;
    static final int LONG_PRESS_POWER_SHUT_OFF = 2;
    static final int LONG_PRESS_HOME_NOTHING = 0;
    static final int LONG_PRESS_HOME_RECENT_DIALOG = 1;
    static final int LONG_PRESS_HOME_RECENT_SYSTEM_UI = 2;
    static final int WALLPAPER_LAYER = 2;
    static final int APPLICATION_LAYER = 2;
    static final int PHONE_LAYER = 3;
    static final int SEARCH_BAR_LAYER = 4;
    static final int SYSTEM_DIALOG_LAYER = 5;
    static final int TOAST_LAYER = 6;
    static final int PRIORITY_PHONE_LAYER = 7;
    static final int SYSTEM_ALERT_LAYER = 8;
    static final int INPUT_METHOD_LAYER = 9;
    static final int INPUT_METHOD_DIALOG_LAYER = 10;
    static final int KEYGUARD_LAYER = 11;
    static final int KEYGUARD_DIALOG_LAYER = 12;
    static final int STATUS_BAR_SUB_PANEL_LAYER = 13;
    static final int STATUS_BAR_LAYER = 14;
    static final int STATUS_BAR_PANEL_LAYER = 15;
    static final int VOLUME_OVERLAY_LAYER = 16;
    static final int SYSTEM_OVERLAY_LAYER = 17;
    static final int NAVIGATION_BAR_LAYER = 18;
    static final int SYSTEM_ERROR_LAYER = 19;
    static final int DRAG_LAYER = 20;
    static final int SECURE_SYSTEM_OVERLAY_LAYER = 21;
    static final int BOOT_PROGRESS_LAYER = 22;
    static final int POINTER_LAYER = 23;
    static final int HIDDEN_NAV_CONSUMER_LAYER = 24;
    static final int APPLICATION_MEDIA_SUBLAYER = -2;
    static final int APPLICATION_MEDIA_OVERLAY_SUBLAYER = -1;
    static final int APPLICATION_PANEL_SUBLAYER = 1;
    static final int APPLICATION_SUB_PANEL_SUBLAYER = 2;
    public static final String SYSTEM_DIALOG_REASON_KEY = "reason";
    public static final String SYSTEM_DIALOG_REASON_GLOBAL_ACTIONS = "globalactions";
    public static final String SYSTEM_DIALOG_REASON_RECENT_APPS = "recentapps";
    public static final String SYSTEM_DIALOG_REASON_HOME_KEY = "homekey";
    private static final int SW_LID = 0;
    private static final int BTN_MOUSE = 272;
    static SparseArray<String> sApplicationLaunchKeyCategories = new SparseArray();
    final Object mLock = new Object();
    Context mContext;
    IWindowManager mWindowManager;
    WindowManagerPolicy.WindowManagerFuncs mWindowManagerFuncs;
    LocalPowerManager mPowerManager;
    IStatusBarService mStatusBarService;
    Vibrator mVibrator;
    long[] mLongPressVibePattern;
    long[] mVirtualKeyVibePattern;
    long[] mKeyboardTapVibePattern;
    long[] mSafeModeDisabledVibePattern;
    long[] mSafeModeEnabledVibePattern;
    boolean mEnableShiftMenuBugReports = false;
    boolean mSafeMode;
    WindowManagerPolicy.WindowState mStatusBar = null;
    boolean mStatusBarCanHide;
    int mStatusBarHeight;
    final ArrayList<WindowManagerPolicy.WindowState> mStatusBarPanels = new ArrayList();
    WindowManagerPolicy.WindowState mNavigationBar = null;
    boolean mHasNavigationBar = false;
    int mNavigationBarWidth = 0;
    int mNavigationBarHeight = 0;
    WindowManagerPolicy.WindowState mKeyguard = null;
    KeyguardViewMediator mKeyguardMediator;
    GlobalActions mGlobalActions;
    volatile boolean mPowerKeyHandled;
    boolean mPendingPowerKeyUpCanceled;
    Handler mHandler;
    static final int RECENT_APPS_BEHAVIOR_SHOW_OR_DISMISS = 0;
    static final int RECENT_APPS_BEHAVIOR_EXIT_TOUCH_MODE_AND_SHOW = 1;
    static final int RECENT_APPS_BEHAVIOR_DISMISS_AND_SWITCH = 2;
    RecentApplicationsDialog mRecentAppsDialog;
    int mRecentAppsDialogHeldModifiers;
    private static final int LID_ABSENT = -1;
    private static final int LID_CLOSED = 0;
    private static final int LID_OPEN = 1;
    int mLidOpen = -1;
    boolean mSystemReady;
    boolean mSystemBooted;
    boolean mHdmiPlugged;
    int mUiMode = 1;
    int mDockMode = 0;
    int mLidOpenRotation;
    int mCarDockRotation;
    int mDeskDockRotation;
    int mHdmiRotation;
    int mUserRotationMode = 0;
    int mUserRotation = 0;
    int mAllowAllRotations = -1;
    boolean mCarDockEnablesAccelerometer;
    boolean mDeskDockEnablesAccelerometer;
    int mLidKeyboardAccessibility;
    int mLidNavigationAccessibility;
    int mLongPressOnPowerBehavior = -1;
    boolean mScreenOnEarly = false;
    boolean mScreenOnFully = false;
    boolean mOrientationSensorEnabled = false;
    int mCurrentAppOrientation = -1;
    static final int DEFAULT_ACCELEROMETER_ROTATION = 0;
    int mAccelerometerDefault = 0;
    boolean mHasSoftInput = false;
    int mPointerLocationMode = 0;
    PointerLocationView mPointerLocationView = null;
    InputChannel mPointerLocationInputChannel;
    WindowManagerPolicy.WindowState mFocusedWindow;
    IApplicationToken mFocusedApp;
    private final InputHandler mPointerLocationInputHandler = new BaseInputHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMotion(MotionEvent event, InputQueue.FinishedCallback finishedCallback) {
            block7: {
                boolean handled = false;
                try {
                    if ((event.getSource() & 2) == 0) break block7;
                    Object object = PhoneWindowManager.this.mLock;
                    synchronized (object) {
                        if (PhoneWindowManager.this.mPointerLocationView != null) {
                            PhoneWindowManager.this.mPointerLocationView.addPointerEvent(event);
                            handled = true;
                        }
                    }
                }
                finally {
                    finishedCallback.finished(handled);
                }
            }
        }
    };
    int mUnrestrictedScreenLeft;
    int mUnrestrictedScreenTop;
    int mUnrestrictedScreenWidth;
    int mUnrestrictedScreenHeight;
    int mRestrictedScreenLeft;
    int mRestrictedScreenTop;
    int mRestrictedScreenWidth;
    int mRestrictedScreenHeight;
    int mCurLeft;
    int mCurTop;
    int mCurRight;
    int mCurBottom;
    int mContentLeft;
    int mContentTop;
    int mContentRight;
    int mContentBottom;
    int mDockLeft;
    int mDockTop;
    int mDockRight;
    int mDockBottom;
    int mDockLayer;
    int mLastSystemUiFlags;
    int mResettingSystemUiFlags = 0;
    int mForceClearedSystemUiFlags = 0;
    boolean mLastFocusNeedsMenu = false;
    WindowManagerPolicy.FakeWindow mHideNavFakeWindow = null;
    static final Rect mTmpParentFrame;
    static final Rect mTmpDisplayFrame;
    static final Rect mTmpContentFrame;
    static final Rect mTmpVisibleFrame;
    static final Rect mTmpNavigationFrame;
    WindowManagerPolicy.WindowState mTopFullscreenOpaqueWindowState;
    boolean mTopIsFullscreen;
    boolean mForceStatusBar;
    boolean mHideLockScreen;
    boolean mDismissKeyguard;
    boolean mHomePressed;
    Intent mHomeIntent;
    Intent mCarDockIntent;
    Intent mDeskDockIntent;
    int mShortcutKeyPressed = -1;
    boolean mConsumeShortcutKeyUp;
    boolean mAllowLockscreenWhenOn;
    int mLockScreenTimeout;
    boolean mLockScreenTimerActive;
    int mEndcallBehavior;
    int mIncallPowerBehavior;
    int mLandscapeRotation = 0;
    int mSeascapeRotation = 0;
    int mPortraitRotation = 0;
    int mUpsideDownRotation = 0;
    private int mLongPressOnHomeBehavior = -1;
    private static final long SCREENSHOT_CHORD_DEBOUNCE_DELAY_MILLIS = 150L;
    private boolean mVolumeDownKeyTriggered;
    private long mVolumeDownKeyTime;
    private boolean mVolumeDownKeyConsumedByScreenshotChord;
    private boolean mVolumeUpKeyTriggered;
    private boolean mPowerKeyTriggered;
    private long mPowerKeyTime;
    ShortcutManager mShortcutManager;
    PowerManager.WakeLock mBroadcastWakeLock;
    final KeyCharacterMap.FallbackAction mFallbackAction = new KeyCharacterMap.FallbackAction();
    private UEventObserver mHDMIObserver = new UEventObserver(){

        public void onUEvent(UEventObserver.UEvent event) {
            PhoneWindowManager.this.setHdmiPlugged("1".equals(event.get("SWITCH_STATE")));
        }
    };
    MyOrientationListener mOrientationListener;
    private final Runnable mPowerLongPress = new Runnable(){

        public void run() {
            if (PhoneWindowManager.this.mLongPressOnPowerBehavior < 0) {
                PhoneWindowManager.this.mLongPressOnPowerBehavior = PhoneWindowManager.this.mContext.getResources().getInteger(17694738);
            }
            switch (PhoneWindowManager.this.mLongPressOnPowerBehavior) {
                case 0: {
                    break;
                }
                case 1: {
                    PhoneWindowManager.this.mPowerKeyHandled = true;
                    PhoneWindowManager.this.performHapticFeedbackLw(null, 0, false);
                    PhoneWindowManager.this.sendCloseSystemWindows(PhoneWindowManager.SYSTEM_DIALOG_REASON_GLOBAL_ACTIONS);
                    PhoneWindowManager.this.showGlobalActionsDialog();
                    break;
                }
                case 2: {
                    PhoneWindowManager.this.mPowerKeyHandled = true;
                    PhoneWindowManager.this.performHapticFeedbackLw(null, 0, false);
                    PhoneWindowManager.this.sendCloseSystemWindows(PhoneWindowManager.SYSTEM_DIALOG_REASON_GLOBAL_ACTIONS);
                    ShutdownThread.shutdown((Context)PhoneWindowManager.this.mContext, (boolean)true);
                }
            }
        }
    };
    private final Runnable mScreenshotChordLongPress = new Runnable(){

        public void run() {
            PhoneWindowManager.this.takeScreenshot();
        }
    };
    static final boolean PRINT_ANIM = false;
    private static final int[] WINDOW_TYPES_WHERE_HOME_DOESNT_WORK;
    final Runnable mAllowSystemUiDelay = new Runnable(){

        public void run() {
        }
    };
    final InputHandler mHideNavInputHandler = new BaseInputHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMotion(MotionEvent event, InputQueue.FinishedCallback finishedCallback) {
            block9: {
                boolean handled = false;
                try {
                    if ((event.getSource() & 2) == 0 || event.getAction() != 0) break block9;
                    boolean changed = false;
                    Object object = PhoneWindowManager.this.mLock;
                    synchronized (object) {
                        int newVal = PhoneWindowManager.this.mResettingSystemUiFlags | 2;
                        if (PhoneWindowManager.this.mResettingSystemUiFlags != newVal) {
                            PhoneWindowManager.this.mResettingSystemUiFlags = newVal;
                            changed = true;
                        }
                        if (PhoneWindowManager.this.mForceClearedSystemUiFlags != (newVal = PhoneWindowManager.this.mForceClearedSystemUiFlags | 2)) {
                            PhoneWindowManager.this.mForceClearedSystemUiFlags = newVal;
                            changed = true;
                            PhoneWindowManager.this.mHandler.postDelayed(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    Object object = PhoneWindowManager.this.mLock;
                                    synchronized (object) {
                                        PhoneWindowManager.this.mForceClearedSystemUiFlags &= 0xFFFFFFFD;
                                    }
                                    PhoneWindowManager.this.mWindowManagerFuncs.reevaluateStatusBarVisibility();
                                }
                            }, 1000L);
                        }
                    }
                    if (changed) {
                        PhoneWindowManager.this.mWindowManagerFuncs.reevaluateStatusBarVisibility();
                    }
                }
                finally {
                    finishedCallback.finished(handled);
                }
            }
        }
    };
    final Object mScreenshotLock = new Object();
    ServiceConnection mScreenshotConnection = null;
    final Runnable mScreenshotTimeout = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = PhoneWindowManager.this.mScreenshotLock;
            synchronized (object) {
                if (PhoneWindowManager.this.mScreenshotConnection != null) {
                    PhoneWindowManager.this.mContext.unbindService(PhoneWindowManager.this.mScreenshotConnection);
                    PhoneWindowManager.this.mScreenshotConnection = null;
                }
            }
        }
    };
    BroadcastReceiver mBroadcastDone = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            PhoneWindowManager.this.mBroadcastWakeLock.release();
        }
    };
    BroadcastReceiver mDockReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.DOCK_EVENT".equals(intent.getAction())) {
                PhoneWindowManager.this.mDockMode = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
            } else {
                try {
                    IUiModeManager uiModeService = IUiModeManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"uimode"));
                    PhoneWindowManager.this.mUiMode = uiModeService.getCurrentModeType();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            PhoneWindowManager.this.updateRotation(true);
            PhoneWindowManager.this.updateOrientationListenerLp();
        }
    };
    ProgressDialog mBootMsgDialog = null;
    Runnable mScreenLockTimeout = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            20 var1_1 = this;
            synchronized (var1_1) {
                PhoneWindowManager.this.mKeyguardMediator.doKeyguardTimeout();
                PhoneWindowManager.this.mLockScreenTimerActive = false;
            }
        }
    };

    boolean needSensorRunningLp() {
        if (this.mCurrentAppOrientation == 4 || this.mCurrentAppOrientation == 10 || this.mCurrentAppOrientation == 7 || this.mCurrentAppOrientation == 6) {
            return true;
        }
        if (this.mCarDockEnablesAccelerometer && this.mDockMode == 2 || this.mDeskDockEnablesAccelerometer && (this.mDockMode == 1 || this.mDockMode == 3 || this.mDockMode == 4)) {
            return true;
        }
        return this.mAccelerometerDefault != 0;
    }

    void updateOrientationListenerLp() {
        if (!this.mOrientationListener.canDetectOrientation()) {
            return;
        }
        boolean disable = true;
        if (this.mScreenOnEarly && this.needSensorRunningLp()) {
            disable = false;
            if (!this.mOrientationSensorEnabled) {
                this.mOrientationListener.enable();
                this.mOrientationSensorEnabled = true;
            }
        }
        if (disable && this.mOrientationSensorEnabled) {
            this.mOrientationListener.disable();
            this.mOrientationSensorEnabled = false;
        }
    }

    private void interceptPowerKeyDown(boolean handled) {
        this.mPowerKeyHandled = handled;
        if (!handled) {
            this.mHandler.postDelayed(this.mPowerLongPress, ViewConfiguration.getGlobalActionKeyTimeout());
        }
    }

    private boolean interceptPowerKeyUp(boolean canceled) {
        if (!this.mPowerKeyHandled) {
            this.mHandler.removeCallbacks(this.mPowerLongPress);
            return !canceled;
        }
        return false;
    }

    private void cancelPendingPowerKeyAction() {
        if (!this.mPowerKeyHandled) {
            this.mHandler.removeCallbacks(this.mPowerLongPress);
        }
        if (this.mPowerKeyTriggered) {
            this.mPendingPowerKeyUpCanceled = true;
        }
    }

    private void interceptScreenshotChord() {
        long now;
        if (this.mVolumeDownKeyTriggered && this.mPowerKeyTriggered && !this.mVolumeUpKeyTriggered && (now = SystemClock.uptimeMillis()) <= this.mVolumeDownKeyTime + 150L && now <= this.mPowerKeyTime + 150L) {
            this.mVolumeDownKeyConsumedByScreenshotChord = true;
            this.cancelPendingPowerKeyAction();
            this.mHandler.postDelayed(this.mScreenshotChordLongPress, ViewConfiguration.getGlobalActionKeyTimeout());
        }
    }

    private void cancelPendingScreenshotChordAction() {
        this.mHandler.removeCallbacks(this.mScreenshotChordLongPress);
    }

    void showGlobalActionsDialog() {
        if (this.mGlobalActions == null) {
            this.mGlobalActions = new GlobalActions(this.mContext);
        }
        boolean keyguardShowing = this.mKeyguardMediator.isShowingAndNotHidden();
        this.mGlobalActions.showDialog(keyguardShowing, this.isDeviceProvisioned());
        if (keyguardShowing) {
            this.mKeyguardMediator.pokeWakelock();
        }
    }

    boolean isDeviceProvisioned() {
        return Settings.Secure.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"device_provisioned", (int)0) != 0;
    }

    private void handleLongPressOnHome() {
        if (this.mLongPressOnHomeBehavior < 0) {
            this.mLongPressOnHomeBehavior = this.mContext.getResources().getInteger(17694749);
            if (this.mLongPressOnHomeBehavior < 0 || this.mLongPressOnHomeBehavior > 2) {
                this.mLongPressOnHomeBehavior = 0;
            }
        }
        if (this.mLongPressOnHomeBehavior != 0) {
            this.performHapticFeedbackLw(null, 0, false);
            this.sendCloseSystemWindows(SYSTEM_DIALOG_REASON_RECENT_APPS);
            this.mHomePressed = false;
        }
        if (this.mLongPressOnHomeBehavior == 1) {
            this.showOrHideRecentAppsDialog(0);
        } else if (this.mLongPressOnHomeBehavior == 2) {
            try {
                this.mStatusBarService.toggleRecentApps();
            }
            catch (RemoteException e) {
                Slog.e((String)TAG, (String)"RemoteException when showing recent apps", (Throwable)e);
            }
        }
    }

    void showOrHideRecentAppsDialog(final int behavior) {
        this.mHandler.post(new Runnable(){

            public void run() {
                if (PhoneWindowManager.this.mRecentAppsDialog == null) {
                    PhoneWindowManager.this.mRecentAppsDialog = new RecentApplicationsDialog(PhoneWindowManager.this.mContext);
                }
                if (PhoneWindowManager.this.mRecentAppsDialog.isShowing()) {
                    switch (behavior) {
                        case 0: {
                            PhoneWindowManager.this.mRecentAppsDialog.dismiss();
                            break;
                        }
                        case 2: {
                            PhoneWindowManager.this.mRecentAppsDialog.dismissAndSwitch();
                            break;
                        }
                    }
                } else {
                    switch (behavior) {
                        case 0: {
                            PhoneWindowManager.this.mRecentAppsDialog.show();
                            break;
                        }
                        case 1: {
                            try {
                                PhoneWindowManager.this.mWindowManager.setInTouchMode(false);
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                            PhoneWindowManager.this.mRecentAppsDialog.show();
                            break;
                        }
                    }
                }
            }
        });
    }

    public void init(Context context, IWindowManager windowManager, WindowManagerPolicy.WindowManagerFuncs windowManagerFuncs, LocalPowerManager powerManager) {
        this.mContext = context;
        this.mWindowManager = windowManager;
        this.mWindowManagerFuncs = windowManagerFuncs;
        this.mPowerManager = powerManager;
        this.mKeyguardMediator = new KeyguardViewMediator(context, this, powerManager);
        this.mHandler = new Handler();
        this.mOrientationListener = new MyOrientationListener(this.mContext);
        try {
            this.mOrientationListener.setCurrentRotation(windowManager.getRotation());
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        SettingsObserver settingsObserver = new SettingsObserver(this.mHandler);
        settingsObserver.observe();
        this.mShortcutManager = new ShortcutManager(context, this.mHandler);
        this.mShortcutManager.observe();
        this.mHomeIntent = new Intent("android.intent.action.MAIN", null);
        this.mHomeIntent.addCategory("android.intent.category.HOME");
        this.mHomeIntent.addFlags(0x10200000);
        this.mCarDockIntent = new Intent("android.intent.action.MAIN", null);
        this.mCarDockIntent.addCategory("android.intent.category.CAR_DOCK");
        this.mCarDockIntent.addFlags(0x10200000);
        this.mDeskDockIntent = new Intent("android.intent.action.MAIN", null);
        this.mDeskDockIntent.addCategory("android.intent.category.DESK_DOCK");
        this.mDeskDockIntent.addFlags(0x10200000);
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mBroadcastWakeLock = pm.newWakeLock(1, "PhoneWindowManager.mBroadcastWakeLock");
        this.mEnableShiftMenuBugReports = "1".equals(SystemProperties.get((String)"ro.debuggable"));
        this.mLidOpenRotation = this.readRotation(17694731);
        this.mCarDockRotation = this.readRotation(17694733);
        this.mDeskDockRotation = this.readRotation(17694732);
        this.mCarDockEnablesAccelerometer = this.mContext.getResources().getBoolean(0x1110016);
        this.mDeskDockEnablesAccelerometer = this.mContext.getResources().getBoolean(0x1110015);
        this.mLidKeyboardAccessibility = this.mContext.getResources().getInteger(0x10E0010);
        this.mLidNavigationAccessibility = this.mContext.getResources().getInteger(0x10E0011);
        IntentFilter filter = new IntentFilter();
        filter.addAction(UiModeManager.ACTION_ENTER_CAR_MODE);
        filter.addAction(UiModeManager.ACTION_EXIT_CAR_MODE);
        filter.addAction(UiModeManager.ACTION_ENTER_DESK_MODE);
        filter.addAction(UiModeManager.ACTION_EXIT_DESK_MODE);
        filter.addAction("android.intent.action.DOCK_EVENT");
        Intent intent = context.registerReceiver(this.mDockReceiver, filter);
        if (intent != null) {
            this.mDockMode = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
        }
        this.mVibrator = new Vibrator();
        this.mLongPressVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17235999);
        this.mVirtualKeyVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17236000);
        this.mKeyboardTapVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17236001);
        this.mSafeModeDisabledVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17236002);
        this.mSafeModeEnabledVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17236003);
        this.initializeHdmiState();
        if (this.mPowerManager.isScreenOn()) {
            this.screenTurningOn(null);
        } else {
            this.screenTurnedOff(2);
        }
    }

    public void setInitialDisplaySize(int width, int height) {
        int shortSize;
        if (width > height) {
            shortSize = height;
            this.mLandscapeRotation = 0;
            this.mSeascapeRotation = 2;
            if (this.mContext.getResources().getBoolean(0x1110014)) {
                this.mPortraitRotation = 1;
                this.mUpsideDownRotation = 3;
            } else {
                this.mPortraitRotation = 3;
                this.mUpsideDownRotation = 1;
            }
        } else {
            shortSize = width;
            this.mPortraitRotation = 0;
            this.mUpsideDownRotation = 2;
            if (this.mContext.getResources().getBoolean(0x1110014)) {
                this.mLandscapeRotation = 3;
                this.mSeascapeRotation = 1;
            } else {
                this.mLandscapeRotation = 1;
                this.mSeascapeRotation = 3;
            }
        }
        int shortSizeDp = shortSize * 160 / DisplayMetrics.DENSITY_DEVICE;
        this.mStatusBarCanHide = shortSizeDp < 600;
        this.mStatusBarHeight = this.mContext.getResources().getDimensionPixelSize(this.mStatusBarCanHide ? 17104906 : 17104907);
        this.mHasNavigationBar = this.mContext.getResources().getBoolean(17891374);
        String navBarOverride = SystemProperties.get((String)"qemu.hw.mainkeys");
        if (!"".equals(navBarOverride)) {
            if (navBarOverride.equals("1")) {
                this.mHasNavigationBar = false;
            } else if (navBarOverride.equals("0")) {
                this.mHasNavigationBar = true;
            }
        }
        this.mNavigationBarHeight = this.mHasNavigationBar ? this.mContext.getResources().getDimensionPixelSize(17104908) : 0;
        this.mNavigationBarWidth = this.mHasNavigationBar ? this.mContext.getResources().getDimensionPixelSize(17104909) : 0;
        this.mHdmiRotation = "portrait".equals(SystemProperties.get((String)"persist.demo.hdmirotation")) ? this.mPortraitRotation : this.mLandscapeRotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSettings() {
        ContentResolver resolver = this.mContext.getContentResolver();
        boolean updateRotation = false;
        PointerLocationView addView = null;
        PointerLocationView removeView = null;
        Object object = this.mLock;
        synchronized (object) {
            boolean hasSoftInput;
            int pointerLocation;
            this.mEndcallBehavior = Settings.System.getInt((ContentResolver)resolver, (String)"end_button_behavior", (int)2);
            this.mIncallPowerBehavior = Settings.Secure.getInt((ContentResolver)resolver, (String)"incall_power_button_behavior", (int)1);
            int accelerometerDefault = Settings.System.getInt((ContentResolver)resolver, (String)"accelerometer_rotation", (int)0);
            this.mUserRotationMode = accelerometerDefault == 0 ? 1 : 0;
            this.mUserRotation = Settings.System.getInt((ContentResolver)resolver, (String)"user_rotation", (int)0);
            if (this.mAccelerometerDefault != accelerometerDefault) {
                this.mAccelerometerDefault = accelerometerDefault;
                this.updateOrientationListenerLp();
            }
            this.mOrientationListener.setLogEnabled(Settings.System.getInt((ContentResolver)resolver, (String)"window_orientation_listener_log", (int)0) != 0);
            if (this.mSystemReady && this.mPointerLocationMode != (pointerLocation = Settings.System.getInt((ContentResolver)resolver, (String)"pointer_location", (int)0))) {
                this.mPointerLocationMode = pointerLocation;
                if (pointerLocation != 0) {
                    if (this.mPointerLocationView == null) {
                        this.mPointerLocationView = new PointerLocationView(this.mContext);
                        this.mPointerLocationView.setPrintCoords(false);
                        addView = this.mPointerLocationView;
                    }
                } else {
                    removeView = this.mPointerLocationView;
                    this.mPointerLocationView = null;
                }
            }
            this.mLockScreenTimeout = Settings.System.getInt((ContentResolver)resolver, (String)"screen_off_timeout", (int)0);
            String imId = Settings.Secure.getString((ContentResolver)resolver, (String)"default_input_method");
            boolean bl = hasSoftInput = imId != null && imId.length() > 0;
            if (this.mHasSoftInput != hasSoftInput) {
                this.mHasSoftInput = hasSoftInput;
                updateRotation = true;
            }
        }
        if (updateRotation) {
            this.updateRotation(true);
        }
        if (addView != null) {
            WindowManager.LayoutParams lp = new WindowManager.LayoutParams(-1, -1);
            lp.type = 2015;
            lp.flags = 1304;
            lp.format = -3;
            lp.setTitle((CharSequence)"PointerLocation");
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            lp.inputFeatures |= 2;
            wm.addView((View)addView, (ViewGroup.LayoutParams)lp);
            if (this.mPointerLocationInputChannel == null) {
                try {
                    this.mPointerLocationInputChannel = this.mWindowManager.monitorInput("PointerLocationView");
                    InputQueue.registerInputChannel((InputChannel)this.mPointerLocationInputChannel, (InputHandler)this.mPointerLocationInputHandler, (MessageQueue)this.mHandler.getLooper().getQueue());
                }
                catch (RemoteException ex) {
                    Slog.e((String)TAG, (String)"Could not set up input monitoring channel for PointerLocation.", (Throwable)ex);
                }
            }
        }
        if (removeView != null) {
            if (this.mPointerLocationInputChannel != null) {
                InputQueue.unregisterInputChannel((InputChannel)this.mPointerLocationInputChannel);
                this.mPointerLocationInputChannel.dispose();
                this.mPointerLocationInputChannel = null;
            }
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            wm.removeView((View)removeView);
        }
    }

    private int readRotation(int resID) {
        try {
            int rotation = this.mContext.getResources().getInteger(resID);
            switch (rotation) {
                case 0: {
                    return 0;
                }
                case 90: {
                    return 1;
                }
                case 180: {
                    return 2;
                }
                case 270: {
                    return 3;
                }
            }
        }
        catch (Resources.NotFoundException notFoundException) {
            // empty catch block
        }
        return -1;
    }

    public int checkAddPermission(WindowManager.LayoutParams attrs) {
        int type = attrs.type;
        if (type < 2000 || type > 2999) {
            return 0;
        }
        String permission = null;
        switch (type) {
            case 2005: {
                break;
            }
            case 2011: 
            case 2013: {
                break;
            }
            case 2002: 
            case 2003: 
            case 2006: 
            case 2007: 
            case 2010: {
                permission = "android.permission.SYSTEM_ALERT_WINDOW";
                break;
            }
            default: {
                permission = "android.permission.INTERNAL_SYSTEM_WINDOW";
            }
        }
        if (permission != null && this.mContext.checkCallingOrSelfPermission(permission) != 0) {
            return -8;
        }
        return 0;
    }

    public void adjustWindowParamsLw(WindowManager.LayoutParams attrs) {
        switch (attrs.type) {
            case 2005: 
            case 2006: 
            case 2015: {
                attrs.flags |= 0x18;
                attrs.flags &= 0xFFFBFFFF;
            }
        }
    }

    void readLidState() {
        try {
            int sw = this.mWindowManager.getSwitchState(0);
            this.mLidOpen = sw > 0 ? 1 : (sw == 0 ? 0 : -1);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private int determineHiddenState(int mode, int hiddenValue, int visibleValue) {
        if (this.mLidOpen != -1) {
            switch (mode) {
                case 1: {
                    return this.mLidOpen == 1 ? visibleValue : hiddenValue;
                }
                case 2: {
                    return this.mLidOpen == 1 ? hiddenValue : visibleValue;
                }
            }
        }
        return visibleValue;
    }

    public void adjustConfigurationLw(Configuration config) {
        this.readLidState();
        this.updateKeyboardVisibility();
        config.hardKeyboardHidden = config.keyboard == 1 ? 2 : this.determineHiddenState(this.mLidKeyboardAccessibility, 2, 1);
        config.navigationHidden = config.navigation == 1 ? 2 : this.determineHiddenState(this.mLidNavigationAccessibility, 2, 1);
        config.keyboardHidden = this.mHasSoftInput || config.hardKeyboardHidden == 1 ? 1 : 2;
    }

    public int windowTypeToLayerLw(int type) {
        if (type >= 1 && type <= 99) {
            return 2;
        }
        switch (type) {
            case 2000: {
                return 14;
            }
            case 2014: {
                return 15;
            }
            case 2017: {
                return 13;
            }
            case 2008: {
                return 5;
            }
            case 2001: {
                return 4;
            }
            case 2002: {
                return 3;
            }
            case 2004: {
                return 11;
            }
            case 2009: {
                return 12;
            }
            case 2003: {
                return 8;
            }
            case 2010: {
                return 19;
            }
            case 2011: {
                return 9;
            }
            case 2012: {
                return 10;
            }
            case 2020: {
                return 16;
            }
            case 2006: {
                return 17;
            }
            case 2015: {
                return 21;
            }
            case 2007: {
                return 7;
            }
            case 2005: {
                return 6;
            }
            case 2013: {
                return 2;
            }
            case 2016: {
                return 20;
            }
            case 2018: {
                return 23;
            }
            case 2019: {
                return 18;
            }
            case 2021: {
                return 22;
            }
            case 2022: {
                return 24;
            }
        }
        Log.e((String)TAG, (String)("Unknown window type: " + type));
        return 2;
    }

    public int subWindowTypeToLayerLw(int type) {
        switch (type) {
            case 1000: 
            case 1003: {
                return 1;
            }
            case 1001: {
                return -2;
            }
            case 1004: {
                return -1;
            }
            case 1002: {
                return 2;
            }
        }
        Log.e((String)TAG, (String)("Unknown sub-window type: " + type));
        return 0;
    }

    public int getMaxWallpaperLayer() {
        return 14;
    }

    public boolean canStatusBarHide() {
        return this.mStatusBarCanHide;
    }

    public int getNonDecorDisplayWidth(int fullWidth, int fullHeight, int rotation) {
        if (fullWidth > fullHeight) {
            return fullWidth - this.mNavigationBarWidth;
        }
        return fullWidth;
    }

    public int getNonDecorDisplayHeight(int fullWidth, int fullHeight, int rotation) {
        return fullHeight - (this.mStatusBarCanHide ? 0 : this.mStatusBarHeight) - (fullWidth > fullHeight ? 0 : this.mNavigationBarHeight);
    }

    public int getConfigDisplayWidth(int fullWidth, int fullHeight, int rotation) {
        return this.getNonDecorDisplayWidth(fullWidth, fullHeight, rotation);
    }

    public int getConfigDisplayHeight(int fullWidth, int fullHeight, int rotation) {
        return this.getNonDecorDisplayHeight(fullWidth, fullHeight, rotation) - (this.mStatusBarCanHide ? this.mStatusBarHeight : 0);
    }

    public boolean doesForceHide(WindowManagerPolicy.WindowState win, WindowManager.LayoutParams attrs) {
        return attrs.type == 2004;
    }

    public boolean canBeForceHidden(WindowManagerPolicy.WindowState win, WindowManager.LayoutParams attrs) {
        return attrs.type != 2000 && attrs.type != 2013;
    }

    public View addStartingWindow(IBinder appToken, String packageName, int theme, CompatibilityInfo compatInfo, CharSequence nonLocalizedLabel, int labelRes, int icon, int windowFlags) {
        if (packageName == null) {
            return null;
        }
        try {
            Window win;
            Context context = this.mContext;
            if (theme != context.getThemeResId() || labelRes != 0) {
                try {
                    context = context.createPackageContext(packageName, 0);
                    context.setTheme(theme);
                }
                catch (PackageManager.NameNotFoundException e) {
                    // empty catch block
                }
            }
            if ((win = PolicyManager.makeNewWindow((Context)context)).getWindowStyle().getBoolean(12, false)) {
                return null;
            }
            Resources r = context.getResources();
            win.setTitle(r.getText(labelRes, nonLocalizedLabel));
            win.setType(3);
            win.setFlags(windowFlags | 0x10 | 8 | 0x20000, windowFlags | 0x10 | 8 | 0x20000);
            if (!compatInfo.supportsScreen()) {
                win.addFlags(0x20000000);
            }
            win.setLayout(-1, -1);
            WindowManager.LayoutParams params = win.getAttributes();
            params.token = appToken;
            params.packageName = packageName;
            params.windowAnimations = win.getWindowStyle().getResourceId(8, 0);
            params.privateFlags |= 1;
            params.setTitle((CharSequence)("Starting " + packageName));
            WindowManager wm = (WindowManager)context.getSystemService("window");
            View view = win.getDecorView();
            if (win.isFloating()) {
                return null;
            }
            wm.addView(view, (ViewGroup.LayoutParams)params);
            return view.getParent() != null ? view : null;
        }
        catch (WindowManager.BadTokenException e) {
            Log.w((String)TAG, (String)(appToken + " already running, starting window not displayed"));
        }
        catch (RuntimeException e) {
            Log.w((String)TAG, (String)(appToken + " failed creating starting window"), (Throwable)e);
        }
        return null;
    }

    public void removeStartingWindow(IBinder appToken, View window) {
        if (window != null) {
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            wm.removeView(window);
        }
    }

    public int prepareAddWindowLw(WindowManagerPolicy.WindowState win, WindowManager.LayoutParams attrs) {
        switch (attrs.type) {
            case 2000: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", "PhoneWindowManager");
                if (this.mStatusBar != null) {
                    return -7;
                }
                this.mStatusBar = win;
                break;
            }
            case 2019: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", "PhoneWindowManager");
                this.mNavigationBar = win;
                break;
            }
            case 2014: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", "PhoneWindowManager");
                this.mStatusBarPanels.add(win);
                break;
            }
            case 2017: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", "PhoneWindowManager");
                this.mStatusBarPanels.add(win);
                break;
            }
            case 2004: {
                if (this.mKeyguard != null) {
                    return -7;
                }
                this.mKeyguard = win;
            }
        }
        return 0;
    }

    public void removeWindowLw(WindowManagerPolicy.WindowState win) {
        if (this.mStatusBar == win) {
            this.mStatusBar = null;
        } else if (this.mKeyguard == win) {
            this.mKeyguard = null;
        } else if (this.mNavigationBar == win) {
            this.mNavigationBar = null;
        } else {
            this.mStatusBarPanels.remove(win);
        }
    }

    public int selectAnimationLw(WindowManagerPolicy.WindowState win, int transit) {
        if (transit == 5 && win.hasAppShownWindows()) {
            return 0x10A0011;
        }
        return 0;
    }

    public Animation createForceHideEnterAnimation() {
        return AnimationUtils.loadAnimation((Context)this.mContext, (int)17432607);
    }

    static ITelephony getTelephonyService() {
        ITelephony telephonyService = ITelephony.Stub.asInterface((IBinder)ServiceManager.checkService((String)"phone"));
        if (telephonyService == null) {
            Log.w((String)TAG, (String)"Unable to find ITelephony interface.");
        }
        return telephonyService;
    }

    static IAudioService getAudioService() {
        IAudioService audioService = IAudioService.Stub.asInterface((IBinder)ServiceManager.checkService((String)"audio"));
        if (audioService == null) {
            Log.w((String)TAG, (String)"Unable to find IAudioService interface.");
        }
        return audioService;
    }

    boolean keyguardOn() {
        return this.keyguardIsShowingTq() || this.inKeyguardRestrictedKeyInputMode();
    }

    public long interceptKeyBeforeDispatching(WindowManagerPolicy.WindowState win, KeyEvent event, int policyFlags) {
        String category;
        Intent shortcutIntent;
        KeyCharacterMap kcm;
        boolean keyguardOn = this.keyguardOn();
        int keyCode = event.getKeyCode();
        int repeatCount = event.getRepeatCount();
        int metaState = event.getMetaState();
        int flags = event.getFlags();
        boolean down = event.getAction() == 0;
        boolean canceled = event.isCanceled();
        if ((flags & 0x400) == 0) {
            long timeoutTime;
            long now;
            if (this.mVolumeDownKeyTriggered && !this.mPowerKeyTriggered && (now = SystemClock.uptimeMillis()) < (timeoutTime = this.mVolumeDownKeyTime + 150L)) {
                return timeoutTime - now;
            }
            if (keyCode == 25 && this.mVolumeDownKeyConsumedByScreenshotChord) {
                if (!down) {
                    this.mVolumeDownKeyConsumedByScreenshotChord = false;
                }
                return -1L;
            }
        }
        if (keyCode == 3) {
            WindowManager.LayoutParams attrs;
            if (this.mHomePressed && !down) {
                this.mHomePressed = false;
                if (!canceled) {
                    boolean incomingRinging = false;
                    try {
                        ITelephony telephonyService = PhoneWindowManager.getTelephonyService();
                        if (telephonyService != null) {
                            incomingRinging = telephonyService.isRinging();
                        }
                    }
                    catch (RemoteException ex) {
                        Log.w((String)TAG, (String)"RemoteException from getPhoneInterface()", (Throwable)ex);
                    }
                    if (incomingRinging) {
                        Log.i((String)TAG, (String)"Ignoring HOME; there's a ringing incoming call.");
                    } else {
                        this.launchHomeFromHotKey();
                    }
                } else {
                    Log.i((String)TAG, (String)"Ignoring HOME; event canceled.");
                }
                return -1L;
            }
            WindowManager.LayoutParams layoutParams = attrs = win != null ? win.getAttrs() : null;
            if (attrs != null) {
                int type = attrs.type;
                if (type == 2004 || type == 2009) {
                    return 0L;
                }
                int typeCount = WINDOW_TYPES_WHERE_HOME_DOESNT_WORK.length;
                for (int i = 0; i < typeCount; ++i) {
                    if (type != WINDOW_TYPES_WHERE_HOME_DOESNT_WORK[i]) continue;
                    return -1L;
                }
            }
            if (down) {
                if (repeatCount == 0) {
                    this.mHomePressed = true;
                } else if ((event.getFlags() & 0x80) != 0 && !keyguardOn) {
                    this.handleLongPressOnHome();
                }
            }
            return -1L;
        }
        if (keyCode == 82) {
            boolean chordBug = true;
            if (down && repeatCount == 0 && this.mEnableShiftMenuBugReports && (metaState & 1) == 1) {
                Intent intent = new Intent("android.intent.action.BUG_REPORT");
                this.mContext.sendOrderedBroadcast(intent, null);
                return -1L;
            }
        } else {
            if (keyCode == 84) {
                if (down) {
                    if (repeatCount == 0) {
                        this.mShortcutKeyPressed = keyCode;
                        this.mConsumeShortcutKeyUp = false;
                    }
                } else if (keyCode == this.mShortcutKeyPressed) {
                    this.mShortcutKeyPressed = -1;
                    if (this.mConsumeShortcutKeyUp) {
                        this.mConsumeShortcutKeyUp = false;
                        return -1L;
                    }
                }
                return 0L;
            }
            if (keyCode == 187) {
                if (down && repeatCount == 0) {
                    this.showOrHideRecentAppsDialog(0);
                }
                return -1L;
            }
        }
        if (this.mShortcutKeyPressed != -1 && (kcm = event.getKeyCharacterMap()).isPrintingKey(keyCode)) {
            this.mConsumeShortcutKeyUp = true;
            if (down && repeatCount == 0 && !keyguardOn) {
                Intent shortcutIntent2 = this.mShortcutManager.getIntent(kcm, keyCode, metaState);
                if (shortcutIntent2 != null) {
                    shortcutIntent2.addFlags(0x10000000);
                    try {
                        this.mContext.startActivity(shortcutIntent2);
                    }
                    catch (ActivityNotFoundException ex) {
                        Slog.w((String)TAG, (String)("Dropping shortcut key combination because the activity to which it is registered was not found: " + KeyEvent.keyCodeToString((int)this.mShortcutKeyPressed) + "+" + KeyEvent.keyCodeToString((int)keyCode)), (Throwable)ex);
                    }
                } else {
                    Slog.i((String)TAG, (String)("Dropping unregistered shortcut key combination: " + KeyEvent.keyCodeToString((int)this.mShortcutKeyPressed) + "+" + KeyEvent.keyCodeToString((int)keyCode)));
                }
            }
            return -1L;
        }
        if (down && repeatCount == 0 && (metaState & 0x10000) != 0 && (shortcutIntent = this.mShortcutManager.getIntent(kcm = event.getKeyCharacterMap(), keyCode, metaState & 0xFFF8FFFF)) != null) {
            shortcutIntent.addFlags(0x10000000);
            try {
                this.mContext.startActivity(shortcutIntent);
            }
            catch (ActivityNotFoundException ex) {
                Slog.w((String)TAG, (String)("Dropping shortcut key combination because the activity to which it is registered was not found: META+" + KeyEvent.keyCodeToString((int)keyCode)), (Throwable)ex);
            }
            return -1L;
        }
        if (down && repeatCount == 0 && (category = (String)sApplicationLaunchKeyCategories.get(keyCode)) != null) {
            Intent intent = Intent.makeMainSelectorActivity((String)"android.intent.action.MAIN", (String)category);
            intent.setFlags(0x10000000);
            try {
                this.mContext.startActivity(intent);
            }
            catch (ActivityNotFoundException ex) {
                Slog.w((String)TAG, (String)("Dropping application launch key because the activity to which it is registered was not found: keyCode=" + keyCode + ", category=" + category), (Throwable)ex);
            }
            return -1L;
        }
        if (down && repeatCount == 0 && keyCode == 61) {
            int shiftlessModifiers;
            if (this.mRecentAppsDialogHeldModifiers == 0 && (KeyEvent.metaStateHasModifiers((int)(shiftlessModifiers = event.getModifiers() & 0xFFFFFF3E), (int)2) || KeyEvent.metaStateHasModifiers((int)shiftlessModifiers, (int)65536))) {
                this.mRecentAppsDialogHeldModifiers = shiftlessModifiers;
                this.showOrHideRecentAppsDialog(1);
                return -1L;
            }
        } else if (!down && this.mRecentAppsDialogHeldModifiers != 0 && (metaState & this.mRecentAppsDialogHeldModifiers) == 0) {
            this.mRecentAppsDialogHeldModifiers = 0;
            this.showOrHideRecentAppsDialog(2);
        }
        return 0L;
    }

    public KeyEvent dispatchUnhandledKey(WindowManagerPolicy.WindowState win, KeyEvent event, int policyFlags) {
        int metaState;
        int keyCode;
        KeyCharacterMap kcm;
        if ((event.getFlags() & 0x400) == 0 && this.getFallbackAction(kcm = event.getKeyCharacterMap(), keyCode = event.getKeyCode(), metaState = event.getMetaState(), this.mFallbackAction)) {
            long delayMillis;
            int flags = event.getFlags() | 0x400;
            KeyEvent fallbackEvent = KeyEvent.obtain((long)event.getDownTime(), (long)event.getEventTime(), (int)event.getAction(), (int)this.mFallbackAction.keyCode, (int)event.getRepeatCount(), (int)this.mFallbackAction.metaState, (int)event.getDeviceId(), (int)event.getScanCode(), (int)flags, (int)event.getSource(), null);
            int actions = this.interceptKeyBeforeQueueing(fallbackEvent, policyFlags, true);
            if ((actions & 1) != 0 && (delayMillis = this.interceptKeyBeforeDispatching(win, fallbackEvent, policyFlags)) == 0L) {
                return fallbackEvent;
            }
            fallbackEvent.recycle();
        }
        return null;
    }

    private boolean getFallbackAction(KeyCharacterMap kcm, int keyCode, int metaState, KeyCharacterMap.FallbackAction outFallbackAction) {
        return kcm.getFallbackAction(keyCode, metaState, outFallbackAction);
    }

    void launchHomeFromHotKey() {
        if (!this.mKeyguardMediator.isShowingAndNotHidden()) {
            if (!this.mHideLockScreen && this.mKeyguardMediator.isInputRestricted()) {
                this.mKeyguardMediator.verifyUnlock(new WindowManagerPolicy.OnKeyguardExitResult(){

                    public void onKeyguardExitResult(boolean success) {
                        if (success) {
                            try {
                                ActivityManagerNative.getDefault().stopAppSwitches();
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                            PhoneWindowManager.this.sendCloseSystemWindows(PhoneWindowManager.SYSTEM_DIALOG_REASON_HOME_KEY);
                            PhoneWindowManager.this.startDockOrHome();
                        }
                    }
                });
            } else {
                try {
                    ActivityManagerNative.getDefault().stopAppSwitches();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                this.sendCloseSystemWindows(SYSTEM_DIALOG_REASON_HOME_KEY);
                this.startDockOrHome();
            }
        }
    }

    public int adjustSystemUiVisibilityLw(int visibility) {
        this.mResettingSystemUiFlags &= visibility;
        return visibility & ~this.mResettingSystemUiFlags & ~this.mForceClearedSystemUiFlags;
    }

    public void getContentInsetHintLw(WindowManager.LayoutParams attrs, Rect contentInset) {
        int fl = attrs.flags;
        if ((fl & 0x10500) == 65792) {
            contentInset.set(this.mCurLeft, this.mCurTop, this.mRestrictedScreenLeft + this.mRestrictedScreenWidth - this.mCurRight, this.mRestrictedScreenTop + this.mRestrictedScreenHeight - this.mCurBottom);
        } else {
            contentInset.setEmpty();
        }
    }

    public void beginLayoutLw(int displayWidth, int displayHeight, int displayRotation) {
        boolean navVisible;
        this.mUnrestrictedScreenTop = 0;
        this.mUnrestrictedScreenLeft = 0;
        this.mUnrestrictedScreenWidth = displayWidth;
        this.mUnrestrictedScreenHeight = displayHeight;
        this.mRestrictedScreenTop = 0;
        this.mRestrictedScreenLeft = 0;
        this.mRestrictedScreenWidth = displayWidth;
        this.mRestrictedScreenHeight = displayHeight;
        this.mCurLeft = 0;
        this.mContentLeft = 0;
        this.mDockLeft = 0;
        this.mCurTop = 0;
        this.mContentTop = 0;
        this.mDockTop = 0;
        this.mContentRight = this.mCurRight = displayWidth;
        this.mDockRight = this.mCurRight;
        this.mContentBottom = this.mCurBottom = displayHeight;
        this.mDockBottom = this.mCurBottom;
        this.mDockLayer = 0x10000000;
        Rect pf = mTmpParentFrame;
        Rect df = mTmpDisplayFrame;
        Rect vf = mTmpVisibleFrame;
        df.left = vf.left = this.mDockLeft;
        pf.left = vf.left;
        df.top = vf.top = this.mDockTop;
        pf.top = vf.top;
        df.right = vf.right = this.mDockRight;
        pf.right = vf.right;
        df.bottom = vf.bottom = this.mDockBottom;
        pf.bottom = vf.bottom;
        boolean bl = navVisible = (this.mNavigationBar == null || this.mNavigationBar.isVisibleLw()) && (this.mLastSystemUiFlags & 2) == 0;
        if (navVisible) {
            if (this.mHideNavFakeWindow != null) {
                this.mHideNavFakeWindow.dismiss();
                this.mHideNavFakeWindow = null;
            }
        } else if (this.mHideNavFakeWindow == null) {
            this.mHideNavFakeWindow = this.mWindowManagerFuncs.addFakeWindow(this.mHandler.getLooper(), this.mHideNavInputHandler, "hidden nav", 2022, 0, false, false, true);
        }
        if (this.mStatusBar != null) {
            if (this.mNavigationBar != null) {
                if (displayWidth < displayHeight) {
                    mTmpNavigationFrame.set(0, displayHeight - this.mNavigationBarHeight, displayWidth, displayHeight);
                    if (navVisible) {
                        this.mDockBottom = PhoneWindowManager.mTmpNavigationFrame.top;
                        this.mRestrictedScreenHeight = this.mDockBottom - this.mDockTop;
                    } else {
                        mTmpNavigationFrame.offset(0, this.mNavigationBarHeight);
                    }
                } else {
                    mTmpNavigationFrame.set(displayWidth - this.mNavigationBarWidth, 0, displayWidth, displayHeight);
                    if (navVisible) {
                        this.mDockRight = PhoneWindowManager.mTmpNavigationFrame.left;
                        this.mRestrictedScreenWidth = this.mDockRight - this.mDockLeft;
                    } else {
                        mTmpNavigationFrame.offset(this.mNavigationBarWidth, 0);
                    }
                }
                this.mNavigationBar.computeFrameLw(mTmpNavigationFrame, mTmpNavigationFrame, mTmpNavigationFrame, mTmpNavigationFrame);
            }
            df.left = vf.left = this.mDockLeft;
            pf.left = vf.left;
            df.top = vf.top = this.mDockTop;
            pf.top = vf.top;
            df.right = vf.right = this.mDockRight;
            pf.right = vf.right;
            df.bottom = vf.bottom = this.mDockBottom;
            pf.bottom = vf.bottom;
            this.mStatusBar.computeFrameLw(pf, df, vf, vf);
            if (this.mStatusBar.isVisibleLw()) {
                Rect r = this.mStatusBar.getFrameLw();
                if (this.mStatusBarCanHide) {
                    if (this.mDockTop == r.top) {
                        this.mDockTop = r.bottom;
                    } else if (this.mDockBottom == r.bottom) {
                        this.mDockBottom = r.top;
                    }
                    this.mContentTop = this.mCurTop = this.mDockTop;
                    this.mContentBottom = this.mCurBottom = this.mDockBottom;
                    this.mContentLeft = this.mCurLeft = this.mDockLeft;
                    this.mContentRight = this.mCurRight = this.mDockRight;
                } else {
                    if (this.mRestrictedScreenTop == r.top) {
                        this.mRestrictedScreenTop = r.bottom;
                        this.mRestrictedScreenHeight -= r.bottom - r.top;
                    } else if (this.mRestrictedScreenHeight - this.mRestrictedScreenTop == r.bottom) {
                        this.mRestrictedScreenHeight -= r.bottom - r.top;
                    }
                    this.mCurTop = this.mDockTop = this.mRestrictedScreenTop;
                    this.mContentTop = this.mDockTop;
                    this.mCurBottom = this.mDockBottom = this.mRestrictedScreenTop + this.mRestrictedScreenHeight;
                    this.mContentBottom = this.mDockBottom;
                }
            }
        }
    }

    void setAttachedWindowFrames(WindowManagerPolicy.WindowState win, int fl, int adjust, WindowManagerPolicy.WindowState attached, boolean insetDecors, Rect pf, Rect df, Rect cf, Rect vf) {
        if (win.getSurfaceLayer() > this.mDockLayer && attached.getSurfaceLayer() < this.mDockLayer) {
            cf.left = vf.left = this.mDockLeft;
            df.left = vf.left;
            cf.top = vf.top = this.mDockTop;
            df.top = vf.top;
            cf.right = vf.right = this.mDockRight;
            df.right = vf.right;
            cf.bottom = vf.bottom = this.mDockBottom;
            df.bottom = vf.bottom;
        } else {
            if (adjust != 16) {
                cf.set(attached.getDisplayFrameLw());
            } else {
                cf.set(attached.getContentFrameLw());
                if (attached.getSurfaceLayer() < this.mDockLayer) {
                    if (cf.left < this.mContentLeft) {
                        cf.left = this.mContentLeft;
                    }
                    if (cf.top < this.mContentTop) {
                        cf.top = this.mContentTop;
                    }
                    if (cf.right > this.mContentRight) {
                        cf.right = this.mContentRight;
                    }
                    if (cf.bottom > this.mContentBottom) {
                        cf.bottom = this.mContentBottom;
                    }
                }
            }
            df.set(insetDecors ? attached.getDisplayFrameLw() : cf);
            vf.set(attached.getVisibleFrameLw());
        }
        pf.set((fl & 0x100) == 0 ? attached.getFrameLw() : df);
    }

    public void layoutWindowLw(WindowManagerPolicy.WindowState win, WindowManager.LayoutParams attrs, WindowManagerPolicy.WindowState attached) {
        boolean hasNavBar;
        if (win == this.mStatusBar || win == this.mNavigationBar) {
            return;
        }
        int fl = attrs.flags;
        int sim = attrs.softInputMode;
        Rect pf = mTmpParentFrame;
        Rect df = mTmpDisplayFrame;
        Rect cf = mTmpContentFrame;
        Rect vf = mTmpVisibleFrame;
        boolean bl = hasNavBar = this.mHasNavigationBar && this.mNavigationBar != null && this.mNavigationBar.isVisibleLw();
        if (attrs.type == 2011) {
            cf.left = vf.left = this.mDockLeft;
            df.left = vf.left;
            pf.left = vf.left;
            cf.top = vf.top = this.mDockTop;
            df.top = vf.top;
            pf.top = vf.top;
            cf.right = vf.right = this.mDockRight;
            df.right = vf.right;
            pf.right = vf.right;
            cf.bottom = vf.bottom = this.mDockBottom;
            df.bottom = vf.bottom;
            pf.bottom = vf.bottom;
            attrs.gravity = 80;
            this.mDockLayer = win.getSurfaceLayer();
        } else {
            int adjust = sim & 0xF0;
            if ((fl & 0x10500) == 65792) {
                if (attached != null) {
                    this.setAttachedWindowFrames(win, fl, sim, attached, true, pf, df, cf, vf);
                } else {
                    if (attrs.type == 2014 || attrs.type == 2017) {
                        df.left = hasNavBar ? this.mDockLeft : this.mUnrestrictedScreenLeft;
                        pf.left = df.left;
                        pf.top = df.top = this.mUnrestrictedScreenTop;
                        df.right = hasNavBar ? this.mRestrictedScreenLeft + this.mRestrictedScreenWidth : this.mUnrestrictedScreenLeft + this.mUnrestrictedScreenWidth;
                        pf.right = df.right;
                        df.bottom = hasNavBar ? this.mRestrictedScreenTop + this.mRestrictedScreenHeight : this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
                        pf.bottom = df.bottom;
                    } else {
                        pf.left = df.left = this.mRestrictedScreenLeft;
                        pf.top = df.top = this.mRestrictedScreenTop;
                        pf.right = df.right = this.mRestrictedScreenLeft + this.mRestrictedScreenWidth;
                        pf.bottom = df.bottom = this.mRestrictedScreenTop + this.mRestrictedScreenHeight;
                    }
                    if (adjust != 16) {
                        cf.left = this.mDockLeft;
                        cf.top = this.mDockTop;
                        cf.right = this.mDockRight;
                        cf.bottom = this.mDockBottom;
                    } else {
                        cf.left = this.mContentLeft;
                        cf.top = this.mContentTop;
                        cf.right = this.mContentRight;
                        cf.bottom = this.mContentBottom;
                    }
                    if (adjust != 48) {
                        vf.left = this.mCurLeft;
                        vf.top = this.mCurTop;
                        vf.right = this.mCurRight;
                        vf.bottom = this.mCurBottom;
                    } else {
                        vf.set(cf);
                    }
                }
            } else if ((fl & 0x100) != 0) {
                if (attrs.type == 2014 || attrs.type == 2017) {
                    cf.left = hasNavBar ? this.mDockLeft : this.mUnrestrictedScreenLeft;
                    df.left = cf.left;
                    pf.left = cf.left;
                    df.top = cf.top = this.mUnrestrictedScreenTop;
                    pf.top = cf.top;
                    cf.right = hasNavBar ? this.mRestrictedScreenLeft + this.mRestrictedScreenWidth : this.mUnrestrictedScreenLeft + this.mUnrestrictedScreenWidth;
                    df.right = cf.right;
                    pf.right = cf.right;
                    cf.bottom = hasNavBar ? this.mRestrictedScreenTop + this.mRestrictedScreenHeight : this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
                    df.bottom = cf.bottom;
                    pf.bottom = cf.bottom;
                } else if (attrs.type == 2019) {
                    pf.left = df.left = this.mUnrestrictedScreenLeft;
                    pf.top = df.top = this.mUnrestrictedScreenTop;
                    pf.right = df.right = this.mUnrestrictedScreenLeft + this.mUnrestrictedScreenWidth;
                    pf.bottom = df.bottom = this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
                } else if (attrs.type == 2015 && (fl & 0x400) != 0) {
                    pf.left = df.left = this.mUnrestrictedScreenLeft;
                    pf.top = df.top = this.mUnrestrictedScreenTop;
                    pf.right = df.right = this.mUnrestrictedScreenLeft + this.mUnrestrictedScreenWidth;
                    pf.bottom = df.bottom = this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
                } else {
                    df.left = cf.left = this.mRestrictedScreenLeft;
                    pf.left = cf.left;
                    df.top = cf.top = this.mRestrictedScreenTop;
                    pf.top = cf.top;
                    df.right = cf.right = this.mRestrictedScreenLeft + this.mRestrictedScreenWidth;
                    pf.right = cf.right;
                    df.bottom = cf.bottom = this.mRestrictedScreenTop + this.mRestrictedScreenHeight;
                    pf.bottom = cf.bottom;
                }
                if (adjust != 48) {
                    vf.left = this.mCurLeft;
                    vf.top = this.mCurTop;
                    vf.right = this.mCurRight;
                    vf.bottom = this.mCurBottom;
                } else {
                    vf.set(cf);
                }
            } else if (attached != null) {
                this.setAttachedWindowFrames(win, fl, adjust, attached, false, pf, df, cf, vf);
            } else if (attrs.type == 2014) {
                df.left = cf.left = this.mRestrictedScreenLeft;
                pf.left = cf.left;
                df.top = cf.top = this.mRestrictedScreenTop;
                pf.top = cf.top;
                df.right = cf.right = this.mRestrictedScreenLeft + this.mRestrictedScreenWidth;
                pf.right = cf.right;
                df.bottom = cf.bottom = this.mRestrictedScreenTop + this.mRestrictedScreenHeight;
                pf.bottom = cf.bottom;
            } else {
                pf.left = this.mContentLeft;
                pf.top = this.mContentTop;
                pf.right = this.mContentRight;
                pf.bottom = this.mContentBottom;
                if (adjust != 16) {
                    df.left = cf.left = this.mDockLeft;
                    df.top = cf.top = this.mDockTop;
                    df.right = cf.right = this.mDockRight;
                    df.bottom = cf.bottom = this.mDockBottom;
                } else {
                    df.left = cf.left = this.mContentLeft;
                    df.top = cf.top = this.mContentTop;
                    df.right = cf.right = this.mContentRight;
                    df.bottom = cf.bottom = this.mContentBottom;
                }
                if (adjust != 48) {
                    vf.left = this.mCurLeft;
                    vf.top = this.mCurTop;
                    vf.right = this.mCurRight;
                    vf.bottom = this.mCurBottom;
                } else {
                    vf.set(cf);
                }
            }
        }
        if ((fl & 0x200) != 0) {
            vf.top = -10000;
            vf.left = -10000;
            cf.top = -10000;
            cf.left = -10000;
            df.top = -10000;
            df.left = -10000;
            vf.bottom = 10000;
            vf.right = 10000;
            cf.bottom = 10000;
            cf.right = 10000;
            df.bottom = 10000;
            df.right = 10000;
        }
        win.computeFrameLw(pf, df, cf, vf);
        if (attrs.type == 2011 && !win.getGivenInsetsPendingLw()) {
            int top = win.getContentFrameLw().top;
            if (this.mContentBottom > (top += win.getGivenContentInsetsLw().top)) {
                this.mContentBottom = top;
            }
            top = win.getVisibleFrameLw().top;
            if (this.mCurBottom > (top += win.getGivenVisibleInsetsLw().top)) {
                this.mCurBottom = top;
            }
        }
    }

    public int finishLayoutLw() {
        return 0;
    }

    public void beginAnimationLw(int displayWidth, int displayHeight) {
        this.mTopFullscreenOpaqueWindowState = null;
        this.mForceStatusBar = false;
        this.mHideLockScreen = false;
        this.mAllowLockscreenWhenOn = false;
        this.mDismissKeyguard = false;
    }

    public void animatingWindowLw(WindowManagerPolicy.WindowState win, WindowManager.LayoutParams attrs) {
        if (this.mTopFullscreenOpaqueWindowState == null && win.isVisibleOrBehindKeyguardLw()) {
            if ((attrs.flags & 0x800) != 0) {
                this.mForceStatusBar = true;
            }
            if (attrs.type >= 1 && attrs.type <= 99 && attrs.x == 0 && attrs.y == 0 && attrs.width == -1 && attrs.height == -1) {
                this.mTopFullscreenOpaqueWindowState = win;
                if ((attrs.flags & 0x80000) != 0) {
                    this.mHideLockScreen = true;
                }
                if ((attrs.flags & 0x400000) != 0) {
                    this.mDismissKeyguard = true;
                }
                if ((attrs.flags & 1) != 0) {
                    this.mAllowLockscreenWhenOn = true;
                }
            }
        }
    }

    public int finishAnimationLw() {
        WindowManager.LayoutParams lp;
        int changes = 0;
        boolean topIsFullscreen = false;
        WindowManager.LayoutParams layoutParams = lp = this.mTopFullscreenOpaqueWindowState != null ? this.mTopFullscreenOpaqueWindowState.getAttrs() : null;
        if (this.mStatusBar != null) {
            if (this.mForceStatusBar) {
                if (this.mStatusBar.showLw(true)) {
                    changes |= 1;
                }
            } else if (this.mTopFullscreenOpaqueWindowState != null) {
                boolean bl = topIsFullscreen = (lp.flags & 0x400) != 0;
                if (topIsFullscreen) {
                    if (this.mStatusBarCanHide && this.mStatusBar.hideLw(true)) {
                        changes |= 1;
                        this.mHandler.post(new Runnable(){

                            public void run() {
                                if (PhoneWindowManager.this.mStatusBarService != null) {
                                    try {
                                        PhoneWindowManager.this.mStatusBarService.collapse();
                                    }
                                    catch (RemoteException remoteException) {
                                        // empty catch block
                                    }
                                }
                            }
                        });
                    }
                } else if (this.mStatusBar.showLw(true)) {
                    changes |= 1;
                }
            }
        }
        this.mTopIsFullscreen = topIsFullscreen;
        if (this.mKeyguard != null) {
            if (this.mDismissKeyguard && !this.mKeyguardMediator.isSecure()) {
                if (this.mKeyguard.hideLw(true)) {
                    changes |= 7;
                }
                if (this.mKeyguardMediator.isShowing()) {
                    this.mHandler.post(new Runnable(){

                        public void run() {
                            PhoneWindowManager.this.mKeyguardMediator.keyguardDone(false, false);
                        }
                    });
                }
            } else if (this.mHideLockScreen) {
                if (this.mKeyguard.hideLw(true)) {
                    changes |= 7;
                }
                this.mKeyguardMediator.setHidden(true);
            } else {
                if (this.mKeyguard.showLw(true)) {
                    changes |= 7;
                }
                this.mKeyguardMediator.setHidden(false);
            }
        }
        if ((this.updateSystemUiVisibilityLw() & 2) != 0) {
            changes |= 1;
        }
        this.updateLockScreenTimeout();
        return changes;
    }

    public boolean allowAppAnimationsLw() {
        return this.mKeyguard == null || !this.mKeyguard.isVisibleLw();
    }

    public int focusChangedLw(WindowManagerPolicy.WindowState lastFocus, WindowManagerPolicy.WindowState newFocus) {
        this.mFocusedWindow = newFocus;
        if ((this.updateSystemUiVisibilityLw() & 2) != 0) {
            return 1;
        }
        return 0;
    }

    public void notifyLidSwitchChanged(long whenNanos, boolean lidOpen) {
        this.mLidOpen = lidOpen ? 1 : 0;
        this.updateKeyboardVisibility();
        boolean awakeNow = this.mKeyguardMediator.doLidChangeTq(lidOpen);
        this.updateRotation(true);
        if (awakeNow) {
            this.mKeyguardMediator.pokeWakelock();
        } else if (this.keyguardIsShowingTq()) {
            if (lidOpen) {
                this.mKeyguardMediator.onWakeKeyWhenKeyguardShowingTq(26, this.mDockMode != 0);
            }
        } else if (lidOpen) {
            this.mPowerManager.userActivity(SystemClock.uptimeMillis(), false, 1);
        } else {
            this.mPowerManager.userActivity(SystemClock.uptimeMillis(), false, 0);
        }
    }

    void setHdmiPlugged(boolean plugged) {
        if (this.mHdmiPlugged != plugged) {
            this.mHdmiPlugged = plugged;
            this.updateRotation(true);
            Intent intent = new Intent("android.intent.action.HDMI_PLUGGED");
            intent.addFlags(0x10000000);
            intent.putExtra("state", plugged);
            this.mContext.sendStickyBroadcast(intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeHdmiState() {
        boolean plugged = false;
        if (new File("/sys/devices/virtual/switch/hdmi/state").exists()) {
            this.mHDMIObserver.startObserving("DEVPATH=/devices/virtual/switch/hdmi");
            String filename = "/sys/class/switch/hdmi/state";
            FileReader reader = null;
            try {
                reader = new FileReader("/sys/class/switch/hdmi/state");
                char[] buf = new char[15];
                int n = reader.read(buf);
                if (n > 1) {
                    plugged = 0 != Integer.parseInt(new String(buf, 0, n - 1));
                }
            }
            catch (IOException ex) {
                Slog.w((String)TAG, (String)("Couldn't read hdmi state from /sys/class/switch/hdmi/state: " + ex));
            }
            catch (NumberFormatException ex) {
                Slog.w((String)TAG, (String)("Couldn't read hdmi state from /sys/class/switch/hdmi/state: " + ex));
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        this.mHdmiPlugged = !plugged;
        this.setHdmiPlugged(!this.mHdmiPlugged);
    }

    boolean isMusicActive() {
        AudioManager am = (AudioManager)this.mContext.getSystemService("audio");
        if (am == null) {
            Log.w((String)TAG, (String)"isMusicActive: couldn't get AudioManager reference");
            return false;
        }
        return am.isMusicActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleVolumeKey(int stream, int keycode) {
        IAudioService audioService = PhoneWindowManager.getAudioService();
        if (audioService == null) {
            return;
        }
        try {
            this.mBroadcastWakeLock.acquire();
            audioService.adjustStreamVolume(stream, keycode == 24 ? 1 : -1, 0);
        }
        catch (RemoteException e) {
            Log.w((String)TAG, (String)("IAudioService.adjustStreamVolume() threw RemoteException " + (Object)((Object)e)));
        }
        finally {
            this.mBroadcastWakeLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeScreenshot() {
        Object object = this.mScreenshotLock;
        synchronized (object) {
            if (this.mScreenshotConnection != null) {
                return;
            }
            ComponentName cn = new ComponentName("com.android.systemui", "com.android.systemui.screenshot.TakeScreenshotService");
            Intent intent = new Intent();
            intent.setComponent(cn);
            ServiceConnection conn = new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onServiceConnected(ComponentName name, IBinder service) {
                    Object object = PhoneWindowManager.this.mScreenshotLock;
                    synchronized (object) {
                        if (PhoneWindowManager.this.mScreenshotConnection != this) {
                            return;
                        }
                        Messenger messenger = new Messenger(service);
                        Message msg = Message.obtain(null, (int)1);
                        final 12 myConn = this;
                        Handler h = new Handler(PhoneWindowManager.this.mHandler.getLooper()){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void handleMessage(Message msg) {
                                Object object = PhoneWindowManager.this.mScreenshotLock;
                                synchronized (object) {
                                    if (PhoneWindowManager.this.mScreenshotConnection == myConn) {
                                        PhoneWindowManager.this.mContext.unbindService(PhoneWindowManager.this.mScreenshotConnection);
                                        PhoneWindowManager.this.mScreenshotConnection = null;
                                        PhoneWindowManager.this.mHandler.removeCallbacks(PhoneWindowManager.this.mScreenshotTimeout);
                                    }
                                }
                            }
                        };
                        msg.replyTo = new Messenger(h);
                        msg.arg2 = 0;
                        msg.arg1 = 0;
                        if (PhoneWindowManager.this.mStatusBar != null && PhoneWindowManager.this.mStatusBar.isVisibleLw()) {
                            msg.arg1 = 1;
                        }
                        if (PhoneWindowManager.this.mNavigationBar != null && PhoneWindowManager.this.mNavigationBar.isVisibleLw()) {
                            msg.arg2 = 1;
                        }
                        try {
                            messenger.send(msg);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                }

                public void onServiceDisconnected(ComponentName name) {
                }
            };
            if (this.mContext.bindService(intent, conn, 1)) {
                this.mScreenshotConnection = conn;
                this.mHandler.postDelayed(this.mScreenshotTimeout, 10000L);
            }
        }
    }

    public int interceptKeyBeforeQueueing(KeyEvent event, int policyFlags, boolean isScreenOn) {
        int result;
        boolean keyguardActive;
        boolean down = event.getAction() == 0;
        boolean canceled = event.isCanceled();
        int keyCode = event.getKeyCode();
        boolean isInjected = (policyFlags & 0x1000000) != 0;
        boolean bl = keyguardActive = isScreenOn ? this.mKeyguardMediator.isShowingAndNotHidden() : this.mKeyguardMediator.isShowing();
        if (!this.mSystemBooted) {
            return 0;
        }
        if (down && (policyFlags & 0x100) != 0 && event.getRepeatCount() == 0) {
            this.performHapticFeedbackLw(null, 1, false);
        }
        if (isScreenOn || isInjected) {
            result = 1;
        } else {
            boolean isWakeKey;
            result = 0;
            boolean bl2 = isWakeKey = (policyFlags & 3) != 0;
            if (down && isWakeKey) {
                if (keyguardActive) {
                    this.mKeyguardMediator.onWakeKeyWhenKeyguardShowingTq(keyCode, this.mDockMode != 0);
                } else {
                    result |= 2;
                }
            }
        }
        switch (keyCode) {
            case 24: 
            case 25: 
            case 164: {
                if (keyCode == 25) {
                    if (down) {
                        if (isScreenOn && !this.mVolumeDownKeyTriggered && (event.getFlags() & 0x400) == 0) {
                            this.mVolumeDownKeyTriggered = true;
                            this.mVolumeDownKeyTime = event.getDownTime();
                            this.mVolumeDownKeyConsumedByScreenshotChord = false;
                            this.cancelPendingPowerKeyAction();
                            this.interceptScreenshotChord();
                        }
                    } else {
                        this.mVolumeDownKeyTriggered = false;
                        this.cancelPendingScreenshotChordAction();
                    }
                } else if (keyCode == 24) {
                    if (down) {
                        if (isScreenOn && !this.mVolumeUpKeyTriggered && (event.getFlags() & 0x400) == 0) {
                            this.mVolumeUpKeyTriggered = true;
                            this.cancelPendingPowerKeyAction();
                            this.cancelPendingScreenshotChordAction();
                        }
                    } else {
                        this.mVolumeUpKeyTriggered = false;
                        this.cancelPendingScreenshotChordAction();
                    }
                }
                if (!down) break;
                ITelephony telephonyService = PhoneWindowManager.getTelephonyService();
                if (telephonyService != null) {
                    try {
                        if (telephonyService.isRinging()) {
                            Log.i((String)TAG, (String)"interceptKeyBeforeQueueing: VOLUME key-down while ringing: Silence ringer!");
                            telephonyService.silenceRinger();
                            result &= 0xFFFFFFFE;
                            break;
                        }
                        if (telephonyService.isOffhook() && (result & 1) == 0) {
                            this.handleVolumeKey(0, keyCode);
                            break;
                        }
                    }
                    catch (RemoteException ex) {
                        Log.w((String)TAG, (String)"ITelephony threw RemoteException", (Throwable)ex);
                    }
                }
                if (!this.isMusicActive() || (result & 1) != 0) break;
                this.handleVolumeKey(3, keyCode);
                break;
            }
            case 6: {
                result &= 0xFFFFFFFE;
                if (down) {
                    ITelephony telephonyService = PhoneWindowManager.getTelephonyService();
                    boolean hungUp = false;
                    if (telephonyService != null) {
                        try {
                            hungUp = telephonyService.endCall();
                        }
                        catch (RemoteException ex) {
                            Log.w((String)TAG, (String)"ITelephony threw RemoteException", (Throwable)ex);
                        }
                    }
                    this.interceptPowerKeyDown(!isScreenOn || hungUp);
                    break;
                }
                if (!this.interceptPowerKeyUp(canceled) || (this.mEndcallBehavior & 1) != 0 && this.goHome() || (this.mEndcallBehavior & 2) == 0) break;
                result = result & 0xFFFFFFFD | 4;
                break;
            }
            case 26: {
                result &= 0xFFFFFFFE;
                if (down) {
                    if (isScreenOn && !this.mPowerKeyTriggered && (event.getFlags() & 0x400) == 0) {
                        this.mPowerKeyTriggered = true;
                        this.mPowerKeyTime = event.getDownTime();
                        this.interceptScreenshotChord();
                    }
                    ITelephony telephonyService = PhoneWindowManager.getTelephonyService();
                    boolean hungUp = false;
                    if (telephonyService != null) {
                        try {
                            if (telephonyService.isRinging()) {
                                telephonyService.silenceRinger();
                            } else if ((this.mIncallPowerBehavior & 2) != 0 && telephonyService.isOffhook()) {
                                hungUp = telephonyService.endCall();
                            }
                        }
                        catch (RemoteException ex) {
                            Log.w((String)TAG, (String)"ITelephony threw RemoteException", (Throwable)ex);
                        }
                    }
                    this.interceptPowerKeyDown(!isScreenOn || hungUp || this.mVolumeDownKeyTriggered || this.mVolumeUpKeyTriggered);
                    break;
                }
                this.mPowerKeyTriggered = false;
                this.cancelPendingScreenshotChordAction();
                if (this.interceptPowerKeyUp(canceled || this.mPendingPowerKeyUpCanceled)) {
                    result = result & 0xFFFFFFFD | 4;
                }
                this.mPendingPowerKeyUpCanceled = false;
                break;
            }
            case 85: 
            case 126: 
            case 127: {
                ITelephony telephonyService;
                if (down && (telephonyService = PhoneWindowManager.getTelephonyService()) != null) {
                    try {
                        if (!telephonyService.isIdle()) {
                            break;
                        }
                    }
                    catch (RemoteException ex) {
                        Log.w((String)TAG, (String)"ITelephony threw RemoteException", (Throwable)ex);
                    }
                }
            }
            case 79: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 130: {
                if ((result & 1) != 0) break;
                this.mBroadcastWakeLock.acquire();
                this.mHandler.post((Runnable)new PassHeadsetKey(new KeyEvent(event)));
                break;
            }
            case 5: {
                ITelephony telephonyService;
                if (!down || (telephonyService = PhoneWindowManager.getTelephonyService()) == null) break;
                try {
                    if (!telephonyService.isRinging()) break;
                    Log.i((String)TAG, (String)"interceptKeyBeforeQueueing: CALL key-down while ringing: Answer the call!");
                    telephonyService.answerRingingCall();
                    result &= 0xFFFFFFFE;
                    break;
                }
                catch (RemoteException ex) {
                    Log.w((String)TAG, (String)"ITelephony threw RemoteException", (Throwable)ex);
                }
            }
        }
        return result;
    }

    public int interceptMotionBeforeQueueingWhenScreenOff(int policyFlags) {
        boolean isWakeMotion;
        int result = 0;
        boolean bl = isWakeMotion = (policyFlags & 3) != 0;
        if (isWakeMotion) {
            if (this.mKeyguardMediator.isShowing()) {
                this.mKeyguardMediator.onWakeMotionWhenKeyguardShowingTq();
            } else {
                result |= 2;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void screenTurnedOff(int why) {
        EventLog.writeEvent((int)70000, (int)0);
        Object object = this.mLock;
        synchronized (object) {
            this.mScreenOnEarly = false;
            this.mScreenOnFully = false;
        }
        this.mKeyguardMediator.onScreenTurnedOff(why);
        object = this.mLock;
        synchronized (object) {
            this.updateOrientationListenerLp();
            this.updateLockScreenTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void screenTurningOn(final WindowManagerPolicy.ScreenOnListener screenOnListener) {
        Object object;
        EventLog.writeEvent((int)70000, (int)1);
        if (screenOnListener != null) {
            this.mKeyguardMediator.onScreenTurnedOn(new KeyguardViewManager.ShowListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onShown(IBinder windowToken) {
                    if (windowToken != null) {
                        try {
                            PhoneWindowManager.this.mWindowManager.waitForWindowDrawn(windowToken, (IRemoteCallback)new IRemoteCallback.Stub(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void sendResult(Bundle data) {
                                    Slog.i((String)PhoneWindowManager.TAG, (String)"Lock screen displayed!");
                                    screenOnListener.onScreenOn();
                                    Object object = PhoneWindowManager.this.mLock;
                                    synchronized (object) {
                                        PhoneWindowManager.this.mScreenOnFully = true;
                                    }
                                }
                            });
                        }
                        catch (RemoteException remoteException) {}
                    } else {
                        Slog.i((String)PhoneWindowManager.TAG, (String)"No lock screen!");
                        screenOnListener.onScreenOn();
                        Object object = PhoneWindowManager.this.mLock;
                        synchronized (object) {
                            PhoneWindowManager.this.mScreenOnFully = true;
                        }
                    }
                }
            });
        } else {
            object = this.mLock;
            synchronized (object) {
                this.mScreenOnFully = true;
            }
        }
        object = this.mLock;
        synchronized (object) {
            this.mScreenOnEarly = true;
            this.updateOrientationListenerLp();
            this.updateLockScreenTimeout();
        }
    }

    public boolean isScreenOnEarly() {
        return this.mScreenOnEarly;
    }

    public boolean isScreenOnFully() {
        return this.mScreenOnFully;
    }

    public void enableKeyguard(boolean enabled) {
        this.mKeyguardMediator.setKeyguardEnabled(enabled);
    }

    public void exitKeyguardSecurely(WindowManagerPolicy.OnKeyguardExitResult callback) {
        this.mKeyguardMediator.verifyUnlock(callback);
    }

    private boolean keyguardIsShowingTq() {
        return this.mKeyguardMediator.isShowingAndNotHidden();
    }

    public boolean isKeyguardLocked() {
        return this.keyguardOn();
    }

    public boolean isKeyguardSecure() {
        return this.mKeyguardMediator.isSecure();
    }

    public boolean inKeyguardRestrictedKeyInputMode() {
        return this.mKeyguardMediator.isInputRestricted();
    }

    public void dismissKeyguardLw() {
        if (!this.mKeyguardMediator.isSecure() && this.mKeyguardMediator.isShowing()) {
            this.mHandler.post(new Runnable(){

                public void run() {
                    PhoneWindowManager.this.mKeyguardMediator.keyguardDone(false, true);
                }
            });
        }
    }

    void sendCloseSystemWindows() {
        PhoneWindowManager.sendCloseSystemWindows(this.mContext, null);
    }

    void sendCloseSystemWindows(String reason) {
        PhoneWindowManager.sendCloseSystemWindows(this.mContext, reason);
    }

    static void sendCloseSystemWindows(Context context, String reason) {
        if (ActivityManagerNative.isSystemReady()) {
            try {
                ActivityManagerNative.getDefault().closeSystemDialogs(reason);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rotationForOrientationLw(int orientation, int lastRotation) {
        Object object = this.mLock;
        synchronized (object) {
            int preferredRotation;
            int sensorRotation = this.mOrientationListener.getProposedRotation();
            if (sensorRotation < 0) {
                sensorRotation = lastRotation;
            }
            if (this.mLidOpen == 1 && this.mLidOpenRotation >= 0) {
                preferredRotation = this.mLidOpenRotation;
            } else if (this.mDockMode == 2 && (this.mCarDockEnablesAccelerometer || this.mCarDockRotation >= 0)) {
                preferredRotation = this.mCarDockEnablesAccelerometer ? sensorRotation : this.mCarDockRotation;
            } else if (!(this.mDockMode != 1 && this.mDockMode != 3 && this.mDockMode != 4 || !this.mDeskDockEnablesAccelerometer && this.mDeskDockRotation < 0)) {
                preferredRotation = this.mDeskDockEnablesAccelerometer ? sensorRotation : this.mDeskDockRotation;
            } else if (this.mHdmiPlugged) {
                preferredRotation = this.mHdmiRotation;
            } else if (this.mAccelerometerDefault != 0 && (orientation == 2 || orientation == -1) || orientation == 4 || orientation == 10 || orientation == 6 || orientation == 7) {
                if (this.mAllowAllRotations < 0) {
                    int n = this.mAllowAllRotations = this.mContext.getResources().getBoolean(0x1110013) ? 1 : 0;
                }
                preferredRotation = sensorRotation != 2 || this.mAllowAllRotations == 1 || orientation == 10 ? sensorRotation : lastRotation;
            } else {
                preferredRotation = this.mUserRotationMode == 1 ? this.mUserRotation : -1;
            }
            switch (orientation) {
                case 1: {
                    if (this.isAnyPortrait(preferredRotation)) {
                        return preferredRotation;
                    }
                    return this.mPortraitRotation;
                }
                case 0: {
                    if (this.isLandscapeOrSeascape(preferredRotation)) {
                        return preferredRotation;
                    }
                    return this.mLandscapeRotation;
                }
                case 9: {
                    if (this.isAnyPortrait(preferredRotation)) {
                        return preferredRotation;
                    }
                    return this.mUpsideDownRotation;
                }
                case 8: {
                    if (this.isLandscapeOrSeascape(preferredRotation)) {
                        return preferredRotation;
                    }
                    return this.mSeascapeRotation;
                }
                case 6: {
                    if (this.isLandscapeOrSeascape(preferredRotation)) {
                        return preferredRotation;
                    }
                    if (this.isLandscapeOrSeascape(lastRotation)) {
                        return lastRotation;
                    }
                    return this.mLandscapeRotation;
                }
                case 7: {
                    if (this.isAnyPortrait(preferredRotation)) {
                        return preferredRotation;
                    }
                    if (this.isAnyPortrait(lastRotation)) {
                        return lastRotation;
                    }
                    return this.mPortraitRotation;
                }
            }
            if (preferredRotation >= 0) {
                return preferredRotation;
            }
            return 0;
        }
    }

    public boolean rotationHasCompatibleMetricsLw(int orientation, int rotation) {
        switch (orientation) {
            case 1: 
            case 7: 
            case 9: {
                return this.isAnyPortrait(rotation);
            }
            case 0: 
            case 6: 
            case 8: {
                return this.isLandscapeOrSeascape(rotation);
            }
        }
        return true;
    }

    public void setRotationLw(int rotation) {
        this.mOrientationListener.setCurrentRotation(rotation);
    }

    private boolean isLandscapeOrSeascape(int rotation) {
        return rotation == this.mLandscapeRotation || rotation == this.mSeascapeRotation;
    }

    private boolean isAnyPortrait(int rotation) {
        return rotation == this.mPortraitRotation || rotation == this.mUpsideDownRotation;
    }

    public void setUserRotationMode(int mode, int rot) {
        ContentResolver res = this.mContext.getContentResolver();
        if (mode == 1) {
            Settings.System.putInt((ContentResolver)res, (String)"user_rotation", (int)rot);
            Settings.System.putInt((ContentResolver)res, (String)"accelerometer_rotation", (int)0);
        } else {
            Settings.System.putInt((ContentResolver)res, (String)"accelerometer_rotation", (int)1);
        }
    }

    public boolean detectSafeMode() {
        try {
            int menuState = this.mWindowManager.getKeycodeState(82);
            int sState = this.mWindowManager.getKeycodeState(47);
            int dpadState = this.mWindowManager.getDPadKeycodeState(23);
            int trackballState = this.mWindowManager.getTrackballScancodeState(272);
            int volumeDownState = this.mWindowManager.getKeycodeState(25);
            this.mSafeMode = menuState > 0 || sState > 0 || dpadState > 0 || trackballState > 0 || volumeDownState > 0;
            this.performHapticFeedbackLw(null, this.mSafeMode ? 10001 : 10000, true);
            if (this.mSafeMode) {
                Log.i((String)TAG, (String)("SAFE MODE ENABLED (menu=" + menuState + " s=" + sState + " dpad=" + dpadState + " trackball=" + trackballState + ")"));
            } else {
                Log.i((String)TAG, (String)"SAFE MODE not enabled");
            }
            return this.mSafeMode;
        }
        catch (RemoteException e) {
            throw new RuntimeException("window manager dead");
        }
    }

    static long[] getLongIntArray(Resources r, int resid) {
        int[] ar = r.getIntArray(resid);
        if (ar == null) {
            return null;
        }
        long[] out = new long[ar.length];
        for (int i = 0; i < ar.length; ++i) {
            out[i] = ar[i];
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        this.mKeyguardMediator.onSystemReady();
        SystemProperties.set((String)"dev.bootcomplete", (String)"1");
        Object object = this.mLock;
        synchronized (object) {
            this.updateOrientationListenerLp();
            this.mSystemReady = true;
            this.mHandler.post(new Runnable(){

                public void run() {
                    PhoneWindowManager.this.updateSettings();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemBooted() {
        Object object = this.mLock;
        synchronized (object) {
            this.mSystemBooted = true;
        }
    }

    public void showBootMessage(final CharSequence msg, boolean always) {
        this.mHandler.post(new Runnable(){

            public void run() {
                if (PhoneWindowManager.this.mBootMsgDialog == null) {
                    PhoneWindowManager.this.mBootMsgDialog = new ProgressDialog(PhoneWindowManager.this.mContext){

                        public boolean dispatchKeyEvent(KeyEvent event) {
                            return true;
                        }

                        public boolean dispatchKeyShortcutEvent(KeyEvent event) {
                            return true;
                        }

                        public boolean dispatchTouchEvent(MotionEvent ev) {
                            return true;
                        }

                        public boolean dispatchTrackballEvent(MotionEvent ev) {
                            return true;
                        }

                        public boolean dispatchGenericMotionEvent(MotionEvent ev) {
                            return true;
                        }

                        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
                            return true;
                        }
                    };
                    PhoneWindowManager.this.mBootMsgDialog.setTitle(17040312);
                    PhoneWindowManager.this.mBootMsgDialog.setProgressStyle(0);
                    PhoneWindowManager.this.mBootMsgDialog.setIndeterminate(true);
                    PhoneWindowManager.this.mBootMsgDialog.getWindow().setType(2021);
                    PhoneWindowManager.this.mBootMsgDialog.getWindow().addFlags(258);
                    PhoneWindowManager.this.mBootMsgDialog.getWindow().setDimAmount(1.0f);
                    WindowManager.LayoutParams lp = PhoneWindowManager.this.mBootMsgDialog.getWindow().getAttributes();
                    lp.screenOrientation = 5;
                    PhoneWindowManager.this.mBootMsgDialog.getWindow().setAttributes(lp);
                    PhoneWindowManager.this.mBootMsgDialog.setCancelable(false);
                    PhoneWindowManager.this.mBootMsgDialog.show();
                }
                PhoneWindowManager.this.mBootMsgDialog.setMessage(msg);
            }
        });
    }

    public void hideBootMessages() {
        this.mHandler.post(new Runnable(){

            public void run() {
                if (PhoneWindowManager.this.mBootMsgDialog != null) {
                    PhoneWindowManager.this.mBootMsgDialog.dismiss();
                    PhoneWindowManager.this.mBootMsgDialog = null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userActivity() {
        Runnable runnable = this.mScreenLockTimeout;
        synchronized (runnable) {
            if (this.mLockScreenTimerActive) {
                this.mHandler.removeCallbacks(this.mScreenLockTimeout);
                this.mHandler.postDelayed(this.mScreenLockTimeout, (long)this.mLockScreenTimeout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLockScreenTimeout() {
        Runnable runnable = this.mScreenLockTimeout;
        synchronized (runnable) {
            boolean enable;
            boolean bl = enable = this.mAllowLockscreenWhenOn && this.mScreenOnEarly && this.mKeyguardMediator.isSecure();
            if (this.mLockScreenTimerActive != enable) {
                if (enable) {
                    this.mHandler.postDelayed(this.mScreenLockTimeout, (long)this.mLockScreenTimeout);
                } else {
                    this.mHandler.removeCallbacks(this.mScreenLockTimeout);
                }
                this.mLockScreenTimerActive = enable;
            }
        }
    }

    public void enableScreenAfterBoot() {
        this.readLidState();
        this.updateKeyboardVisibility();
        this.updateRotation(true);
    }

    private void updateKeyboardVisibility() {
        this.mPowerManager.setKeyboardVisibility(this.mLidOpen == 1);
    }

    void updateRotation(boolean alwaysSendConfiguration) {
        try {
            this.mWindowManager.updateRotation(alwaysSendConfiguration);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    Intent createHomeDockIntent() {
        Intent intent = null;
        if (this.mUiMode == 3) {
            intent = this.mCarDockIntent;
        } else if (this.mUiMode == 2) {
            // empty if block
        }
        if (intent == null) {
            return null;
        }
        ActivityInfo ai = intent.resolveActivityInfo(this.mContext.getPackageManager(), 128);
        if (ai == null) {
            return null;
        }
        if (ai.metaData != null && ai.metaData.getBoolean("android.dock_home")) {
            intent = new Intent(intent);
            intent.setClassName(ai.packageName, ai.name);
            return intent;
        }
        return null;
    }

    void startDockOrHome() {
        Intent dock = this.createHomeDockIntent();
        if (dock != null) {
            try {
                this.mContext.startActivity(dock);
                return;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                // empty catch block
            }
        }
        this.mContext.startActivity(this.mHomeIntent);
    }

    boolean goHome() {
        try {
            if (SystemProperties.getInt((String)"persist.sys.uts-test-mode", (int)0) == 1) {
                Log.d((String)TAG, (String)"UTS-TEST-MODE");
            } else {
                int result;
                ActivityManagerNative.getDefault().stopAppSwitches();
                this.sendCloseSystemWindows();
                Intent dock = this.createHomeDockIntent();
                if (dock != null && (result = ActivityManagerNative.getDefault().startActivity(null, dock, dock.resolveTypeIfNeeded(this.mContext.getContentResolver()), null, 0, null, null, 0, true, false, null, null, false)) == 1) {
                    return false;
                }
            }
            int result = ActivityManagerNative.getDefault().startActivity(null, this.mHomeIntent, this.mHomeIntent.resolveTypeIfNeeded(this.mContext.getContentResolver()), null, 0, null, null, 0, true, false, null, null, false);
            if (result == 1) {
                return false;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentOrientationLw(int newOrientation) {
        Object object = this.mLock;
        synchronized (object) {
            if (newOrientation != this.mCurrentAppOrientation) {
                this.mCurrentAppOrientation = newOrientation;
                this.updateOrientationListenerLp();
            }
        }
    }

    public boolean performHapticFeedbackLw(WindowManagerPolicy.WindowState win, int effectId, boolean always) {
        boolean hapticsDisabled;
        boolean bl = hapticsDisabled = Settings.System.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"haptic_feedback_enabled", (int)0) == 0;
        if (!always && (hapticsDisabled || this.mKeyguardMediator.isShowingAndNotHidden())) {
            return false;
        }
        long[] pattern = null;
        switch (effectId) {
            case 0: {
                pattern = this.mLongPressVibePattern;
                break;
            }
            case 1: {
                pattern = this.mVirtualKeyVibePattern;
                break;
            }
            case 3: {
                pattern = this.mKeyboardTapVibePattern;
                break;
            }
            case 10000: {
                pattern = this.mSafeModeDisabledVibePattern;
                break;
            }
            case 10001: {
                pattern = this.mSafeModeEnabledVibePattern;
                break;
            }
            default: {
                return false;
            }
        }
        if (pattern.length == 1) {
            this.mVibrator.vibrate(pattern[0]);
        } else {
            this.mVibrator.vibrate(pattern, -1);
        }
        return true;
    }

    public void screenOnStartedLw() {
    }

    public void screenOnStoppedLw() {
        if (this.mPowerManager.isScreenOn() && !this.mKeyguardMediator.isShowingAndNotHidden()) {
            long curTime = SystemClock.uptimeMillis();
            this.mPowerManager.userActivity(curTime, false, 0);
        }
    }

    public boolean allowKeyRepeat() {
        return this.mScreenOnEarly;
    }

    private int updateSystemUiVisibilityLw() {
        if (this.mFocusedWindow == null) {
            return 0;
        }
        final int visibility = this.mFocusedWindow.getSystemUiVisibility() & ~this.mResettingSystemUiFlags & ~this.mForceClearedSystemUiFlags;
        int diff = visibility ^ this.mLastSystemUiFlags;
        final boolean needsMenu = this.mFocusedWindow.getNeedsMenuLw(this.mTopFullscreenOpaqueWindowState);
        if (diff == 0 && this.mLastFocusNeedsMenu == needsMenu && this.mFocusedApp == this.mFocusedWindow.getAppToken()) {
            return 0;
        }
        this.mLastSystemUiFlags = visibility;
        this.mLastFocusNeedsMenu = needsMenu;
        this.mFocusedApp = this.mFocusedWindow.getAppToken();
        this.mHandler.post(new Runnable(){

            public void run() {
                if (PhoneWindowManager.this.mStatusBarService == null) {
                    PhoneWindowManager.this.mStatusBarService = IStatusBarService.Stub.asInterface((IBinder)ServiceManager.getService((String)"statusbar"));
                }
                if (PhoneWindowManager.this.mStatusBarService != null) {
                    try {
                        PhoneWindowManager.this.mStatusBarService.setSystemUiVisibility(visibility);
                        PhoneWindowManager.this.mStatusBarService.topAppWindowChanged(needsMenu);
                    }
                    catch (RemoteException e) {
                        PhoneWindowManager.this.mStatusBarService = null;
                    }
                }
            }
        });
        return diff;
    }

    public boolean hasNavigationBar() {
        return this.mHasNavigationBar;
    }

    public void dump(String prefix, FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.print(prefix);
        pw.print("mSafeMode=");
        pw.print(this.mSafeMode);
        pw.print(" mSystemReady=");
        pw.print(this.mSystemReady);
        pw.print(" mSystemBooted=");
        pw.println(this.mSystemBooted);
        pw.print(prefix);
        pw.print("mLidOpen=");
        pw.print(this.mLidOpen);
        pw.print(" mLidOpenRotation=");
        pw.print(this.mLidOpenRotation);
        pw.print(" mHdmiPlugged=");
        pw.println(this.mHdmiPlugged);
        if (this.mLastSystemUiFlags != 0 || this.mResettingSystemUiFlags != 0 || this.mForceClearedSystemUiFlags != 0) {
            pw.print(prefix);
            pw.print("mLastSystemUiFlags=0x");
            pw.print(Integer.toHexString(this.mLastSystemUiFlags));
            pw.print(" mResettingSystemUiFlags=0x");
            pw.print(Integer.toHexString(this.mResettingSystemUiFlags));
            pw.print(" mForceClearedSystemUiFlags=0x");
            pw.println(Integer.toHexString(this.mForceClearedSystemUiFlags));
        }
        if (this.mLastFocusNeedsMenu) {
            pw.print(prefix);
            pw.print("mLastFocusNeedsMenu=");
            pw.println(this.mLastFocusNeedsMenu);
        }
        pw.print(prefix);
        pw.print("mUiMode=");
        pw.print(this.mUiMode);
        pw.print(" mDockMode=");
        pw.print(this.mDockMode);
        pw.print(" mCarDockRotation=");
        pw.print(this.mCarDockRotation);
        pw.print(" mDeskDockRotation=");
        pw.println(this.mDeskDockRotation);
        pw.print(prefix);
        pw.print("mUserRotationMode=");
        pw.print(this.mUserRotationMode);
        pw.print(" mUserRotation=");
        pw.print(this.mUserRotation);
        pw.print(" mAllowAllRotations=");
        pw.println(this.mAllowAllRotations);
        pw.print(prefix);
        pw.print("mAccelerometerDefault=");
        pw.print(this.mAccelerometerDefault);
        pw.print(" mCurrentAppOrientation=");
        pw.println(this.mCurrentAppOrientation);
        pw.print(prefix);
        pw.print("mCarDockEnablesAccelerometer=");
        pw.print(this.mCarDockEnablesAccelerometer);
        pw.print(" mDeskDockEnablesAccelerometer=");
        pw.println(this.mDeskDockEnablesAccelerometer);
        pw.print(prefix);
        pw.print("mLidKeyboardAccessibility=");
        pw.print(this.mLidKeyboardAccessibility);
        pw.print(" mLidNavigationAccessibility=");
        pw.print(this.mLidNavigationAccessibility);
        pw.print(" mLongPressOnPowerBehavior=");
        pw.println(this.mLongPressOnPowerBehavior);
        pw.print(prefix);
        pw.print("mScreenOnEarly=");
        pw.print(this.mScreenOnEarly);
        pw.print(" mScreenOnFully=");
        pw.print(this.mScreenOnFully);
        pw.print(" mOrientationSensorEnabled=");
        pw.print(this.mOrientationSensorEnabled);
        pw.print(" mHasSoftInput=");
        pw.println(this.mHasSoftInput);
        pw.print(prefix);
        pw.print("mUnrestrictedScreen=(");
        pw.print(this.mUnrestrictedScreenLeft);
        pw.print(",");
        pw.print(this.mUnrestrictedScreenTop);
        pw.print(") ");
        pw.print(this.mUnrestrictedScreenWidth);
        pw.print("x");
        pw.println(this.mUnrestrictedScreenHeight);
        pw.print(prefix);
        pw.print("mRestrictedScreen=(");
        pw.print(this.mRestrictedScreenLeft);
        pw.print(",");
        pw.print(this.mRestrictedScreenTop);
        pw.print(") ");
        pw.print(this.mRestrictedScreenWidth);
        pw.print("x");
        pw.println(this.mRestrictedScreenHeight);
        pw.print(prefix);
        pw.print("mCur=(");
        pw.print(this.mCurLeft);
        pw.print(",");
        pw.print(this.mCurTop);
        pw.print(")-(");
        pw.print(this.mCurRight);
        pw.print(",");
        pw.print(this.mCurBottom);
        pw.println(")");
        pw.print(prefix);
        pw.print("mContent=(");
        pw.print(this.mContentLeft);
        pw.print(",");
        pw.print(this.mContentTop);
        pw.print(")-(");
        pw.print(this.mContentRight);
        pw.print(",");
        pw.print(this.mContentBottom);
        pw.println(")");
        pw.print(prefix);
        pw.print("mDock=(");
        pw.print(this.mDockLeft);
        pw.print(",");
        pw.print(this.mDockTop);
        pw.print(")-(");
        pw.print(this.mDockRight);
        pw.print(",");
        pw.print(this.mDockBottom);
        pw.println(")");
        pw.print(prefix);
        pw.print("mDockLayer=");
        pw.println(this.mDockLayer);
        pw.print(prefix);
        pw.print("mTopFullscreenOpaqueWindowState=");
        pw.println(this.mTopFullscreenOpaqueWindowState);
        pw.print(prefix);
        pw.print("mTopIsFullscreen=");
        pw.print(this.mTopIsFullscreen);
        pw.print(" mForceStatusBar=");
        pw.print(this.mForceStatusBar);
        pw.print(" mHideLockScreen=");
        pw.println(this.mHideLockScreen);
        pw.print(prefix);
        pw.print("mDismissKeyguard=");
        pw.print(this.mDismissKeyguard);
        pw.print(" mHomePressed=");
        pw.println(this.mHomePressed);
        pw.print(prefix);
        pw.print("mAllowLockscreenWhenOn=");
        pw.print(this.mAllowLockscreenWhenOn);
        pw.print(" mLockScreenTimeout=");
        pw.print(this.mLockScreenTimeout);
        pw.print(" mLockScreenTimerActive=");
        pw.println(this.mLockScreenTimerActive);
        pw.print(prefix);
        pw.print("mEndcallBehavior=");
        pw.print(this.mEndcallBehavior);
        pw.print(" mIncallPowerBehavior=");
        pw.print(this.mIncallPowerBehavior);
        pw.print(" mLongPressOnHomeBehavior=");
        pw.println(this.mLongPressOnHomeBehavior);
        pw.print(prefix);
        pw.print("mLandscapeRotation=");
        pw.print(this.mLandscapeRotation);
        pw.print(" mSeascapeRotation=");
        pw.println(this.mSeascapeRotation);
        pw.print(prefix);
        pw.print("mPortraitRotation=");
        pw.print(this.mPortraitRotation);
        pw.print(" mUpsideDownRotation=");
        pw.println(this.mUpsideDownRotation);
    }

    static {
        sApplicationLaunchKeyCategories.append(64, (Object)"android.intent.category.APP_BROWSER");
        sApplicationLaunchKeyCategories.append(65, (Object)"android.intent.category.APP_EMAIL");
        sApplicationLaunchKeyCategories.append(207, (Object)"android.intent.category.APP_CONTACTS");
        sApplicationLaunchKeyCategories.append(208, (Object)"android.intent.category.APP_CALENDAR");
        sApplicationLaunchKeyCategories.append(209, (Object)"android.intent.category.APP_MUSIC");
        sApplicationLaunchKeyCategories.append(210, (Object)"android.intent.category.APP_CALCULATOR");
        mTmpParentFrame = new Rect();
        mTmpDisplayFrame = new Rect();
        mTmpContentFrame = new Rect();
        mTmpVisibleFrame = new Rect();
        mTmpNavigationFrame = new Rect();
        WINDOW_TYPES_WHERE_HOME_DOESNT_WORK = new int[]{2003, 2010};
    }

    class PassHeadsetKey
    implements Runnable {
        KeyEvent mKeyEvent;

        PassHeadsetKey(KeyEvent keyEvent) {
            this.mKeyEvent = keyEvent;
        }

        public void run() {
            if (ActivityManagerNative.isSystemReady()) {
                Intent intent = new Intent("android.intent.action.MEDIA_BUTTON", null);
                intent.putExtra("android.intent.extra.KEY_EVENT", (Parcelable)this.mKeyEvent);
                PhoneWindowManager.this.mContext.sendOrderedBroadcast(intent, null, PhoneWindowManager.this.mBroadcastDone, PhoneWindowManager.this.mHandler, -1, null, null);
            }
        }
    }

    class MyOrientationListener
    extends WindowOrientationListener {
        MyOrientationListener(Context context) {
            super(context);
        }

        public void onProposedRotationChanged(int rotation) {
            PhoneWindowManager.this.updateRotation(false);
        }
    }

    class SettingsObserver
    extends ContentObserver {
        SettingsObserver(Handler handler) {
            super(handler);
        }

        void observe() {
            ContentResolver resolver = PhoneWindowManager.this.mContext.getContentResolver();
            resolver.registerContentObserver(Settings.System.getUriFor((String)"end_button_behavior"), false, (ContentObserver)this);
            resolver.registerContentObserver(Settings.Secure.getUriFor((String)"incall_power_button_behavior"), false, (ContentObserver)this);
            resolver.registerContentObserver(Settings.System.getUriFor((String)"accelerometer_rotation"), false, (ContentObserver)this);
            resolver.registerContentObserver(Settings.System.getUriFor((String)"user_rotation"), false, (ContentObserver)this);
            resolver.registerContentObserver(Settings.System.getUriFor((String)"screen_off_timeout"), false, (ContentObserver)this);
            resolver.registerContentObserver(Settings.System.getUriFor((String)"window_orientation_listener_log"), false, (ContentObserver)this);
            resolver.registerContentObserver(Settings.System.getUriFor((String)"pointer_location"), false, (ContentObserver)this);
            resolver.registerContentObserver(Settings.Secure.getUriFor((String)"default_input_method"), false, (ContentObserver)this);
            resolver.registerContentObserver(Settings.System.getUriFor((String)"fancy_rotation_anim"), false, (ContentObserver)this);
            PhoneWindowManager.this.updateSettings();
        }

        public void onChange(boolean selfChange) {
            PhoneWindowManager.this.updateSettings();
            PhoneWindowManager.this.updateRotation(false);
        }
    }
}

