/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.res.Configuration;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.text.Editable;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.internal.policy.impl.KeyguardScreen;
import com.android.internal.policy.impl.KeyguardScreenCallback;
import com.android.internal.policy.impl.KeyguardStatusViewManager;
import com.android.internal.policy.impl.KeyguardUpdateMonitor;
import com.android.internal.telephony.ITelephony;
import com.android.internal.widget.LockPatternUtils;

public class SimPukUnlockScreen
extends LinearLayout
implements KeyguardScreen,
View.OnClickListener,
View.OnFocusChangeListener {
    private static final int DIGIT_PRESS_WAKE_MILLIS = 5000;
    private final KeyguardUpdateMonitor mUpdateMonitor;
    private final KeyguardScreenCallback mCallback;
    private KeyguardStatusViewManager mKeyguardStatusViewManager;
    private TextView mHeaderText;
    private TextView mPukText;
    private TextView mPinText;
    private TextView mFocusedEntry;
    private View mOkButton;
    private View mDelPukButton;
    private View mDelPinButton;
    private ProgressDialog mSimUnlockProgressDialog = null;
    private LockPatternUtils mLockPatternUtils;
    private int mCreationOrientation;
    private int mKeyboardHidden;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public SimPukUnlockScreen(Context context, Configuration configuration, KeyguardUpdateMonitor updateMonitor, KeyguardScreenCallback callback, LockPatternUtils lockpatternutils) {
        super(context);
        this.mUpdateMonitor = updateMonitor;
        this.mCallback = callback;
        this.mCreationOrientation = configuration.orientation;
        this.mKeyboardHidden = configuration.hardKeyboardHidden;
        this.mLockPatternUtils = lockpatternutils;
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        if (this.mKeyboardHidden == 1) {
            inflater.inflate(17367122, (ViewGroup)this, true);
        } else {
            inflater.inflate(17367123, (ViewGroup)this, true);
            new TouchInput();
        }
        this.mHeaderText = (TextView)this.findViewById(16908960);
        this.mPukText = (TextView)this.findViewById(16908969);
        this.mPinText = (TextView)this.findViewById(16908962);
        this.mDelPukButton = this.findViewById(16908970);
        this.mDelPinButton = this.findViewById(16908955);
        this.mOkButton = this.findViewById(16908934);
        this.mDelPinButton.setOnClickListener((View.OnClickListener)this);
        this.mDelPukButton.setOnClickListener((View.OnClickListener)this);
        this.mOkButton.setOnClickListener((View.OnClickListener)this);
        this.mHeaderText.setText(17040081);
        this.mHeaderText.setSelected(true);
        this.mKeyguardStatusViewManager = new KeyguardStatusViewManager((View)this, updateMonitor, lockpatternutils, callback, false);
        this.mPinText.setFocusableInTouchMode(true);
        this.mPinText.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.mPukText.setFocusableInTouchMode(true);
        this.mPukText.setOnFocusChangeListener((View.OnFocusChangeListener)this);
    }

    public boolean needsInput() {
        return false;
    }

    public void onPause() {
        this.mKeyguardStatusViewManager.onPause();
    }

    public void onResume() {
        this.mHeaderText.setText(17040081);
        this.mKeyguardStatusViewManager.onResume();
    }

    public void cleanUp() {
        if (this.mSimUnlockProgressDialog != null) {
            this.mSimUnlockProgressDialog.dismiss();
            this.mSimUnlockProgressDialog = null;
        }
        this.mUpdateMonitor.removeCallback(this);
    }

    public void onClick(View v) {
        if (v == this.mDelPukButton) {
            Editable digits;
            int len;
            if (this.mFocusedEntry != this.mPukText) {
                this.mPukText.requestFocus();
            }
            if ((len = (digits = this.mPukText.getEditableText()).length()) > 0) {
                digits.delete(len - 1, len);
            }
        } else if (v == this.mDelPinButton) {
            Editable digits;
            int len;
            if (this.mFocusedEntry != this.mPinText) {
                this.mPinText.requestFocus();
            }
            if ((len = (digits = this.mPinText.getEditableText()).length()) > 0) {
                digits.delete(len - 1, len);
            }
        } else if (v == this.mOkButton) {
            this.checkPuk();
        }
        this.mCallback.pokeWakelock(5000);
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (hasFocus) {
            this.mFocusedEntry = (TextView)v;
        }
    }

    private Dialog getSimUnlockProgressDialog() {
        if (this.mSimUnlockProgressDialog == null) {
            this.mSimUnlockProgressDialog = new ProgressDialog(this.mContext);
            this.mSimUnlockProgressDialog.setMessage((CharSequence)this.mContext.getString(17040119));
            this.mSimUnlockProgressDialog.setIndeterminate(true);
            this.mSimUnlockProgressDialog.setCancelable(false);
            this.mSimUnlockProgressDialog.getWindow().setType(2009);
        }
        return this.mSimUnlockProgressDialog;
    }

    private void checkPuk() {
        if (this.mPukText.getText().length() < 8) {
            this.mHeaderText.setText(17039567);
            this.mPukText.setText((CharSequence)"");
            return;
        }
        if (this.mPinText.getText().length() < 4 || this.mPinText.getText().length() > 8) {
            this.mHeaderText.setText(17039566);
            this.mPinText.setText((CharSequence)"");
            return;
        }
        this.getSimUnlockProgressDialog().show();
        new CheckSimPuk(((Object)this.mPukText.getText()).toString(), ((Object)this.mPinText.getText()).toString()){

            void onSimLockChangedResponse(final boolean success) {
                SimPukUnlockScreen.this.mPinText.post(new Runnable(){

                    public void run() {
                        if (SimPukUnlockScreen.this.mSimUnlockProgressDialog != null) {
                            SimPukUnlockScreen.this.mSimUnlockProgressDialog.hide();
                        }
                        if (success) {
                            SimPukUnlockScreen.this.mUpdateMonitor.reportSimUnlocked();
                            SimPukUnlockScreen.this.mCallback.goToUnlockScreen();
                        } else {
                            SimPukUnlockScreen.this.mHeaderText.setText(17039564);
                            SimPukUnlockScreen.this.mPukText.setText((CharSequence)"");
                            SimPukUnlockScreen.this.mPinText.setText((CharSequence)"");
                        }
                    }
                });
            }
        }.start();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.mCallback.goToLockScreen();
            return true;
        }
        char match = event.getMatch(DIGITS);
        if (match != '\u0000') {
            this.reportDigit(match - 48);
            return true;
        }
        if (keyCode == 67) {
            this.mFocusedEntry.onKeyDown(keyCode, event);
            Editable digits = this.mFocusedEntry.getEditableText();
            int len = digits.length();
            if (len > 0) {
                digits.delete(len - 1, len);
            }
            this.mCallback.pokeWakelock(5000);
            return true;
        }
        if (keyCode == 66) {
            this.checkPuk();
            return true;
        }
        return false;
    }

    private void reportDigit(int digit) {
        this.mFocusedEntry.append((CharSequence)Integer.toString(digit));
    }

    void updateConfiguration() {
        Configuration newConfig = this.getResources().getConfiguration();
        if (newConfig.orientation != this.mCreationOrientation) {
            this.mCallback.recreateMe(newConfig);
        } else if (newConfig.hardKeyboardHidden != this.mKeyboardHidden) {
            boolean isKeyboardOpen;
            this.mKeyboardHidden = newConfig.hardKeyboardHidden;
            boolean bl = isKeyboardOpen = this.mKeyboardHidden == 1;
            if (this.mUpdateMonitor.isKeyguardBypassEnabled() && isKeyboardOpen) {
                this.mCallback.goToUnlockScreen();
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.updateConfiguration();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.updateConfiguration();
    }

    private class TouchInput
    implements View.OnClickListener {
        private TextView mZero;
        private TextView mOne;
        private TextView mTwo;
        private TextView mThree;
        private TextView mFour;
        private TextView mFive;
        private TextView mSix;
        private TextView mSeven;
        private TextView mEight;
        private TextView mNine;
        private TextView mCancelButton;

        private TouchInput() {
            this.mZero = (TextView)SimPukUnlockScreen.this.findViewById(16909097);
            this.mOne = (TextView)SimPukUnlockScreen.this.findViewById(16909088);
            this.mTwo = (TextView)SimPukUnlockScreen.this.findViewById(16909089);
            this.mThree = (TextView)SimPukUnlockScreen.this.findViewById(16909090);
            this.mFour = (TextView)SimPukUnlockScreen.this.findViewById(16909091);
            this.mFive = (TextView)SimPukUnlockScreen.this.findViewById(16909092);
            this.mSix = (TextView)SimPukUnlockScreen.this.findViewById(16909093);
            this.mSeven = (TextView)SimPukUnlockScreen.this.findViewById(16909094);
            this.mEight = (TextView)SimPukUnlockScreen.this.findViewById(16909095);
            this.mNine = (TextView)SimPukUnlockScreen.this.findViewById(16909096);
            this.mCancelButton = (TextView)SimPukUnlockScreen.this.findViewById(16908886);
            this.mZero.setText((CharSequence)"0");
            this.mOne.setText((CharSequence)"1");
            this.mTwo.setText((CharSequence)"2");
            this.mThree.setText((CharSequence)"3");
            this.mFour.setText((CharSequence)"4");
            this.mFive.setText((CharSequence)"5");
            this.mSix.setText((CharSequence)"6");
            this.mSeven.setText((CharSequence)"7");
            this.mEight.setText((CharSequence)"8");
            this.mNine.setText((CharSequence)"9");
            this.mZero.setOnClickListener((View.OnClickListener)this);
            this.mOne.setOnClickListener((View.OnClickListener)this);
            this.mTwo.setOnClickListener((View.OnClickListener)this);
            this.mThree.setOnClickListener((View.OnClickListener)this);
            this.mFour.setOnClickListener((View.OnClickListener)this);
            this.mFive.setOnClickListener((View.OnClickListener)this);
            this.mSix.setOnClickListener((View.OnClickListener)this);
            this.mSeven.setOnClickListener((View.OnClickListener)this);
            this.mEight.setOnClickListener((View.OnClickListener)this);
            this.mNine.setOnClickListener((View.OnClickListener)this);
            this.mCancelButton.setOnClickListener((View.OnClickListener)this);
        }

        public void onClick(View v) {
            if (v == this.mCancelButton) {
                SimPukUnlockScreen.this.mPinText.setText((CharSequence)"");
                SimPukUnlockScreen.this.mPukText.setText((CharSequence)"");
                SimPukUnlockScreen.this.mCallback.goToLockScreen();
                return;
            }
            int digit = this.checkDigit(v);
            if (digit >= 0) {
                SimPukUnlockScreen.this.mCallback.pokeWakelock(5000);
                SimPukUnlockScreen.this.reportDigit(digit);
            }
        }

        private int checkDigit(View v) {
            int digit = -1;
            if (v == this.mZero) {
                digit = 0;
            } else if (v == this.mOne) {
                digit = 1;
            } else if (v == this.mTwo) {
                digit = 2;
            } else if (v == this.mThree) {
                digit = 3;
            } else if (v == this.mFour) {
                digit = 4;
            } else if (v == this.mFive) {
                digit = 5;
            } else if (v == this.mSix) {
                digit = 6;
            } else if (v == this.mSeven) {
                digit = 7;
            } else if (v == this.mEight) {
                digit = 8;
            } else if (v == this.mNine) {
                digit = 9;
            }
            return digit;
        }
    }

    private abstract class CheckSimPuk
    extends Thread {
        private final String mPin;
        private final String mPuk;

        protected CheckSimPuk(String puk, String pin) {
            this.mPuk = puk;
            this.mPin = pin;
        }

        abstract void onSimLockChangedResponse(boolean var1);

        public void run() {
            try {
                final boolean result = ITelephony.Stub.asInterface((IBinder)ServiceManager.checkService((String)"phone")).supplyPuk(this.mPuk, this.mPin);
                SimPukUnlockScreen.this.post(new Runnable(){

                    public void run() {
                        CheckSimPuk.this.onSimLockChangedResponse(result);
                    }
                });
            }
            catch (RemoteException e) {
                SimPukUnlockScreen.this.post(new Runnable(){

                    public void run() {
                        CheckSimPuk.this.onSimLockChangedResponse(false);
                    }
                });
            }
        }
    }
}

