/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.res.Configuration;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.text.Editable;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.internal.policy.impl.KeyguardScreen;
import com.android.internal.policy.impl.KeyguardScreenCallback;
import com.android.internal.policy.impl.KeyguardStatusViewManager;
import com.android.internal.policy.impl.KeyguardUpdateMonitor;
import com.android.internal.telephony.ITelephony;
import com.android.internal.widget.LockPatternUtils;

public class SimUnlockScreen
extends LinearLayout
implements KeyguardScreen,
View.OnClickListener {
    private static final int DIGIT_PRESS_WAKE_MILLIS = 5000;
    private final KeyguardUpdateMonitor mUpdateMonitor;
    private final KeyguardScreenCallback mCallback;
    private TextView mHeaderText;
    private TextView mPinText;
    private TextView mOkButton;
    private View mBackSpaceButton;
    private final int[] mEnteredPin = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private int mEnteredDigits = 0;
    private ProgressDialog mSimUnlockProgressDialog = null;
    private LockPatternUtils mLockPatternUtils;
    private int mCreationOrientation;
    private int mKeyboardHidden;
    private KeyguardStatusViewManager mKeyguardStatusViewManager;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public SimUnlockScreen(Context context, Configuration configuration, KeyguardUpdateMonitor updateMonitor, KeyguardScreenCallback callback, LockPatternUtils lockpatternutils) {
        super(context);
        this.mUpdateMonitor = updateMonitor;
        this.mCallback = callback;
        this.mCreationOrientation = configuration.orientation;
        this.mKeyboardHidden = configuration.hardKeyboardHidden;
        this.mLockPatternUtils = lockpatternutils;
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        if (this.mKeyboardHidden == 1) {
            inflater.inflate(17367120, (ViewGroup)this, true);
        } else {
            inflater.inflate(17367121, (ViewGroup)this, true);
            new TouchInput();
        }
        this.mHeaderText = (TextView)this.findViewById(16908960);
        this.mPinText = (TextView)this.findViewById(16908962);
        this.mBackSpaceButton = this.findViewById(16908963);
        this.mBackSpaceButton.setOnClickListener((View.OnClickListener)this);
        this.mOkButton = (TextView)this.findViewById(16908934);
        this.mHeaderText.setText(17040080);
        this.mPinText.setFocusable(false);
        this.mOkButton.setOnClickListener((View.OnClickListener)this);
        this.mKeyguardStatusViewManager = new KeyguardStatusViewManager((View)this, updateMonitor, lockpatternutils, callback, false);
        this.setFocusableInTouchMode(true);
    }

    public boolean needsInput() {
        return true;
    }

    public void onPause() {
        this.mKeyguardStatusViewManager.onPause();
    }

    public void onResume() {
        this.mHeaderText.setText(17040080);
        this.mPinText.setText((CharSequence)"");
        this.mEnteredDigits = 0;
        this.mKeyguardStatusViewManager.onResume();
    }

    public void cleanUp() {
        if (this.mSimUnlockProgressDialog != null) {
            this.mSimUnlockProgressDialog.dismiss();
            this.mSimUnlockProgressDialog = null;
        }
        this.mUpdateMonitor.removeCallback(this);
    }

    public void onClick(View v) {
        if (v == this.mBackSpaceButton) {
            Editable digits = this.mPinText.getEditableText();
            int len = digits.length();
            if (len > 0) {
                digits.delete(len - 1, len);
                --this.mEnteredDigits;
            }
            this.mCallback.pokeWakelock();
        } else if (v == this.mOkButton) {
            this.checkPin();
        }
    }

    private Dialog getSimUnlockProgressDialog() {
        if (this.mSimUnlockProgressDialog == null) {
            this.mSimUnlockProgressDialog = new ProgressDialog(this.mContext);
            this.mSimUnlockProgressDialog.setMessage((CharSequence)this.mContext.getString(17040119));
            this.mSimUnlockProgressDialog.setIndeterminate(true);
            this.mSimUnlockProgressDialog.setCancelable(false);
            this.mSimUnlockProgressDialog.getWindow().setType(2009);
        }
        return this.mSimUnlockProgressDialog;
    }

    private void checkPin() {
        if (this.mEnteredDigits < 4) {
            this.mHeaderText.setText(17039566);
            this.mPinText.setText((CharSequence)"");
            this.mEnteredDigits = 0;
            this.mCallback.pokeWakelock();
            return;
        }
        this.getSimUnlockProgressDialog().show();
        new CheckSimPin(((Object)this.mPinText.getText()).toString()){

            void onSimLockChangedResponse(final boolean success) {
                SimUnlockScreen.this.mPinText.post(new Runnable(){

                    public void run() {
                        if (SimUnlockScreen.this.mSimUnlockProgressDialog != null) {
                            SimUnlockScreen.this.mSimUnlockProgressDialog.hide();
                        }
                        if (success) {
                            SimUnlockScreen.this.mUpdateMonitor.reportSimUnlocked();
                            SimUnlockScreen.this.mCallback.goToUnlockScreen();
                        } else {
                            SimUnlockScreen.this.mHeaderText.setText(17040087);
                            SimUnlockScreen.this.mPinText.setText((CharSequence)"");
                            SimUnlockScreen.this.mEnteredDigits = 0;
                        }
                        SimUnlockScreen.this.mCallback.pokeWakelock();
                    }
                });
            }
        }.start();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.mCallback.goToLockScreen();
            return true;
        }
        char match = event.getMatch(DIGITS);
        if (match != '\u0000') {
            this.reportDigit(match - 48);
            return true;
        }
        if (keyCode == 67) {
            if (this.mEnteredDigits > 0) {
                this.mPinText.onKeyDown(keyCode, event);
                --this.mEnteredDigits;
            }
            return true;
        }
        if (keyCode == 66) {
            this.checkPin();
            return true;
        }
        return false;
    }

    private void reportDigit(int digit) {
        if (this.mEnteredDigits == 0) {
            this.mPinText.setText((CharSequence)"");
        }
        if (this.mEnteredDigits == 8) {
            return;
        }
        this.mPinText.append((CharSequence)Integer.toString(digit));
        this.mEnteredPin[this.mEnteredDigits++] = digit;
    }

    void updateConfiguration() {
        Configuration newConfig = this.getResources().getConfiguration();
        if (newConfig.orientation != this.mCreationOrientation) {
            this.mCallback.recreateMe(newConfig);
        } else if (newConfig.hardKeyboardHidden != this.mKeyboardHidden) {
            boolean isKeyboardOpen;
            this.mKeyboardHidden = newConfig.hardKeyboardHidden;
            boolean bl = isKeyboardOpen = this.mKeyboardHidden == 1;
            if (this.mUpdateMonitor.isKeyguardBypassEnabled() && isKeyboardOpen) {
                this.mCallback.goToUnlockScreen();
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.updateConfiguration();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.updateConfiguration();
    }

    private class TouchInput
    implements View.OnClickListener {
        private TextView mZero;
        private TextView mOne;
        private TextView mTwo;
        private TextView mThree;
        private TextView mFour;
        private TextView mFive;
        private TextView mSix;
        private TextView mSeven;
        private TextView mEight;
        private TextView mNine;
        private TextView mCancelButton;

        private TouchInput() {
            this.mZero = (TextView)SimUnlockScreen.this.findViewById(16909097);
            this.mOne = (TextView)SimUnlockScreen.this.findViewById(16909088);
            this.mTwo = (TextView)SimUnlockScreen.this.findViewById(16909089);
            this.mThree = (TextView)SimUnlockScreen.this.findViewById(16909090);
            this.mFour = (TextView)SimUnlockScreen.this.findViewById(16909091);
            this.mFive = (TextView)SimUnlockScreen.this.findViewById(16909092);
            this.mSix = (TextView)SimUnlockScreen.this.findViewById(16909093);
            this.mSeven = (TextView)SimUnlockScreen.this.findViewById(16909094);
            this.mEight = (TextView)SimUnlockScreen.this.findViewById(16909095);
            this.mNine = (TextView)SimUnlockScreen.this.findViewById(16909096);
            this.mCancelButton = (TextView)SimUnlockScreen.this.findViewById(16908886);
            this.mZero.setText((CharSequence)"0");
            this.mOne.setText((CharSequence)"1");
            this.mTwo.setText((CharSequence)"2");
            this.mThree.setText((CharSequence)"3");
            this.mFour.setText((CharSequence)"4");
            this.mFive.setText((CharSequence)"5");
            this.mSix.setText((CharSequence)"6");
            this.mSeven.setText((CharSequence)"7");
            this.mEight.setText((CharSequence)"8");
            this.mNine.setText((CharSequence)"9");
            this.mZero.setOnClickListener((View.OnClickListener)this);
            this.mOne.setOnClickListener((View.OnClickListener)this);
            this.mTwo.setOnClickListener((View.OnClickListener)this);
            this.mThree.setOnClickListener((View.OnClickListener)this);
            this.mFour.setOnClickListener((View.OnClickListener)this);
            this.mFive.setOnClickListener((View.OnClickListener)this);
            this.mSix.setOnClickListener((View.OnClickListener)this);
            this.mSeven.setOnClickListener((View.OnClickListener)this);
            this.mEight.setOnClickListener((View.OnClickListener)this);
            this.mNine.setOnClickListener((View.OnClickListener)this);
            this.mCancelButton.setOnClickListener((View.OnClickListener)this);
        }

        public void onClick(View v) {
            if (v == this.mCancelButton) {
                SimUnlockScreen.this.mPinText.setText((CharSequence)"");
                SimUnlockScreen.this.mCallback.goToLockScreen();
                return;
            }
            int digit = this.checkDigit(v);
            if (digit >= 0) {
                SimUnlockScreen.this.mCallback.pokeWakelock(5000);
                SimUnlockScreen.this.reportDigit(digit);
            }
        }

        private int checkDigit(View v) {
            int digit = -1;
            if (v == this.mZero) {
                digit = 0;
            } else if (v == this.mOne) {
                digit = 1;
            } else if (v == this.mTwo) {
                digit = 2;
            } else if (v == this.mThree) {
                digit = 3;
            } else if (v == this.mFour) {
                digit = 4;
            } else if (v == this.mFive) {
                digit = 5;
            } else if (v == this.mSix) {
                digit = 6;
            } else if (v == this.mSeven) {
                digit = 7;
            } else if (v == this.mEight) {
                digit = 8;
            } else if (v == this.mNine) {
                digit = 9;
            }
            return digit;
        }
    }

    private abstract class CheckSimPin
    extends Thread {
        private final String mPin;

        protected CheckSimPin(String pin) {
            this.mPin = pin;
        }

        abstract void onSimLockChangedResponse(boolean var1);

        public void run() {
            try {
                final boolean result = ITelephony.Stub.asInterface((IBinder)ServiceManager.checkService((String)"phone")).supplyPin(this.mPin);
                SimUnlockScreen.this.post(new Runnable(){

                    public void run() {
                        CheckSimPin.this.onSimLockChangedResponse(result);
                    }
                });
            }
            catch (RemoteException e) {
                SimUnlockScreen.this.post(new Runnable(){

                    public void run() {
                        CheckSimPin.this.onSimLockChangedResponse(false);
                    }
                });
            }
        }
    }
}

