/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorDescription;
import android.accounts.AuthenticatorException;
import android.accounts.ChooseAccountTypeActivity;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChooseTypeAndAccountActivity
extends Activity
implements AccountManagerCallback<Bundle> {
    private static final String TAG = "AccountChooser";
    public static final String EXTRA_ALLOWABLE_ACCOUNTS_ARRAYLIST = "allowableAccounts";
    public static final String EXTRA_ALLOWABLE_ACCOUNT_TYPES_STRING_ARRAY = "allowableAccountTypes";
    public static final String EXTRA_ADD_ACCOUNT_OPTIONS_BUNDLE = "addAccountOptions";
    public static final String EXTRA_ADD_ACCOUNT_REQUIRED_FEATURES_STRING_ARRAY = "addAccountRequiredFeatures";
    public static final String EXTRA_ADD_ACCOUNT_AUTH_TOKEN_TYPE_STRING = "authTokenType";
    public static final String EXTRA_SELECTED_ACCOUNT = "selectedAccount";
    public static final String EXTRA_ALWAYS_PROMPT_FOR_ACCOUNT = "alwaysPromptForAccount";
    public static final String EXTRA_DESCRIPTION_TEXT_OVERRIDE = "descriptionTextOverride";
    public static final int REQUEST_NULL = 0;
    public static final int REQUEST_CHOOSE_TYPE = 1;
    public static final int REQUEST_ADD_ACCOUNT = 2;
    private static final String KEY_INSTANCE_STATE_PENDING_REQUEST = "pendingRequest";
    private static final String KEY_INSTANCE_STATE_EXISTING_ACCOUNTS = "existingAccounts";
    private ArrayList<AccountInfo> mAccountInfos;
    private int mPendingRequest = 0;
    private Parcelable[] mExistingAccounts = null;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "ChooseTypeAndAccountActivity.onCreate(savedInstanceState=" + savedInstanceState + ")");
        }
        this.setContentView(17367091);
        if (savedInstanceState != null) {
            this.mPendingRequest = savedInstanceState.getInt(KEY_INSTANCE_STATE_PENDING_REQUEST);
            this.mExistingAccounts = savedInstanceState.getParcelableArray(KEY_INSTANCE_STATE_EXISTING_ACCOUNTS);
        } else {
            this.mPendingRequest = 0;
            this.mExistingAccounts = null;
        }
        AccountManager accountManager = AccountManager.get(this);
        Intent intent = this.getIntent();
        String descriptionOverride = intent.getStringExtra(EXTRA_DESCRIPTION_TEXT_OVERRIDE);
        if (!TextUtils.isEmpty(descriptionOverride)) {
            ((TextView)this.findViewById(16908890)).setText(descriptionOverride);
        }
        Account selectedAccount = (Account)intent.getParcelableExtra(EXTRA_SELECTED_ACCOUNT);
        HashMap<String, AuthenticatorDescription> typeToAuthDescription = new HashMap<String, AuthenticatorDescription>();
        for (AuthenticatorDescription desc : accountManager.getAuthenticatorTypes()) {
            typeToAuthDescription.put(desc.type, desc);
        }
        HashSet<Account> setOfAllowableAccounts = null;
        ArrayList validAccounts = intent.getParcelableArrayListExtra(EXTRA_ALLOWABLE_ACCOUNTS_ARRAYLIST);
        if (validAccounts != null) {
            setOfAllowableAccounts = new HashSet<Account>(validAccounts.size());
            for (Parcelable parcelable : validAccounts) {
                setOfAllowableAccounts.add((Account)parcelable);
            }
        }
        HashSet<String> setOfAllowableAccountTypes = null;
        String[] validAccountTypes = intent.getStringArrayExtra(EXTRA_ALLOWABLE_ACCOUNT_TYPES_STRING_ARRAY);
        if (validAccountTypes != null) {
            setOfAllowableAccountTypes = new HashSet<String>(validAccountTypes.length);
            for (String type : validAccountTypes) {
                setOfAllowableAccountTypes.add(type);
            }
        }
        Account[] accounts = accountManager.getAccounts();
        this.mAccountInfos = new ArrayList(accounts.length);
        for (Account account : accounts) {
            if (setOfAllowableAccounts != null && !setOfAllowableAccounts.contains(account) || setOfAllowableAccountTypes != null && !setOfAllowableAccountTypes.contains(account.type)) continue;
            this.mAccountInfos.add(new AccountInfo(account, this.getDrawableForType(typeToAuthDescription, account.type), account.equals(selectedAccount)));
        }
        ListView list = (ListView)this.findViewById(16908298);
        list.setAdapter(new AccountArrayAdapter((Context)this, 17367043, this.mAccountInfos));
        list.setChoiceMode(1);
        list.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @Override
            public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
                ChooseTypeAndAccountActivity.this.onListItemClick((ListView)parent, v, position, id2);
            }
        });
        Button addAccountButton = (Button)this.findViewById(16908891);
        addAccountButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChooseTypeAndAccountActivity.this.startChooseAccountTypeActivity();
            }
        });
        if (this.mPendingRequest == 0) {
            if (this.mAccountInfos.isEmpty()) {
                this.startChooseAccountTypeActivity();
                return;
            }
            if (!intent.getBooleanExtra(EXTRA_ALWAYS_PROMPT_FOR_ACCOUNT, false) && this.mAccountInfos.size() == 1) {
                Account account = this.mAccountInfos.get((int)0).account;
                this.setResultAndFinish(account.name, account.type);
                return;
            }
        }
    }

    @Override
    protected void onDestroy() {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "ChooseTypeAndAccountActivity.onDestroy()");
        }
        super.onDestroy();
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(KEY_INSTANCE_STATE_PENDING_REQUEST, this.mPendingRequest);
        if (this.mPendingRequest == 2) {
            outState.putParcelableArray(KEY_INSTANCE_STATE_EXISTING_ACCOUNTS, this.mExistingAccounts);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (Log.isLoggable(TAG, 2)) {
            if (data != null && data.getExtras() != null) {
                data.getExtras().keySet();
            }
            Bundle extras = data != null ? data.getExtras() : null;
            Log.v(TAG, "ChooseTypeAndAccountActivity.onActivityResult(reqCode=" + requestCode + ", resCode=" + resultCode + ", extras=" + extras + ")");
        }
        this.mPendingRequest = 0;
        if (resultCode == 0) {
            return;
        }
        if (resultCode == -1) {
            if (requestCode == 1) {
                String accountType;
                if (data != null && (accountType = data.getStringExtra("accountType")) != null) {
                    this.runAddAccountForAuthenticator(accountType);
                    return;
                }
                Log.d(TAG, "ChooseTypeAndAccountActivity.onActivityResult: unable to find account type, pretending the request was canceled");
            } else if (requestCode == 2) {
                String accountName = null;
                String accountType = null;
                if (data != null) {
                    accountName = data.getStringExtra("authAccount");
                    accountType = data.getStringExtra("accountType");
                }
                if (accountName == null || accountType == null) {
                    Account[] currentAccounts = AccountManager.get(this).getAccounts();
                    HashSet<Account> preExistingAccounts = new HashSet<Account>();
                    for (Parcelable parcelable : this.mExistingAccounts) {
                        preExistingAccounts.add((Account)parcelable);
                    }
                    for (Parcelable parcelable : currentAccounts) {
                        if (preExistingAccounts.contains(parcelable)) continue;
                        accountName = ((Account)parcelable).name;
                        accountType = ((Account)parcelable).type;
                        break;
                    }
                }
                if (accountName != null || accountType != null) {
                    this.setResultAndFinish(accountName, accountType);
                    return;
                }
            }
            Log.d(TAG, "ChooseTypeAndAccountActivity.onActivityResult: unable to find added account, pretending the request was canceled");
        }
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "ChooseTypeAndAccountActivity.onActivityResult: canceled");
        }
        this.setResult(0);
        this.finish();
    }

    protected void runAddAccountForAuthenticator(String type) {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "runAddAccountForAuthenticator: " + type);
        }
        Bundle options = this.getIntent().getBundleExtra(EXTRA_ADD_ACCOUNT_OPTIONS_BUNDLE);
        String[] requiredFeatures = this.getIntent().getStringArrayExtra(EXTRA_ADD_ACCOUNT_REQUIRED_FEATURES_STRING_ARRAY);
        String authTokenType = this.getIntent().getStringExtra(EXTRA_ADD_ACCOUNT_AUTH_TOKEN_TYPE_STRING);
        AccountManager.get(this).addAccount(type, authTokenType, requiredFeatures, options, null, this, null);
    }

    @Override
    public void run(AccountManagerFuture<Bundle> accountManagerFuture) {
        try {
            Bundle accountManagerResult = accountManagerFuture.getResult();
            Intent intent = (Intent)accountManagerResult.getParcelable("intent");
            if (intent != null) {
                this.mPendingRequest = 2;
                this.mExistingAccounts = AccountManager.get(this).getAccounts();
                intent.setFlags(intent.getFlags() & 0xEFFFFFFF);
                this.startActivityForResult(intent, 2);
                return;
            }
        }
        catch (OperationCanceledException e) {
            this.setResult(0);
            this.finish();
            return;
        }
        catch (IOException e) {
        }
        catch (AuthenticatorException e) {
            // empty catch block
        }
        Bundle bundle = new Bundle();
        bundle.putString("errorMessage", "error communicating with server");
        this.setResult(-1, new Intent().putExtras(bundle));
        this.finish();
    }

    private Drawable getDrawableForType(HashMap<String, AuthenticatorDescription> typeToAuthDescription, String accountType) {
        Drawable icon;
        block5: {
            icon = null;
            if (typeToAuthDescription.containsKey(accountType)) {
                try {
                    AuthenticatorDescription desc = typeToAuthDescription.get(accountType);
                    Context authContext = this.createPackageContext(desc.packageName, 0);
                    icon = authContext.getResources().getDrawable(desc.iconId);
                }
                catch (PackageManager.NameNotFoundException e) {
                    if (Log.isLoggable(TAG, 5)) {
                        Log.w(TAG, "No icon name for account type " + accountType);
                    }
                }
                catch (Resources.NotFoundException e) {
                    if (!Log.isLoggable(TAG, 5)) break block5;
                    Log.w(TAG, "No icon resource for account type " + accountType);
                }
            }
        }
        return icon;
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        AccountInfo accountInfo = this.mAccountInfos.get(position);
        Log.d(TAG, "selected account " + accountInfo.account);
        this.setResultAndFinish(accountInfo.account.name, accountInfo.account.type);
    }

    private void setResultAndFinish(String accountName, String accountType) {
        Bundle bundle = new Bundle();
        bundle.putString("authAccount", accountName);
        bundle.putString("accountType", accountType);
        this.setResult(-1, new Intent().putExtras(bundle));
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "ChooseTypeAndAccountActivity.setResultAndFinish: selected account " + accountName + ", " + accountType);
        }
        this.finish();
    }

    private void startChooseAccountTypeActivity() {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "ChooseAccountTypeActivity.startChooseAccountTypeActivity()");
        }
        Intent intent = new Intent(this, ChooseAccountTypeActivity.class);
        intent.setFlags(524288);
        intent.putExtra(EXTRA_ALLOWABLE_ACCOUNT_TYPES_STRING_ARRAY, this.getIntent().getStringArrayExtra(EXTRA_ALLOWABLE_ACCOUNT_TYPES_STRING_ARRAY));
        intent.putExtra(EXTRA_ADD_ACCOUNT_OPTIONS_BUNDLE, this.getIntent().getBundleExtra(EXTRA_ADD_ACCOUNT_OPTIONS_BUNDLE));
        intent.putExtra(EXTRA_ADD_ACCOUNT_REQUIRED_FEATURES_STRING_ARRAY, this.getIntent().getStringArrayExtra(EXTRA_ADD_ACCOUNT_REQUIRED_FEATURES_STRING_ARRAY));
        intent.putExtra(EXTRA_ADD_ACCOUNT_AUTH_TOKEN_TYPE_STRING, this.getIntent().getStringExtra(EXTRA_ADD_ACCOUNT_AUTH_TOKEN_TYPE_STRING));
        this.startActivityForResult(intent, 1);
        this.mPendingRequest = 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AccountArrayAdapter
    extends ArrayAdapter<AccountInfo> {
        private LayoutInflater mLayoutInflater;
        private ArrayList<AccountInfo> mInfos;

        public AccountArrayAdapter(Context context, int textViewResourceId, ArrayList<AccountInfo> infos) {
            super(context, textViewResourceId, infos);
            this.mInfos = infos;
            this.mLayoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            if (convertView == null) {
                convertView = this.mLayoutInflater.inflate(17367090, null);
                holder = new ViewHolder();
                holder.text = (TextView)convertView.findViewById(16908888);
                holder.icon = (ImageView)convertView.findViewById(16908887);
                holder.checkmark = (ImageView)convertView.findViewById(16908889);
                convertView.setTag(holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            holder.text.setText(this.mInfos.get((int)position).account.name);
            holder.icon.setImageDrawable(this.mInfos.get((int)position).drawable);
            int displayCheckmark = this.mInfos.get(position).checked ? 0 : 4;
            holder.checkmark.setVisibility(displayCheckmark);
            return convertView;
        }
    }

    private static class ViewHolder {
        ImageView icon;
        TextView text;
        ImageView checkmark;

        private ViewHolder() {
        }
    }

    private static class AccountInfo {
        final Account account;
        final Drawable drawable;
        private final boolean checked;

        AccountInfo(Account account, Drawable drawable2, boolean checked) {
            this.account = account;
            this.drawable = drawable2;
            this.checked = checked;
        }
    }
}

