/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AccountManagerService;
import android.accounts.IAccountManagerResponse;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

public class GrantCredentialsPermissionActivity
extends Activity
implements View.OnClickListener {
    public static final String EXTRAS_ACCOUNT = "account";
    public static final String EXTRAS_AUTH_TOKEN_LABEL = "authTokenLabel";
    public static final String EXTRAS_AUTH_TOKEN_TYPE = "authTokenType";
    public static final String EXTRAS_RESPONSE = "response";
    public static final String EXTRAS_ACCOUNT_TYPE_LABEL = "accountTypeLabel";
    public static final String EXTRAS_PACKAGES = "application";
    public static final String EXTRAS_REQUESTING_UID = "uid";
    private Account mAccount;
    private String mAuthTokenType;
    private int mUid;
    private Bundle mResultBundle = null;
    protected LayoutInflater mInflater;
    private final AccountManagerService accountManagerService = AccountManagerService.getSingleton();

    protected void onCreate(Bundle savedInstanceState) {
        String accountTypeLabel;
        super.onCreate(savedInstanceState);
        this.setContentView(17367106);
        this.setTitle(17040440);
        this.mInflater = (LayoutInflater)this.getSystemService("layout_inflater");
        Bundle extras = this.getIntent().getExtras();
        if (extras == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        this.mAccount = (Account)extras.getParcelable(EXTRAS_ACCOUNT);
        this.mAuthTokenType = extras.getString(EXTRAS_AUTH_TOKEN_TYPE);
        this.mUid = extras.getInt(EXTRAS_REQUESTING_UID);
        PackageManager pm = this.getPackageManager();
        String[] packages = pm.getPackagesForUid(this.mUid);
        if (this.mAccount == null || this.mAuthTokenType == null || packages == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        try {
            accountTypeLabel = this.accountManagerService.getAccountLabel(this.mAccount.type);
        }
        catch (IllegalArgumentException e) {
            this.setResult(0);
            this.finish();
            return;
        }
        final TextView authTokenTypeView = (TextView)this.findViewById(16908908);
        authTokenTypeView.setVisibility(8);
        IAccountManagerResponse.Stub response = new IAccountManagerResponse.Stub(){

            public void onResult(Bundle bundle) {
                final String authTokenLabel = bundle.getString("authTokenLabelKey");
                if (!TextUtils.isEmpty(authTokenLabel)) {
                    GrantCredentialsPermissionActivity.this.runOnUiThread(new Runnable(){

                        public void run() {
                            if (!GrantCredentialsPermissionActivity.this.isFinishing()) {
                                authTokenTypeView.setText(authTokenLabel);
                                authTokenTypeView.setVisibility(0);
                            }
                        }
                    });
                }
            }

            public void onError(int code, String message) {
            }
        };
        this.accountManagerService.getAuthTokenLabel(response, this.mAccount, this.mAuthTokenType);
        this.findViewById(16908912).setOnClickListener(this);
        this.findViewById(16908911).setOnClickListener(this);
        LinearLayout packagesListView = (LinearLayout)this.findViewById(16908904);
        for (String pkg : packages) {
            String packageLabel;
            try {
                packageLabel = ((Object)pm.getApplicationLabel(pm.getApplicationInfo(pkg, 0))).toString();
            }
            catch (PackageManager.NameNotFoundException e) {
                packageLabel = pkg;
            }
            packagesListView.addView(this.newPackageView(packageLabel));
        }
        ((TextView)this.findViewById(16908907)).setText(this.mAccount.name);
        ((TextView)this.findViewById(16908906)).setText(accountTypeLabel);
    }

    private View newPackageView(String packageLabel) {
        View view = this.mInflater.inflate(17367143, null);
        ((TextView)view.findViewById(16909003)).setText(packageLabel);
        return view;
    }

    public void onClick(View v) {
        switch (v.getId()) {
            case 16908912: {
                this.accountManagerService.grantAppPermission(this.mAccount, this.mAuthTokenType, this.mUid);
                Intent result = new Intent();
                result.putExtra("retry", true);
                this.setResult(-1, result);
                this.setAccountAuthenticatorResult(result.getExtras());
                break;
            }
            case 16908911: {
                this.accountManagerService.revokeAppPermission(this.mAccount, this.mAuthTokenType, this.mUid);
                this.setResult(0);
            }
        }
        this.finish();
    }

    public final void setAccountAuthenticatorResult(Bundle result) {
        this.mResultBundle = result;
    }

    public void finish() {
        Intent intent = this.getIntent();
        AccountAuthenticatorResponse response = (AccountAuthenticatorResponse)intent.getParcelableExtra(EXTRAS_RESPONSE);
        if (response != null) {
            if (this.mResultBundle != null) {
                response.onResult(this.mResultBundle);
            } else {
                response.onError(4, "canceled");
            }
        }
        super.finish();
    }
}

