/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.TimeInterpolator;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Animator
implements Cloneable {
    ArrayList<AnimatorListener> mListeners = null;

    public void start() {
    }

    public void cancel() {
    }

    public void end() {
    }

    public abstract long getStartDelay();

    public abstract void setStartDelay(long var1);

    public abstract Animator setDuration(long var1);

    public abstract long getDuration();

    public abstract void setInterpolator(TimeInterpolator var1);

    public abstract boolean isRunning();

    public boolean isStarted() {
        return this.isRunning();
    }

    public void addListener(AnimatorListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(listener);
    }

    public void removeListener(AnimatorListener listener) {
        if (this.mListeners == null) {
            return;
        }
        this.mListeners.remove(listener);
        if (this.mListeners.size() == 0) {
            this.mListeners = null;
        }
    }

    public ArrayList<AnimatorListener> getListeners() {
        return this.mListeners;
    }

    public void removeAllListeners() {
        if (this.mListeners != null) {
            this.mListeners.clear();
            this.mListeners = null;
        }
    }

    public Animator clone() {
        try {
            Animator anim2 = (Animator)super.clone();
            if (this.mListeners != null) {
                ArrayList<AnimatorListener> oldListeners = this.mListeners;
                anim2.mListeners = new ArrayList();
                int numListeners = oldListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    anim2.mListeners.add(oldListeners.get(i));
                }
            }
            return anim2;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public void setupStartValues() {
    }

    public void setupEndValues() {
    }

    public void setTarget(Object target) {
    }

    public static interface AnimatorListener {
        public void onAnimationStart(Animator var1);

        public void onAnimationEnd(Animator var1);

        public void onAnimationCancel(Animator var1);

        public void onAnimationRepeat(Animator var1);
    }
}

