/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnimatorSet
extends Animator {
    private ArrayList<Animator> mPlayingSet = new ArrayList();
    private HashMap<Animator, Node> mNodeMap = new HashMap();
    private ArrayList<Node> mNodes = new ArrayList();
    private ArrayList<Node> mSortedNodes = new ArrayList();
    private boolean mNeedsSort = true;
    private AnimatorSetListener mSetListener = null;
    boolean mTerminated = false;
    private boolean mStarted = false;
    private long mStartDelay = 0L;
    private ValueAnimator mDelayAnim = null;
    private long mDuration = -1L;

    public void playTogether(Animator ... items) {
        if (items != null) {
            this.mNeedsSort = true;
            Builder builder = this.play(items[0]);
            for (int i = 1; i < items.length; ++i) {
                builder.with(items[i]);
            }
        }
    }

    public void playTogether(Collection<Animator> items) {
        if (items != null && items.size() > 0) {
            this.mNeedsSort = true;
            Builder builder = null;
            for (Animator anim2 : items) {
                if (builder == null) {
                    builder = this.play(anim2);
                    continue;
                }
                builder.with(anim2);
            }
        }
    }

    public void playSequentially(Animator ... items) {
        if (items != null) {
            this.mNeedsSort = true;
            if (items.length == 1) {
                this.play(items[0]);
            } else {
                for (int i = 0; i < items.length - 1; ++i) {
                    this.play(items[i]).before(items[i + 1]);
                }
            }
        }
    }

    public void playSequentially(List<Animator> items) {
        if (items != null && items.size() > 0) {
            this.mNeedsSort = true;
            if (items.size() == 1) {
                this.play(items.get(0));
            } else {
                for (int i = 0; i < items.size() - 1; ++i) {
                    this.play(items.get(i)).before(items.get(i + 1));
                }
            }
        }
    }

    public ArrayList<Animator> getChildAnimations() {
        ArrayList<Animator> childList = new ArrayList<Animator>();
        for (Node node : this.mNodes) {
            childList.add(node.animation);
        }
        return childList;
    }

    @Override
    public void setTarget(Object target) {
        for (Node node : this.mNodes) {
            Animator animation = node.animation;
            if (animation instanceof AnimatorSet) {
                ((AnimatorSet)animation).setTarget(target);
                continue;
            }
            if (!(animation instanceof ObjectAnimator)) continue;
            ((ObjectAnimator)animation).setTarget(target);
        }
    }

    @Override
    public void setInterpolator(TimeInterpolator interpolator2) {
        for (Node node : this.mNodes) {
            node.animation.setInterpolator(interpolator2);
        }
    }

    public Builder play(Animator anim2) {
        if (anim2 != null) {
            this.mNeedsSort = true;
            return new Builder(anim2);
        }
        return null;
    }

    @Override
    public void cancel() {
        this.mTerminated = true;
        if (this.isStarted()) {
            ArrayList tmpListeners = null;
            if (this.mListeners != null) {
                tmpListeners = (ArrayList)this.mListeners.clone();
                for (Animator.AnimatorListener listener : tmpListeners) {
                    listener.onAnimationCancel(this);
                }
            }
            if (this.mDelayAnim != null && this.mDelayAnim.isRunning()) {
                this.mDelayAnim.cancel();
            } else if (this.mSortedNodes.size() > 0) {
                for (Node node : this.mSortedNodes) {
                    node.animation.cancel();
                }
            }
            if (tmpListeners != null) {
                for (Animator.AnimatorListener listener : tmpListeners) {
                    listener.onAnimationEnd(this);
                }
            }
            this.mStarted = false;
        }
    }

    @Override
    public void end() {
        this.mTerminated = true;
        if (this.isStarted()) {
            if (this.mSortedNodes.size() != this.mNodes.size()) {
                this.sortNodes();
                for (Node node : this.mSortedNodes) {
                    if (this.mSetListener == null) {
                        this.mSetListener = new AnimatorSetListener(this);
                    }
                    node.animation.addListener(this.mSetListener);
                }
            }
            if (this.mDelayAnim != null) {
                this.mDelayAnim.cancel();
            }
            if (this.mSortedNodes.size() > 0) {
                for (Node node : this.mSortedNodes) {
                    node.animation.end();
                }
            }
            if (this.mListeners != null) {
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                for (Animator.AnimatorListener listener : tmpListeners) {
                    listener.onAnimationEnd(this);
                }
            }
            this.mStarted = false;
        }
    }

    @Override
    public boolean isRunning() {
        for (Node node : this.mNodes) {
            if (!node.animation.isRunning()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStarted() {
        return this.mStarted;
    }

    @Override
    public long getStartDelay() {
        return this.mStartDelay;
    }

    @Override
    public void setStartDelay(long startDelay) {
        this.mStartDelay = startDelay;
    }

    @Override
    public long getDuration() {
        return this.mDuration;
    }

    @Override
    public AnimatorSet setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("duration must be a value of zero or greater");
        }
        for (Node node : this.mNodes) {
            node.animation.setDuration(duration);
        }
        this.mDuration = duration;
        return this;
    }

    @Override
    public void setupStartValues() {
        for (Node node : this.mNodes) {
            node.animation.setupStartValues();
        }
    }

    @Override
    public void setupEndValues() {
        for (Node node : this.mNodes) {
            node.animation.setupEndValues();
        }
    }

    @Override
    public void start() {
        this.mTerminated = false;
        this.mStarted = true;
        this.sortNodes();
        int numSortedNodes = this.mSortedNodes.size();
        for (int i = 0; i < numSortedNodes; ++i) {
            Node node = this.mSortedNodes.get(i);
            ArrayList<Animator.AnimatorListener> oldListeners = node.animation.getListeners();
            if (oldListeners == null || oldListeners.size() <= 0) continue;
            ArrayList<Animator.AnimatorListener> clonedListeners = new ArrayList<Animator.AnimatorListener>(oldListeners);
            for (Animator.AnimatorListener listener : clonedListeners) {
                if (!(listener instanceof DependencyListener) && !(listener instanceof AnimatorSetListener)) continue;
                node.animation.removeListener(listener);
            }
        }
        final ArrayList<Node> nodesToStart = new ArrayList<Node>();
        for (int i = 0; i < numSortedNodes; ++i) {
            Node node = this.mSortedNodes.get(i);
            if (this.mSetListener == null) {
                this.mSetListener = new AnimatorSetListener(this);
            }
            if (node.dependencies == null || node.dependencies.size() == 0) {
                nodesToStart.add(node);
            } else {
                int numDependencies = node.dependencies.size();
                for (int j = 0; j < numDependencies; ++j) {
                    Dependency dependency = node.dependencies.get(j);
                    dependency.node.animation.addListener(new DependencyListener(this, node, dependency.rule));
                }
                node.tmpDependencies = (ArrayList)node.dependencies.clone();
            }
            node.animation.addListener(this.mSetListener);
        }
        if (this.mStartDelay <= 0L) {
            for (Node node : nodesToStart) {
                node.animation.start();
                this.mPlayingSet.add(node.animation);
            }
        } else {
            this.mDelayAnim = ValueAnimator.ofFloat(0.0f, 1.0f);
            this.mDelayAnim.setDuration(this.mStartDelay);
            this.mDelayAnim.addListener(new AnimatorListenerAdapter(){
                boolean canceled = false;

                public void onAnimationCancel(Animator anim2) {
                    this.canceled = true;
                }

                public void onAnimationEnd(Animator anim2) {
                    if (!this.canceled) {
                        int numNodes = nodesToStart.size();
                        for (int i = 0; i < numNodes; ++i) {
                            Node node = (Node)nodesToStart.get(i);
                            node.animation.start();
                            AnimatorSet.this.mPlayingSet.add(node.animation);
                        }
                    }
                }
            });
            this.mDelayAnim.start();
        }
        if (this.mListeners != null) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationStart(this);
            }
        }
        if (this.mNodes.size() == 0 && this.mStartDelay == 0L) {
            this.mStarted = false;
            if (this.mListeners != null) {
                ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
                int numListeners = tmpListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationEnd(this);
                }
            }
        }
    }

    @Override
    public AnimatorSet clone() {
        Node nodeClone;
        AnimatorSet anim2 = (AnimatorSet)super.clone();
        anim2.mNeedsSort = true;
        anim2.mTerminated = false;
        anim2.mStarted = false;
        anim2.mPlayingSet = new ArrayList();
        anim2.mNodeMap = new HashMap();
        anim2.mNodes = new ArrayList();
        anim2.mSortedNodes = new ArrayList();
        HashMap<Node, Node> nodeCloneMap = new HashMap<Node, Node>();
        for (Node node : this.mNodes) {
            nodeClone = node.clone();
            nodeCloneMap.put(node, nodeClone);
            anim2.mNodes.add(nodeClone);
            anim2.mNodeMap.put(nodeClone.animation, nodeClone);
            nodeClone.dependencies = null;
            nodeClone.tmpDependencies = null;
            nodeClone.nodeDependents = null;
            nodeClone.nodeDependencies = null;
            ArrayList<Animator.AnimatorListener> cloneListeners = nodeClone.animation.getListeners();
            if (cloneListeners == null) continue;
            ArrayList<Animator.AnimatorListener> listenersToRemove = null;
            for (Animator.AnimatorListener listener : cloneListeners) {
                if (!(listener instanceof AnimatorSetListener)) continue;
                if (listenersToRemove == null) {
                    listenersToRemove = new ArrayList<Animator.AnimatorListener>();
                }
                listenersToRemove.add(listener);
            }
            if (listenersToRemove == null) continue;
            for (Animator.AnimatorListener listener : listenersToRemove) {
                cloneListeners.remove(listener);
            }
        }
        for (Node node : this.mNodes) {
            nodeClone = (Node)nodeCloneMap.get(node);
            if (node.dependencies == null) continue;
            for (Dependency dependency : node.dependencies) {
                Node clonedDependencyNode = (Node)nodeCloneMap.get(dependency.node);
                Dependency cloneDependency = new Dependency(clonedDependencyNode, dependency.rule);
                nodeClone.addDependency(cloneDependency);
            }
        }
        return anim2;
    }

    private void sortNodes() {
        if (this.mNeedsSort) {
            this.mSortedNodes.clear();
            ArrayList<Node> roots = new ArrayList<Node>();
            int numNodes = this.mNodes.size();
            for (int i = 0; i < numNodes; ++i) {
                Node node = this.mNodes.get(i);
                if (node.dependencies != null && node.dependencies.size() != 0) continue;
                roots.add(node);
            }
            ArrayList<Node> tmpRoots = new ArrayList<Node>();
            while (roots.size() > 0) {
                int numRoots = roots.size();
                for (int i = 0; i < numRoots; ++i) {
                    Node root = (Node)roots.get(i);
                    this.mSortedNodes.add(root);
                    if (root.nodeDependents == null) continue;
                    int numDependents = root.nodeDependents.size();
                    for (int j = 0; j < numDependents; ++j) {
                        Node node = root.nodeDependents.get(j);
                        node.nodeDependencies.remove(root);
                        if (node.nodeDependencies.size() != 0) continue;
                        tmpRoots.add(node);
                    }
                }
                roots.clear();
                roots.addAll(tmpRoots);
                tmpRoots.clear();
            }
            this.mNeedsSort = false;
            if (this.mSortedNodes.size() != this.mNodes.size()) {
                throw new IllegalStateException("Circular dependencies cannot exist in AnimatorSet");
            }
        } else {
            int numNodes = this.mNodes.size();
            for (int i = 0; i < numNodes; ++i) {
                Node node = this.mNodes.get(i);
                if (node.dependencies != null && node.dependencies.size() > 0) {
                    int numDependencies = node.dependencies.size();
                    for (int j = 0; j < numDependencies; ++j) {
                        Dependency dependency = node.dependencies.get(j);
                        if (node.nodeDependencies == null) {
                            node.nodeDependencies = new ArrayList();
                        }
                        if (node.nodeDependencies.contains(dependency.node)) continue;
                        node.nodeDependencies.add(dependency.node);
                    }
                }
                node.done = false;
            }
        }
    }

    public class Builder {
        private Node mCurrentNode;

        Builder(Animator anim2) {
            this.mCurrentNode = (Node)AnimatorSet.this.mNodeMap.get(anim2);
            if (this.mCurrentNode == null) {
                this.mCurrentNode = new Node(anim2);
                AnimatorSet.this.mNodeMap.put(anim2, this.mCurrentNode);
                AnimatorSet.this.mNodes.add(this.mCurrentNode);
            }
        }

        public Builder with(Animator anim2) {
            Node node = (Node)AnimatorSet.this.mNodeMap.get(anim2);
            if (node == null) {
                node = new Node(anim2);
                AnimatorSet.this.mNodeMap.put(anim2, node);
                AnimatorSet.this.mNodes.add(node);
            }
            Dependency dependency = new Dependency(this.mCurrentNode, 0);
            node.addDependency(dependency);
            return this;
        }

        public Builder before(Animator anim2) {
            Node node = (Node)AnimatorSet.this.mNodeMap.get(anim2);
            if (node == null) {
                node = new Node(anim2);
                AnimatorSet.this.mNodeMap.put(anim2, node);
                AnimatorSet.this.mNodes.add(node);
            }
            Dependency dependency = new Dependency(this.mCurrentNode, 1);
            node.addDependency(dependency);
            return this;
        }

        public Builder after(Animator anim2) {
            Node node = (Node)AnimatorSet.this.mNodeMap.get(anim2);
            if (node == null) {
                node = new Node(anim2);
                AnimatorSet.this.mNodeMap.put(anim2, node);
                AnimatorSet.this.mNodes.add(node);
            }
            Dependency dependency = new Dependency(node, 1);
            this.mCurrentNode.addDependency(dependency);
            return this;
        }

        public Builder after(long delay) {
            ValueAnimator anim2 = ValueAnimator.ofFloat(0.0f, 1.0f);
            anim2.setDuration(delay);
            this.after(anim2);
            return this;
        }
    }

    private static class Node
    implements Cloneable {
        public Animator animation;
        public ArrayList<Dependency> dependencies = null;
        public ArrayList<Dependency> tmpDependencies = null;
        public ArrayList<Node> nodeDependencies = null;
        public ArrayList<Node> nodeDependents = null;
        public boolean done = false;

        public Node(Animator animation) {
            this.animation = animation;
        }

        public void addDependency(Dependency dependency) {
            if (this.dependencies == null) {
                this.dependencies = new ArrayList();
                this.nodeDependencies = new ArrayList();
            }
            this.dependencies.add(dependency);
            if (!this.nodeDependencies.contains(dependency.node)) {
                this.nodeDependencies.add(dependency.node);
            }
            Node dependencyNode = dependency.node;
            if (dependencyNode.nodeDependents == null) {
                dependencyNode.nodeDependents = new ArrayList();
            }
            dependencyNode.nodeDependents.add(this);
        }

        public Node clone() {
            try {
                Node node = (Node)super.clone();
                node.animation = this.animation.clone();
                return node;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }
    }

    private static class Dependency {
        static final int WITH = 0;
        static final int AFTER = 1;
        public Node node;
        public int rule;

        public Dependency(Node node, int rule) {
            this.node = node;
            this.rule = rule;
        }
    }

    private class AnimatorSetListener
    implements Animator.AnimatorListener {
        private AnimatorSet mAnimatorSet;

        AnimatorSetListener(AnimatorSet animatorSet2) {
            this.mAnimatorSet = animatorSet2;
        }

        public void onAnimationCancel(Animator animation) {
            if (!AnimatorSet.this.mTerminated && AnimatorSet.this.mPlayingSet.size() == 0 && AnimatorSet.this.mListeners != null) {
                int numListeners = AnimatorSet.this.mListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((Animator.AnimatorListener)AnimatorSet.this.mListeners.get(i)).onAnimationCancel(this.mAnimatorSet);
                }
            }
        }

        public void onAnimationEnd(Animator animation) {
            animation.removeListener(this);
            AnimatorSet.this.mPlayingSet.remove(animation);
            Node animNode = (Node)this.mAnimatorSet.mNodeMap.get(animation);
            animNode.done = true;
            if (!AnimatorSet.this.mTerminated) {
                ArrayList sortedNodes = this.mAnimatorSet.mSortedNodes;
                boolean allDone = true;
                int numSortedNodes = sortedNodes.size();
                for (int i = 0; i < numSortedNodes; ++i) {
                    if (((Node)sortedNodes.get((int)i)).done) continue;
                    allDone = false;
                    break;
                }
                if (allDone) {
                    if (AnimatorSet.this.mListeners != null) {
                        ArrayList tmpListeners = (ArrayList)AnimatorSet.this.mListeners.clone();
                        int numListeners = tmpListeners.size();
                        for (int i = 0; i < numListeners; ++i) {
                            ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationEnd(this.mAnimatorSet);
                        }
                    }
                    this.mAnimatorSet.mStarted = false;
                }
            }
        }

        public void onAnimationRepeat(Animator animation) {
        }

        public void onAnimationStart(Animator animation) {
        }
    }

    private static class DependencyListener
    implements Animator.AnimatorListener {
        private AnimatorSet mAnimatorSet;
        private Node mNode;
        private int mRule;

        public DependencyListener(AnimatorSet animatorSet, Node node, int rule) {
            this.mAnimatorSet = animatorSet;
            this.mNode = node;
            this.mRule = rule;
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            if (this.mRule == 1) {
                this.startIfReady(animation);
            }
        }

        public void onAnimationRepeat(Animator animation) {
        }

        public void onAnimationStart(Animator animation) {
            if (this.mRule == 0) {
                this.startIfReady(animation);
            }
        }

        private void startIfReady(Animator dependencyAnimation) {
            if (this.mAnimatorSet.mTerminated) {
                return;
            }
            Dependency dependencyToRemove = null;
            int numDependencies = this.mNode.tmpDependencies.size();
            for (int i = 0; i < numDependencies; ++i) {
                Dependency dependency = this.mNode.tmpDependencies.get(i);
                if (dependency.rule != this.mRule || dependency.node.animation != dependencyAnimation) continue;
                dependencyToRemove = dependency;
                dependencyAnimation.removeListener(this);
                break;
            }
            this.mNode.tmpDependencies.remove(dependencyToRemove);
            if (this.mNode.tmpDependencies.size() == 0) {
                this.mNode.animation.start();
                this.mAnimatorSet.mPlayingSet.add(this.mNode.animation);
            }
        }
    }
}

