/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ListActivity;
import android.content.Intent;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.PaintDrawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ListView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LauncherActivity
extends ListActivity {
    Intent mIntent;
    PackageManager mPackageManager;
    IconResizer mIconResizer;

    @Override
    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.mPackageManager = this.getPackageManager();
        this.requestWindowFeature(5);
        this.setProgressBarIndeterminateVisibility(true);
        this.onSetContentView();
        this.mIconResizer = new IconResizer();
        this.mIntent = new Intent(this.getTargetIntent());
        this.mIntent.setComponent(null);
        this.mAdapter = new ActivityAdapter(this.mIconResizer);
        this.setListAdapter(this.mAdapter);
        this.getListView().setTextFilterEnabled(true);
        this.updateAlertTitle();
        this.updateButtonText();
        this.setProgressBarIndeterminateVisibility(false);
    }

    private void updateAlertTitle() {
        TextView alertTitle = (TextView)this.findViewById(16908858);
        if (alertTitle != null) {
            alertTitle.setText(this.getTitle());
        }
    }

    private void updateButtonText() {
        Button cancelButton = (Button)this.findViewById(16908313);
        if (cancelButton != null) {
            cancelButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    LauncherActivity.this.finish();
                }
            });
        }
    }

    @Override
    public void setTitle(CharSequence title) {
        super.setTitle(title);
        this.updateAlertTitle();
    }

    @Override
    public void setTitle(int titleId) {
        super.setTitle(titleId);
        this.updateAlertTitle();
    }

    protected void onSetContentView() {
        this.setContentView(17367072);
    }

    @Override
    protected void onListItemClick(ListView l, View v, int position, long id2) {
        Intent intent = this.intentForPosition(position);
        this.startActivity(intent);
    }

    protected Intent intentForPosition(int position) {
        ActivityAdapter adapter = (ActivityAdapter)this.mAdapter;
        return adapter.intentForPosition(position);
    }

    protected ListItem itemForPosition(int position) {
        ActivityAdapter adapter = (ActivityAdapter)this.mAdapter;
        return adapter.itemForPosition(position);
    }

    protected Intent getTargetIntent() {
        return new Intent();
    }

    protected List<ResolveInfo> onQueryPackageManager(Intent queryIntent) {
        return this.mPackageManager.queryIntentActivities(queryIntent, 0);
    }

    public List<ListItem> makeListItems() {
        List<ResolveInfo> list = this.onQueryPackageManager(this.mIntent);
        Collections.sort(list, new ResolveInfo.DisplayNameComparator(this.mPackageManager));
        ArrayList<ListItem> result = new ArrayList<ListItem>(list.size());
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            ResolveInfo resolveInfo = list.get(i);
            result.add(new ListItem(this.mPackageManager, resolveInfo, null));
        }
        return result;
    }

    protected boolean onEvaluateShowIcons() {
        return true;
    }

    public class IconResizer {
        private int mIconWidth = -1;
        private int mIconHeight = -1;
        private final Rect mOldBounds = new Rect();
        private Canvas mCanvas = new Canvas();

        public IconResizer() {
            this.mCanvas.setDrawFilter(new PaintFlagsDrawFilter(4, 2));
            Resources resources = LauncherActivity.this.getResources();
            this.mIconWidth = this.mIconHeight = (int)resources.getDimension(0x1050000);
        }

        public Drawable createIconThumbnail(Drawable icon) {
            int width = this.mIconWidth;
            int height = this.mIconHeight;
            int iconWidth = icon.getIntrinsicWidth();
            int iconHeight = icon.getIntrinsicHeight();
            if (icon instanceof PaintDrawable) {
                PaintDrawable painter = (PaintDrawable)icon;
                painter.setIntrinsicWidth(width);
                painter.setIntrinsicHeight(height);
            }
            if (width > 0 && height > 0) {
                if (width < iconWidth || height < iconHeight) {
                    float ratio = (float)iconWidth / (float)iconHeight;
                    if (iconWidth > iconHeight) {
                        height = (int)((float)width / ratio);
                    } else if (iconHeight > iconWidth) {
                        width = (int)((float)height * ratio);
                    }
                    Bitmap.Config c = icon.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
                    Bitmap thumb = Bitmap.createBitmap(this.mIconWidth, this.mIconHeight, c);
                    Canvas canvas = this.mCanvas;
                    canvas.setBitmap(thumb);
                    this.mOldBounds.set(icon.getBounds());
                    int x = (this.mIconWidth - width) / 2;
                    int y = (this.mIconHeight - height) / 2;
                    icon.setBounds(x, y, x + width, y + height);
                    icon.draw(canvas);
                    icon.setBounds(this.mOldBounds);
                    icon = new BitmapDrawable(LauncherActivity.this.getResources(), thumb);
                    canvas.setBitmap(null);
                } else if (iconWidth < width && iconHeight < height) {
                    Bitmap.Config c = Bitmap.Config.ARGB_8888;
                    Bitmap thumb = Bitmap.createBitmap(this.mIconWidth, this.mIconHeight, c);
                    Canvas canvas = this.mCanvas;
                    canvas.setBitmap(thumb);
                    this.mOldBounds.set(icon.getBounds());
                    int x = (width - iconWidth) / 2;
                    int y = (height - iconHeight) / 2;
                    icon.setBounds(x, y, x + iconWidth, y + iconHeight);
                    icon.draw(canvas);
                    icon.setBounds(this.mOldBounds);
                    icon = new BitmapDrawable(LauncherActivity.this.getResources(), thumb);
                    canvas.setBitmap(null);
                }
            }
            return icon;
        }
    }

    private class ActivityAdapter
    extends BaseAdapter
    implements Filterable {
        private final Object lock = new Object();
        private ArrayList<ListItem> mOriginalValues;
        protected final IconResizer mIconResizer;
        protected final LayoutInflater mInflater;
        protected List<ListItem> mActivitiesList;
        private Filter mFilter;
        private final boolean mShowIcons;

        public ActivityAdapter(IconResizer resizer) {
            this.mIconResizer = resizer;
            this.mInflater = (LayoutInflater)LauncherActivity.this.getSystemService("layout_inflater");
            this.mShowIcons = LauncherActivity.this.onEvaluateShowIcons();
            this.mActivitiesList = LauncherActivity.this.makeListItems();
        }

        public Intent intentForPosition(int position) {
            if (this.mActivitiesList == null) {
                return null;
            }
            Intent intent = new Intent(LauncherActivity.this.mIntent);
            ListItem item = this.mActivitiesList.get(position);
            intent.setClassName(item.packageName, item.className);
            if (item.extras != null) {
                intent.putExtras(item.extras);
            }
            return intent;
        }

        public ListItem itemForPosition(int position) {
            if (this.mActivitiesList == null) {
                return null;
            }
            return this.mActivitiesList.get(position);
        }

        public int getCount() {
            return this.mActivitiesList != null ? this.mActivitiesList.size() : 0;
        }

        public Object getItem(int position) {
            return position;
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            View view = convertView == null ? this.mInflater.inflate(17367073, parent, false) : convertView;
            this.bindView(view, this.mActivitiesList.get(position));
            return view;
        }

        private void bindView(View view, ListItem item) {
            TextView text = (TextView)view;
            text.setText(item.label);
            if (this.mShowIcons) {
                if (item.icon == null) {
                    item.icon = this.mIconResizer.createIconThumbnail(item.resolveInfo.loadIcon(LauncherActivity.this.getPackageManager()));
                }
                text.setCompoundDrawablesWithIntrinsicBounds(item.icon, null, null, null);
            }
        }

        public Filter getFilter() {
            if (this.mFilter == null) {
                this.mFilter = new ArrayFilter();
            }
            return this.mFilter;
        }

        private class ArrayFilter
        extends Filter {
            private ArrayFilter() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Filter.FilterResults performFiltering(CharSequence prefix) {
                Object object;
                Filter.FilterResults results = new Filter.FilterResults();
                if (ActivityAdapter.this.mOriginalValues == null) {
                    object = ActivityAdapter.this.lock;
                    synchronized (object) {
                        ActivityAdapter.this.mOriginalValues = new ArrayList<ListItem>(ActivityAdapter.this.mActivitiesList);
                    }
                }
                if (prefix == null || prefix.length() == 0) {
                    object = ActivityAdapter.this.lock;
                    synchronized (object) {
                        ArrayList list;
                        results.values = list = new ArrayList(ActivityAdapter.this.mOriginalValues);
                        results.count = list.size();
                    }
                } else {
                    String prefixString = ((Object)prefix).toString().toLowerCase();
                    ArrayList values = ActivityAdapter.this.mOriginalValues;
                    int count = values.size();
                    ArrayList<ListItem> newValues = new ArrayList<ListItem>(count);
                    block6: for (int i = 0; i < count; ++i) {
                        ListItem item = (ListItem)values.get(i);
                        for (String word : ((Object)item.label).toString().toLowerCase().split(" ")) {
                            if (!word.startsWith(prefixString)) continue;
                            newValues.add(item);
                            continue block6;
                        }
                    }
                    results.values = newValues;
                    results.count = newValues.size();
                }
                return results;
            }

            protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
                ActivityAdapter.this.mActivitiesList = (List)results.values;
                if (results.count > 0) {
                    ActivityAdapter.this.notifyDataSetChanged();
                } else {
                    ActivityAdapter.this.notifyDataSetInvalidated();
                }
            }
        }
    }

    public static class ListItem {
        public ResolveInfo resolveInfo;
        public CharSequence label;
        public Drawable icon;
        public String packageName;
        public String className;
        public Bundle extras;

        ListItem(PackageManager pm, ResolveInfo resolveInfo, IconResizer resizer) {
            this.resolveInfo = resolveInfo;
            this.label = resolveInfo.loadLabel(pm);
            ComponentInfo ci = resolveInfo.activityInfo;
            if (ci == null) {
                ci = resolveInfo.serviceInfo;
            }
            if (this.label == null && ci != null) {
                this.label = resolveInfo.activityInfo.name;
            }
            if (resizer != null) {
                this.icon = resizer.createIconThumbnail(resolveInfo.loadIcon(pm));
            }
            this.packageName = ci.applicationInfo.packageName;
            this.className = ci.name;
        }

        public ListItem() {
        }
    }
}

