/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TimePicker;

public class TimePickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
TimePicker.OnTimeChangedListener {
    private static final String HOUR = "hour";
    private static final String MINUTE = "minute";
    private static final String IS_24_HOUR = "is24hour";
    private final TimePicker mTimePicker;
    private final OnTimeSetListener mCallback;
    int mInitialHourOfDay;
    int mInitialMinute;
    boolean mIs24HourView;

    public TimePickerDialog(Context context, OnTimeSetListener callBack, int hourOfDay, int minute, boolean is24HourView) {
        this(context, 0, callBack, hourOfDay, minute, is24HourView);
    }

    public TimePickerDialog(Context context, int theme, OnTimeSetListener callBack, int hourOfDay, int minute, boolean is24HourView) {
        super(context, theme);
        this.mCallback = callBack;
        this.mInitialHourOfDay = hourOfDay;
        this.mInitialMinute = minute;
        this.mIs24HourView = is24HourView;
        this.setIcon(0);
        this.setTitle(17040369);
        Context themeContext = this.getContext();
        this.setButton(-1, themeContext.getText(17040371), this);
        this.setButton(-2, themeContext.getText(0x1040000), (DialogInterface.OnClickListener)null);
        LayoutInflater inflater = (LayoutInflater)themeContext.getSystemService("layout_inflater");
        View view = inflater.inflate(17367209, null);
        this.setView(view);
        this.mTimePicker = (TimePicker)view.findViewById(16909086);
        this.mTimePicker.setIs24HourView(this.mIs24HourView);
        this.mTimePicker.setCurrentHour(this.mInitialHourOfDay);
        this.mTimePicker.setCurrentMinute(this.mInitialMinute);
        this.mTimePicker.setOnTimeChangedListener(this);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (this.mCallback != null) {
            this.mTimePicker.clearFocus();
            this.mCallback.onTimeSet(this.mTimePicker, this.mTimePicker.getCurrentHour(), this.mTimePicker.getCurrentMinute());
        }
    }

    public void updateTime(int hourOfDay, int minutOfHour) {
        this.mTimePicker.setCurrentHour(hourOfDay);
        this.mTimePicker.setCurrentMinute(minutOfHour);
    }

    public void onTimeChanged(TimePicker view, int hourOfDay, int minute) {
    }

    public Bundle onSaveInstanceState() {
        Bundle state = super.onSaveInstanceState();
        state.putInt(HOUR, this.mTimePicker.getCurrentHour());
        state.putInt(MINUTE, this.mTimePicker.getCurrentMinute());
        state.putBoolean(IS_24_HOUR, this.mTimePicker.is24HourView());
        return state;
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        int hour = savedInstanceState.getInt(HOUR);
        int minute = savedInstanceState.getInt(MINUTE);
        this.mTimePicker.setIs24HourView(savedInstanceState.getBoolean(IS_24_HOUR));
        this.mTimePicker.setCurrentHour(hour);
        this.mTimePicker.setCurrentMinute(minute);
    }

    public static interface OnTimeSetListener {
        public void onTimeSet(TimePicker var1, int var2, int var3);
    }
}

