/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.IBackupAgent;
import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.app.backup.FullBackup;
import android.app.backup.FullBackupDataOutput;
import android.app.backup.IBackupManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.ApplicationInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import libcore.io.ErrnoException;
import libcore.io.Libcore;
import libcore.io.OsConstants;
import libcore.io.StructStat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BackupAgent
extends ContextWrapper {
    private static final String TAG = "BackupAgent";
    private static final boolean DEBUG = true;
    public static final int TYPE_EOF = 0;
    public static final int TYPE_FILE = 1;
    public static final int TYPE_DIRECTORY = 2;
    public static final int TYPE_SYMLINK = 3;
    private final IBinder mBinder = new BackupServiceBinder().asBinder();

    public BackupAgent() {
        super(null);
    }

    public void onCreate() {
    }

    public void onDestroy() {
    }

    public abstract void onBackup(ParcelFileDescriptor var1, BackupDataOutput var2, ParcelFileDescriptor var3) throws IOException;

    public abstract void onRestore(BackupDataInput var1, int var2, ParcelFileDescriptor var3) throws IOException;

    public void onFullBackup(FullBackupDataOutput data) throws IOException {
        ApplicationInfo appInfo = this.getApplicationInfo();
        String rootDir = new File(appInfo.dataDir).getCanonicalPath();
        String filesDir = this.getFilesDir().getCanonicalPath();
        String databaseDir = this.getDatabasePath("foo").getParentFile().getCanonicalPath();
        String sharedPrefsDir = this.getSharedPrefsFile("foo").getParentFile().getCanonicalPath();
        String cacheDir = this.getCacheDir().getCanonicalPath();
        String libDir = appInfo.nativeLibraryDir != null ? new File(appInfo.nativeLibraryDir).getCanonicalPath() : null;
        HashSet<String> filterSet = new HashSet<String>();
        String packageName = this.getPackageName();
        if (libDir != null) {
            filterSet.add(libDir);
        }
        filterSet.add(cacheDir);
        filterSet.add(databaseDir);
        filterSet.add(sharedPrefsDir);
        filterSet.add(filesDir);
        this.fullBackupFileTree(packageName, "r", rootDir, filterSet, data);
        filterSet.add(rootDir);
        filterSet.remove(filesDir);
        this.fullBackupFileTree(packageName, "f", filesDir, filterSet, data);
        filterSet.add(filesDir);
        filterSet.remove(databaseDir);
        this.fullBackupFileTree(packageName, "db", databaseDir, filterSet, data);
        filterSet.add(databaseDir);
        filterSet.remove(sharedPrefsDir);
        this.fullBackupFileTree(packageName, "sp", sharedPrefsDir, filterSet, data);
    }

    public final void fullBackupFile(File file, FullBackupDataOutput output) {
        String domain;
        String filePath;
        String libDir;
        String cacheDir;
        String spDir;
        String dbDir;
        String filesDir;
        String mainDir;
        ApplicationInfo appInfo = this.getApplicationInfo();
        try {
            mainDir = new File(appInfo.dataDir).getCanonicalPath();
            filesDir = this.getFilesDir().getCanonicalPath();
            dbDir = this.getDatabasePath("foo").getParentFile().getCanonicalPath();
            spDir = this.getSharedPrefsFile("foo").getParentFile().getCanonicalPath();
            cacheDir = this.getCacheDir().getCanonicalPath();
            libDir = appInfo.nativeLibraryDir == null ? null : new File(appInfo.nativeLibraryDir).getCanonicalPath();
            filePath = file.getCanonicalPath();
        }
        catch (IOException e) {
            Log.w(TAG, "Unable to obtain canonical paths");
            return;
        }
        if (filePath.startsWith(cacheDir) || filePath.startsWith(libDir)) {
            Log.w(TAG, "lib and cache files are not backed up");
            return;
        }
        String rootpath = null;
        if (filePath.startsWith(dbDir)) {
            domain = "db";
            rootpath = dbDir;
        } else if (filePath.startsWith(spDir)) {
            domain = "sp";
            rootpath = spDir;
        } else if (filePath.startsWith(filesDir)) {
            domain = "f";
            rootpath = filesDir;
        } else if (filePath.startsWith(mainDir)) {
            domain = "r";
            rootpath = mainDir;
        } else {
            Log.w(TAG, "File " + filePath + " is in an unsupported location; skipping");
            return;
        }
        Log.i(TAG, "backupFile() of " + filePath + " => domain=" + domain + " rootpath=" + rootpath);
        FullBackup.backupToTar(this.getPackageName(), domain, null, rootpath, filePath, output.getData());
    }

    protected final void fullBackupFileTree(String packageName, String domain, String rootPath, HashSet<String> excludes, FullBackupDataOutput output) {
        File rootFile = new File(rootPath);
        if (rootFile.exists()) {
            LinkedList<File> scanQueue = new LinkedList<File>();
            scanQueue.add(rootFile);
            while (scanQueue.size() > 0) {
                String filePath;
                block7: {
                    File file = (File)scanQueue.remove(0);
                    try {
                        File[] contents;
                        filePath = file.getCanonicalPath();
                        if (excludes != null && excludes.contains(filePath)) continue;
                        StructStat stat = Libcore.os.lstat(filePath);
                        if (OsConstants.S_ISLNK((int)stat.st_mode)) {
                            Log.i(TAG, "Symlink (skipping)!: " + file);
                            continue;
                        }
                        if (!OsConstants.S_ISDIR((int)stat.st_mode) || (contents = file.listFiles()) == null) break block7;
                        for (File entry : contents) {
                            scanQueue.add(0, entry);
                        }
                    }
                    catch (IOException e) {
                        Log.w(TAG, "Error canonicalizing path of " + file);
                        continue;
                    }
                    catch (ErrnoException e) {
                        Log.w(TAG, "Error scanning file " + file + " : " + (Object)((Object)e));
                        continue;
                    }
                }
                FullBackup.backupToTar(packageName, domain, null, rootPath, filePath, output.getData());
            }
        }
    }

    public void onRestoreFile(ParcelFileDescriptor data, long size, File destination, int type, long mode, long mtime) throws IOException {
        FullBackup.restoreFile(data, size, type, mode, mtime, destination);
    }

    protected void onRestoreFile(ParcelFileDescriptor data, long size, int type, String domain, String path, long mode, long mtime) throws IOException {
        String basePath = null;
        Log.d(TAG, "onRestoreFile() size=" + size + " type=" + type + " domain=" + domain + " relpath=" + path + " mode=" + mode + " mtime=" + mtime);
        if (domain.equals("f")) {
            basePath = this.getFilesDir().getCanonicalPath();
        } else if (domain.equals("db")) {
            basePath = this.getDatabasePath("foo").getParentFile().getCanonicalPath();
        } else if (domain.equals("r")) {
            basePath = new File(this.getApplicationInfo().dataDir).getCanonicalPath();
        } else if (domain.equals("sp")) {
            basePath = this.getSharedPrefsFile("foo").getParentFile().getCanonicalPath();
        } else if (domain.equals("c")) {
            basePath = this.getCacheDir().getCanonicalPath();
        } else {
            Log.i(TAG, "Data restored from non-app domain " + domain + ", ignoring");
        }
        if (basePath != null) {
            File outFile = new File(basePath, path);
            Log.i(TAG, "[" + domain + " : " + path + "] mapped to " + outFile.getPath());
            this.onRestoreFile(data, size, outFile, type, mode, mtime);
        } else {
            Log.i(TAG, "[ skipping data from unsupported domain " + domain + "]");
            FullBackup.restoreFile(data, size, type, mode, mtime, null);
        }
    }

    public final IBinder onBind() {
        return this.mBinder;
    }

    public void attach(Context context) {
        this.attachBaseContext(context);
    }

    private class BackupServiceBinder
    extends IBackupAgent.Stub {
        private static final String TAG = "BackupServiceBinder";

        private BackupServiceBinder() {
        }

        public void doBackup(ParcelFileDescriptor oldState, ParcelFileDescriptor data, ParcelFileDescriptor newState, int token, IBackupManager callbackBinder) throws RemoteException {
            long ident = Binder.clearCallingIdentity();
            Log.v(TAG, "doBackup() invoked");
            BackupDataOutput output = new BackupDataOutput(data.getFileDescriptor());
            try {
                BackupAgent.this.onBackup(oldState, output, newState);
            }
            catch (IOException ex) {
                Log.d(TAG, "onBackup (" + BackupAgent.this.getClass().getName() + ") threw", ex);
                throw new RuntimeException(ex);
            }
            catch (RuntimeException ex) {
                Log.d(TAG, "onBackup (" + BackupAgent.this.getClass().getName() + ") threw", ex);
                throw ex;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opComplete(token);
                }
                catch (RemoteException e) {}
            }
        }

        public void doRestore(ParcelFileDescriptor data, int appVersionCode, ParcelFileDescriptor newState, int token, IBackupManager callbackBinder) throws RemoteException {
            long ident = Binder.clearCallingIdentity();
            Log.v(TAG, "doRestore() invoked");
            BackupDataInput input = new BackupDataInput(data.getFileDescriptor());
            try {
                BackupAgent.this.onRestore(input, appVersionCode, newState);
            }
            catch (IOException ex) {
                Log.d(TAG, "onRestore (" + BackupAgent.this.getClass().getName() + ") threw", ex);
                throw new RuntimeException(ex);
            }
            catch (RuntimeException ex) {
                Log.d(TAG, "onRestore (" + BackupAgent.this.getClass().getName() + ") threw", ex);
                throw ex;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opComplete(token);
                }
                catch (RemoteException e) {}
            }
        }

        public void doFullBackup(ParcelFileDescriptor data, int token, IBackupManager callbackBinder) {
            long ident = Binder.clearCallingIdentity();
            Log.v(TAG, "doFullBackup() invoked");
            try {
                BackupAgent.this.onFullBackup(new FullBackupDataOutput(data));
            }
            catch (IOException ex) {
                Log.d(TAG, "onBackup (" + BackupAgent.this.getClass().getName() + ") threw", ex);
                throw new RuntimeException(ex);
            }
            catch (RuntimeException ex) {
                Log.d(TAG, "onBackup (" + BackupAgent.this.getClass().getName() + ") threw", ex);
                throw ex;
            }
            finally {
                try {
                    FileOutputStream out = new FileOutputStream(data.getFileDescriptor());
                    byte[] buf = new byte[4];
                    out.write(buf);
                }
                catch (IOException e) {
                    Log.e(TAG, "Unable to finalize backup stream!");
                }
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opComplete(token);
                }
                catch (RemoteException e) {}
            }
        }

        public void doRestoreFile(ParcelFileDescriptor data, long size, int type, String domain, String path, long mode, long mtime, int token, IBackupManager callbackBinder) throws RemoteException {
            long ident = Binder.clearCallingIdentity();
            try {
                BackupAgent.this.onRestoreFile(data, size, type, domain, path, mode, mtime);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opComplete(token);
                }
                catch (RemoteException e) {}
            }
        }
    }
}

