/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.WallpaperManager;
import android.app.backup.BackupDataInputStream;
import android.app.backup.BackupDataOutput;
import android.app.backup.BackupHelper;
import android.app.backup.FileBackupHelperBase;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.os.ParcelFileDescriptor;
import android.view.Display;
import android.view.WindowManager;
import java.io.File;

public class WallpaperBackupHelper
extends FileBackupHelperBase
implements BackupHelper {
    private static final String TAG = "WallpaperBackupHelper";
    private static final boolean DEBUG = false;
    private static final String WALLPAPER_IMAGE = "/data/data/com.android.settings/files/wallpaper";
    private static final String STAGE_FILE = "/data/data/com.android.settings/files/wallpaper-tmp";
    Context mContext;
    String[] mFiles;
    double mDesiredMinWidth;
    double mDesiredMinHeight;

    public WallpaperBackupHelper(Context context, String ... files) {
        super(context);
        this.mContext = context;
        this.mFiles = files;
        WallpaperManager wpm = (WallpaperManager)context.getSystemService("wallpaper");
        this.mDesiredMinWidth = wpm.getDesiredMinimumWidth();
        this.mDesiredMinHeight = wpm.getDesiredMinimumHeight();
        if (this.mDesiredMinWidth <= 0.0 || this.mDesiredMinHeight <= 0.0) {
            WindowManager wm = (WindowManager)context.getSystemService("window");
            Display d = wm.getDefaultDisplay();
            Point size = new Point();
            d.getSize(size);
            this.mDesiredMinWidth = size.x;
            this.mDesiredMinHeight = size.y;
        }
    }

    public void performBackup(ParcelFileDescriptor oldState, BackupDataOutput data, ParcelFileDescriptor newState) {
        WallpaperBackupHelper.performBackup_checked(oldState, data, newState, this.mFiles, this.mFiles);
    }

    public void restoreEntity(BackupDataInputStream data) {
        String key = data.getKey();
        if (this.isKeyInList(key, this.mFiles)) {
            if (key.equals(WALLPAPER_IMAGE)) {
                File f = new File(STAGE_FILE);
                if (this.writeFile(f, data)) {
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inJustDecodeBounds = true;
                    BitmapFactory.decodeFile(STAGE_FILE, options);
                    double widthRatio = this.mDesiredMinWidth / (double)options.outWidth;
                    double heightRatio = this.mDesiredMinHeight / (double)options.outHeight;
                    if (widthRatio > 0.0 && widthRatio < 1.33 && heightRatio > 0.0 && heightRatio < 1.33) {
                        f.renameTo(new File(WALLPAPER_IMAGE));
                    } else {
                        f.delete();
                    }
                }
            } else {
                File f = new File(key);
                this.writeFile(f, data);
            }
        }
    }
}

