/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

public final class BluetoothAudioGateway {
    private static final String TAG = "BT Audio Gateway";
    private static final boolean DBG = false;
    private int mNativeData;
    private int mHandsfreeAgRfcommChannel = -1;
    private int mHeadsetAgRfcommChannel = -1;
    private String mConnectingHeadsetAddress;
    private int mConnectingHeadsetRfcommChannel;
    private int mConnectingHeadsetSocketFd;
    private String mConnectingHandsfreeAddress;
    private int mConnectingHandsfreeRfcommChannel;
    private int mConnectingHandsfreeSocketFd;
    private int mTimeoutRemainingMs;
    private final BluetoothAdapter mAdapter;
    public static final int DEFAULT_HF_AG_CHANNEL = 10;
    public static final int DEFAULT_HS_AG_CHANNEL = 11;
    private Thread mConnectThead;
    private volatile boolean mInterrupted;
    private static final int SELECT_WAIT_TIMEOUT = 1000;
    private Handler mCallback;
    public static final int MSG_INCOMING_HEADSET_CONNECTION = 100;
    public static final int MSG_INCOMING_HANDSFREE_CONNECTION = 101;

    public BluetoothAudioGateway(BluetoothAdapter adapter) {
        this(adapter, 10, 11);
    }

    public BluetoothAudioGateway(BluetoothAdapter adapter, int handsfreeAgRfcommChannel, int headsetAgRfcommChannel) {
        this.mAdapter = adapter;
        this.mHandsfreeAgRfcommChannel = handsfreeAgRfcommChannel;
        this.mHeadsetAgRfcommChannel = headsetAgRfcommChannel;
        this.initializeNativeDataNative();
    }

    public synchronized boolean start(Handler callback) {
        if (this.mConnectThead == null) {
            this.mCallback = callback;
            this.mConnectThead = new Thread(TAG){

                public void run() {
                    while (!BluetoothAudioGateway.this.mInterrupted) {
                        Message msg;
                        BluetoothAudioGateway.this.mConnectingHeadsetRfcommChannel = -1;
                        BluetoothAudioGateway.this.mConnectingHandsfreeRfcommChannel = -1;
                        if (!BluetoothAudioGateway.this.waitForHandsfreeConnectNative(1000)) {
                            if (BluetoothAudioGateway.this.mTimeoutRemainingMs <= 0) continue;
                            try {
                                Log.i(BluetoothAudioGateway.TAG, "select thread timed out, but " + BluetoothAudioGateway.this.mTimeoutRemainingMs + "ms of waiting remain.");
                                Thread.sleep(BluetoothAudioGateway.this.mTimeoutRemainingMs);
                            }
                            catch (InterruptedException e) {
                                Log.i(BluetoothAudioGateway.TAG, "select thread was interrupted (2), exiting");
                                BluetoothAudioGateway.this.mInterrupted = true;
                            }
                            continue;
                        }
                        Log.i(BluetoothAudioGateway.TAG, "connect notification!");
                        if (BluetoothAudioGateway.this.mConnectingHeadsetRfcommChannel >= 0) {
                            Log.i(BluetoothAudioGateway.TAG, "Incoming connection from headset " + BluetoothAudioGateway.this.mConnectingHeadsetAddress + " on channel " + BluetoothAudioGateway.this.mConnectingHeadsetRfcommChannel);
                            msg = Message.obtain(BluetoothAudioGateway.this.mCallback);
                            msg.what = 100;
                            msg.obj = new IncomingConnectionInfo(BluetoothAudioGateway.this.mAdapter, BluetoothAudioGateway.this.mAdapter.getRemoteDevice(BluetoothAudioGateway.this.mConnectingHeadsetAddress), BluetoothAudioGateway.this.mConnectingHeadsetSocketFd, BluetoothAudioGateway.this.mConnectingHeadsetRfcommChannel);
                            msg.sendToTarget();
                        }
                        if (BluetoothAudioGateway.this.mConnectingHandsfreeRfcommChannel < 0) continue;
                        Log.i(BluetoothAudioGateway.TAG, "Incoming connection from handsfree " + BluetoothAudioGateway.this.mConnectingHandsfreeAddress + " on channel " + BluetoothAudioGateway.this.mConnectingHandsfreeRfcommChannel);
                        msg = Message.obtain();
                        msg.setTarget(BluetoothAudioGateway.this.mCallback);
                        msg.what = 101;
                        msg.obj = new IncomingConnectionInfo(BluetoothAudioGateway.this.mAdapter, BluetoothAudioGateway.this.mAdapter.getRemoteDevice(BluetoothAudioGateway.this.mConnectingHandsfreeAddress), BluetoothAudioGateway.this.mConnectingHandsfreeSocketFd, BluetoothAudioGateway.this.mConnectingHandsfreeRfcommChannel);
                        msg.sendToTarget();
                    }
                }
            };
            if (!this.setUpListeningSocketsNative()) {
                Log.e(TAG, "Could not set up listening socket, exiting");
                return false;
            }
            this.mInterrupted = false;
            this.mConnectThead.start();
        }
        return true;
    }

    public synchronized void stop() {
        if (this.mConnectThead != null) {
            this.mInterrupted = true;
            try {
                this.mConnectThead.interrupt();
                this.mConnectThead.join();
                this.mConnectThead = null;
                this.mCallback = null;
                this.tearDownListeningSocketsNative();
            }
            catch (InterruptedException e) {
                Log.w(TAG, "Interrupted waiting for Connect Thread to join");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.cleanupNativeDataNative();
        }
        finally {
            super.finalize();
        }
    }

    private static native void classInitNative();

    private native void initializeNativeDataNative();

    private native void cleanupNativeDataNative();

    private native boolean waitForHandsfreeConnectNative(int var1);

    private native boolean setUpListeningSocketsNative();

    private native void tearDownListeningSocketsNative();

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    static {
        BluetoothAudioGateway.classInitNative();
    }

    public class IncomingConnectionInfo {
        public BluetoothAdapter mAdapter;
        public BluetoothDevice mRemoteDevice;
        public int mSocketFd;
        public int mRfcommChan;

        IncomingConnectionInfo(BluetoothAdapter adapter, BluetoothDevice remoteDevice, int socketFd, int rfcommChan) {
            this.mAdapter = adapter;
            this.mRemoteDevice = remoteDevice;
            this.mSocketFd = socketFd;
            this.mRfcommChan = rfcommChan;
        }
    }
}

