/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothPbap;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Message;
import android.os.PowerManager;
import android.server.BluetoothA2dpService;
import android.server.BluetoothService;
import android.util.Log;
import android.util.Pair;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;

public final class BluetoothDeviceProfileState
extends StateMachine {
    private static final String TAG = "BluetoothDeviceProfileState";
    private static final boolean DBG = false;
    public static final int CONNECT_HFP_OUTGOING = 1;
    public static final int CONNECT_HFP_INCOMING = 2;
    public static final int CONNECT_A2DP_OUTGOING = 3;
    public static final int CONNECT_A2DP_INCOMING = 4;
    public static final int CONNECT_HID_OUTGOING = 5;
    public static final int CONNECT_HID_INCOMING = 6;
    public static final int DISCONNECT_HFP_OUTGOING = 50;
    private static final int DISCONNECT_HFP_INCOMING = 51;
    public static final int DISCONNECT_A2DP_OUTGOING = 52;
    public static final int DISCONNECT_A2DP_INCOMING = 53;
    public static final int DISCONNECT_HID_OUTGOING = 54;
    public static final int DISCONNECT_HID_INCOMING = 55;
    public static final int DISCONNECT_PBAP_OUTGOING = 56;
    public static final int UNPAIR = 100;
    public static final int AUTO_CONNECT_PROFILES = 101;
    public static final int TRANSITION_TO_STABLE = 102;
    public static final int CONNECT_OTHER_PROFILES = 103;
    private static final int CONNECTION_ACCESS_REQUEST_REPLY = 104;
    private static final int CONNECTION_ACCESS_REQUEST_EXPIRY = 105;
    public static final int CONNECT_OTHER_PROFILES_DELAY = 4000;
    private static final int CONNECTION_ACCESS_REQUEST_EXPIRY_TIMEOUT = 7000;
    private static final int CONNECTION_ACCESS_UNDEFINED = -1;
    private static final long INIT_INCOMING_REJECT_TIMER = 1000L;
    private static final long MAX_INCOMING_REJECT_TIMER = 14400000L;
    private static final String ACCESS_AUTHORITY_PACKAGE = "com.android.settings";
    private static final String ACCESS_AUTHORITY_CLASS = "com.android.settings.bluetooth.BluetoothPermissionRequest";
    private BondedDevice mBondedDevice = new BondedDevice();
    private OutgoingHandsfree mOutgoingHandsfree = new OutgoingHandsfree();
    private IncomingHandsfree mIncomingHandsfree = new IncomingHandsfree();
    private IncomingA2dp mIncomingA2dp = new IncomingA2dp();
    private OutgoingA2dp mOutgoingA2dp = new OutgoingA2dp();
    private OutgoingHid mOutgoingHid = new OutgoingHid();
    private IncomingHid mIncomingHid = new IncomingHid();
    private Context mContext;
    private BluetoothService mService;
    private BluetoothA2dpService mA2dpService;
    private BluetoothHeadset mHeadsetService;
    private BluetoothPbap mPbapService;
    private PbapServiceListener mPbap;
    private BluetoothAdapter mAdapter;
    private boolean mPbapServiceConnected;
    private boolean mAutoConnectionPending;
    private static final String BLUETOOTH_ADMIN_PERM = "android.permission.BLUETOOTH_ADMIN";
    private BluetoothDevice mDevice;
    private int mHeadsetState = 0;
    private int mA2dpState = 0;
    private long mIncomingRejectTimer;
    private boolean mConnectionAccessReplyReceived = false;
    private Pair<Integer, String> mIncomingConnections;
    private PowerManager.WakeLock mWakeLock;
    private PowerManager mPowerManager;
    private boolean mPairingRequestRcvd = false;
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if (device == null || !device.equals(BluetoothDeviceProfileState.this.mDevice)) {
                return;
            }
            if (action.equals("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED")) {
                int newState = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                int oldState = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", 0);
                if (newState == 2) {
                    BluetoothDeviceProfileState.this.setTrust(1);
                }
                BluetoothDeviceProfileState.this.mA2dpState = newState;
                if (oldState == 2 && newState == 0) {
                    BluetoothDeviceProfileState.this.sendMessage(53);
                }
                if (newState == 2 || newState == 0) {
                    BluetoothDeviceProfileState.this.sendMessage(102);
                }
            } else if (action.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                int newState = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                int oldState = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", 0);
                if (newState == 2) {
                    BluetoothDeviceProfileState.this.setTrust(1);
                }
                BluetoothDeviceProfileState.this.mHeadsetState = newState;
                if (oldState == 2 && newState == 0) {
                    BluetoothDeviceProfileState.this.sendMessage(51);
                }
                if (newState == 2 || newState == 0) {
                    BluetoothDeviceProfileState.this.sendMessage(102);
                }
            } else if (action.equals("android.bluetooth.input.profile.action.CONNECTION_STATE_CHANGED")) {
                int newState = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                int oldState = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", 0);
                if (newState == 2) {
                    BluetoothDeviceProfileState.this.setTrust(1);
                }
                if (oldState == 2 && newState == 0) {
                    BluetoothDeviceProfileState.this.sendMessage(55);
                }
                if (newState == 2 || newState == 0) {
                    BluetoothDeviceProfileState.this.sendMessage(102);
                }
            } else if (action.equals("android.bluetooth.device.action.ACL_DISCONNECTED")) {
                BluetoothDeviceProfileState.this.sendMessage(102);
            } else if (action.equals("android.bluetooth.device.action.CONNECTION_ACCESS_REPLY")) {
                BluetoothDeviceProfileState.this.mWakeLock.release();
                int val = intent.getIntExtra("android.bluetooth.device.extra.CONNECTION_ACCESS_RESULT", 2);
                Message msg = BluetoothDeviceProfileState.this.obtainMessage(104);
                msg.arg1 = val;
                BluetoothDeviceProfileState.this.sendMessage(msg);
            } else if (action.equals("android.bluetooth.device.action.PAIRING_REQUEST")) {
                BluetoothDeviceProfileState.this.mPairingRequestRcvd = true;
            } else if (action.equals("android.bluetooth.device.action.BOND_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", Integer.MIN_VALUE);
                if (state == 12 && BluetoothDeviceProfileState.this.mPairingRequestRcvd) {
                    BluetoothDeviceProfileState.this.setTrust(1);
                    BluetoothDeviceProfileState.this.mPairingRequestRcvd = false;
                } else if (state == 10) {
                    BluetoothDeviceProfileState.this.mPairingRequestRcvd = false;
                }
            }
        }
    };
    private BluetoothProfile.ServiceListener mBluetoothProfileServiceListener = new BluetoothProfile.ServiceListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            BluetoothDeviceProfileState bluetoothDeviceProfileState = BluetoothDeviceProfileState.this;
            synchronized (bluetoothDeviceProfileState) {
                BluetoothDeviceProfileState.this.mHeadsetService = (BluetoothHeadset)proxy;
                if (BluetoothDeviceProfileState.this.mAutoConnectionPending) {
                    BluetoothDeviceProfileState.this.sendMessage(101);
                    BluetoothDeviceProfileState.this.mAutoConnectionPending = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(int profile) {
            BluetoothDeviceProfileState bluetoothDeviceProfileState = BluetoothDeviceProfileState.this;
            synchronized (bluetoothDeviceProfileState) {
                BluetoothDeviceProfileState.this.mHeadsetService = null;
            }
        }
    };

    private boolean isPhoneDocked(BluetoothDevice autoConnectDevice) {
        BluetoothDevice device;
        int state;
        Intent i = this.mContext.registerReceiver(null, new IntentFilter("android.intent.action.DOCK_EVENT"));
        return i != null && (state = i.getIntExtra("android.intent.extra.DOCK_STATE", 0)) != 0 && (device = (BluetoothDevice)i.getParcelableExtra("android.bluetooth.device.extra.DEVICE")) != null && autoConnectDevice.equals(device);
    }

    public BluetoothDeviceProfileState(Context context, String address, BluetoothService service, BluetoothA2dpService a2dpService, boolean setTrust) {
        super(address);
        this.mContext = context;
        this.mDevice = new BluetoothDevice(address);
        this.mService = service;
        this.mA2dpService = a2dpService;
        this.addState(this.mBondedDevice);
        this.addState(this.mOutgoingHandsfree);
        this.addState(this.mIncomingHandsfree);
        this.addState(this.mIncomingA2dp);
        this.addState(this.mOutgoingA2dp);
        this.addState(this.mOutgoingHid);
        this.addState(this.mIncomingHid);
        this.setInitialState(this.mBondedDevice);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
        filter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        filter.addAction("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED");
        filter.addAction("android.bluetooth.input.profile.action.CONNECTION_STATE_CHANGED");
        filter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
        filter.addAction("android.bluetooth.device.action.CONNECTION_ACCESS_REPLY");
        filter.addAction("android.bluetooth.device.action.PAIRING_REQUEST");
        filter.addAction("android.bluetooth.device.action.BOND_STATE_CHANGED");
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mAdapter.getProfileProxy(this.mContext, this.mBluetoothProfileServiceListener, 1);
        this.mPbap = new PbapServiceListener();
        this.mIncomingConnections = this.mService.getIncomingState(address);
        this.mIncomingRejectTimer = this.readTimerValue();
        this.mPowerManager = (PowerManager)this.mContext.getSystemService("power");
        this.mWakeLock = this.mPowerManager.newWakeLock(0x30000006, TAG);
        this.mWakeLock.setReferenceCounted(false);
        if (setTrust) {
            this.setTrust(1);
        }
    }

    synchronized void cancelCommand(int command) {
        if (command == 1 && this.mHeadsetService != null) {
            this.mHeadsetService.cancelConnectThread();
        }
    }

    synchronized void deferProfileServiceMessage(int command) {
        Message msg = new Message();
        msg.what = command;
        this.deferMessage(msg);
    }

    private void updateIncomingAllowedTimer() {
        if (this.mIncomingRejectTimer == 0L) {
            this.mIncomingRejectTimer = 1000L;
        }
        this.mIncomingRejectTimer *= 5L;
        if (this.mIncomingRejectTimer > 14400000L) {
            this.mIncomingRejectTimer = 14400000L;
        }
        this.writeTimerValue(this.mIncomingRejectTimer);
    }

    private boolean handleIncomingConnection(int command, boolean accept) {
        boolean ret = false;
        Log.i(TAG, "handleIncomingConnection:" + command + ":" + accept);
        switch (command) {
            case 2: {
                if (!accept) {
                    ret = this.mHeadsetService.rejectIncomingConnect(this.mDevice);
                    this.sendMessage(102);
                    this.updateIncomingAllowedTimer();
                    break;
                }
                if (this.mHeadsetState == 1) {
                    this.writeTimerValue(0L);
                    ret = this.mHeadsetService.acceptIncomingConnect(this.mDevice);
                    break;
                }
                if (this.mHeadsetState != 0) break;
                this.writeTimerValue(0L);
                this.handleConnectionOfOtherProfiles(command);
                ret = this.mHeadsetService.createIncomingConnect(this.mDevice);
                break;
            }
            case 4: {
                if (!accept) {
                    ret = this.mA2dpService.allowIncomingConnect(this.mDevice, false);
                    this.sendMessage(102);
                    this.updateIncomingAllowedTimer();
                    break;
                }
                this.writeTimerValue(0L);
                ret = this.mA2dpService.allowIncomingConnect(this.mDevice, true);
                this.handleConnectionOfOtherProfiles(command);
                break;
            }
            case 6: {
                if (!accept) {
                    ret = this.mService.allowIncomingProfileConnect(this.mDevice, false);
                    this.sendMessage(102);
                    this.updateIncomingAllowedTimer();
                    break;
                }
                this.writeTimerValue(0L);
                ret = this.mService.allowIncomingProfileConnect(this.mDevice, true);
                break;
            }
            default: {
                Log.e(TAG, "Waiting for incoming connection but state changed to:" + command);
            }
        }
        return ret;
    }

    private void sendConnectionAccessIntent() {
        this.mConnectionAccessReplyReceived = false;
        if (!this.mPowerManager.isScreenOn()) {
            this.mWakeLock.acquire();
        }
        Intent intent = new Intent("android.bluetooth.device.action.CONNECTION_ACCESS_REQUEST");
        intent.setClassName(ACCESS_AUTHORITY_PACKAGE, ACCESS_AUTHORITY_CLASS);
        intent.putExtra("android.bluetooth.device.extra.ACCESS_REQUEST_TYPE", 1);
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mDevice);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
    }

    private void sendConnectionAccessRemovalIntent() {
        this.mWakeLock.release();
        Intent intent = new Intent("android.bluetooth.device.action.CONNECTION_ACCESS_CANCEL");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mDevice);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
    }

    private int getTrust() {
        String address = this.mDevice.getAddress();
        if (this.mIncomingConnections != null) {
            return (Integer)this.mIncomingConnections.first;
        }
        return -1;
    }

    private String getStringValue(long value) {
        StringBuilder sbr = new StringBuilder();
        sbr.append(Long.toString(System.currentTimeMillis()));
        sbr.append("-");
        sbr.append(Long.toString(value));
        return sbr.toString();
    }

    private void setTrust(int value) {
        String second = this.mIncomingConnections == null ? this.getStringValue(1000L) : (String)this.mIncomingConnections.second;
        this.mIncomingConnections = new Pair<Integer, String>(value, second);
        this.mService.writeIncomingConnectionState(this.mDevice.getAddress(), this.mIncomingConnections);
    }

    private void writeTimerValue(long value) {
        Integer first = this.mIncomingConnections == null ? Integer.valueOf(-1) : (Integer)this.mIncomingConnections.first;
        this.mIncomingConnections = new Pair<Integer, String>(first, this.getStringValue(value));
        this.mService.writeIncomingConnectionState(this.mDevice.getAddress(), this.mIncomingConnections);
    }

    private long readTimerValue() {
        if (this.mIncomingConnections == null) {
            return 0L;
        }
        String value = (String)this.mIncomingConnections.second;
        String[] splits = value.split("-");
        if (splits != null && splits.length == 2) {
            return Long.parseLong(splits[1]);
        }
        return 0L;
    }

    private boolean readIncomingAllowedValue() {
        long val2;
        long val1;
        if (this.readTimerValue() == 0L) {
            return true;
        }
        String value = (String)this.mIncomingConnections.second;
        String[] splits = value.split("-");
        return splits != null && splits.length == 2 && (val1 = Long.parseLong(splits[0])) + (val2 = Long.parseLong(splits[1])) <= System.currentTimeMillis();
    }

    synchronized boolean processCommand(int command) {
        this.log("Processing command:" + command);
        switch (command) {
            case 1: {
                if (this.mHeadsetService == null) {
                    this.deferProfileServiceMessage(command);
                    break;
                }
                return this.mHeadsetService.connectHeadsetInternal(this.mDevice);
            }
            case 2: {
                if (this.mHeadsetService == null) {
                    this.deferProfileServiceMessage(command);
                    break;
                }
                this.processIncomingConnectCommand(command);
                return true;
            }
            case 3: {
                if (this.mA2dpService == null) break;
                return this.mA2dpService.connectSinkInternal(this.mDevice);
            }
            case 4: {
                this.processIncomingConnectCommand(command);
                return true;
            }
            case 5: {
                return this.mService.connectInputDeviceInternal(this.mDevice);
            }
            case 6: {
                this.processIncomingConnectCommand(command);
                return true;
            }
            case 50: {
                if (this.mHeadsetService == null) {
                    this.deferProfileServiceMessage(command);
                    break;
                }
                Message m = new Message();
                m.what = 56;
                this.deferMessage(m);
                if (this.mHeadsetService.getPriority(this.mDevice) == 1000) {
                    this.mHeadsetService.setPriority(this.mDevice, 100);
                }
                return this.mHeadsetService.disconnectHeadsetInternal(this.mDevice);
            }
            case 51: {
                return true;
            }
            case 53: {
                return true;
            }
            case 52: {
                if (this.mA2dpService == null) break;
                if (this.mA2dpService.getPriority(this.mDevice) == 1000) {
                    this.mA2dpService.setPriority(this.mDevice, 100);
                }
                return this.mA2dpService.disconnectSinkInternal(this.mDevice);
            }
            case 55: {
                return true;
            }
            case 54: {
                if (this.mService.getInputDevicePriority(this.mDevice) == 1000) {
                    this.mService.setInputDevicePriority(this.mDevice, 100);
                }
                return this.mService.disconnectInputDeviceInternal(this.mDevice);
            }
            case 56: {
                if (!this.mPbapServiceConnected) {
                    this.deferProfileServiceMessage(command);
                    break;
                }
                return this.mPbapService.disconnect();
            }
            case 100: {
                this.writeTimerValue(1000L);
                this.setTrust(-1);
                return this.mService.removeBondInternal(this.mDevice.getAddress());
            }
            default: {
                Log.e(TAG, "Error: Unknown Command");
            }
        }
        return false;
    }

    private void processIncomingConnectCommand(int command) {
        int access = this.getTrust();
        if (access == 1) {
            this.handleIncomingConnection(command, true);
        } else if (access == 2 && !this.readIncomingAllowedValue()) {
            this.handleIncomingConnection(command, false);
        } else {
            this.sendConnectionAccessIntent();
            Message msg = this.obtainMessage(105);
            this.sendMessageDelayed(msg, 7000L);
        }
    }

    private void handleConnectionOfOtherProfiles(int command) {
        switch (command) {
            case 2: {
                if (this.mA2dpService.getPriority(this.mDevice) != 100 && this.mA2dpService.getPriority(this.mDevice) != 1000) break;
                Message msg = new Message();
                msg.what = 103;
                msg.arg1 = 3;
                this.sendMessageDelayed(msg, 4000L);
                break;
            }
            case 4: {
                if (this.mHeadsetService == null || this.mHeadsetService.getPriority(this.mDevice) != 100 && this.mHeadsetService.getPriority(this.mDevice) != 1000) break;
                Message msg = new Message();
                msg.what = 103;
                msg.arg1 = 1;
                this.sendMessageDelayed(msg, 4000L);
                break;
            }
        }
    }

    BluetoothDevice getDevice() {
        return this.mDevice;
    }

    private void log(String message) {
    }

    private class IncomingHid
    extends State {
        private boolean mStatus = false;
        private int mCommand;

        private IncomingHid() {
        }

        public void enter() {
            BluetoothDeviceProfileState.this.log("Entering IncomingHid state with: " + ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what);
            this.mCommand = ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what;
            if (this.mCommand != 6 && this.mCommand != 55) {
                Log.e(BluetoothDeviceProfileState.TAG, "Error: IncomingHid state with command:" + this.mCommand);
            }
            this.mStatus = BluetoothDeviceProfileState.this.processCommand(this.mCommand);
            if (!this.mStatus) {
                BluetoothDeviceProfileState.this.sendMessage(102);
            }
        }

        public boolean processMessage(Message message) {
            BluetoothDeviceProfileState.this.log("IncomingHid State->Processing Message: " + message.what);
            Message deferMsg = new Message();
            switch (message.what) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 50: 
                case 52: 
                case 54: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 104: {
                    BluetoothDeviceProfileState.this.mConnectionAccessReplyReceived = true;
                    int val = message.arg1;
                    BluetoothDeviceProfileState.this.setTrust(val);
                    BluetoothDeviceProfileState.this.handleIncomingConnection(6, val == 1);
                    break;
                }
                case 105: {
                    if (BluetoothDeviceProfileState.this.mConnectionAccessReplyReceived) break;
                    BluetoothDeviceProfileState.this.handleIncomingConnection(6, false);
                    BluetoothDeviceProfileState.this.sendConnectionAccessRemovalIntent();
                    BluetoothDeviceProfileState.this.sendMessage(102);
                    break;
                }
                case 51: {
                    break;
                }
                case 53: 
                case 55: {
                    break;
                }
                case 56: 
                case 100: 
                case 101: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 102: {
                    BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mBondedDevice);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    private class OutgoingHid
    extends State {
        private boolean mStatus = false;
        private int mCommand;

        private OutgoingHid() {
        }

        public void enter() {
            BluetoothDeviceProfileState.this.log("Entering OutgoingHid state with: " + ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what);
            this.mCommand = ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what;
            if (this.mCommand != 5 && this.mCommand != 54) {
                Log.e(BluetoothDeviceProfileState.TAG, "Error: OutgoingHid state with command:" + this.mCommand);
            }
            this.mStatus = BluetoothDeviceProfileState.this.processCommand(this.mCommand);
            if (!this.mStatus) {
                BluetoothDeviceProfileState.this.sendMessage(102);
            }
        }

        public boolean processMessage(Message message) {
            BluetoothDeviceProfileState.this.log("OutgoingHid State->Processing Message: " + message.what);
            Message deferMsg = new Message();
            switch (message.what) {
                case 1: 
                case 3: 
                case 5: 
                case 50: 
                case 52: 
                case 54: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 2: {
                    BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mIncomingHandsfree);
                    break;
                }
                case 4: {
                    BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mIncomingA2dp);
                    if (!this.mStatus) break;
                    deferMsg.what = this.mCommand;
                    BluetoothDeviceProfileState.this.deferMessage(deferMsg);
                    break;
                }
                case 6: {
                    BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mIncomingHid);
                    break;
                }
                case 51: 
                case 53: {
                    if (!this.mStatus) break;
                    deferMsg.what = this.mCommand;
                    BluetoothDeviceProfileState.this.deferMessage(deferMsg);
                    break;
                }
                case 55: {
                    break;
                }
                case 56: 
                case 100: 
                case 101: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 102: {
                    BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mBondedDevice);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    private class IncomingA2dp
    extends State {
        private boolean mStatus = false;
        private int mCommand;

        private IncomingA2dp() {
        }

        public void enter() {
            Log.i(BluetoothDeviceProfileState.TAG, "Entering IncomingA2dp state with: " + ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what);
            this.mCommand = ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what;
            if (this.mCommand != 4 && this.mCommand != 53) {
                Log.e(BluetoothDeviceProfileState.TAG, "Error: IncomingA2DP state with command:" + this.mCommand);
            }
            this.mStatus = BluetoothDeviceProfileState.this.processCommand(this.mCommand);
            if (!this.mStatus) {
                BluetoothDeviceProfileState.this.sendMessage(102);
                BluetoothDeviceProfileState.this.mService.sendProfileStateMessage(1, 100);
            }
        }

        public boolean processMessage(Message message) {
            BluetoothDeviceProfileState.this.log("IncomingA2dp State->Processing Message: " + message.what);
            switch (message.what) {
                case 1: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 2: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 4: {
                    break;
                }
                case 104: {
                    int val = message.arg1;
                    BluetoothDeviceProfileState.this.mConnectionAccessReplyReceived = true;
                    boolean value = false;
                    if (val == 1) {
                        value = true;
                    }
                    BluetoothDeviceProfileState.this.setTrust(val);
                    BluetoothDeviceProfileState.this.handleIncomingConnection(4, value);
                    break;
                }
                case 105: {
                    if (BluetoothDeviceProfileState.this.mConnectionAccessReplyReceived) break;
                    BluetoothDeviceProfileState.this.handleIncomingConnection(4, false);
                    BluetoothDeviceProfileState.this.sendConnectionAccessRemovalIntent();
                    BluetoothDeviceProfileState.this.sendMessage(102);
                    break;
                }
                case 3: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 50: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 51: {
                    break;
                }
                case 52: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 53: {
                    break;
                }
                case 5: 
                case 54: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 6: 
                case 55: {
                    break;
                }
                case 56: 
                case 100: 
                case 101: 
                case 103: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 102: {
                    BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mBondedDevice);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    private class OutgoingA2dp
    extends State {
        private boolean mStatus = false;
        private int mCommand;

        private OutgoingA2dp() {
        }

        public void enter() {
            Log.i(BluetoothDeviceProfileState.TAG, "Entering OutgoingA2dp state with: " + ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what);
            this.mCommand = ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what;
            if (this.mCommand != 3 && this.mCommand != 52) {
                Log.e(BluetoothDeviceProfileState.TAG, "Error: OutgoingA2DP state with command:" + this.mCommand);
            }
            this.mStatus = BluetoothDeviceProfileState.this.processCommand(this.mCommand);
            if (!this.mStatus) {
                BluetoothDeviceProfileState.this.sendMessage(102);
                BluetoothDeviceProfileState.this.mService.sendProfileStateMessage(1, 100);
            }
        }

        public boolean processMessage(Message message) {
            BluetoothDeviceProfileState.this.log("OutgoingA2dp State->Processing Message: " + message.what);
            Message deferMsg = new Message();
            switch (message.what) {
                case 1: {
                    BluetoothDeviceProfileState.this.processCommand(1);
                    if (!this.mStatus) break;
                    deferMsg.what = this.mCommand;
                    BluetoothDeviceProfileState.this.deferMessage(deferMsg);
                    break;
                }
                case 2: {
                    BluetoothDeviceProfileState.this.processCommand(2);
                    if (!this.mStatus) break;
                    deferMsg.what = this.mCommand;
                    BluetoothDeviceProfileState.this.deferMessage(deferMsg);
                    break;
                }
                case 4: {
                    BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mIncomingA2dp);
                    break;
                }
                case 3: {
                    break;
                }
                case 50: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 51: {
                    if (!this.mStatus) break;
                    deferMsg.what = this.mCommand;
                    BluetoothDeviceProfileState.this.deferMessage(deferMsg);
                    break;
                }
                case 52: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 53: {
                    break;
                }
                case 5: 
                case 54: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 6: {
                    BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mIncomingHid);
                    if (!this.mStatus) break;
                    deferMsg.what = this.mCommand;
                    BluetoothDeviceProfileState.this.deferMessage(deferMsg);
                    break;
                }
                case 55: {
                    if (!this.mStatus) break;
                    deferMsg.what = this.mCommand;
                    BluetoothDeviceProfileState.this.deferMessage(deferMsg);
                    break;
                }
                case 56: 
                case 100: 
                case 101: 
                case 103: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 102: {
                    BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mBondedDevice);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    private class IncomingHandsfree
    extends State {
        private boolean mStatus = false;
        private int mCommand;

        private IncomingHandsfree() {
        }

        public void enter() {
            Log.i(BluetoothDeviceProfileState.TAG, "Entering IncomingHandsfree state with: " + ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what);
            this.mCommand = ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what;
            if (this.mCommand != 2 && this.mCommand != 51) {
                Log.e(BluetoothDeviceProfileState.TAG, "Error: IncomingHandsfree state with command:" + this.mCommand);
            }
            this.mStatus = BluetoothDeviceProfileState.this.processCommand(this.mCommand);
            if (!this.mStatus) {
                BluetoothDeviceProfileState.this.sendMessage(102);
                BluetoothDeviceProfileState.this.mService.sendProfileStateMessage(0, 100);
            }
        }

        public boolean processMessage(Message message) {
            BluetoothDeviceProfileState.this.log("IncomingHandsfree State -> Processing Message: " + message.what);
            switch (message.what) {
                case 1: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 2: {
                    Log.e(BluetoothDeviceProfileState.TAG, "Error: Incoming connection with a pending incoming connection");
                    break;
                }
                case 104: {
                    int val = message.arg1;
                    BluetoothDeviceProfileState.this.mConnectionAccessReplyReceived = true;
                    boolean value = false;
                    if (val == 1) {
                        value = true;
                    }
                    BluetoothDeviceProfileState.this.setTrust(val);
                    BluetoothDeviceProfileState.this.handleIncomingConnection(2, value);
                    break;
                }
                case 105: {
                    if (BluetoothDeviceProfileState.this.mConnectionAccessReplyReceived) break;
                    BluetoothDeviceProfileState.this.handleIncomingConnection(2, false);
                    BluetoothDeviceProfileState.this.sendConnectionAccessRemovalIntent();
                    BluetoothDeviceProfileState.this.sendMessage(102);
                    break;
                }
                case 4: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 3: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 50: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 51: {
                    break;
                }
                case 52: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 53: {
                    break;
                }
                case 5: 
                case 54: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 6: 
                case 55: {
                    break;
                }
                case 56: 
                case 100: 
                case 101: 
                case 103: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 102: {
                    BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mBondedDevice);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    private class OutgoingHandsfree
    extends State {
        private boolean mStatus = false;
        private int mCommand;

        private OutgoingHandsfree() {
        }

        public void enter() {
            Log.i(BluetoothDeviceProfileState.TAG, "Entering OutgoingHandsfree state with: " + ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what);
            this.mCommand = ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what;
            if (this.mCommand != 1 && this.mCommand != 50) {
                Log.e(BluetoothDeviceProfileState.TAG, "Error: OutgoingHandsfree state with command:" + this.mCommand);
            }
            this.mStatus = BluetoothDeviceProfileState.this.processCommand(this.mCommand);
            if (!this.mStatus) {
                BluetoothDeviceProfileState.this.sendMessage(102);
                BluetoothDeviceProfileState.this.mService.sendProfileStateMessage(0, 100);
            }
        }

        public boolean processMessage(Message message) {
            BluetoothDeviceProfileState.this.log("OutgoingHandsfree State -> Processing Message: " + message.what);
            Message deferMsg = new Message();
            int command = message.what;
            switch (command) {
                case 1: {
                    if (command == this.mCommand) break;
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 2: {
                    if (this.mCommand == 1) {
                        BluetoothDeviceProfileState.this.cancelCommand(1);
                        BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mIncomingHandsfree);
                        break;
                    }
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 4: {
                    BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mIncomingA2dp);
                    if (!this.mStatus) break;
                    deferMsg.what = this.mCommand;
                    BluetoothDeviceProfileState.this.deferMessage(deferMsg);
                    break;
                }
                case 3: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 50: {
                    if (this.mCommand != 1) break;
                    BluetoothDeviceProfileState.this.cancelCommand(1);
                    BluetoothDeviceProfileState.this.processCommand(50);
                    break;
                }
                case 51: {
                    BluetoothDeviceProfileState.this.cancelCommand(1);
                    break;
                }
                case 52: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 53: {
                    if (!this.mStatus) break;
                    deferMsg.what = this.mCommand;
                    BluetoothDeviceProfileState.this.deferMessage(deferMsg);
                    break;
                }
                case 5: 
                case 54: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 6: {
                    BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mIncomingHid);
                    if (!this.mStatus) break;
                    deferMsg.what = this.mCommand;
                    BluetoothDeviceProfileState.this.deferMessage(deferMsg);
                    break;
                }
                case 55: {
                    if (!this.mStatus) break;
                    deferMsg.what = this.mCommand;
                    BluetoothDeviceProfileState.this.deferMessage(deferMsg);
                    break;
                }
                case 56: 
                case 100: 
                case 101: 
                case 103: {
                    BluetoothDeviceProfileState.this.deferMessage(message);
                    break;
                }
                case 102: {
                    BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mBondedDevice);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    private class BondedDevice
    extends State {
        private BondedDevice() {
        }

        public void enter() {
            Log.i(BluetoothDeviceProfileState.TAG, "Entering ACL Connected state with: " + ((BluetoothDeviceProfileState)BluetoothDeviceProfileState.this).getCurrentMessage().what);
            Message m = new Message();
            m.copyFrom(BluetoothDeviceProfileState.this.getCurrentMessage());
            BluetoothDeviceProfileState.this.sendMessageAtFrontOfQueue(m);
        }

        public boolean processMessage(Message message) {
            BluetoothDeviceProfileState.this.log("ACL Connected State -> Processing Message: " + message.what);
            switch (message.what) {
                case 1: 
                case 50: {
                    BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mOutgoingHandsfree);
                    break;
                }
                case 2: {
                    BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mIncomingHandsfree);
                    break;
                }
                case 51: {
                    BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mIncomingHandsfree);
                    break;
                }
                case 3: 
                case 52: {
                    BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mOutgoingA2dp);
                    break;
                }
                case 4: 
                case 53: {
                    BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mIncomingA2dp);
                    break;
                }
                case 5: 
                case 54: {
                    BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mOutgoingHid);
                    break;
                }
                case 6: 
                case 55: {
                    BluetoothDeviceProfileState.this.transitionTo(BluetoothDeviceProfileState.this.mIncomingHid);
                    break;
                }
                case 56: {
                    BluetoothDeviceProfileState.this.processCommand(56);
                    break;
                }
                case 100: {
                    if (BluetoothDeviceProfileState.this.mHeadsetState != 0) {
                        BluetoothDeviceProfileState.this.sendMessage(50);
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        break;
                    }
                    if (BluetoothDeviceProfileState.this.mA2dpState != 0) {
                        BluetoothDeviceProfileState.this.sendMessage(52);
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        break;
                    }
                    if (BluetoothDeviceProfileState.this.mService.getInputDeviceConnectionState(BluetoothDeviceProfileState.this.mDevice) != 0) {
                        BluetoothDeviceProfileState.this.sendMessage(54);
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        break;
                    }
                    BluetoothDeviceProfileState.this.processCommand(100);
                    break;
                }
                case 101: {
                    if (BluetoothDeviceProfileState.this.isPhoneDocked(BluetoothDeviceProfileState.this.mDevice)) break;
                    if (BluetoothDeviceProfileState.this.mHeadsetService == null) {
                        BluetoothDeviceProfileState.this.mAutoConnectionPending = true;
                    } else if (BluetoothDeviceProfileState.this.mHeadsetService.getPriority(BluetoothDeviceProfileState.this.mDevice) == 1000 && BluetoothDeviceProfileState.this.mHeadsetService.getDevicesMatchingConnectionStates(new int[]{2, 1, 3}).size() == 0) {
                        BluetoothDeviceProfileState.this.mHeadsetService.connect(BluetoothDeviceProfileState.this.mDevice);
                    }
                    if (BluetoothDeviceProfileState.this.mA2dpService != null && BluetoothDeviceProfileState.this.mA2dpService.getPriority(BluetoothDeviceProfileState.this.mDevice) == 1000 && BluetoothDeviceProfileState.this.mA2dpService.getDevicesMatchingConnectionStates(new int[]{2, 1, 3}).size() == 0) {
                        BluetoothDeviceProfileState.this.mA2dpService.connect(BluetoothDeviceProfileState.this.mDevice);
                    }
                    if (BluetoothDeviceProfileState.this.mService.getInputDevicePriority(BluetoothDeviceProfileState.this.mDevice) != 1000) break;
                    BluetoothDeviceProfileState.this.mService.connectInputDevice(BluetoothDeviceProfileState.this.mDevice);
                    break;
                }
                case 103: {
                    if (BluetoothDeviceProfileState.this.isPhoneDocked(BluetoothDeviceProfileState.this.mDevice)) break;
                    if (message.arg1 == 3) {
                        if (BluetoothDeviceProfileState.this.mA2dpService == null || BluetoothDeviceProfileState.this.mA2dpService.getConnectedDevices().size() != 0) break;
                        Log.i(BluetoothDeviceProfileState.TAG, "A2dp:Connect Other Profiles");
                        BluetoothDeviceProfileState.this.mA2dpService.connect(BluetoothDeviceProfileState.this.mDevice);
                        break;
                    }
                    if (message.arg1 != 1) break;
                    if (BluetoothDeviceProfileState.this.mHeadsetService == null) {
                        BluetoothDeviceProfileState.this.deferMessage(message);
                        break;
                    }
                    if (BluetoothDeviceProfileState.this.mHeadsetService.getConnectedDevices().size() != 0) break;
                    Log.i(BluetoothDeviceProfileState.TAG, "Headset:Connect Other Profiles");
                    BluetoothDeviceProfileState.this.mHeadsetService.connect(BluetoothDeviceProfileState.this.mDevice);
                    break;
                }
                case 102: {
                    break;
                }
                case -1: {
                    BluetoothDeviceProfileState.this.mContext.unregisterReceiver(BluetoothDeviceProfileState.this.mBroadcastReceiver);
                    BluetoothDeviceProfileState.this.mBroadcastReceiver = null;
                    BluetoothDeviceProfileState.this.mAdapter.closeProfileProxy(1, BluetoothDeviceProfileState.this.mHeadsetService);
                    BluetoothDeviceProfileState.this.mBluetoothProfileServiceListener = null;
                    BluetoothDeviceProfileState.this.mOutgoingHandsfree = null;
                    BluetoothDeviceProfileState.this.mPbap = null;
                    BluetoothDeviceProfileState.this.mPbapService.close();
                    BluetoothDeviceProfileState.this.mPbapService = null;
                    BluetoothDeviceProfileState.this.mIncomingHid = null;
                    BluetoothDeviceProfileState.this.mOutgoingHid = null;
                    BluetoothDeviceProfileState.this.mIncomingHandsfree = null;
                    BluetoothDeviceProfileState.this.mOutgoingHandsfree = null;
                    BluetoothDeviceProfileState.this.mIncomingA2dp = null;
                    BluetoothDeviceProfileState.this.mOutgoingA2dp = null;
                    BluetoothDeviceProfileState.this.mBondedDevice = null;
                    return false;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    private class PbapServiceListener
    implements BluetoothPbap.ServiceListener {
        public PbapServiceListener() {
            BluetoothDeviceProfileState.this.mPbapService = new BluetoothPbap(BluetoothDeviceProfileState.this.mContext, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected() {
            BluetoothDeviceProfileState bluetoothDeviceProfileState = BluetoothDeviceProfileState.this;
            synchronized (bluetoothDeviceProfileState) {
                BluetoothDeviceProfileState.this.mPbapServiceConnected = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected() {
            BluetoothDeviceProfileState bluetoothDeviceProfileState = BluetoothDeviceProfileState.this;
            synchronized (bluetoothDeviceProfileState) {
                BluetoothDeviceProfileState.this.mPbapServiceConnected = false;
            }
        }
    }
}

