/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothPan;
import android.bluetooth.BluetoothProfile;
import android.content.Context;
import android.net.DhcpInfoInternal;
import android.net.LinkCapabilities;
import android.net.LinkProperties;
import android.net.NetworkInfo;
import android.net.NetworkStateTracker;
import android.net.NetworkUtils;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class BluetoothTetheringDataTracker
implements NetworkStateTracker {
    private static final String NETWORKTYPE = "BLUETOOTH_TETHER";
    private static final String TAG = "BluetoothTethering";
    private AtomicBoolean mTeardownRequested = new AtomicBoolean(false);
    private AtomicBoolean mPrivateDnsRouteSet = new AtomicBoolean(false);
    private AtomicInteger mDefaultGatewayAddr = new AtomicInteger(0);
    private AtomicBoolean mDefaultRouteSet = new AtomicBoolean(false);
    private LinkProperties mLinkProperties;
    private LinkCapabilities mLinkCapabilities;
    private NetworkInfo mNetworkInfo;
    private BluetoothPan mBluetoothPan;
    private BluetoothDevice mDevice;
    private static String mIface;
    private Handler mCsHandler;
    private Context mContext;
    public static BluetoothTetheringDataTracker sInstance;
    private BluetoothProfile.ServiceListener mProfileServiceListener = new BluetoothProfile.ServiceListener(){

        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            BluetoothTetheringDataTracker.this.mBluetoothPan = (BluetoothPan)proxy;
        }

        public void onServiceDisconnected(int profile) {
            BluetoothTetheringDataTracker.this.mBluetoothPan = null;
        }
    };

    private BluetoothTetheringDataTracker() {
        this.mNetworkInfo = new NetworkInfo(7, 0, NETWORKTYPE, "");
        this.mLinkProperties = new LinkProperties();
        this.mLinkCapabilities = new LinkCapabilities();
        this.mNetworkInfo.setIsAvailable(false);
        this.setTeardownRequested(false);
    }

    public static synchronized BluetoothTetheringDataTracker getInstance() {
        if (sInstance == null) {
            sInstance = new BluetoothTetheringDataTracker();
        }
        return sInstance;
    }

    public Object Clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void setTeardownRequested(boolean isRequested) {
        this.mTeardownRequested.set(isRequested);
    }

    public boolean isTeardownRequested() {
        return this.mTeardownRequested.get();
    }

    public void startMonitoring(Context context, Handler target) {
        this.mContext = context;
        this.mCsHandler = target;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            adapter.getProfileProxy(this.mContext, this.mProfileServiceListener, 5);
        }
    }

    public boolean teardown() {
        this.mTeardownRequested.set(true);
        if (this.mBluetoothPan != null) {
            for (BluetoothDevice device : this.mBluetoothPan.getConnectedDevices()) {
                this.mBluetoothPan.disconnect(device);
            }
        }
        return true;
    }

    public boolean reconnect() {
        this.mTeardownRequested.set(false);
        return true;
    }

    public boolean setRadio(boolean turnOn) {
        return true;
    }

    public synchronized boolean isAvailable() {
        return this.mNetworkInfo.isAvailable();
    }

    public int startUsingNetworkFeature(String feature, int callingPid, int callingUid) {
        return -1;
    }

    public int stopUsingNetworkFeature(String feature, int callingPid, int callingUid) {
        return -1;
    }

    public void setUserDataEnable(boolean enabled) {
        Log.w(TAG, "ignoring setUserDataEnable(" + enabled + ")");
    }

    public void setPolicyDataEnable(boolean enabled) {
        Log.w(TAG, "ignoring setPolicyDataEnable(" + enabled + ")");
    }

    public boolean isPrivateDnsRouteSet() {
        return this.mPrivateDnsRouteSet.get();
    }

    public void privateDnsRouteSet(boolean enabled) {
        this.mPrivateDnsRouteSet.set(enabled);
    }

    public synchronized NetworkInfo getNetworkInfo() {
        return this.mNetworkInfo;
    }

    public synchronized LinkProperties getLinkProperties() {
        return new LinkProperties(this.mLinkProperties);
    }

    public LinkCapabilities getLinkCapabilities() {
        return new LinkCapabilities(this.mLinkCapabilities);
    }

    public int getDefaultGatewayAddr() {
        return this.mDefaultGatewayAddr.get();
    }

    public boolean isDefaultRouteSet() {
        return this.mDefaultRouteSet.get();
    }

    public void defaultRouteSet(boolean enabled) {
        this.mDefaultRouteSet.set(enabled);
    }

    public String getTcpBufferSizesPropName() {
        return "net.tcp.buffersize.wifi";
    }

    public synchronized void startReverseTether(String iface, BluetoothDevice device) {
        mIface = iface;
        this.mDevice = device;
        Thread dhcpThread = new Thread(new Runnable(){

            public void run() {
                DhcpInfoInternal dhcpInfoInternal = new DhcpInfoInternal();
                if (!NetworkUtils.runDhcp(mIface, dhcpInfoInternal)) {
                    Log.e(BluetoothTetheringDataTracker.TAG, "DHCP request error:" + NetworkUtils.getDhcpError());
                    return;
                }
                BluetoothTetheringDataTracker.this.mLinkProperties = dhcpInfoInternal.makeLinkProperties();
                BluetoothTetheringDataTracker.this.mLinkProperties.setInterfaceName(mIface);
                BluetoothTetheringDataTracker.this.mNetworkInfo.setIsAvailable(true);
                BluetoothTetheringDataTracker.this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.CONNECTED, null, null);
                Message msg = BluetoothTetheringDataTracker.this.mCsHandler.obtainMessage(3, BluetoothTetheringDataTracker.this.mNetworkInfo);
                msg.sendToTarget();
                msg = BluetoothTetheringDataTracker.this.mCsHandler.obtainMessage(1, BluetoothTetheringDataTracker.this.mNetworkInfo);
                msg.sendToTarget();
            }
        });
        dhcpThread.start();
    }

    public synchronized void stopReverseTether(String iface) {
        NetworkUtils.stopDhcp(iface);
        this.mLinkProperties.clear();
        this.mNetworkInfo.setIsAvailable(false);
        this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, null);
        Message msg = this.mCsHandler.obtainMessage(3, this.mNetworkInfo);
        msg.sendToTarget();
        msg = this.mCsHandler.obtainMessage(1, this.mNetworkInfo);
        msg.sendToTarget();
    }

    public void setDependencyMet(boolean met) {
    }
}

