/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Printer;
import java.text.Collator;
import java.util.Comparator;

public class ApplicationInfo
extends PackageItemInfo
implements Parcelable {
    public String taskAffinity;
    public String permission;
    public String processName;
    public String className;
    public int descriptionRes;
    public int theme;
    public String manageSpaceActivityName;
    public String backupAgentName;
    public int uiOptions = 0;
    public static final int FLAG_SYSTEM = 1;
    public static final int FLAG_DEBUGGABLE = 2;
    public static final int FLAG_HAS_CODE = 4;
    public static final int FLAG_PERSISTENT = 8;
    public static final int FLAG_FACTORY_TEST = 16;
    public static final int FLAG_ALLOW_TASK_REPARENTING = 32;
    public static final int FLAG_ALLOW_CLEAR_USER_DATA = 64;
    public static final int FLAG_UPDATED_SYSTEM_APP = 128;
    public static final int FLAG_TEST_ONLY = 256;
    public static final int FLAG_SUPPORTS_SMALL_SCREENS = 512;
    public static final int FLAG_SUPPORTS_NORMAL_SCREENS = 1024;
    public static final int FLAG_SUPPORTS_LARGE_SCREENS = 2048;
    public static final int FLAG_RESIZEABLE_FOR_SCREENS = 4096;
    public static final int FLAG_SUPPORTS_SCREEN_DENSITIES = 8192;
    public static final int FLAG_VM_SAFE_MODE = 16384;
    public static final int FLAG_ALLOW_BACKUP = 32768;
    public static final int FLAG_KILL_AFTER_RESTORE = 65536;
    public static final int FLAG_RESTORE_ANY_VERSION = 131072;
    public static final int FLAG_EXTERNAL_STORAGE = 262144;
    public static final int FLAG_SUPPORTS_XLARGE_SCREENS = 524288;
    public static final int FLAG_LARGE_HEAP = 0x100000;
    public static final int FLAG_STOPPED = 0x200000;
    public static final int FLAG_FORWARD_LOCK = 0x20000000;
    public static final int FLAG_CANT_SAVE_STATE = 0x10000000;
    public int flags = 0;
    public int requiresSmallestWidthDp = 0;
    public int compatibleWidthLimitDp = 0;
    public int largestWidthLimitDp = 0;
    public String sourceDir;
    public String publicSourceDir;
    public String[] resourceDirs;
    public String[] sharedLibraryFiles;
    public String dataDir;
    public String nativeLibraryDir;
    public int uid;
    public int targetSdkVersion;
    public boolean enabled = true;
    public int enabledSetting = 0;
    public int installLocation = -1;
    public static final Parcelable.Creator<ApplicationInfo> CREATOR = new Parcelable.Creator<ApplicationInfo>(){

        @Override
        public ApplicationInfo createFromParcel(Parcel source) {
            return new ApplicationInfo(source);
        }

        public ApplicationInfo[] newArray(int size) {
            return new ApplicationInfo[size];
        }
    };

    public void dump(Printer pw, String prefix) {
        super.dumpFront(pw, prefix);
        if (this.className != null) {
            pw.println(prefix + "className=" + this.className);
        }
        if (this.permission != null) {
            pw.println(prefix + "permission=" + this.permission);
        }
        pw.println(prefix + "processName=" + this.processName);
        pw.println(prefix + "taskAffinity=" + this.taskAffinity);
        pw.println(prefix + "uid=" + this.uid + " flags=0x" + Integer.toHexString(this.flags) + " theme=0x" + Integer.toHexString(this.theme));
        pw.println(prefix + "requiresSmallestWidthDp=" + this.requiresSmallestWidthDp + " compatibleWidthLimitDp=" + this.compatibleWidthLimitDp + " largestWidthLimitDp=" + this.largestWidthLimitDp);
        pw.println(prefix + "sourceDir=" + this.sourceDir);
        if (this.sourceDir == null) {
            if (this.publicSourceDir != null) {
                pw.println(prefix + "publicSourceDir=" + this.publicSourceDir);
            }
        } else if (!this.sourceDir.equals(this.publicSourceDir)) {
            pw.println(prefix + "publicSourceDir=" + this.publicSourceDir);
        }
        if (this.resourceDirs != null) {
            pw.println(prefix + "resourceDirs=" + this.resourceDirs);
        }
        pw.println(prefix + "dataDir=" + this.dataDir);
        if (this.sharedLibraryFiles != null) {
            pw.println(prefix + "sharedLibraryFiles=" + this.sharedLibraryFiles);
        }
        pw.println(prefix + "enabled=" + this.enabled + " targetSdkVersion=" + this.targetSdkVersion);
        if (this.manageSpaceActivityName != null) {
            pw.println(prefix + "manageSpaceActivityName=" + this.manageSpaceActivityName);
        }
        if (this.descriptionRes != 0) {
            pw.println(prefix + "description=0x" + Integer.toHexString(this.descriptionRes));
        }
        if (this.uiOptions != 0) {
            pw.println(prefix + "uiOptions=0x" + Integer.toHexString(this.uiOptions));
        }
        super.dumpBack(pw, prefix);
    }

    public ApplicationInfo() {
    }

    public ApplicationInfo(ApplicationInfo orig) {
        super(orig);
        this.taskAffinity = orig.taskAffinity;
        this.permission = orig.permission;
        this.processName = orig.processName;
        this.className = orig.className;
        this.theme = orig.theme;
        this.flags = orig.flags;
        this.requiresSmallestWidthDp = orig.requiresSmallestWidthDp;
        this.compatibleWidthLimitDp = orig.compatibleWidthLimitDp;
        this.largestWidthLimitDp = orig.largestWidthLimitDp;
        this.sourceDir = orig.sourceDir;
        this.publicSourceDir = orig.publicSourceDir;
        this.nativeLibraryDir = orig.nativeLibraryDir;
        this.resourceDirs = orig.resourceDirs;
        this.sharedLibraryFiles = orig.sharedLibraryFiles;
        this.dataDir = orig.dataDir;
        this.uid = orig.uid;
        this.targetSdkVersion = orig.targetSdkVersion;
        this.enabled = orig.enabled;
        this.enabledSetting = orig.enabledSetting;
        this.installLocation = orig.installLocation;
        this.manageSpaceActivityName = orig.manageSpaceActivityName;
        this.descriptionRes = orig.descriptionRes;
        this.uiOptions = orig.uiOptions;
    }

    public String toString() {
        return "ApplicationInfo{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.packageName + "}";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int parcelableFlags) {
        super.writeToParcel(dest, parcelableFlags);
        dest.writeString(this.taskAffinity);
        dest.writeString(this.permission);
        dest.writeString(this.processName);
        dest.writeString(this.className);
        dest.writeInt(this.theme);
        dest.writeInt(this.flags);
        dest.writeInt(this.requiresSmallestWidthDp);
        dest.writeInt(this.compatibleWidthLimitDp);
        dest.writeInt(this.largestWidthLimitDp);
        dest.writeString(this.sourceDir);
        dest.writeString(this.publicSourceDir);
        dest.writeString(this.nativeLibraryDir);
        dest.writeStringArray(this.resourceDirs);
        dest.writeStringArray(this.sharedLibraryFiles);
        dest.writeString(this.dataDir);
        dest.writeInt(this.uid);
        dest.writeInt(this.targetSdkVersion);
        dest.writeInt(this.enabled ? 1 : 0);
        dest.writeInt(this.enabledSetting);
        dest.writeInt(this.installLocation);
        dest.writeString(this.manageSpaceActivityName);
        dest.writeString(this.backupAgentName);
        dest.writeInt(this.descriptionRes);
        dest.writeInt(this.uiOptions);
    }

    private ApplicationInfo(Parcel source) {
        super(source);
        this.taskAffinity = source.readString();
        this.permission = source.readString();
        this.processName = source.readString();
        this.className = source.readString();
        this.theme = source.readInt();
        this.flags = source.readInt();
        this.requiresSmallestWidthDp = source.readInt();
        this.compatibleWidthLimitDp = source.readInt();
        this.largestWidthLimitDp = source.readInt();
        this.sourceDir = source.readString();
        this.publicSourceDir = source.readString();
        this.nativeLibraryDir = source.readString();
        this.resourceDirs = source.readStringArray();
        this.sharedLibraryFiles = source.readStringArray();
        this.dataDir = source.readString();
        this.uid = source.readInt();
        this.targetSdkVersion = source.readInt();
        this.enabled = source.readInt() != 0;
        this.enabledSetting = source.readInt();
        this.installLocation = source.readInt();
        this.manageSpaceActivityName = source.readString();
        this.backupAgentName = source.readString();
        this.descriptionRes = source.readInt();
        this.uiOptions = source.readInt();
    }

    public CharSequence loadDescription(PackageManager pm) {
        CharSequence label;
        if (this.descriptionRes != 0 && (label = pm.getText(this.packageName, this.descriptionRes, this)) != null) {
            return label;
        }
        return null;
    }

    public void disableCompatibilityMode() {
        this.flags |= 0x83E00;
    }

    protected Drawable loadDefaultIcon(PackageManager pm) {
        if ((this.flags & 0x40000) != 0 && this.isPackageUnavailable(pm)) {
            return Resources.getSystem().getDrawable(17302874);
        }
        return pm.getDefaultActivityIcon();
    }

    private boolean isPackageUnavailable(PackageManager pm) {
        try {
            return pm.getPackageInfo(this.packageName, 0) == null;
        }
        catch (PackageManager.NameNotFoundException ex) {
            return true;
        }
    }

    protected ApplicationInfo getApplicationInfo() {
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DisplayNameComparator
    implements Comparator<ApplicationInfo> {
        private final Collator sCollator = Collator.getInstance();
        private PackageManager mPM;

        public DisplayNameComparator(PackageManager pm) {
            this.mPM = pm;
        }

        @Override
        public final int compare(ApplicationInfo aa, ApplicationInfo ab) {
            CharSequence sb;
            CharSequence sa = this.mPM.getApplicationLabel(aa);
            if (sa == null) {
                sa = aa.packageName;
            }
            if ((sb = this.mPM.getApplicationLabel(ab)) == null) {
                sb = ab.packageName;
            }
            return this.sCollator.compare(((Object)sa).toString(), ((Object)sb).toString());
        }
    }
}

