/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import java.util.Arrays;
import java.util.jar.Attributes;

public class ManifestDigest
implements Parcelable {
    private final byte[] mDigest;
    private static final String[] DIGEST_TYPES = new String[]{"SHA1-Digest", "SHA-Digest", "MD5-Digest"};
    private static final String TO_STRING_PREFIX = "ManifestDigest {mDigest=";
    public static final Parcelable.Creator<ManifestDigest> CREATOR = new Parcelable.Creator<ManifestDigest>(){

        @Override
        public ManifestDigest createFromParcel(Parcel source) {
            return new ManifestDigest(source);
        }

        public ManifestDigest[] newArray(int size) {
            return new ManifestDigest[size];
        }
    };

    ManifestDigest(byte[] digest) {
        this.mDigest = digest;
    }

    private ManifestDigest(Parcel source) {
        this.mDigest = source.createByteArray();
    }

    static ManifestDigest fromAttributes(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        String encodedDigest = null;
        for (int i = 0; i < DIGEST_TYPES.length; ++i) {
            String value = attributes.getValue(DIGEST_TYPES[i]);
            if (value == null) continue;
            encodedDigest = value;
            break;
        }
        if (encodedDigest == null) {
            return null;
        }
        byte[] digest = Base64.decode(encodedDigest, 0);
        return new ManifestDigest(digest);
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ManifestDigest)) {
            return false;
        }
        ManifestDigest other = (ManifestDigest)o;
        return this == other || Arrays.equals(this.mDigest, other.mDigest);
    }

    public int hashCode() {
        return Arrays.hashCode(this.mDigest);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(TO_STRING_PREFIX.length() + this.mDigest.length * 3 + 1);
        sb.append(TO_STRING_PREFIX);
        for (byte b : this.mDigest) {
            IntegralToString.appendByteAsHex((StringBuilder)sb, (byte)b, (boolean)false);
            sb.append(',');
        }
        sb.append('}');
        return sb.toString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(this.mDigest);
    }
}

