/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.LocaleUtil;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Configuration
implements Parcelable,
Comparable<Configuration> {
    public float fontScale;
    public int mcc;
    public int mnc;
    public Locale locale;
    public boolean userSetLocale;
    public static final int SCREENLAYOUT_SIZE_MASK = 15;
    public static final int SCREENLAYOUT_SIZE_UNDEFINED = 0;
    public static final int SCREENLAYOUT_SIZE_SMALL = 1;
    public static final int SCREENLAYOUT_SIZE_NORMAL = 2;
    public static final int SCREENLAYOUT_SIZE_LARGE = 3;
    public static final int SCREENLAYOUT_SIZE_XLARGE = 4;
    public static final int SCREENLAYOUT_LONG_MASK = 48;
    public static final int SCREENLAYOUT_LONG_UNDEFINED = 0;
    public static final int SCREENLAYOUT_LONG_NO = 16;
    public static final int SCREENLAYOUT_LONG_YES = 32;
    public static final int SCREENLAYOUT_COMPAT_NEEDED = 0x10000000;
    public int screenLayout;
    public static final int TOUCHSCREEN_UNDEFINED = 0;
    public static final int TOUCHSCREEN_NOTOUCH = 1;
    public static final int TOUCHSCREEN_STYLUS = 2;
    public static final int TOUCHSCREEN_FINGER = 3;
    public int touchscreen;
    public static final int KEYBOARD_UNDEFINED = 0;
    public static final int KEYBOARD_NOKEYS = 1;
    public static final int KEYBOARD_QWERTY = 2;
    public static final int KEYBOARD_12KEY = 3;
    public int keyboard;
    public static final int KEYBOARDHIDDEN_UNDEFINED = 0;
    public static final int KEYBOARDHIDDEN_NO = 1;
    public static final int KEYBOARDHIDDEN_YES = 2;
    public static final int KEYBOARDHIDDEN_SOFT = 3;
    public int keyboardHidden;
    public static final int HARDKEYBOARDHIDDEN_UNDEFINED = 0;
    public static final int HARDKEYBOARDHIDDEN_NO = 1;
    public static final int HARDKEYBOARDHIDDEN_YES = 2;
    public int hardKeyboardHidden;
    public static final int NAVIGATION_UNDEFINED = 0;
    public static final int NAVIGATION_NONAV = 1;
    public static final int NAVIGATION_DPAD = 2;
    public static final int NAVIGATION_TRACKBALL = 3;
    public static final int NAVIGATION_WHEEL = 4;
    public int navigation;
    public static final int NAVIGATIONHIDDEN_UNDEFINED = 0;
    public static final int NAVIGATIONHIDDEN_NO = 1;
    public static final int NAVIGATIONHIDDEN_YES = 2;
    public int navigationHidden;
    public static final int ORIENTATION_UNDEFINED = 0;
    public static final int ORIENTATION_PORTRAIT = 1;
    public static final int ORIENTATION_LANDSCAPE = 2;
    public static final int ORIENTATION_SQUARE = 3;
    public int orientation;
    public static final int UI_MODE_TYPE_MASK = 15;
    public static final int UI_MODE_TYPE_UNDEFINED = 0;
    public static final int UI_MODE_TYPE_NORMAL = 1;
    public static final int UI_MODE_TYPE_DESK = 2;
    public static final int UI_MODE_TYPE_CAR = 3;
    public static final int UI_MODE_TYPE_TELEVISION = 4;
    public static final int UI_MODE_NIGHT_MASK = 48;
    public static final int UI_MODE_NIGHT_UNDEFINED = 0;
    public static final int UI_MODE_NIGHT_NO = 16;
    public static final int UI_MODE_NIGHT_YES = 32;
    public int uiMode;
    public static final int SCREEN_WIDTH_DP_UNDEFINED = 0;
    public int screenWidthDp;
    public static final int SCREEN_HEIGHT_DP_UNDEFINED = 0;
    public int screenHeightDp;
    public static final int SMALLEST_SCREEN_WIDTH_DP_UNDEFINED = 0;
    public int smallestScreenWidthDp;
    public int compatScreenWidthDp;
    public int compatScreenHeightDp;
    public int compatSmallestScreenWidthDp;
    public int textLayoutDirection;
    public int seq;
    public static final Parcelable.Creator<Configuration> CREATOR = new Parcelable.Creator<Configuration>(){

        @Override
        public Configuration createFromParcel(Parcel source) {
            return new Configuration(source);
        }

        public Configuration[] newArray(int size) {
            return new Configuration[size];
        }
    };

    public boolean isLayoutSizeAtLeast(int size) {
        int cur = this.screenLayout & 0xF;
        if (cur == 0) {
            return false;
        }
        return cur >= size;
    }

    public Configuration() {
        this.setToDefaults();
    }

    public Configuration(Configuration o) {
        this.setTo(o);
    }

    public void setTo(Configuration o) {
        this.fontScale = o.fontScale;
        this.mcc = o.mcc;
        this.mnc = o.mnc;
        if (o.locale != null) {
            this.locale = (Locale)o.locale.clone();
            this.textLayoutDirection = o.textLayoutDirection;
        }
        this.userSetLocale = o.userSetLocale;
        this.touchscreen = o.touchscreen;
        this.keyboard = o.keyboard;
        this.keyboardHidden = o.keyboardHidden;
        this.hardKeyboardHidden = o.hardKeyboardHidden;
        this.navigation = o.navigation;
        this.navigationHidden = o.navigationHidden;
        this.orientation = o.orientation;
        this.screenLayout = o.screenLayout;
        this.uiMode = o.uiMode;
        this.screenWidthDp = o.screenWidthDp;
        this.screenHeightDp = o.screenHeightDp;
        this.smallestScreenWidthDp = o.smallestScreenWidthDp;
        this.compatScreenWidthDp = o.compatScreenWidthDp;
        this.compatScreenHeightDp = o.compatScreenHeightDp;
        this.compatSmallestScreenWidthDp = o.compatSmallestScreenWidthDp;
        this.seq = o.seq;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("{");
        sb.append(this.fontScale);
        sb.append(" ");
        sb.append(this.mcc);
        sb.append("mcc");
        sb.append(this.mnc);
        sb.append("mnc");
        if (this.locale != null) {
            sb.append(" ");
            sb.append(this.locale);
        } else {
            sb.append(" (no locale)");
        }
        switch (this.textLayoutDirection) {
            case 1: {
                sb.append(" rtl");
                break;
            }
            default: {
                sb.append(" layoutdir=");
                sb.append(this.textLayoutDirection);
            }
        }
        if (this.smallestScreenWidthDp != 0) {
            sb.append(" sw");
            sb.append(this.smallestScreenWidthDp);
            sb.append("dp");
        } else {
            sb.append(" ?swdp");
        }
        if (this.screenWidthDp != 0) {
            sb.append(" w");
            sb.append(this.screenWidthDp);
            sb.append("dp");
        } else {
            sb.append(" ?wdp");
        }
        if (this.screenHeightDp != 0) {
            sb.append(" h");
            sb.append(this.screenHeightDp);
            sb.append("dp");
        } else {
            sb.append(" ?hdp");
        }
        switch (this.screenLayout & 0xF) {
            case 0: {
                sb.append(" ?lsize");
                break;
            }
            case 1: {
                sb.append(" smll");
                break;
            }
            case 2: {
                sb.append(" nrml");
                break;
            }
            case 3: {
                sb.append(" lrg");
                break;
            }
            case 4: {
                sb.append(" xlrg");
                break;
            }
            default: {
                sb.append(" layoutSize=");
                sb.append(this.screenLayout & 0xF);
            }
        }
        switch (this.screenLayout & 0x30) {
            case 0: {
                sb.append(" ?long");
                break;
            }
            case 16: {
                break;
            }
            case 32: {
                sb.append(" long");
                break;
            }
            default: {
                sb.append(" layoutLong=");
                sb.append(this.screenLayout & 0x30);
            }
        }
        switch (this.orientation) {
            case 0: {
                sb.append(" ?orien");
                break;
            }
            case 2: {
                sb.append(" land");
                break;
            }
            case 1: {
                sb.append(" port");
                break;
            }
            default: {
                sb.append(" orien=");
                sb.append(this.orientation);
            }
        }
        switch (this.uiMode & 0xF) {
            case 0: {
                sb.append(" ?uimode");
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                sb.append(" desk");
                break;
            }
            case 3: {
                sb.append(" car");
                break;
            }
            case 4: {
                sb.append(" television");
                break;
            }
            default: {
                sb.append(" uimode=");
                sb.append(this.uiMode & 0xF);
            }
        }
        switch (this.uiMode & 0x30) {
            case 0: {
                sb.append(" ?night");
                break;
            }
            case 16: {
                break;
            }
            case 32: {
                sb.append(" night");
                break;
            }
            default: {
                sb.append(" night=");
                sb.append(this.uiMode & 0x30);
            }
        }
        switch (this.touchscreen) {
            case 0: {
                sb.append(" ?touch");
                break;
            }
            case 1: {
                sb.append(" -touch");
                break;
            }
            case 2: {
                sb.append(" stylus");
                break;
            }
            case 3: {
                sb.append(" finger");
                break;
            }
            default: {
                sb.append(" touch=");
                sb.append(this.touchscreen);
            }
        }
        switch (this.keyboard) {
            case 0: {
                sb.append(" ?keyb");
                break;
            }
            case 1: {
                sb.append(" -keyb");
                break;
            }
            case 2: {
                sb.append(" qwerty");
                break;
            }
            case 3: {
                sb.append(" 12key");
                break;
            }
            default: {
                sb.append(" keys=");
                sb.append(this.keyboard);
            }
        }
        switch (this.keyboardHidden) {
            case 0: {
                sb.append("/?");
                break;
            }
            case 1: {
                sb.append("/v");
                break;
            }
            case 2: {
                sb.append("/h");
                break;
            }
            case 3: {
                sb.append("/s");
                break;
            }
            default: {
                sb.append("/");
                sb.append(this.keyboardHidden);
            }
        }
        switch (this.hardKeyboardHidden) {
            case 0: {
                sb.append("/?");
                break;
            }
            case 1: {
                sb.append("/v");
                break;
            }
            case 2: {
                sb.append("/h");
                break;
            }
            default: {
                sb.append("/");
                sb.append(this.hardKeyboardHidden);
            }
        }
        switch (this.navigation) {
            case 0: {
                sb.append(" ?nav");
                break;
            }
            case 1: {
                sb.append(" -nav");
                break;
            }
            case 2: {
                sb.append(" dpad");
                break;
            }
            case 3: {
                sb.append(" tball");
                break;
            }
            case 4: {
                sb.append(" wheel");
                break;
            }
            default: {
                sb.append(" nav=");
                sb.append(this.navigation);
            }
        }
        switch (this.navigationHidden) {
            case 0: {
                sb.append("/?");
                break;
            }
            case 1: {
                sb.append("/v");
                break;
            }
            case 2: {
                sb.append("/h");
                break;
            }
            default: {
                sb.append("/");
                sb.append(this.navigationHidden);
            }
        }
        if (this.seq != 0) {
            sb.append(" s.");
            sb.append(this.seq);
        }
        sb.append('}');
        return sb.toString();
    }

    public void setToDefaults() {
        this.fontScale = 1.0f;
        this.mnc = 0;
        this.mcc = 0;
        this.locale = null;
        this.userSetLocale = false;
        this.touchscreen = 0;
        this.keyboard = 0;
        this.keyboardHidden = 0;
        this.hardKeyboardHidden = 0;
        this.navigation = 0;
        this.navigationHidden = 0;
        this.orientation = 0;
        this.screenLayout = 0;
        this.uiMode = 0;
        this.compatScreenWidthDp = 0;
        this.screenWidthDp = 0;
        this.compatScreenHeightDp = 0;
        this.screenHeightDp = 0;
        this.compatSmallestScreenWidthDp = 0;
        this.smallestScreenWidthDp = 0;
        this.textLayoutDirection = 0;
        this.seq = 0;
    }

    @Deprecated
    public void makeDefault() {
        this.setToDefaults();
    }

    public int updateFrom(Configuration delta) {
        int changed = 0;
        if (delta.fontScale > 0.0f && this.fontScale != delta.fontScale) {
            changed |= 0x40000000;
            this.fontScale = delta.fontScale;
        }
        if (delta.mcc != 0 && this.mcc != delta.mcc) {
            changed |= 1;
            this.mcc = delta.mcc;
        }
        if (delta.mnc != 0 && this.mnc != delta.mnc) {
            changed |= 2;
            this.mnc = delta.mnc;
        }
        if (!(delta.locale == null || this.locale != null && this.locale.equals(delta.locale))) {
            changed |= 4;
            this.locale = delta.locale != null ? (Locale)delta.locale.clone() : null;
            this.textLayoutDirection = LocaleUtil.getLayoutDirectionFromLocale(this.locale);
        }
        if (delta.userSetLocale && (!this.userSetLocale || (changed & 4) != 0)) {
            this.userSetLocale = true;
            changed |= 4;
        }
        if (delta.touchscreen != 0 && this.touchscreen != delta.touchscreen) {
            changed |= 8;
            this.touchscreen = delta.touchscreen;
        }
        if (delta.keyboard != 0 && this.keyboard != delta.keyboard) {
            changed |= 0x10;
            this.keyboard = delta.keyboard;
        }
        if (delta.keyboardHidden != 0 && this.keyboardHidden != delta.keyboardHidden) {
            changed |= 0x20;
            this.keyboardHidden = delta.keyboardHidden;
        }
        if (delta.hardKeyboardHidden != 0 && this.hardKeyboardHidden != delta.hardKeyboardHidden) {
            changed |= 0x20;
            this.hardKeyboardHidden = delta.hardKeyboardHidden;
        }
        if (delta.navigation != 0 && this.navigation != delta.navigation) {
            changed |= 0x40;
            this.navigation = delta.navigation;
        }
        if (delta.navigationHidden != 0 && this.navigationHidden != delta.navigationHidden) {
            changed |= 0x20;
            this.navigationHidden = delta.navigationHidden;
        }
        if (delta.orientation != 0 && this.orientation != delta.orientation) {
            changed |= 0x80;
            this.orientation = delta.orientation;
        }
        if (delta.screenLayout != 0 && this.screenLayout != delta.screenLayout) {
            changed |= 0x100;
            this.screenLayout = delta.screenLayout;
        }
        if (delta.uiMode != 0 && this.uiMode != delta.uiMode) {
            changed |= 0x200;
            if ((delta.uiMode & 0xF) != 0) {
                this.uiMode = this.uiMode & 0xFFFFFFF0 | delta.uiMode & 0xF;
            }
            if ((delta.uiMode & 0x30) != 0) {
                this.uiMode = this.uiMode & 0xFFFFFFCF | delta.uiMode & 0x30;
            }
        }
        if (delta.screenWidthDp != 0 && this.screenWidthDp != delta.screenWidthDp) {
            changed |= 0x400;
            this.screenWidthDp = delta.screenWidthDp;
        }
        if (delta.screenHeightDp != 0 && this.screenHeightDp != delta.screenHeightDp) {
            changed |= 0x400;
            this.screenHeightDp = delta.screenHeightDp;
        }
        if (delta.smallestScreenWidthDp != 0) {
            this.smallestScreenWidthDp = delta.smallestScreenWidthDp;
        }
        if (delta.compatScreenWidthDp != 0) {
            this.compatScreenWidthDp = delta.compatScreenWidthDp;
        }
        if (delta.compatScreenHeightDp != 0) {
            this.compatScreenHeightDp = delta.compatScreenHeightDp;
        }
        if (delta.compatSmallestScreenWidthDp != 0) {
            this.compatSmallestScreenWidthDp = delta.compatSmallestScreenWidthDp;
        }
        if (delta.seq != 0) {
            this.seq = delta.seq;
        }
        return changed;
    }

    public int diff(Configuration delta) {
        int changed = 0;
        if (delta.fontScale > 0.0f && this.fontScale != delta.fontScale) {
            changed |= 0x40000000;
        }
        if (delta.mcc != 0 && this.mcc != delta.mcc) {
            changed |= 1;
        }
        if (delta.mnc != 0 && this.mnc != delta.mnc) {
            changed |= 2;
        }
        if (!(delta.locale == null || this.locale != null && this.locale.equals(delta.locale))) {
            changed |= 4;
        }
        if (delta.touchscreen != 0 && this.touchscreen != delta.touchscreen) {
            changed |= 8;
        }
        if (delta.keyboard != 0 && this.keyboard != delta.keyboard) {
            changed |= 0x10;
        }
        if (delta.keyboardHidden != 0 && this.keyboardHidden != delta.keyboardHidden) {
            changed |= 0x20;
        }
        if (delta.hardKeyboardHidden != 0 && this.hardKeyboardHidden != delta.hardKeyboardHidden) {
            changed |= 0x20;
        }
        if (delta.navigation != 0 && this.navigation != delta.navigation) {
            changed |= 0x40;
        }
        if (delta.navigationHidden != 0 && this.navigationHidden != delta.navigationHidden) {
            changed |= 0x20;
        }
        if (delta.orientation != 0 && this.orientation != delta.orientation) {
            changed |= 0x80;
        }
        if (delta.screenLayout != 0 && this.screenLayout != delta.screenLayout) {
            changed |= 0x100;
        }
        if (delta.uiMode != 0 && this.uiMode != delta.uiMode) {
            changed |= 0x200;
        }
        if (delta.screenWidthDp != 0 && this.screenWidthDp != delta.screenWidthDp) {
            changed |= 0x400;
        }
        if (delta.screenHeightDp != 0 && this.screenHeightDp != delta.screenHeightDp) {
            changed |= 0x400;
        }
        if (delta.smallestScreenWidthDp != 0 && this.smallestScreenWidthDp != delta.smallestScreenWidthDp) {
            changed |= 0x800;
        }
        return changed;
    }

    public static boolean needNewResources(int configChanges, int interestingChanges) {
        return (configChanges & (interestingChanges | 0x40000000)) != 0;
    }

    public boolean isOtherSeqNewer(Configuration other) {
        if (other == null) {
            return false;
        }
        if (other.seq == 0) {
            return true;
        }
        if (this.seq == 0) {
            return true;
        }
        int diff = other.seq - this.seq;
        if (diff > 65536) {
            return false;
        }
        return diff > 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(this.fontScale);
        dest.writeInt(this.mcc);
        dest.writeInt(this.mnc);
        if (this.locale == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            dest.writeString(this.locale.getLanguage());
            dest.writeString(this.locale.getCountry());
            dest.writeString(this.locale.getVariant());
        }
        if (this.userSetLocale) {
            dest.writeInt(1);
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.touchscreen);
        dest.writeInt(this.keyboard);
        dest.writeInt(this.keyboardHidden);
        dest.writeInt(this.hardKeyboardHidden);
        dest.writeInt(this.navigation);
        dest.writeInt(this.navigationHidden);
        dest.writeInt(this.orientation);
        dest.writeInt(this.screenLayout);
        dest.writeInt(this.uiMode);
        dest.writeInt(this.screenWidthDp);
        dest.writeInt(this.screenHeightDp);
        dest.writeInt(this.smallestScreenWidthDp);
        dest.writeInt(this.compatScreenWidthDp);
        dest.writeInt(this.compatScreenHeightDp);
        dest.writeInt(this.compatSmallestScreenWidthDp);
        dest.writeInt(this.textLayoutDirection);
        dest.writeInt(this.seq);
    }

    public void readFromParcel(Parcel source) {
        this.fontScale = source.readFloat();
        this.mcc = source.readInt();
        this.mnc = source.readInt();
        if (source.readInt() != 0) {
            this.locale = new Locale(source.readString(), source.readString(), source.readString());
        }
        this.userSetLocale = source.readInt() == 1;
        this.touchscreen = source.readInt();
        this.keyboard = source.readInt();
        this.keyboardHidden = source.readInt();
        this.hardKeyboardHidden = source.readInt();
        this.navigation = source.readInt();
        this.navigationHidden = source.readInt();
        this.orientation = source.readInt();
        this.screenLayout = source.readInt();
        this.uiMode = source.readInt();
        this.screenWidthDp = source.readInt();
        this.screenHeightDp = source.readInt();
        this.smallestScreenWidthDp = source.readInt();
        this.compatScreenWidthDp = source.readInt();
        this.compatScreenHeightDp = source.readInt();
        this.compatSmallestScreenWidthDp = source.readInt();
        this.textLayoutDirection = source.readInt();
        this.seq = source.readInt();
    }

    private Configuration(Parcel source) {
        this.readFromParcel(source);
    }

    @Override
    public int compareTo(Configuration that) {
        float a = this.fontScale;
        float b = that.fontScale;
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        int n = this.mcc - that.mcc;
        if (n != 0) {
            return n;
        }
        n = this.mnc - that.mnc;
        if (n != 0) {
            return n;
        }
        if (this.locale == null) {
            if (that.locale != null) {
                return 1;
            }
        } else {
            if (that.locale == null) {
                return -1;
            }
            n = this.locale.getLanguage().compareTo(that.locale.getLanguage());
            if (n != 0) {
                return n;
            }
            n = this.locale.getCountry().compareTo(that.locale.getCountry());
            if (n != 0) {
                return n;
            }
            n = this.locale.getVariant().compareTo(that.locale.getVariant());
            if (n != 0) {
                return n;
            }
        }
        if ((n = this.touchscreen - that.touchscreen) != 0) {
            return n;
        }
        n = this.keyboard - that.keyboard;
        if (n != 0) {
            return n;
        }
        n = this.keyboardHidden - that.keyboardHidden;
        if (n != 0) {
            return n;
        }
        n = this.hardKeyboardHidden - that.hardKeyboardHidden;
        if (n != 0) {
            return n;
        }
        n = this.navigation - that.navigation;
        if (n != 0) {
            return n;
        }
        n = this.navigationHidden - that.navigationHidden;
        if (n != 0) {
            return n;
        }
        n = this.orientation - that.orientation;
        if (n != 0) {
            return n;
        }
        n = this.screenLayout - that.screenLayout;
        if (n != 0) {
            return n;
        }
        n = this.uiMode - that.uiMode;
        if (n != 0) {
            return n;
        }
        n = this.screenWidthDp - that.screenWidthDp;
        if (n != 0) {
            return n;
        }
        n = this.screenHeightDp - that.screenHeightDp;
        if (n != 0) {
            return n;
        }
        n = this.smallestScreenWidthDp - that.smallestScreenWidthDp;
        return n;
    }

    public boolean equals(Configuration that) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        return this.compareTo(that) == 0;
    }

    public boolean equals(Object that) {
        try {
            return this.equals((Configuration)that);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Float.floatToIntBits(this.fontScale);
        result = 31 * result + this.mcc;
        result = 31 * result + this.mnc;
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 31 * result + this.touchscreen;
        result = 31 * result + this.keyboard;
        result = 31 * result + this.keyboardHidden;
        result = 31 * result + this.hardKeyboardHidden;
        result = 31 * result + this.navigation;
        result = 31 * result + this.navigationHidden;
        result = 31 * result + this.orientation;
        result = 31 * result + this.screenLayout;
        result = 31 * result + this.uiMode;
        result = 31 * result + this.screenWidthDp;
        result = 31 * result + this.screenHeightDp;
        result = 31 * result + this.smallestScreenWidthDp;
        return result;
    }
}

