/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.AbstractCursor;
import android.database.AbstractWindowedCursor;
import android.database.IBulkCursor;
import android.database.IContentObserver;
import android.database.StaleDataException;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;

public final class BulkCursorToCursorAdaptor
extends AbstractWindowedCursor {
    private static final String TAG = "BulkCursor";
    private AbstractCursor.SelfContentObserver mObserverBridge = new AbstractCursor.SelfContentObserver(this);
    private IBulkCursor mBulkCursor;
    private int mCount;
    private String[] mColumns;
    private boolean mWantsAllOnMoveCalls;

    public void initialize(IBulkCursor bulkCursor, int count, int idIndex, boolean wantsAllOnMoveCalls) {
        this.mBulkCursor = bulkCursor;
        this.mColumns = null;
        this.mCount = count;
        this.mRowIdColumnIndex = idIndex;
        this.mWantsAllOnMoveCalls = wantsAllOnMoveCalls;
    }

    public static int findRowIdColumnIndex(String[] columnNames) {
        int length = columnNames.length;
        for (int i = 0; i < length; ++i) {
            if (!columnNames[i].equals("_id")) continue;
            return i;
        }
        return -1;
    }

    public IContentObserver getObserver() {
        return this.mObserverBridge.getContentObserver();
    }

    private void throwIfCursorIsClosed() {
        if (this.mBulkCursor == null) {
            throw new StaleDataException("Attempted to access a cursor after it has been closed.");
        }
    }

    public int getCount() {
        this.throwIfCursorIsClosed();
        return this.mCount;
    }

    public boolean onMove(int oldPosition, int newPosition) {
        this.throwIfCursorIsClosed();
        try {
            if (this.mWindow == null || newPosition < this.mWindow.getStartPosition() || newPosition >= this.mWindow.getStartPosition() + this.mWindow.getNumRows()) {
                this.setWindow(this.mBulkCursor.getWindow(newPosition));
            } else if (this.mWantsAllOnMoveCalls) {
                this.mBulkCursor.onMove(newPosition);
            }
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Unable to get window because the remote process is dead");
            return false;
        }
        return this.mWindow != null;
    }

    public void deactivate() {
        super.deactivate();
        if (this.mBulkCursor != null) {
            try {
                this.mBulkCursor.deactivate();
            }
            catch (RemoteException ex) {
                Log.w(TAG, "Remote process exception when deactivating");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        if (this.mBulkCursor != null) {
            try {
                this.mBulkCursor.close();
            }
            catch (RemoteException ex) {
                Log.w(TAG, "Remote process exception when closing");
            }
            finally {
                this.mBulkCursor = null;
            }
        }
    }

    public boolean requery() {
        this.throwIfCursorIsClosed();
        try {
            this.mCount = this.mBulkCursor.requery(this.getObserver());
            if (this.mCount != -1) {
                this.mPos = -1;
                this.closeWindow();
                super.requery();
                return true;
            }
            this.deactivate();
            return false;
        }
        catch (Exception ex) {
            Log.e(TAG, "Unable to requery because the remote process exception " + ex.getMessage());
            this.deactivate();
            return false;
        }
    }

    public String[] getColumnNames() {
        this.throwIfCursorIsClosed();
        if (this.mColumns == null) {
            try {
                this.mColumns = this.mBulkCursor.getColumnNames();
            }
            catch (RemoteException ex) {
                Log.e(TAG, "Unable to fetch column names because the remote process is dead");
                return null;
            }
        }
        return this.mColumns;
    }

    public Bundle getExtras() {
        this.throwIfCursorIsClosed();
        try {
            return this.mBulkCursor.getExtras();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public Bundle respond(Bundle extras) {
        this.throwIfCursorIsClosed();
        try {
            return this.mBulkCursor.respond(extras);
        }
        catch (RemoteException e) {
            Log.w(TAG, "respond() threw RemoteException, returning an empty bundle.", e);
            return Bundle.EMPTY;
        }
    }
}

