/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.content.res.Resources;
import android.database.sqlite.SQLiteDatabase;
import android.os.SystemClock;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DatabaseConnectionPool {
    private static final String TAG = "DatabaseConnectionPool";
    private volatile int mMaxPoolSize = Resources.getSystem().getInteger(17694757);
    private final ArrayList<PoolObj> mPool = new ArrayList(this.mMaxPoolSize);
    private final SQLiteDatabase mParentDbObj;
    private Random rand;

    DatabaseConnectionPool(SQLiteDatabase db) {
        this.mParentDbObj = db;
        if (Log.isLoggable(TAG, 3)) {
            Log.d(TAG, "Max Pool Size: " + this.mMaxPoolSize);
        }
    }

    synchronized void close() {
        if (Log.isLoggable(TAG, 3)) {
            Log.d(TAG, "Closing the connection pool on " + this.mParentDbObj.getPath() + this.toString());
        }
        for (int i = this.mPool.size() - 1; i >= 0; --i) {
            this.mPool.get(i).mDb.close();
        }
        this.mPool.clear();
    }

    synchronized SQLiteDatabase get(String sql) {
        SQLiteDatabase db = null;
        PoolObj poolObj = null;
        int poolSize = this.mPool.size();
        if (Log.isLoggable(TAG, 3)) {
            assert (sql != null);
            this.doAsserts();
        }
        if (this.getFreePoolSize() == 0) {
            if (this.mMaxPoolSize == poolSize) {
                if (this.mMaxPoolSize == 1) {
                    poolObj = this.mPool.get(0);
                } else {
                    for (int i = 0; i < this.mMaxPoolSize; ++i) {
                        if (!this.mPool.get(i).mDb.isInStatementCache(sql)) continue;
                        poolObj = this.mPool.get(i);
                        break;
                    }
                    if (poolObj == null) {
                        if (this.rand == null) {
                            this.rand = new Random(SystemClock.elapsedRealtime());
                        }
                        poolObj = this.mPool.get(this.rand.nextInt(this.mMaxPoolSize));
                    }
                }
                db = poolObj.mDb;
            } else {
                db = this.mParentDbObj.createPoolConnection((short)(poolSize + 1));
                poolObj = new PoolObj(db);
                this.mPool.add(poolSize, poolObj);
            }
        } else {
            int i;
            for (i = 0; i < poolSize; ++i) {
                if (!this.mPool.get(i).isFree() || !this.mPool.get(i).mDb.isInStatementCache(sql)) continue;
                poolObj = this.mPool.get(i);
                break;
            }
            if (poolObj == null) {
                for (i = 0; i < poolSize; ++i) {
                    if (!this.mPool.get(i).isFree()) continue;
                    poolObj = this.mPool.get(i);
                    break;
                }
            }
            db = poolObj.mDb;
        }
        assert (poolObj != null);
        assert (poolObj.mDb == db);
        poolObj.acquire();
        if (Log.isLoggable(TAG, 3)) {
            Log.d(TAG, "END get-connection: " + this.toString() + poolObj.toString());
        }
        return db;
    }

    synchronized void release(SQLiteDatabase db) {
        if (Log.isLoggable(TAG, 3)) {
            assert (db.mConnectionNum > 0);
            this.doAsserts();
            assert (this.mPool.get(db.mConnectionNum - 1).mDb == db);
        }
        PoolObj poolObj = this.mPool.get(db.mConnectionNum - 1);
        if (Log.isLoggable(TAG, 3)) {
            Log.d(TAG, "BEGIN release-conn: " + this.toString() + poolObj.toString());
        }
        if (poolObj.isFree()) {
            throw new IllegalStateException("Releasing object already freed: " + db.mConnectionNum);
        }
        poolObj.release();
        if (Log.isLoggable(TAG, 3)) {
            Log.d(TAG, "END release-conn: " + this.toString() + poolObj.toString());
        }
    }

    synchronized ArrayList<SQLiteDatabase> getConnectionList() {
        ArrayList<SQLiteDatabase> list = new ArrayList<SQLiteDatabase>();
        for (int i = this.mPool.size() - 1; i >= 0; --i) {
            list.add(this.mPool.get(i).mDb);
        }
        return list;
    }

    int getFreePoolSize() {
        int count = 0;
        for (int i = this.mPool.size() - 1; i >= 0; --i) {
            if (!this.mPool.get(i).isFree()) continue;
            ++count;
        }
        return count++;
    }

    ArrayList<PoolObj> getPool() {
        return this.mPool;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("db: ");
        buff.append(this.mParentDbObj.getPath());
        buff.append(", totalsize = ");
        buff.append(this.mPool.size());
        buff.append(", #free = ");
        buff.append(this.getFreePoolSize());
        buff.append(", maxpoolsize = ");
        buff.append(this.mMaxPoolSize);
        for (PoolObj p : this.mPool) {
            buff.append("\n");
            buff.append(p.toString());
        }
        return buff.toString();
    }

    private void doAsserts() {
        for (int i = 0; i < this.mPool.size(); ++i) {
            this.mPool.get(i).verify();
            assert (((PoolObj)this.mPool.get((int)i)).mDb.mConnectionNum == i + 1);
        }
    }

    synchronized void setMaxPoolSize(int size) {
        this.mMaxPoolSize = size;
    }

    synchronized int getMaxPoolSize() {
        return this.mMaxPoolSize;
    }

    boolean isDatabaseObjFree(SQLiteDatabase db) {
        return this.mPool.get(db.mConnectionNum - 1).isFree();
    }

    int getSize() {
        return this.mPool.size();
    }

    static class PoolObj {
        private final SQLiteDatabase mDb;
        private boolean mFreeBusyFlag = true;
        private static final boolean FREE = true;
        private static final boolean BUSY = false;
        private int mNumHolders = 0;
        private HashSet<Long> mHolderIds = new HashSet();

        public PoolObj(SQLiteDatabase db) {
            this.mDb = db;
        }

        private synchronized void acquire() {
            if (Log.isLoggable(DatabaseConnectionPool.TAG, 3)) {
                assert (this.isFree());
                long id2 = Thread.currentThread().getId();
                assert (!this.mHolderIds.contains(id2));
                this.mHolderIds.add(id2);
            }
            ++this.mNumHolders;
            this.mFreeBusyFlag = false;
        }

        private synchronized void release() {
            if (Log.isLoggable(DatabaseConnectionPool.TAG, 3)) {
                long id2 = Thread.currentThread().getId();
                assert (this.mHolderIds.size() == this.mNumHolders);
                assert (this.mHolderIds.contains(id2));
                this.mHolderIds.remove(id2);
            }
            --this.mNumHolders;
            if (this.mNumHolders == 0) {
                this.mFreeBusyFlag = true;
            }
        }

        private synchronized boolean isFree() {
            if (Log.isLoggable(DatabaseConnectionPool.TAG, 3)) {
                this.verify();
            }
            return this.mFreeBusyFlag;
        }

        private synchronized void verify() {
            if (this.mFreeBusyFlag ? !$assertionsDisabled && this.mNumHolders != 0 : !$assertionsDisabled && this.mNumHolders <= 0) {
                throw new AssertionError();
            }
        }

        synchronized int getNumHolders() {
            return this.mNumHolders;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append(", conn # ");
            buff.append(this.mDb.mConnectionNum);
            buff.append(", mCountHolders = ");
            PoolObj poolObj = this;
            synchronized (poolObj) {
                buff.append(this.mNumHolders);
                buff.append(", freeBusyFlag = ");
                buff.append(this.mFreeBusyFlag);
                for (Long l : this.mHolderIds) {
                    buff.append(", id = " + l);
                }
            }
            return buff.toString();
        }
    }
}

