/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import android.os.SystemProperties;
import android.util.Log;
import java.util.ArrayList;

public final class SQLiteDebug {
    public static final boolean DEBUG_SQL_STATEMENTS = Log.isLoggable("SQLiteStatements", 2);
    public static final boolean DEBUG_SQL_TIME = Log.isLoggable("SQLiteTime", 2);
    public static final boolean DEBUG_SQL_CACHE = Log.isLoggable("SQLiteCompiledSql", 2);
    public static final boolean DEBUG_ACTIVE_CURSOR_FINALIZATION = Log.isLoggable("SQLiteCursorClosing", 2);
    public static final boolean DEBUG_LOCK_TIME_TRACKING = Log.isLoggable("SQLiteLockTime", 2);
    public static final boolean DEBUG_LOCK_TIME_TRACKING_STACK_TRACE = Log.isLoggable("SQLiteLockStackTrace", 2);
    public static final boolean DEBUG_LOG_SLOW_QUERIES = Build.IS_DEBUGGABLE;
    private static int sNumActiveCursorsFinalized = 0;

    public static final boolean shouldLogSlowQuery(long elapsedTimeMillis) {
        int slowQueryMillis = SystemProperties.getInt("db.log.slow_query_threshold", -1);
        return slowQueryMillis >= 0 && elapsedTimeMillis > (long)slowQueryMillis;
    }

    public static PagerStats getDatabaseInfo() {
        PagerStats stats = new PagerStats();
        SQLiteDebug.getPagerStats(stats);
        stats.dbStats = SQLiteDatabase.getDbStats();
        return stats;
    }

    public static native void getPagerStats(PagerStats var0);

    public static native long getHeapSize();

    public static native long getHeapAllocatedSize();

    public static native long getHeapFreeSize();

    public static native void getHeapDirtyPages(int[] var0);

    public static int getNumActiveCursorsFinalized() {
        return sNumActiveCursorsFinalized;
    }

    static synchronized void notifyActiveCursorFinalized() {
        ++sNumActiveCursorsFinalized;
    }

    public static class DbStats {
        public String dbName;
        public long pageSize;
        public long dbSize;
        public int lookaside;
        public String cache;

        public DbStats(String dbName, long pageCount, long pageSize, int lookaside, int hits, int misses, int cachesize) {
            this.dbName = dbName;
            this.pageSize = pageSize / 1024L;
            this.dbSize = pageCount * pageSize / 1024L;
            this.lookaside = lookaside;
            this.cache = hits + "/" + misses + "/" + cachesize;
        }
    }

    public static class PagerStats {
        @Deprecated
        public long totalBytes;
        @Deprecated
        public long referencedBytes;
        @Deprecated
        public long databaseBytes;
        @Deprecated
        public int numPagers;
        public int memoryUsed;
        public int pageCacheOverflo;
        public int largestMemAlloc;
        public ArrayList<DbStats> dbStats;
    }
}

