/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteClosable;
import android.database.sqlite.SQLiteCompiledSql;
import android.database.sqlite.SQLiteDatabase;
import java.util.HashMap;

public abstract class SQLiteProgram
extends SQLiteClosable {
    private static final String TAG = "SQLiteProgram";
    @Deprecated
    protected SQLiteDatabase mDatabase;
    final String mSql;
    @Deprecated
    protected int nHandle;
    SQLiteCompiledSql mCompiledSql;
    @Deprecated
    protected int nStatement;
    HashMap<Integer, Object> mBindArgs = null;
    final int mStatementType;
    static final int STATEMENT_CACHEABLE = 16;
    static final int STATEMENT_DONT_PREPARE = 32;
    static final int STATEMENT_USE_POOLED_CONN = 64;
    static final int STATEMENT_TYPE_MASK = 15;

    SQLiteProgram(SQLiteDatabase db, String sql) {
        this(db, sql, null, true);
    }

    SQLiteProgram(SQLiteDatabase db, String sql, Object[] bindArgs, boolean compileFlag) {
        this.mSql = sql.trim();
        int n = DatabaseUtils.getSqlStatementType(this.mSql);
        switch (n) {
            case 2: {
                this.mStatementType = n | 0x10;
                break;
            }
            case 1: {
                this.mStatementType = n | 0x10 | 0x40;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.mStatementType = n | 0x20;
                break;
            }
            default: {
                this.mStatementType = n;
            }
        }
        db.acquireReference();
        db.addSQLiteClosable(this);
        this.mDatabase = db;
        this.nHandle = db.mNativeHandle;
        if (bindArgs != null) {
            int size = bindArgs.length;
            for (int i = 0; i < size; ++i) {
                this.addToBindArgs(i + 1, bindArgs[i]);
            }
        }
        if (compileFlag) {
            this.compileAndbindAllArgs();
        }
    }

    private void compileSql() {
        if ((this.mStatementType & 0x10) == 0) {
            this.mCompiledSql = new SQLiteCompiledSql(this.mDatabase, this.mSql);
            this.nStatement = this.mCompiledSql.nStatement;
            return;
        }
        this.mCompiledSql = this.mDatabase.getCompiledStatementForSql(this.mSql);
        if (this.mCompiledSql == null) {
            this.mCompiledSql = new SQLiteCompiledSql(this.mDatabase, this.mSql);
            this.mCompiledSql.acquire();
            this.mDatabase.addToCompiledQueries(this.mSql, this.mCompiledSql);
        } else if (!this.mCompiledSql.acquire()) {
            int last = this.mCompiledSql.nStatement;
            this.mCompiledSql = new SQLiteCompiledSql(this.mDatabase, this.mSql);
        }
        this.nStatement = this.mCompiledSql.nStatement;
    }

    protected void onAllReferencesReleased() {
        this.release();
        this.mDatabase.removeSQLiteClosable(this);
        this.mDatabase.releaseReference();
    }

    protected void onAllReferencesReleasedFromContainer() {
        this.release();
        this.mDatabase.releaseReference();
    }

    void release() {
        if (this.mCompiledSql == null) {
            return;
        }
        this.mDatabase.releaseCompiledSqlObj(this.mSql, this.mCompiledSql);
        this.mCompiledSql = null;
        this.nStatement = 0;
    }

    @Deprecated
    public final int getUniqueId() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getSqlStatementId() {
        SQLiteProgram sQLiteProgram = this;
        synchronized (sQLiteProgram) {
            return this.mCompiledSql == null ? 0 : this.nStatement;
        }
    }

    String getSqlString() {
        return this.mSql;
    }

    @Deprecated
    protected void compile(String sql, boolean forceCompilation) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void bind(int type, int index, Object value) {
        this.mDatabase.verifyDbIsOpen();
        this.addToBindArgs(index, type == 0 ? null : value);
        if (this.nStatement <= 0) return;
        this.acquireReference();
        try {
            switch (type) {
                case 0: {
                    this.native_bind_null(index);
                    return;
                }
                case 4: {
                    this.native_bind_blob(index, (byte[])value);
                    return;
                }
                case 2: {
                    this.native_bind_double(index, (Double)value);
                    return;
                }
                case 1: {
                    this.native_bind_long(index, (Long)value);
                    return;
                }
                default: {
                    this.native_bind_string(index, (String)value);
                    return;
                }
            }
        }
        finally {
            this.releaseReference();
        }
    }

    public void bindNull(int index) {
        this.bind(0, index, null);
    }

    public void bindLong(int index, long value) {
        this.bind(1, index, value);
    }

    public void bindDouble(int index, double value) {
        this.bind(2, index, value);
    }

    public void bindString(int index, String value) {
        if (value == null) {
            throw new IllegalArgumentException("the bind value at index " + index + " is null");
        }
        this.bind(3, index, value);
    }

    public void bindBlob(int index, byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("the bind value at index " + index + " is null");
        }
        this.bind(4, index, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBindings() {
        this.mBindArgs = null;
        if (this.nStatement == 0) {
            return;
        }
        this.mDatabase.verifyDbIsOpen();
        this.acquireReference();
        try {
            this.native_clear_bindings();
        }
        finally {
            this.releaseReference();
        }
    }

    public void close() {
        this.mBindArgs = null;
        if (this.nHandle == 0 || !this.mDatabase.isOpen()) {
            return;
        }
        this.releaseReference();
    }

    private void addToBindArgs(int index, Object value) {
        if (this.mBindArgs == null) {
            this.mBindArgs = new HashMap();
        }
        this.mBindArgs.put(index, value);
    }

    void compileAndbindAllArgs() {
        if ((this.mStatementType & 0x20) > 0) {
            if (this.mBindArgs != null) {
                throw new IllegalArgumentException("Can't pass bindargs for this sql :" + this.mSql);
            }
            return;
        }
        if (this.nStatement == 0) {
            this.compileSql();
        }
        if (this.mBindArgs == null) {
            return;
        }
        for (int index : this.mBindArgs.keySet()) {
            Object value = this.mBindArgs.get(index);
            if (value == null) {
                this.native_bind_null(index);
                continue;
            }
            if (value instanceof Double || value instanceof Float) {
                this.native_bind_double(index, ((Number)value).doubleValue());
                continue;
            }
            if (value instanceof Number) {
                this.native_bind_long(index, ((Number)value).longValue());
                continue;
            }
            if (value instanceof Boolean) {
                Boolean bool2 = (Boolean)value;
                this.native_bind_long(index, bool2 != false ? 1L : 0L);
                if (bool2.booleanValue()) {
                    this.native_bind_long(index, 1L);
                    continue;
                }
                this.native_bind_long(index, 0L);
                continue;
            }
            if (value instanceof byte[]) {
                this.native_bind_blob(index, (byte[])value);
                continue;
            }
            this.native_bind_string(index, value.toString());
        }
    }

    public void bindAllArgsAsStrings(String[] bindArgs) {
        if (bindArgs == null) {
            return;
        }
        int size = bindArgs.length;
        for (int i = 0; i < size; ++i) {
            this.bindString(i + 1, bindArgs[i]);
        }
    }

    final synchronized void setNativeHandle(int nHandle) {
        this.nHandle = nHandle;
    }

    @Deprecated
    protected final native void native_compile(String var1);

    @Deprecated
    protected final native void native_finalize();

    protected final native void native_bind_null(int var1);

    protected final native void native_bind_long(int var1, long var2);

    protected final native void native_bind_double(int var1, double var2);

    protected final native void native_bind_string(int var1, String var2);

    protected final native void native_bind_blob(int var1, byte[] var2);

    private final native void native_clear_bindings();
}

