/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDoneException;
import android.database.sqlite.SQLiteProgram;
import android.os.ParcelFileDescriptor;
import android.os.SystemClock;
import android.util.Log;
import dalvik.system.BlockGuard;
import java.io.IOException;

public class SQLiteStatement
extends SQLiteProgram {
    private static final String TAG = "SQLiteStatement";
    private static final boolean READ = true;
    private static final boolean WRITE = false;
    private SQLiteDatabase mOrigDb;
    private int mState;
    private static final int TRANS_STARTED = 1;
    private static final int LOCK_ACQUIRED = 2;

    SQLiteStatement(SQLiteDatabase db, String sql, Object[] bindArgs) {
        super(db, sql, bindArgs, false);
    }

    public void execute() {
        this.executeUpdateDelete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdateDelete() {
        try {
            this.saveSqlAsLastSqlStatement();
            this.acquireAndLock(false);
            int numChanges = 0;
            if ((this.mStatementType & 0x20) > 0) {
                this.native_executeSql(this.mSql);
            } else {
                numChanges = this.native_execute();
            }
            int n = numChanges;
            return n;
        }
        finally {
            this.releaseAndUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeInsert() {
        try {
            this.saveSqlAsLastSqlStatement();
            this.acquireAndLock(false);
            long l = this.native_executeInsert();
            return l;
        }
        finally {
            this.releaseAndUnlock();
        }
    }

    private void saveSqlAsLastSqlStatement() {
        if ((this.mStatementType & 0xF) == 2 || (this.mStatementType & 0xF) == 4) {
            this.mDatabase.setLastSqlStatement(this.mSql);
        }
    }

    public long simpleQueryForLong() {
        try {
            long timeStart = this.acquireAndLock(true);
            long retValue = this.native_1x1_long();
            this.mDatabase.logTimeStat(this.mSql, timeStart);
            long l = retValue;
            return l;
        }
        catch (SQLiteDoneException e) {
            throw new SQLiteDoneException("expected 1 row from this query but query returned no data. check the query: " + this.mSql);
        }
        finally {
            this.releaseAndUnlock();
        }
    }

    public String simpleQueryForString() {
        try {
            long timeStart = this.acquireAndLock(true);
            String retValue = this.native_1x1_string();
            this.mDatabase.logTimeStat(this.mSql, timeStart);
            String string2 = retValue;
            return string2;
        }
        catch (SQLiteDoneException e) {
            throw new SQLiteDoneException("expected 1 row from this query but query returned no data. check the query: " + this.mSql);
        }
        finally {
            this.releaseAndUnlock();
        }
    }

    public ParcelFileDescriptor simpleQueryForBlobFileDescriptor() {
        try {
            long timeStart = this.acquireAndLock(true);
            ParcelFileDescriptor retValue = this.native_1x1_blob_ashmem();
            this.mDatabase.logTimeStat(this.mSql, timeStart);
            ParcelFileDescriptor parcelFileDescriptor = retValue;
            return parcelFileDescriptor;
        }
        catch (IOException ex) {
            Log.e(TAG, "simpleQueryForBlobFileDescriptor() failed", ex);
            ParcelFileDescriptor parcelFileDescriptor = null;
            return parcelFileDescriptor;
        }
        catch (SQLiteDoneException e) {
            throw new SQLiteDoneException("expected 1 row from this query but query returned no data. check the query: " + this.mSql);
        }
        finally {
            this.releaseAndUnlock();
        }
    }

    private long acquireAndLock(boolean rwFlag) {
        this.mState = 0;
        this.mDatabase.verifyDbIsOpen();
        SQLiteDatabase db = (this.mStatementType & 0x40) > 0 ? this.mDatabase.getDbConnection(this.mSql) : this.mDatabase;
        this.mOrigDb = this.mDatabase;
        this.mDatabase = db;
        this.setNativeHandle(this.mDatabase.mNativeHandle);
        if (!rwFlag) {
            BlockGuard.getThreadPolicy().onWriteToDisk();
        } else {
            BlockGuard.getThreadPolicy().onReadFromDisk();
        }
        if ((this.mStatementType & 0xF) == 4) {
            if (!this.mDatabase.isDbLockedByCurrentThread()) {
                this.mDatabase.setTransactionUsingExecSqlFlag();
            }
        } else if ((this.mStatementType & 0xF) == 2 && !this.mDatabase.inTransaction()) {
            this.mDatabase.beginTransactionNonExclusive();
            this.mState = 1;
        }
        if (!this.mDatabase.isDbLockedByCurrentThread()) {
            this.mDatabase.lock(this.mSql);
            this.mState = 2;
        }
        this.acquireReference();
        long startTime = SystemClock.uptimeMillis();
        this.mDatabase.closePendingStatements();
        this.compileAndbindAllArgs();
        return startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseAndUnlock() {
        this.releaseReference();
        if (this.mState == 1) {
            try {
                this.mDatabase.setTransactionSuccessful();
            }
            finally {
                this.mDatabase.endTransaction();
            }
        } else if (this.mState == 2) {
            this.mDatabase.unlock();
        }
        if ((this.mStatementType & 0xF) == 5 || (this.mStatementType & 0xF) == 6) {
            this.mDatabase.resetTransactionUsingExecSqlFlag();
        }
        this.clearBindings();
        this.release();
        this.mDatabase = this.mOrigDb;
        this.setNativeHandle(this.mDatabase.mNativeHandle);
    }

    private final native int native_execute();

    private final native long native_executeInsert();

    private final native long native_1x1_long();

    private final native String native_1x1_string();

    private final native ParcelFileDescriptor native_1x1_blob_ashmem() throws IOException;

    private final native void native_executeSql(String var1);
}

