/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.os.Debug;
import android.util.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;
import org.apache.harmony.dalvik.ddmc.DdmVmInternal;

public class DdmHandleHeap
extends ChunkHandler {
    public static final int CHUNK_HPIF = DdmHandleHeap.type((String)"HPIF");
    public static final int CHUNK_HPSG = DdmHandleHeap.type((String)"HPSG");
    public static final int CHUNK_HPDU = DdmHandleHeap.type((String)"HPDU");
    public static final int CHUNK_HPDS = DdmHandleHeap.type((String)"HPDS");
    public static final int CHUNK_NHSG = DdmHandleHeap.type((String)"NHSG");
    public static final int CHUNK_HPGC = DdmHandleHeap.type((String)"HPGC");
    public static final int CHUNK_REAE = DdmHandleHeap.type((String)"REAE");
    public static final int CHUNK_REAQ = DdmHandleHeap.type((String)"REAQ");
    public static final int CHUNK_REAL = DdmHandleHeap.type((String)"REAL");
    private static DdmHandleHeap mInstance = new DdmHandleHeap();

    private DdmHandleHeap() {
    }

    public static void register() {
        DdmServer.registerHandler((int)CHUNK_HPIF, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_HPSG, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_HPDU, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_HPDS, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_NHSG, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_HPGC, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_REAE, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_REAQ, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_REAL, (ChunkHandler)mInstance);
    }

    public void connected() {
    }

    public void disconnected() {
    }

    public Chunk handleChunk(Chunk request) {
        int type = request.type;
        if (type == CHUNK_HPIF) {
            return this.handleHPIF(request);
        }
        if (type == CHUNK_HPSG) {
            return this.handleHPSGNHSG(request, false);
        }
        if (type == CHUNK_HPDU) {
            return this.handleHPDU(request);
        }
        if (type == CHUNK_HPDS) {
            return this.handleHPDS(request);
        }
        if (type == CHUNK_NHSG) {
            return this.handleHPSGNHSG(request, true);
        }
        if (type == CHUNK_HPGC) {
            return this.handleHPGC(request);
        }
        if (type == CHUNK_REAE) {
            return this.handleREAE(request);
        }
        if (type == CHUNK_REAQ) {
            return this.handleREAQ(request);
        }
        if (type == CHUNK_REAL) {
            return this.handleREAL(request);
        }
        throw new RuntimeException("Unknown packet " + ChunkHandler.name((int)type));
    }

    private Chunk handleHPIF(Chunk request) {
        ByteBuffer in = DdmHandleHeap.wrapChunk((Chunk)request);
        byte when = in.get();
        boolean ok = DdmVmInternal.heapInfoNotify((int)when);
        if (!ok) {
            return DdmHandleHeap.createFailChunk((int)1, (String)"Unsupported HPIF what");
        }
        return null;
    }

    private Chunk handleHPSGNHSG(Chunk request, boolean isNative) {
        byte what;
        ByteBuffer in = DdmHandleHeap.wrapChunk((Chunk)request);
        byte when = in.get();
        boolean ok = DdmVmInternal.heapSegmentNotify((int)when, (int)(what = in.get()), (boolean)isNative);
        if (!ok) {
            return DdmHandleHeap.createFailChunk((int)1, (String)"Unsupported HPSG what/when");
        }
        return null;
    }

    private Chunk handleHPDU(Chunk request) {
        byte result;
        ByteBuffer in = DdmHandleHeap.wrapChunk((Chunk)request);
        int len = in.getInt();
        String fileName = DdmHandleHeap.getString((ByteBuffer)in, (int)len);
        try {
            Debug.dumpHprofData(fileName);
            result = 0;
        }
        catch (UnsupportedOperationException uoe) {
            Log.w("ddm-heap", "hprof dumps not supported in this VM");
            result = -1;
        }
        catch (IOException ioe) {
            result = -1;
        }
        catch (RuntimeException re) {
            result = -1;
        }
        byte[] reply = new byte[]{result};
        return new Chunk(CHUNK_HPDU, reply, 0, reply.length);
    }

    private Chunk handleHPDS(Chunk request) {
        ByteBuffer in = DdmHandleHeap.wrapChunk((Chunk)request);
        String failMsg = null;
        try {
            Debug.dumpHprofDataDdms();
        }
        catch (UnsupportedOperationException uoe) {
            failMsg = "hprof dumps not supported in this VM";
        }
        catch (RuntimeException re) {
            failMsg = "Exception: " + re.getMessage();
        }
        if (failMsg != null) {
            Log.w("ddm-heap", failMsg);
            return DdmHandleHeap.createFailChunk((int)1, (String)failMsg);
        }
        return null;
    }

    private Chunk handleHPGC(Chunk request) {
        System.gc();
        return null;
    }

    private Chunk handleREAE(Chunk request) {
        ByteBuffer in = DdmHandleHeap.wrapChunk((Chunk)request);
        boolean enable = in.get() != 0;
        DdmVmInternal.enableRecentAllocations((boolean)enable);
        return null;
    }

    private Chunk handleREAQ(Chunk request) {
        byte[] reply = new byte[]{DdmVmInternal.getRecentAllocationStatus() ? (byte)1 : 0};
        return new Chunk(CHUNK_REAQ, reply, 0, reply.length);
    }

    private Chunk handleREAL(Chunk request) {
        byte[] reply = DdmVmInternal.getRecentAllocations();
        return new Chunk(CHUNK_REAL, reply, 0, reply.length);
    }
}

