/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.os.Debug;
import android.util.Log;
import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;

public class DdmHandleProfiling
extends ChunkHandler {
    public static final int CHUNK_MPRS = DdmHandleProfiling.type((String)"MPRS");
    public static final int CHUNK_MPRE = DdmHandleProfiling.type((String)"MPRE");
    public static final int CHUNK_MPSS = DdmHandleProfiling.type((String)"MPSS");
    public static final int CHUNK_MPSE = DdmHandleProfiling.type((String)"MPSE");
    public static final int CHUNK_MPRQ = DdmHandleProfiling.type((String)"MPRQ");
    private static DdmHandleProfiling mInstance = new DdmHandleProfiling();

    private DdmHandleProfiling() {
    }

    public static void register() {
        DdmServer.registerHandler((int)CHUNK_MPRS, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_MPRE, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_MPSS, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_MPSE, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_MPRQ, (ChunkHandler)mInstance);
    }

    public void connected() {
    }

    public void disconnected() {
    }

    public Chunk handleChunk(Chunk request) {
        int type = request.type;
        if (type == CHUNK_MPRS) {
            return this.handleMPRS(request);
        }
        if (type == CHUNK_MPRE) {
            return this.handleMPRE(request);
        }
        if (type == CHUNK_MPSS) {
            return this.handleMPSS(request);
        }
        if (type == CHUNK_MPSE) {
            return this.handleMPSE(request);
        }
        if (type == CHUNK_MPRQ) {
            return this.handleMPRQ(request);
        }
        throw new RuntimeException("Unknown packet " + ChunkHandler.name((int)type));
    }

    private Chunk handleMPRS(Chunk request) {
        ByteBuffer in = DdmHandleProfiling.wrapChunk((Chunk)request);
        int bufferSize = in.getInt();
        int flags = in.getInt();
        int len = in.getInt();
        String fileName = DdmHandleProfiling.getString((ByteBuffer)in, (int)len);
        try {
            Debug.startMethodTracing(fileName, bufferSize, flags);
            return null;
        }
        catch (RuntimeException re) {
            return DdmHandleProfiling.createFailChunk((int)1, (String)re.getMessage());
        }
    }

    private Chunk handleMPRE(Chunk request) {
        byte result;
        try {
            Debug.stopMethodTracing();
            result = 0;
        }
        catch (RuntimeException re) {
            Log.w("ddm-heap", "Method profiling end failed: " + re.getMessage());
            result = 1;
        }
        byte[] reply = new byte[]{result};
        return new Chunk(CHUNK_MPRE, reply, 0, reply.length);
    }

    private Chunk handleMPSS(Chunk request) {
        ByteBuffer in = DdmHandleProfiling.wrapChunk((Chunk)request);
        int bufferSize = in.getInt();
        int flags = in.getInt();
        try {
            Debug.startMethodTracingDdms(bufferSize, flags);
            return null;
        }
        catch (RuntimeException re) {
            return DdmHandleProfiling.createFailChunk((int)1, (String)re.getMessage());
        }
    }

    private Chunk handleMPSE(Chunk request) {
        try {
            Debug.stopMethodTracing();
            boolean result = false;
        }
        catch (RuntimeException re) {
            Log.w("ddm-heap", "Method prof stream end failed: " + re.getMessage());
            return DdmHandleProfiling.createFailChunk((int)1, (String)re.getMessage());
        }
        return null;
    }

    private Chunk handleMPRQ(Chunk request) {
        boolean result = Debug.isMethodTracingActive();
        byte[] reply = new byte[]{(byte)(result ? 1 : 0)};
        return new Chunk(CHUNK_MPRQ, reply, 0, reply.length);
    }
}

