/*
 * Decompiled with CFR 0.152.
 */
package android.drm;

import android.drm.DrmUtils;
import android.drm.ProcessedData;
import java.io.File;
import java.io.IOException;

public class DrmRights {
    private byte[] mData;
    private String mMimeType;
    private String mAccountId = "_NO_USER";
    private String mSubscriptionId = "";

    public DrmRights(String rightsFilePath, String mimeType) {
        File file = new File(rightsFilePath);
        this.instantiate(file, mimeType);
    }

    public DrmRights(String rightsFilePath, String mimeType, String accountId) {
        this(rightsFilePath, mimeType);
        if (null != accountId && !accountId.equals("")) {
            this.mAccountId = accountId;
        }
    }

    public DrmRights(String rightsFilePath, String mimeType, String accountId, String subscriptionId) {
        this(rightsFilePath, mimeType);
        if (null != accountId && !accountId.equals("")) {
            this.mAccountId = accountId;
        }
        if (null != subscriptionId && !subscriptionId.equals("")) {
            this.mSubscriptionId = subscriptionId;
        }
    }

    public DrmRights(File rightsFile, String mimeType) {
        this.instantiate(rightsFile, mimeType);
    }

    private void instantiate(File rightsFile, String mimeType) {
        try {
            this.mData = DrmUtils.readBytes(rightsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mMimeType = mimeType;
    }

    public DrmRights(ProcessedData data, String mimeType) {
        if (data != null) {
            String subscriptionId;
            this.mData = data.getData();
            String accountId = data.getAccountId();
            if (null != accountId && !accountId.equals("")) {
                this.mAccountId = accountId;
            }
            if (null != (subscriptionId = data.getSubscriptionId()) && !subscriptionId.equals("")) {
                this.mSubscriptionId = subscriptionId;
            }
        }
        this.mMimeType = mimeType;
    }

    public byte[] getData() {
        return this.mData;
    }

    public String getMimeType() {
        return this.mMimeType;
    }

    public String getAccountId() {
        return this.mAccountId;
    }

    public String getSubscriptionId() {
        return this.mSubscriptionId;
    }

    boolean isValid() {
        return null != this.mMimeType && !this.mMimeType.equals("") && null != this.mData && this.mData.length > 0;
    }
}

