/*
 * Decompiled with CFR 0.152.
 */
package android.drm;

import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrmSupportInfo {
    private final ArrayList<String> mFileSuffixList = new ArrayList();
    private final ArrayList<String> mMimeTypeList = new ArrayList();
    private String mDescription = "";

    public void addMimeType(String mimeType) {
        this.mMimeTypeList.add(mimeType);
    }

    public void addFileSuffix(String fileSuffix) {
        this.mFileSuffixList.add(fileSuffix);
    }

    public Iterator<String> getMimeTypeIterator() {
        return this.mMimeTypeList.iterator();
    }

    public Iterator<String> getFileSuffixIterator() {
        return this.mFileSuffixList.iterator();
    }

    public void setDescription(String description) {
        if (null != description) {
            this.mDescription = description;
        }
    }

    public String getDescriprition() {
        return this.mDescription;
    }

    public int hashCode() {
        return this.mFileSuffixList.hashCode() + this.mMimeTypeList.hashCode() + this.mDescription.hashCode();
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object instanceof DrmSupportInfo) {
            result = this.mFileSuffixList.equals(((DrmSupportInfo)object).mFileSuffixList) && this.mMimeTypeList.equals(((DrmSupportInfo)object).mMimeTypeList) && this.mDescription.equals(((DrmSupportInfo)object).mDescription);
        }
        return result;
    }

    boolean isSupportedMimeType(String mimeType) {
        if (null != mimeType && !mimeType.equals("")) {
            for (int i = 0; i < this.mMimeTypeList.size(); ++i) {
                String completeMimeType = this.mMimeTypeList.get(i);
                if (!completeMimeType.startsWith(mimeType)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isSupportedFileSuffix(String fileSuffix) {
        return this.mFileSuffixList.contains(fileSuffix);
    }
}

