/*
 * Decompiled with CFR 0.152.
 */
package android.drm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;

public class DrmUtils {
    static byte[] readBytes(String path) throws IOException {
        File file = new File(path);
        return DrmUtils.readBytes(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readBytes(File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        BufferedInputStream bufferedStream = new BufferedInputStream(inputStream);
        byte[] data = null;
        try {
            int length = bufferedStream.available();
            if (length > 0) {
                data = new byte[length];
                bufferedStream.read(data);
            }
        }
        finally {
            DrmUtils.quiteDispose(bufferedStream);
            DrmUtils.quiteDispose(inputStream);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeToFile(String path, byte[] data) throws IOException {
        FileOutputStream outputStream = null;
        if (null != path && null != data) {
            try {
                outputStream = new FileOutputStream(path);
                outputStream.write(data);
            }
            catch (Throwable throwable) {
                DrmUtils.quiteDispose(outputStream);
                throw throwable;
            }
            DrmUtils.quiteDispose(outputStream);
        }
    }

    static void removeFile(String path) throws IOException {
        File file = new File(path);
        file.delete();
    }

    private static void quiteDispose(InputStream stream) {
        try {
            if (null != stream) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void quiteDispose(OutputStream stream) {
        try {
            if (null != stream) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static ExtendedMetadataParser getExtendedMetadataParser(byte[] extendedMetadata) {
        return new ExtendedMetadataParser(extendedMetadata);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtendedMetadataParser {
        HashMap<String, String> mMap = new HashMap();

        private int readByte(byte[] constraintData, int arrayIndex) {
            return constraintData[arrayIndex];
        }

        private String readMultipleBytes(byte[] constraintData, int numberOfBytes, int arrayIndex) {
            byte[] returnBytes = new byte[numberOfBytes];
            int j = arrayIndex;
            int i = 0;
            while (j < arrayIndex + numberOfBytes) {
                returnBytes[i] = constraintData[j];
                ++j;
                ++i;
            }
            return new String(returnBytes);
        }

        private ExtendedMetadataParser(byte[] constraintData) {
            int valueLength;
            for (int index = 0; index < constraintData.length; index += valueLength) {
                int keyLength = this.readByte(constraintData, index);
                valueLength = this.readByte(constraintData, ++index);
                String strKey = this.readMultipleBytes(constraintData, keyLength, ++index);
                String strValue = this.readMultipleBytes(constraintData, valueLength, index += keyLength);
                if (strValue.equals(" ")) {
                    strValue = "";
                }
                this.mMap.put(strKey, strValue);
            }
        }

        public Iterator<String> iterator() {
            return this.mMap.values().iterator();
        }

        public Iterator<String> keyIterator() {
            return this.mMap.keySet().iterator();
        }

        public String get(String key) {
            return this.mMap.get(key);
        }
    }
}

