/*
 * Decompiled with CFR 0.152.
 */
package android.drm.mobile1;

import android.drm.mobile1.DrmException;
import android.drm.mobile1.DrmRawContent;
import android.drm.mobile1.DrmRights;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class DrmRightsManager {
    public static final String DRM_MIMETYPE_RIGHTS_XML_STRING = "application/vnd.oma.drm.rights+xml";
    public static final String DRM_MIMETYPE_RIGHTS_WBXML_STRING = "application/vnd.oma.drm.rights+wbxml";
    private static final int DRM_MIMETYPE_RIGHTS_XML = 3;
    private static final int DRM_MIMETYPE_RIGHTS_WBXML = 4;
    private static final int DRM_MIMETYPE_MESSAGE = 1;
    private static final int JNI_DRM_SUCCESS = 0;
    private static final int JNI_DRM_FAILURE = -1;
    private static DrmRightsManager singleton = null;

    protected DrmRightsManager() {
    }

    public static synchronized DrmRightsManager getInstance() {
        if (singleton == null) {
            singleton = new DrmRightsManager();
        }
        return singleton;
    }

    public synchronized DrmRights installRights(InputStream rightsData, int len, String mimeTypeStr) throws DrmException, IOException {
        int mimeType = 0;
        if (DRM_MIMETYPE_RIGHTS_XML_STRING.equals(mimeTypeStr)) {
            mimeType = 3;
        } else if (DRM_MIMETYPE_RIGHTS_WBXML_STRING.equals(mimeTypeStr)) {
            mimeType = 4;
        } else if ("application/vnd.oma.drm.message".equals(mimeTypeStr)) {
            mimeType = 1;
        } else {
            throw new IllegalArgumentException("mimeType must be DRM_MIMETYPE_RIGHTS_XML or DRM_MIMETYPE_RIGHTS_WBXML or DRM_MIMETYPE_MESSAGE");
        }
        if (len <= 0) {
            return null;
        }
        DrmRights rights = new DrmRights();
        int res = this.nativeInstallDrmRights(rightsData, len, mimeType, rights);
        if (-1 == res) {
            throw new DrmException("nativeInstallDrmRights() returned JNI_DRM_FAILURE");
        }
        return rights;
    }

    public synchronized DrmRights queryRights(DrmRawContent content) {
        DrmRights rights = new DrmRights();
        int res = this.nativeQueryRights(content, rights);
        if (-1 == res) {
            return null;
        }
        return rights;
    }

    public synchronized List getRightsList() {
        ArrayList<DrmRights> rightsList = new ArrayList<DrmRights>();
        int num = this.nativeGetNumOfRights();
        if (-1 == num) {
            return null;
        }
        if (num > 0) {
            int i;
            DrmRights[] rightsArray = new DrmRights[num];
            for (i = 0; i < num; ++i) {
                rightsArray[i] = new DrmRights();
            }
            if (-1 == (num = this.nativeGetRightsList(rightsArray, num))) {
                return null;
            }
            for (i = 0; i < num; ++i) {
                rightsList.add(rightsArray[i]);
            }
        }
        return rightsList;
    }

    public synchronized void deleteRights(DrmRights rights) {
        int res = this.nativeDeleteRights(rights);
        if (-1 == res) {
            return;
        }
    }

    private native int nativeInstallDrmRights(InputStream var1, int var2, int var3, DrmRights var4);

    private native int nativeQueryRights(DrmRawContent var1, DrmRights var2);

    private native int nativeGetNumOfRights();

    private native int nativeGetRightsList(DrmRights[] var1, int var2);

    private native int nativeDeleteRights(DrmRights var1);

    static {
        try {
            System.loadLibrary("drm1_jni");
        }
        catch (UnsatisfiedLinkError ule) {
            System.err.println("WARNING: Could not load libdrm1_jni.so");
        }
    }
}

