/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.util.TypedValue;
import java.io.BufferedInputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitmapFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeFile(String pathName, Options opts) {
        Bitmap bm = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(pathName);
            bm = BitmapFactory.decodeStream(stream, null, opts);
        }
        catch (Exception e) {
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {}
            }
        }
        return bm;
    }

    public static Bitmap decodeFile(String pathName) {
        return BitmapFactory.decodeFile(pathName, null);
    }

    public static Bitmap decodeResourceStream(Resources res, TypedValue value, InputStream is, Rect pad, Options opts) {
        if (opts == null) {
            opts = new Options();
        }
        if (opts.inDensity == 0 && value != null) {
            int density = value.density;
            if (density == 0) {
                opts.inDensity = 160;
            } else if (density != 65535) {
                opts.inDensity = density;
            }
        }
        if (opts.inTargetDensity == 0 && res != null) {
            opts.inTargetDensity = res.getDisplayMetrics().densityDpi;
        }
        return BitmapFactory.decodeStream(is, pad, opts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeResource(Resources res, int id2, Options opts) {
        Bitmap bm = null;
        InputStream is = null;
        try {
            TypedValue value = new TypedValue();
            is = res.openRawResource(id2, value);
            bm = BitmapFactory.decodeResourceStream(res, value, is, null, opts);
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
        if (bm == null && opts != null && opts.inBitmap != null) {
            throw new IllegalArgumentException("Problem decoding into existing bitmap");
        }
        return bm;
    }

    public static Bitmap decodeResource(Resources res, int id2) {
        return BitmapFactory.decodeResource(res, id2, null);
    }

    public static Bitmap decodeByteArray(byte[] data, int offset, int length, Options opts) {
        if ((offset | length) < 0 || data.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Bitmap bm = BitmapFactory.nativeDecodeByteArray(data, offset, length, opts);
        if (bm == null && opts != null && opts.inBitmap != null) {
            throw new IllegalArgumentException("Problem decoding into existing bitmap");
        }
        return bm;
    }

    public static Bitmap decodeByteArray(byte[] data, int offset, int length) {
        return BitmapFactory.decodeByteArray(data, offset, length, null);
    }

    public static Bitmap decodeStream(InputStream is, Rect outPadding, Options opts) {
        Bitmap bm;
        if (is == null) {
            return null;
        }
        if (!is.markSupported()) {
            is = new BufferedInputStream(is, 16384);
        }
        is.mark(1024);
        if (is instanceof AssetManager.AssetInputStream) {
            bm = BitmapFactory.nativeDecodeAsset(((AssetManager.AssetInputStream)is).getAssetInt(), outPadding, opts);
        } else {
            byte[] tempStorage = null;
            if (opts != null) {
                tempStorage = opts.inTempStorage;
            }
            if (tempStorage == null) {
                tempStorage = new byte[16384];
            }
            bm = BitmapFactory.nativeDecodeStream(is, tempStorage, outPadding, opts);
        }
        if (bm == null && opts != null && opts.inBitmap != null) {
            throw new IllegalArgumentException("Problem decoding into existing bitmap");
        }
        return BitmapFactory.finishDecode(bm, outPadding, opts);
    }

    private static Bitmap finishDecode(Bitmap bm, Rect outPadding, Options opts) {
        boolean isNinePatch;
        if (bm == null || opts == null) {
            return bm;
        }
        int density = opts.inDensity;
        if (density == 0) {
            return bm;
        }
        bm.setDensity(density);
        int targetDensity = opts.inTargetDensity;
        if (targetDensity == 0 || density == targetDensity || density == opts.inScreenDensity) {
            return bm;
        }
        byte[] np = bm.getNinePatchChunk();
        boolean bl = isNinePatch = np != null && NinePatch.isNinePatchChunk(np);
        if (opts.inScaled || isNinePatch) {
            float scale = (float)targetDensity / (float)density;
            Bitmap oldBitmap = bm;
            bm = Bitmap.createScaledBitmap(oldBitmap, (int)((float)bm.getWidth() * scale + 0.5f), (int)((float)bm.getHeight() * scale + 0.5f), true);
            oldBitmap.recycle();
            if (isNinePatch) {
                np = BitmapFactory.nativeScaleNinePatch(np, scale, outPadding);
                bm.setNinePatchChunk(np);
            }
            bm.setDensity(targetDensity);
        }
        return bm;
    }

    public static Bitmap decodeStream(InputStream is) {
        return BitmapFactory.decodeStream(is, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeFileDescriptor(FileDescriptor fd, Rect outPadding, Options opts) {
        if (BitmapFactory.nativeIsSeekable(fd)) {
            Bitmap bm = BitmapFactory.nativeDecodeFileDescriptor(fd, outPadding, opts);
            if (bm == null && opts != null && opts.inBitmap != null) {
                throw new IllegalArgumentException("Problem decoding into existing bitmap");
            }
            return BitmapFactory.finishDecode(bm, outPadding, opts);
        }
        FileInputStream fis = new FileInputStream(fd);
        try {
            Bitmap bitmap = BitmapFactory.decodeStream(fis, outPadding, opts);
            return bitmap;
        }
        finally {
            try {
                fis.close();
            }
            catch (Throwable t) {}
        }
    }

    public static Bitmap decodeFileDescriptor(FileDescriptor fd) {
        return BitmapFactory.decodeFileDescriptor(fd, null, null);
    }

    public static void setDefaultConfig(Bitmap.Config config) {
        if (config == null) {
            config = Bitmap.Config.RGB_565;
        }
        BitmapFactory.nativeSetDefaultConfig(config.nativeInt);
    }

    private static native void nativeSetDefaultConfig(int var0);

    private static native Bitmap nativeDecodeStream(InputStream var0, byte[] var1, Rect var2, Options var3);

    private static native Bitmap nativeDecodeFileDescriptor(FileDescriptor var0, Rect var1, Options var2);

    private static native Bitmap nativeDecodeAsset(int var0, Rect var1, Options var2);

    private static native Bitmap nativeDecodeByteArray(byte[] var0, int var1, int var2, Options var3);

    private static native byte[] nativeScaleNinePatch(byte[] var0, float var1, Rect var2);

    private static native boolean nativeIsSeekable(FileDescriptor var0);

    public static class Options {
        public Bitmap inBitmap;
        public boolean inMutable;
        public boolean inJustDecodeBounds;
        public int inSampleSize;
        public Bitmap.Config inPreferredConfig = Bitmap.Config.ARGB_8888;
        public boolean inDither = false;
        public int inDensity;
        public int inTargetDensity;
        public int inScreenDensity;
        public boolean inScaled = true;
        public boolean inPurgeable;
        public boolean inInputShareable;
        public boolean inPreferQualityOverSpeed;
        public int outWidth;
        public int outHeight;
        public String outMimeType;
        public byte[] inTempStorage;
        public boolean mCancel;

        private native void requestCancel();

        public void requestCancelDecode() {
            this.mCancel = true;
            this.requestCancel();
        }
    }
}

