/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Path;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;

public class Region
implements Parcelable {
    public final int mNativeRegion;
    public static final Parcelable.Creator<Region> CREATOR = new Parcelable.Creator<Region>(){

        @Override
        public Region createFromParcel(Parcel p) {
            int ni = Region.nativeCreateFromParcel(p);
            if (ni == 0) {
                throw new RuntimeException();
            }
            return new Region(ni);
        }

        public Region[] newArray(int size) {
            return new Region[size];
        }
    };

    public Region() {
        this(Region.nativeConstructor());
    }

    public Region(Region region) {
        this(Region.nativeConstructor());
        Region.nativeSetRegion(this.mNativeRegion, region.mNativeRegion);
    }

    public Region(Rect r) {
        this.mNativeRegion = Region.nativeConstructor();
        Region.nativeSetRect(this.mNativeRegion, r.left, r.top, r.right, r.bottom);
    }

    public Region(int left, int top, int right, int bottom) {
        this.mNativeRegion = Region.nativeConstructor();
        Region.nativeSetRect(this.mNativeRegion, left, top, right, bottom);
    }

    public void setEmpty() {
        Region.nativeSetRect(this.mNativeRegion, 0, 0, 0, 0);
    }

    public boolean set(Region region) {
        return Region.nativeSetRegion(this.mNativeRegion, region.mNativeRegion);
    }

    public boolean set(Rect r) {
        return Region.nativeSetRect(this.mNativeRegion, r.left, r.top, r.right, r.bottom);
    }

    public boolean set(int left, int top, int right, int bottom) {
        return Region.nativeSetRect(this.mNativeRegion, left, top, right, bottom);
    }

    public boolean setPath(Path path, Region clip) {
        return Region.nativeSetPath(this.mNativeRegion, path.ni(), clip.mNativeRegion);
    }

    public native boolean isEmpty();

    public native boolean isRect();

    public native boolean isComplex();

    public Rect getBounds() {
        Rect r = new Rect();
        Region.nativeGetBounds(this.mNativeRegion, r);
        return r;
    }

    public boolean getBounds(Rect r) {
        if (r == null) {
            throw new NullPointerException();
        }
        return Region.nativeGetBounds(this.mNativeRegion, r);
    }

    public Path getBoundaryPath() {
        Path path = new Path();
        Region.nativeGetBoundaryPath(this.mNativeRegion, path.ni());
        return path;
    }

    public boolean getBoundaryPath(Path path) {
        return Region.nativeGetBoundaryPath(this.mNativeRegion, path.ni());
    }

    public native boolean contains(int var1, int var2);

    public boolean quickContains(Rect r) {
        return this.quickContains(r.left, r.top, r.right, r.bottom);
    }

    public native boolean quickContains(int var1, int var2, int var3, int var4);

    public boolean quickReject(Rect r) {
        return this.quickReject(r.left, r.top, r.right, r.bottom);
    }

    public native boolean quickReject(int var1, int var2, int var3, int var4);

    public native boolean quickReject(Region var1);

    public void translate(int dx, int dy) {
        this.translate(dx, dy, null);
    }

    public native void translate(int var1, int var2, Region var3);

    public void scale(float scale) {
        this.scale(scale, null);
    }

    public native void scale(float var1, Region var2);

    public final boolean union(Rect r) {
        return this.op(r, Op.UNION);
    }

    public boolean op(Rect r, Op op) {
        return Region.nativeOp(this.mNativeRegion, r.left, r.top, r.right, r.bottom, op.nativeInt);
    }

    public boolean op(int left, int top, int right, int bottom, Op op) {
        return Region.nativeOp(this.mNativeRegion, left, top, right, bottom, op.nativeInt);
    }

    public boolean op(Region region, Op op) {
        return this.op(this, region, op);
    }

    public boolean op(Rect rect, Region region, Op op) {
        return Region.nativeOp(this.mNativeRegion, rect, region.mNativeRegion, op.nativeInt);
    }

    public boolean op(Region region1, Region region2, Op op) {
        return Region.nativeOp(this.mNativeRegion, region1.mNativeRegion, region2.mNativeRegion, op.nativeInt);
    }

    public String toString() {
        return Region.nativeToString(this.mNativeRegion);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel p, int flags) {
        if (!Region.nativeWriteToParcel(this.mNativeRegion, p)) {
            throw new RuntimeException();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Region)) {
            return false;
        }
        Region peer = (Region)obj;
        return Region.nativeEquals(this.mNativeRegion, peer.mNativeRegion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Region.nativeDestructor(this.mNativeRegion);
        }
        finally {
            super.finalize();
        }
    }

    Region(int ni) {
        if (ni == 0) {
            throw new RuntimeException();
        }
        this.mNativeRegion = ni;
    }

    private Region(int ni, int dummy) {
        this(ni);
    }

    final int ni() {
        return this.mNativeRegion;
    }

    private static native boolean nativeEquals(int var0, int var1);

    private static native int nativeConstructor();

    private static native void nativeDestructor(int var0);

    private static native boolean nativeSetRegion(int var0, int var1);

    private static native boolean nativeSetRect(int var0, int var1, int var2, int var3, int var4);

    private static native boolean nativeSetPath(int var0, int var1, int var2);

    private static native boolean nativeGetBounds(int var0, Rect var1);

    private static native boolean nativeGetBoundaryPath(int var0, int var1);

    private static native boolean nativeOp(int var0, int var1, int var2, int var3, int var4, int var5);

    private static native boolean nativeOp(int var0, Rect var1, int var2, int var3);

    private static native boolean nativeOp(int var0, int var1, int var2, int var3);

    private static native int nativeCreateFromParcel(Parcel var0);

    private static native boolean nativeWriteToParcel(int var0, Parcel var1);

    private static native String nativeToString(int var0);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Op {
        DIFFERENCE(0),
        INTERSECT(1),
        UNION(2),
        XOR(3),
        REVERSE_DIFFERENCE(4),
        REPLACE(5);

        public final int nativeInt;

        private Op(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }
}

