/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import java.lang.ref.WeakReference;

public class SurfaceTexture {
    private EventHandler mEventHandler;
    private OnFrameAvailableListener mOnFrameAvailableListener;
    private int mSurfaceTexture;

    public SurfaceTexture(int texName) {
        this(texName, false);
    }

    public SurfaceTexture(int texName, boolean allowSynchronousMode) {
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(looper) : null);
        this.nativeInit(texName, new WeakReference<SurfaceTexture>(this), allowSynchronousMode);
    }

    public void setOnFrameAvailableListener(OnFrameAvailableListener l) {
        this.mOnFrameAvailableListener = l;
    }

    public void setDefaultBufferSize(int width, int height) {
        this.nativeSetDefaultBufferSize(width, height);
    }

    public void updateTexImage() {
        int err = this.nativeUpdateTexImage();
        if (err != 0) {
            throw new RuntimeException("Error during updateTexImage (see logs)");
        }
    }

    public void getTransformMatrix(float[] mtx) {
        if (mtx.length != 16) {
            throw new IllegalArgumentException();
        }
        this.nativeGetTransformMatrix(mtx);
    }

    public long getTimestamp() {
        return this.nativeGetTimestamp();
    }

    public void release() {
        this.nativeRelease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.nativeFinalize();
        }
        finally {
            super.finalize();
        }
    }

    private static void postEventFromNative(Object selfRef) {
        WeakReference weakSelf = (WeakReference)selfRef;
        SurfaceTexture st = (SurfaceTexture)weakSelf.get();
        if (st == null) {
            return;
        }
        if (st.mEventHandler != null) {
            Message m = st.mEventHandler.obtainMessage();
            st.mEventHandler.sendMessage(m);
        }
    }

    private native void nativeInit(int var1, Object var2, boolean var3);

    private native void nativeFinalize();

    private native void nativeGetTransformMatrix(float[] var1);

    private native long nativeGetTimestamp();

    private native void nativeSetDefaultBufferSize(int var1, int var2);

    private native int nativeUpdateTexImage();

    private native int nativeGetQueuedCount();

    private native void nativeRelease();

    private static native void nativeClassInit();

    static {
        SurfaceTexture.nativeClassInit();
    }

    private class EventHandler
    extends Handler {
        public EventHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (SurfaceTexture.this.mOnFrameAvailableListener != null) {
                SurfaceTexture.this.mOnFrameAvailableListener.onFrameAvailable(SurfaceTexture.this);
            }
        }
    }

    public static class OutOfResourcesException
    extends Exception {
        public OutOfResourcesException() {
        }

        public OutOfResourcesException(String name) {
            super(name);
        }
    }

    public static interface OnFrameAvailableListener {
        public void onFrameAvailable(SurfaceTexture var1);
    }
}

