/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.android.internal.R;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class NinePatchDrawable
extends Drawable {
    private static final boolean DEFAULT_DITHER = true;
    private NinePatchState mNinePatchState;
    private NinePatch mNinePatch;
    private Rect mPadding;
    private Paint mPaint;
    private boolean mMutated;
    private int mTargetDensity = 160;
    private int mBitmapWidth;
    private int mBitmapHeight;

    NinePatchDrawable() {
    }

    @Deprecated
    public NinePatchDrawable(Bitmap bitmap, byte[] chunk, Rect padding, String srcName) {
        this(new NinePatchState(new NinePatch(bitmap, chunk, srcName), padding), null);
    }

    public NinePatchDrawable(Resources res, Bitmap bitmap, byte[] chunk, Rect padding, String srcName) {
        this(new NinePatchState(new NinePatch(bitmap, chunk, srcName), padding), res);
        this.mNinePatchState.mTargetDensity = this.mTargetDensity;
    }

    @Deprecated
    public NinePatchDrawable(NinePatch patch) {
        this(new NinePatchState(patch, new Rect()), null);
    }

    public NinePatchDrawable(Resources res, NinePatch patch) {
        this(new NinePatchState(patch, new Rect()), res);
        this.mNinePatchState.mTargetDensity = this.mTargetDensity;
    }

    private void setNinePatchState(NinePatchState state, Resources res) {
        this.mNinePatchState = state;
        this.mNinePatch = state.mNinePatch;
        this.mPadding = state.mPadding;
        int n = this.mTargetDensity = res != null ? res.getDisplayMetrics().densityDpi : state.mTargetDensity;
        if (!state.mDither) {
            this.setDither(state.mDither);
        }
        if (this.mNinePatch != null) {
            this.computeBitmapSize();
        }
    }

    public void setTargetDensity(Canvas canvas) {
        this.setTargetDensity(canvas.getDensity());
    }

    public void setTargetDensity(DisplayMetrics metrics) {
        this.setTargetDensity(metrics.densityDpi);
    }

    public void setTargetDensity(int density) {
        if (density != this.mTargetDensity) {
            int n = this.mTargetDensity = density == 0 ? 160 : density;
            if (this.mNinePatch != null) {
                this.computeBitmapSize();
            }
            this.invalidateSelf();
        }
    }

    private void computeBitmapSize() {
        int tdensity;
        int sdensity = this.mNinePatch.getDensity();
        if (sdensity == (tdensity = this.mTargetDensity)) {
            this.mBitmapWidth = this.mNinePatch.getWidth();
            this.mBitmapHeight = this.mNinePatch.getHeight();
        } else {
            this.mBitmapWidth = Bitmap.scaleFromDensity(this.mNinePatch.getWidth(), sdensity, tdensity);
            this.mBitmapHeight = Bitmap.scaleFromDensity(this.mNinePatch.getHeight(), sdensity, tdensity);
            if (this.mNinePatchState.mPadding != null && this.mPadding != null) {
                Rect dest = this.mPadding;
                Rect src = this.mNinePatchState.mPadding;
                if (dest == src) {
                    this.mPadding = dest = new Rect(src);
                }
                dest.left = Bitmap.scaleFromDensity(src.left, sdensity, tdensity);
                dest.top = Bitmap.scaleFromDensity(src.top, sdensity, tdensity);
                dest.right = Bitmap.scaleFromDensity(src.right, sdensity, tdensity);
                dest.bottom = Bitmap.scaleFromDensity(src.bottom, sdensity, tdensity);
            }
        }
    }

    public void draw(Canvas canvas) {
        this.mNinePatch.draw(canvas, this.getBounds(), this.mPaint);
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mNinePatchState.mChangingConfigurations;
    }

    public boolean getPadding(Rect padding) {
        padding.set(this.mPadding);
        return true;
    }

    public void setAlpha(int alpha) {
        if (this.mPaint == null && alpha == 255) {
            return;
        }
        this.getPaint().setAlpha(alpha);
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter cf) {
        if (this.mPaint == null && cf == null) {
            return;
        }
        this.getPaint().setColorFilter(cf);
        this.invalidateSelf();
    }

    public void setDither(boolean dither) {
        if (this.mPaint == null && dither) {
            return;
        }
        this.getPaint().setDither(dither);
        this.invalidateSelf();
    }

    public void setFilterBitmap(boolean filter) {
        this.getPaint().setFilterBitmap(filter);
        this.invalidateSelf();
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs);
        TypedArray a = r.obtainAttributes(attrs, R.styleable.NinePatchDrawable);
        int id2 = a.getResourceId(0, 0);
        if (id2 == 0) {
            throw new XmlPullParserException(parser.getPositionDescription() + ": <nine-patch> requires a valid src attribute");
        }
        boolean dither = a.getBoolean(1, true);
        BitmapFactory.Options options = new BitmapFactory.Options();
        if (dither) {
            options.inDither = false;
        }
        options.inScreenDensity = DisplayMetrics.DENSITY_DEVICE;
        Rect padding = new Rect();
        Bitmap bitmap = null;
        try {
            TypedValue value = new TypedValue();
            InputStream is = r.openRawResource(id2, value);
            bitmap = BitmapFactory.decodeResourceStream(r, value, is, padding, options);
            is.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (bitmap == null) {
            throw new XmlPullParserException(parser.getPositionDescription() + ": <nine-patch> requires a valid src attribute");
        }
        if (bitmap.getNinePatchChunk() == null) {
            throw new XmlPullParserException(parser.getPositionDescription() + ": <nine-patch> requires a valid 9-patch source image");
        }
        this.setNinePatchState(new NinePatchState(new NinePatch(bitmap, bitmap.getNinePatchChunk(), "XML 9-patch"), padding, dither), r);
        this.mNinePatchState.mTargetDensity = this.mTargetDensity;
        a.recycle();
    }

    public Paint getPaint() {
        if (this.mPaint == null) {
            this.mPaint = new Paint();
            this.mPaint.setDither(true);
        }
        return this.mPaint;
    }

    public int getIntrinsicWidth() {
        return this.mBitmapWidth;
    }

    public int getIntrinsicHeight() {
        return this.mBitmapHeight;
    }

    public int getMinimumWidth() {
        return this.mBitmapWidth;
    }

    public int getMinimumHeight() {
        return this.mBitmapHeight;
    }

    public int getOpacity() {
        return this.mNinePatch.hasAlpha() || this.mPaint != null && this.mPaint.getAlpha() < 255 ? -3 : -1;
    }

    public Region getTransparentRegion() {
        return this.mNinePatch.getTransparentRegion(this.getBounds());
    }

    public Drawable.ConstantState getConstantState() {
        this.mNinePatchState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mNinePatchState;
    }

    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mNinePatchState = new NinePatchState(this.mNinePatchState);
            this.mNinePatch = this.mNinePatchState.mNinePatch;
            this.mMutated = true;
        }
        return this;
    }

    private NinePatchDrawable(NinePatchState state, Resources res) {
        this.setNinePatchState(state, res);
    }

    static final class NinePatchState
    extends Drawable.ConstantState {
        final NinePatch mNinePatch;
        final Rect mPadding;
        final boolean mDither;
        int mChangingConfigurations;
        int mTargetDensity = 160;

        NinePatchState(NinePatch ninePatch, Rect padding) {
            this(ninePatch, padding, true);
        }

        NinePatchState(NinePatch ninePatch, Rect rect, boolean dither) {
            this.mNinePatch = ninePatch;
            this.mPadding = rect;
            this.mDither = dither;
        }

        NinePatchState(NinePatchState state) {
            this.mNinePatch = new NinePatch(state.mNinePatch);
            this.mPadding = state.mPadding;
            this.mDither = state.mDither;
            this.mChangingConfigurations = state.mChangingConfigurations;
            this.mTargetDensity = state.mTargetDensity;
        }

        public Drawable newDrawable() {
            return new NinePatchDrawable(this, null);
        }

        public Drawable newDrawable(Resources res) {
            return new NinePatchDrawable(this, res);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }
    }
}

