/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class Camera {
    private static final String TAG = "Camera";
    private static final int CAMERA_MSG_ERROR = 1;
    private static final int CAMERA_MSG_SHUTTER = 2;
    private static final int CAMERA_MSG_FOCUS = 4;
    private static final int CAMERA_MSG_ZOOM = 8;
    private static final int CAMERA_MSG_PREVIEW_FRAME = 16;
    private static final int CAMERA_MSG_VIDEO_FRAME = 32;
    private static final int CAMERA_MSG_POSTVIEW_FRAME = 64;
    private static final int CAMERA_MSG_RAW_IMAGE = 128;
    private static final int CAMERA_MSG_COMPRESSED_IMAGE = 256;
    private static final int CAMERA_MSG_RAW_IMAGE_NOTIFY = 512;
    private static final int CAMERA_MSG_PREVIEW_METADATA = 1024;
    private static final int CAMERA_MSG_ALL_MSGS = 1279;
    private int mNativeContext;
    private EventHandler mEventHandler;
    private ShutterCallback mShutterCallback = null;
    private PictureCallback mRawImageCallback = null;
    private PictureCallback mJpegCallback = null;
    private PreviewCallback mPreviewCallback = null;
    private PictureCallback mPostviewCallback = null;
    private AutoFocusCallback mAutoFocusCallback;
    private OnZoomChangeListener mZoomListener = null;
    private FaceDetectionListener mFaceListener;
    private ErrorCallback mErrorCallback;
    private boolean mOneShot;
    private boolean mWithBuffer;
    private boolean mFaceDetectionRunning = false;
    public static final String ACTION_NEW_PICTURE = "android.hardware.action.NEW_PICTURE";
    public static final String ACTION_NEW_VIDEO = "android.hardware.action.NEW_VIDEO";
    private static final int CAMERA_FACE_DETECTION_HW = 0;
    private static final int CAMERA_FACE_DETECTION_SW = 1;
    public static final int CAMERA_ERROR_UNKNOWN = 1;
    public static final int CAMERA_ERROR_SERVER_DIED = 100;

    public static native int getNumberOfCameras();

    public static native void getCameraInfo(int var0, CameraInfo var1);

    public static Camera open(int cameraId) {
        return new Camera(cameraId);
    }

    public static Camera open() {
        int numberOfCameras = Camera.getNumberOfCameras();
        CameraInfo cameraInfo = new CameraInfo();
        for (int i = 0; i < numberOfCameras; ++i) {
            Camera.getCameraInfo(i, cameraInfo);
            if (cameraInfo.facing != 0) continue;
            return new Camera(i);
        }
        return null;
    }

    Camera(int cameraId) {
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.native_setup(new WeakReference<Camera>(this), cameraId);
    }

    protected void finalize() {
        this.release();
    }

    private final native void native_setup(Object var1, int var2);

    private final native void native_release();

    public final void release() {
        this.native_release();
        this.mFaceDetectionRunning = false;
    }

    public final native void unlock();

    public final native void lock();

    public final native void reconnect() throws IOException;

    public final void setPreviewDisplay(SurfaceHolder holder) throws IOException {
        if (holder != null) {
            this.setPreviewDisplay(holder.getSurface());
        } else {
            this.setPreviewDisplay((Surface)null);
        }
    }

    private final native void setPreviewDisplay(Surface var1) throws IOException;

    public final native void setPreviewTexture(SurfaceTexture var1) throws IOException;

    public final native void startPreview();

    public final void stopPreview() {
        this._stopPreview();
        this.mFaceDetectionRunning = false;
        this.mShutterCallback = null;
        this.mRawImageCallback = null;
        this.mPostviewCallback = null;
        this.mJpegCallback = null;
        this.mAutoFocusCallback = null;
    }

    private final native void _stopPreview();

    public final native boolean previewEnabled();

    public final void setPreviewCallback(PreviewCallback cb) {
        this.mPreviewCallback = cb;
        this.mOneShot = false;
        this.mWithBuffer = false;
        this.setHasPreviewCallback(cb != null, false);
    }

    public final void setOneShotPreviewCallback(PreviewCallback cb) {
        this.mPreviewCallback = cb;
        this.mOneShot = true;
        this.mWithBuffer = false;
        this.setHasPreviewCallback(cb != null, false);
    }

    private final native void setHasPreviewCallback(boolean var1, boolean var2);

    public final void setPreviewCallbackWithBuffer(PreviewCallback cb) {
        this.mPreviewCallback = cb;
        this.mOneShot = false;
        this.mWithBuffer = true;
        this.setHasPreviewCallback(cb != null, true);
    }

    public final void addCallbackBuffer(byte[] callbackBuffer) {
        this._addCallbackBuffer(callbackBuffer, 16);
    }

    public final void addRawImageCallbackBuffer(byte[] callbackBuffer) {
        this.addCallbackBuffer(callbackBuffer, 128);
    }

    private final void addCallbackBuffer(byte[] callbackBuffer, int msgType) {
        if (msgType != 16 && msgType != 128) {
            throw new IllegalArgumentException("Unsupported message type: " + msgType);
        }
        this._addCallbackBuffer(callbackBuffer, msgType);
    }

    private final native void _addCallbackBuffer(byte[] var1, int var2);

    private static void postEventFromNative(Object camera_ref, int what, int arg1, int arg2, Object obj) {
        Camera c = (Camera)((WeakReference)camera_ref).get();
        if (c == null) {
            return;
        }
        if (c.mEventHandler != null) {
            Message m = c.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            c.mEventHandler.sendMessage(m);
        }
    }

    public final void autoFocus(AutoFocusCallback cb) {
        this.mAutoFocusCallback = cb;
        this.native_autoFocus();
    }

    private final native void native_autoFocus();

    public final void cancelAutoFocus() {
        this.mAutoFocusCallback = null;
        this.native_cancelAutoFocus();
    }

    private final native void native_cancelAutoFocus();

    public final void takePicture(ShutterCallback shutter, PictureCallback raw2, PictureCallback jpeg) {
        this.takePicture(shutter, raw2, null, jpeg);
    }

    private final native void native_takePicture(int var1);

    public final void takePicture(ShutterCallback shutter, PictureCallback raw2, PictureCallback postview, PictureCallback jpeg) {
        this.mShutterCallback = shutter;
        this.mRawImageCallback = raw2;
        this.mPostviewCallback = postview;
        this.mJpegCallback = jpeg;
        int msgType = 0;
        if (this.mShutterCallback != null) {
            msgType |= 2;
        }
        if (this.mRawImageCallback != null) {
            msgType |= 0x80;
        }
        if (this.mPostviewCallback != null) {
            msgType |= 0x40;
        }
        if (this.mJpegCallback != null) {
            msgType |= 0x100;
        }
        this.native_takePicture(msgType);
    }

    public final native void startSmoothZoom(int var1);

    public final native void stopSmoothZoom();

    public final native void setDisplayOrientation(int var1);

    public final void setZoomChangeListener(OnZoomChangeListener listener) {
        this.mZoomListener = listener;
    }

    public final void setFaceDetectionListener(FaceDetectionListener listener) {
        this.mFaceListener = listener;
    }

    public final void startFaceDetection() {
        if (this.mFaceDetectionRunning) {
            throw new RuntimeException("Face detection is already running");
        }
        this._startFaceDetection(0);
        this.mFaceDetectionRunning = true;
    }

    public final void stopFaceDetection() {
        this._stopFaceDetection();
        this.mFaceDetectionRunning = false;
    }

    private final native void _startFaceDetection(int var1);

    private final native void _stopFaceDetection();

    public final void setErrorCallback(ErrorCallback cb) {
        this.mErrorCallback = cb;
    }

    private final native void native_setParameters(String var1);

    private final native String native_getParameters();

    public void setParameters(Parameters params) {
        this.native_setParameters(params.flatten());
    }

    public Parameters getParameters() {
        Parameters p = new Parameters();
        String s = this.native_getParameters();
        p.unflatten(s);
        return p;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Parameters {
        private static final String KEY_PREVIEW_SIZE = "preview-size";
        private static final String KEY_PREVIEW_FORMAT = "preview-format";
        private static final String KEY_PREVIEW_FRAME_RATE = "preview-frame-rate";
        private static final String KEY_PREVIEW_FPS_RANGE = "preview-fps-range";
        private static final String KEY_PICTURE_SIZE = "picture-size";
        private static final String KEY_PICTURE_FORMAT = "picture-format";
        private static final String KEY_JPEG_THUMBNAIL_SIZE = "jpeg-thumbnail-size";
        private static final String KEY_JPEG_THUMBNAIL_WIDTH = "jpeg-thumbnail-width";
        private static final String KEY_JPEG_THUMBNAIL_HEIGHT = "jpeg-thumbnail-height";
        private static final String KEY_JPEG_THUMBNAIL_QUALITY = "jpeg-thumbnail-quality";
        private static final String KEY_JPEG_QUALITY = "jpeg-quality";
        private static final String KEY_ROTATION = "rotation";
        private static final String KEY_GPS_LATITUDE = "gps-latitude";
        private static final String KEY_GPS_LONGITUDE = "gps-longitude";
        private static final String KEY_GPS_ALTITUDE = "gps-altitude";
        private static final String KEY_GPS_TIMESTAMP = "gps-timestamp";
        private static final String KEY_GPS_PROCESSING_METHOD = "gps-processing-method";
        private static final String KEY_WHITE_BALANCE = "whitebalance";
        private static final String KEY_EFFECT = "effect";
        private static final String KEY_ANTIBANDING = "antibanding";
        private static final String KEY_SCENE_MODE = "scene-mode";
        private static final String KEY_FLASH_MODE = "flash-mode";
        private static final String KEY_FOCUS_MODE = "focus-mode";
        private static final String KEY_FOCUS_AREAS = "focus-areas";
        private static final String KEY_MAX_NUM_FOCUS_AREAS = "max-num-focus-areas";
        private static final String KEY_FOCAL_LENGTH = "focal-length";
        private static final String KEY_HORIZONTAL_VIEW_ANGLE = "horizontal-view-angle";
        private static final String KEY_VERTICAL_VIEW_ANGLE = "vertical-view-angle";
        private static final String KEY_EXPOSURE_COMPENSATION = "exposure-compensation";
        private static final String KEY_MAX_EXPOSURE_COMPENSATION = "max-exposure-compensation";
        private static final String KEY_MIN_EXPOSURE_COMPENSATION = "min-exposure-compensation";
        private static final String KEY_EXPOSURE_COMPENSATION_STEP = "exposure-compensation-step";
        private static final String KEY_AUTO_EXPOSURE_LOCK = "auto-exposure-lock";
        private static final String KEY_AUTO_EXPOSURE_LOCK_SUPPORTED = "auto-exposure-lock-supported";
        private static final String KEY_AUTO_WHITEBALANCE_LOCK = "auto-whitebalance-lock";
        private static final String KEY_AUTO_WHITEBALANCE_LOCK_SUPPORTED = "auto-whitebalance-lock-supported";
        private static final String KEY_METERING_AREAS = "metering-areas";
        private static final String KEY_MAX_NUM_METERING_AREAS = "max-num-metering-areas";
        private static final String KEY_ZOOM = "zoom";
        private static final String KEY_MAX_ZOOM = "max-zoom";
        private static final String KEY_ZOOM_RATIOS = "zoom-ratios";
        private static final String KEY_ZOOM_SUPPORTED = "zoom-supported";
        private static final String KEY_SMOOTH_ZOOM_SUPPORTED = "smooth-zoom-supported";
        private static final String KEY_FOCUS_DISTANCES = "focus-distances";
        private static final String KEY_VIDEO_SIZE = "video-size";
        private static final String KEY_PREFERRED_PREVIEW_SIZE_FOR_VIDEO = "preferred-preview-size-for-video";
        private static final String KEY_MAX_NUM_DETECTED_FACES_HW = "max-num-detected-faces-hw";
        private static final String KEY_MAX_NUM_DETECTED_FACES_SW = "max-num-detected-faces-sw";
        private static final String KEY_RECORDING_HINT = "recording-hint";
        private static final String KEY_VIDEO_SNAPSHOT_SUPPORTED = "video-snapshot-supported";
        private static final String KEY_VIDEO_STABILIZATION = "video-stabilization";
        private static final String KEY_VIDEO_STABILIZATION_SUPPORTED = "video-stabilization-supported";
        private static final String SUPPORTED_VALUES_SUFFIX = "-values";
        private static final String TRUE = "true";
        private static final String FALSE = "false";
        public static final String WHITE_BALANCE_AUTO = "auto";
        public static final String WHITE_BALANCE_INCANDESCENT = "incandescent";
        public static final String WHITE_BALANCE_FLUORESCENT = "fluorescent";
        public static final String WHITE_BALANCE_WARM_FLUORESCENT = "warm-fluorescent";
        public static final String WHITE_BALANCE_DAYLIGHT = "daylight";
        public static final String WHITE_BALANCE_CLOUDY_DAYLIGHT = "cloudy-daylight";
        public static final String WHITE_BALANCE_TWILIGHT = "twilight";
        public static final String WHITE_BALANCE_SHADE = "shade";
        public static final String EFFECT_NONE = "none";
        public static final String EFFECT_MONO = "mono";
        public static final String EFFECT_NEGATIVE = "negative";
        public static final String EFFECT_SOLARIZE = "solarize";
        public static final String EFFECT_SEPIA = "sepia";
        public static final String EFFECT_POSTERIZE = "posterize";
        public static final String EFFECT_WHITEBOARD = "whiteboard";
        public static final String EFFECT_BLACKBOARD = "blackboard";
        public static final String EFFECT_AQUA = "aqua";
        public static final String ANTIBANDING_AUTO = "auto";
        public static final String ANTIBANDING_50HZ = "50hz";
        public static final String ANTIBANDING_60HZ = "60hz";
        public static final String ANTIBANDING_OFF = "off";
        public static final String FLASH_MODE_OFF = "off";
        public static final String FLASH_MODE_AUTO = "auto";
        public static final String FLASH_MODE_ON = "on";
        public static final String FLASH_MODE_RED_EYE = "red-eye";
        public static final String FLASH_MODE_TORCH = "torch";
        public static final String SCENE_MODE_AUTO = "auto";
        public static final String SCENE_MODE_ACTION = "action";
        public static final String SCENE_MODE_PORTRAIT = "portrait";
        public static final String SCENE_MODE_LANDSCAPE = "landscape";
        public static final String SCENE_MODE_NIGHT = "night";
        public static final String SCENE_MODE_NIGHT_PORTRAIT = "night-portrait";
        public static final String SCENE_MODE_THEATRE = "theatre";
        public static final String SCENE_MODE_BEACH = "beach";
        public static final String SCENE_MODE_SNOW = "snow";
        public static final String SCENE_MODE_SUNSET = "sunset";
        public static final String SCENE_MODE_STEADYPHOTO = "steadyphoto";
        public static final String SCENE_MODE_FIREWORKS = "fireworks";
        public static final String SCENE_MODE_SPORTS = "sports";
        public static final String SCENE_MODE_PARTY = "party";
        public static final String SCENE_MODE_CANDLELIGHT = "candlelight";
        public static final String SCENE_MODE_BARCODE = "barcode";
        public static final String FOCUS_MODE_AUTO = "auto";
        public static final String FOCUS_MODE_INFINITY = "infinity";
        public static final String FOCUS_MODE_MACRO = "macro";
        public static final String FOCUS_MODE_FIXED = "fixed";
        public static final String FOCUS_MODE_EDOF = "edof";
        public static final String FOCUS_MODE_CONTINUOUS_VIDEO = "continuous-video";
        public static final String FOCUS_MODE_CONTINUOUS_PICTURE = "continuous-picture";
        public static final int FOCUS_DISTANCE_NEAR_INDEX = 0;
        public static final int FOCUS_DISTANCE_OPTIMAL_INDEX = 1;
        public static final int FOCUS_DISTANCE_FAR_INDEX = 2;
        public static final int PREVIEW_FPS_MIN_INDEX = 0;
        public static final int PREVIEW_FPS_MAX_INDEX = 1;
        private static final String PIXEL_FORMAT_YUV422SP = "yuv422sp";
        private static final String PIXEL_FORMAT_YUV420SP = "yuv420sp";
        private static final String PIXEL_FORMAT_YUV422I = "yuv422i-yuyv";
        private static final String PIXEL_FORMAT_YUV420P = "yuv420p";
        private static final String PIXEL_FORMAT_RGB565 = "rgb565";
        private static final String PIXEL_FORMAT_JPEG = "jpeg";
        private static final String PIXEL_FORMAT_BAYER_RGGB = "bayer-rggb";
        private HashMap<String, String> mMap = new HashMap();

        private Parameters() {
        }

        public void dump() {
            Log.e(Camera.TAG, "dump: size=" + this.mMap.size());
            for (String k : this.mMap.keySet()) {
                Log.e(Camera.TAG, "dump: " + k + "=" + this.mMap.get(k));
            }
        }

        public String flatten() {
            StringBuilder flattened = new StringBuilder();
            for (String k : this.mMap.keySet()) {
                flattened.append(k);
                flattened.append("=");
                flattened.append(this.mMap.get(k));
                flattened.append(";");
            }
            flattened.deleteCharAt(flattened.length() - 1);
            return flattened.toString();
        }

        public void unflatten(String flattened) {
            this.mMap.clear();
            StringTokenizer tokenizer = new StringTokenizer(flattened, ";");
            while (tokenizer.hasMoreElements()) {
                String kv = tokenizer.nextToken();
                int pos = kv.indexOf(61);
                if (pos == -1) continue;
                String k = kv.substring(0, pos);
                String v = kv.substring(pos + 1);
                this.mMap.put(k, v);
            }
        }

        public void remove(String key) {
            this.mMap.remove(key);
        }

        public void set(String key, String value) {
            if (key.indexOf(61) != -1 || key.indexOf(59) != -1) {
                Log.e(Camera.TAG, "Key \"" + key + "\" contains invalid character (= or ;)");
                return;
            }
            if (value.indexOf(61) != -1 || value.indexOf(59) != -1) {
                Log.e(Camera.TAG, "Value \"" + value + "\" contains invalid character (= or ;)");
                return;
            }
            this.mMap.put(key, value);
        }

        public void set(String key, int value) {
            this.mMap.put(key, Integer.toString(value));
        }

        private void set(String key, List<Area> areas) {
            if (areas == null) {
                this.set(key, "(0,0,0,0,0)");
            } else {
                StringBuilder buffer = new StringBuilder();
                for (int i = 0; i < areas.size(); ++i) {
                    Area area = areas.get(i);
                    Rect rect = area.rect;
                    buffer.append('(');
                    buffer.append(rect.left);
                    buffer.append(',');
                    buffer.append(rect.top);
                    buffer.append(',');
                    buffer.append(rect.right);
                    buffer.append(',');
                    buffer.append(rect.bottom);
                    buffer.append(',');
                    buffer.append(area.weight);
                    buffer.append(')');
                    if (i == areas.size() - 1) continue;
                    buffer.append(',');
                }
                this.set(key, buffer.toString());
            }
        }

        public String get(String key) {
            return this.mMap.get(key);
        }

        public int getInt(String key) {
            return Integer.parseInt(this.mMap.get(key));
        }

        public void setPreviewSize(int width, int height) {
            String v = Integer.toString(width) + "x" + Integer.toString(height);
            this.set(KEY_PREVIEW_SIZE, v);
        }

        public Size getPreviewSize() {
            String pair = this.get(KEY_PREVIEW_SIZE);
            return this.strToSize(pair);
        }

        public List<Size> getSupportedPreviewSizes() {
            String str = this.get("preview-size-values");
            return this.splitSize(str);
        }

        public List<Size> getSupportedVideoSizes() {
            String str = this.get("video-size-values");
            return this.splitSize(str);
        }

        public Size getPreferredPreviewSizeForVideo() {
            String pair = this.get(KEY_PREFERRED_PREVIEW_SIZE_FOR_VIDEO);
            return this.strToSize(pair);
        }

        public void setJpegThumbnailSize(int width, int height) {
            this.set(KEY_JPEG_THUMBNAIL_WIDTH, width);
            this.set(KEY_JPEG_THUMBNAIL_HEIGHT, height);
        }

        public Size getJpegThumbnailSize() {
            return new Size(this.getInt(KEY_JPEG_THUMBNAIL_WIDTH), this.getInt(KEY_JPEG_THUMBNAIL_HEIGHT));
        }

        public List<Size> getSupportedJpegThumbnailSizes() {
            String str = this.get("jpeg-thumbnail-size-values");
            return this.splitSize(str);
        }

        public void setJpegThumbnailQuality(int quality) {
            this.set(KEY_JPEG_THUMBNAIL_QUALITY, quality);
        }

        public int getJpegThumbnailQuality() {
            return this.getInt(KEY_JPEG_THUMBNAIL_QUALITY);
        }

        public void setJpegQuality(int quality) {
            this.set(KEY_JPEG_QUALITY, quality);
        }

        public int getJpegQuality() {
            return this.getInt(KEY_JPEG_QUALITY);
        }

        @Deprecated
        public void setPreviewFrameRate(int fps) {
            this.set(KEY_PREVIEW_FRAME_RATE, fps);
        }

        @Deprecated
        public int getPreviewFrameRate() {
            return this.getInt(KEY_PREVIEW_FRAME_RATE);
        }

        @Deprecated
        public List<Integer> getSupportedPreviewFrameRates() {
            String str = this.get("preview-frame-rate-values");
            return this.splitInt(str);
        }

        public void setPreviewFpsRange(int min, int max) {
            this.set(KEY_PREVIEW_FPS_RANGE, "" + min + "," + max);
        }

        public void getPreviewFpsRange(int[] range) {
            if (range == null || range.length != 2) {
                throw new IllegalArgumentException("range must be an array with two elements.");
            }
            this.splitInt(this.get(KEY_PREVIEW_FPS_RANGE), range);
        }

        public List<int[]> getSupportedPreviewFpsRange() {
            String str = this.get("preview-fps-range-values");
            return this.splitRange(str);
        }

        public void setPreviewFormat(int pixel_format) {
            String s = this.cameraFormatForPixelFormat(pixel_format);
            if (s == null) {
                throw new IllegalArgumentException("Invalid pixel_format=" + pixel_format);
            }
            this.set(KEY_PREVIEW_FORMAT, s);
        }

        public int getPreviewFormat() {
            return this.pixelFormatForCameraFormat(this.get(KEY_PREVIEW_FORMAT));
        }

        public List<Integer> getSupportedPreviewFormats() {
            String str = this.get("preview-format-values");
            ArrayList<Integer> formats = new ArrayList<Integer>();
            for (String s : this.split(str)) {
                int f = this.pixelFormatForCameraFormat(s);
                if (f == 0) continue;
                formats.add(f);
            }
            return formats;
        }

        public void setPictureSize(int width, int height) {
            String v = Integer.toString(width) + "x" + Integer.toString(height);
            this.set(KEY_PICTURE_SIZE, v);
        }

        public Size getPictureSize() {
            String pair = this.get(KEY_PICTURE_SIZE);
            return this.strToSize(pair);
        }

        public List<Size> getSupportedPictureSizes() {
            String str = this.get("picture-size-values");
            return this.splitSize(str);
        }

        public void setPictureFormat(int pixel_format) {
            String s = this.cameraFormatForPixelFormat(pixel_format);
            if (s == null) {
                throw new IllegalArgumentException("Invalid pixel_format=" + pixel_format);
            }
            this.set(KEY_PICTURE_FORMAT, s);
        }

        public int getPictureFormat() {
            return this.pixelFormatForCameraFormat(this.get(KEY_PICTURE_FORMAT));
        }

        public List<Integer> getSupportedPictureFormats() {
            String str = this.get("picture-format-values");
            ArrayList<Integer> formats = new ArrayList<Integer>();
            for (String s : this.split(str)) {
                int f = this.pixelFormatForCameraFormat(s);
                if (f == 0) continue;
                formats.add(f);
            }
            return formats;
        }

        private String cameraFormatForPixelFormat(int pixel_format) {
            switch (pixel_format) {
                case 16: {
                    return PIXEL_FORMAT_YUV422SP;
                }
                case 17: {
                    return PIXEL_FORMAT_YUV420SP;
                }
                case 20: {
                    return PIXEL_FORMAT_YUV422I;
                }
                case 842094169: {
                    return PIXEL_FORMAT_YUV420P;
                }
                case 4: {
                    return PIXEL_FORMAT_RGB565;
                }
                case 256: {
                    return PIXEL_FORMAT_JPEG;
                }
                case 512: {
                    return PIXEL_FORMAT_BAYER_RGGB;
                }
            }
            return null;
        }

        private int pixelFormatForCameraFormat(String format) {
            if (format == null) {
                return 0;
            }
            if (format.equals(PIXEL_FORMAT_YUV422SP)) {
                return 16;
            }
            if (format.equals(PIXEL_FORMAT_YUV420SP)) {
                return 17;
            }
            if (format.equals(PIXEL_FORMAT_YUV422I)) {
                return 20;
            }
            if (format.equals(PIXEL_FORMAT_YUV420P)) {
                return 842094169;
            }
            if (format.equals(PIXEL_FORMAT_RGB565)) {
                return 4;
            }
            if (format.equals(PIXEL_FORMAT_JPEG)) {
                return 256;
            }
            return 0;
        }

        public void setRotation(int rotation) {
            if (rotation != 0 && rotation != 90 && rotation != 180 && rotation != 270) {
                throw new IllegalArgumentException("Invalid rotation=" + rotation);
            }
            this.set(KEY_ROTATION, Integer.toString(rotation));
        }

        public void setGpsLatitude(double latitude) {
            this.set(KEY_GPS_LATITUDE, Double.toString(latitude));
        }

        public void setGpsLongitude(double longitude) {
            this.set(KEY_GPS_LONGITUDE, Double.toString(longitude));
        }

        public void setGpsAltitude(double altitude) {
            this.set(KEY_GPS_ALTITUDE, Double.toString(altitude));
        }

        public void setGpsTimestamp(long timestamp) {
            this.set(KEY_GPS_TIMESTAMP, Long.toString(timestamp));
        }

        public void setGpsProcessingMethod(String processing_method) {
            this.set(KEY_GPS_PROCESSING_METHOD, processing_method);
        }

        public void removeGpsData() {
            this.remove(KEY_GPS_LATITUDE);
            this.remove(KEY_GPS_LONGITUDE);
            this.remove(KEY_GPS_ALTITUDE);
            this.remove(KEY_GPS_TIMESTAMP);
            this.remove(KEY_GPS_PROCESSING_METHOD);
        }

        public String getWhiteBalance() {
            return this.get(KEY_WHITE_BALANCE);
        }

        public void setWhiteBalance(String value) {
            String oldValue = this.get(KEY_WHITE_BALANCE);
            if (this.same(value, oldValue)) {
                return;
            }
            this.set(KEY_WHITE_BALANCE, value);
            this.set(KEY_AUTO_WHITEBALANCE_LOCK, FALSE);
        }

        public List<String> getSupportedWhiteBalance() {
            String str = this.get("whitebalance-values");
            return this.split(str);
        }

        public String getColorEffect() {
            return this.get(KEY_EFFECT);
        }

        public void setColorEffect(String value) {
            this.set(KEY_EFFECT, value);
        }

        public List<String> getSupportedColorEffects() {
            String str = this.get("effect-values");
            return this.split(str);
        }

        public String getAntibanding() {
            return this.get(KEY_ANTIBANDING);
        }

        public void setAntibanding(String antibanding) {
            this.set(KEY_ANTIBANDING, antibanding);
        }

        public List<String> getSupportedAntibanding() {
            String str = this.get("antibanding-values");
            return this.split(str);
        }

        public String getSceneMode() {
            return this.get(KEY_SCENE_MODE);
        }

        public void setSceneMode(String value) {
            this.set(KEY_SCENE_MODE, value);
        }

        public List<String> getSupportedSceneModes() {
            String str = this.get("scene-mode-values");
            return this.split(str);
        }

        public String getFlashMode() {
            return this.get(KEY_FLASH_MODE);
        }

        public void setFlashMode(String value) {
            this.set(KEY_FLASH_MODE, value);
        }

        public List<String> getSupportedFlashModes() {
            String str = this.get("flash-mode-values");
            return this.split(str);
        }

        public String getFocusMode() {
            return this.get(KEY_FOCUS_MODE);
        }

        public void setFocusMode(String value) {
            this.set(KEY_FOCUS_MODE, value);
        }

        public List<String> getSupportedFocusModes() {
            String str = this.get("focus-mode-values");
            return this.split(str);
        }

        public float getFocalLength() {
            return Float.parseFloat(this.get(KEY_FOCAL_LENGTH));
        }

        public float getHorizontalViewAngle() {
            return Float.parseFloat(this.get(KEY_HORIZONTAL_VIEW_ANGLE));
        }

        public float getVerticalViewAngle() {
            return Float.parseFloat(this.get(KEY_VERTICAL_VIEW_ANGLE));
        }

        public int getExposureCompensation() {
            return this.getInt(KEY_EXPOSURE_COMPENSATION, 0);
        }

        public void setExposureCompensation(int value) {
            this.set(KEY_EXPOSURE_COMPENSATION, value);
        }

        public int getMaxExposureCompensation() {
            return this.getInt(KEY_MAX_EXPOSURE_COMPENSATION, 0);
        }

        public int getMinExposureCompensation() {
            return this.getInt(KEY_MIN_EXPOSURE_COMPENSATION, 0);
        }

        public float getExposureCompensationStep() {
            return this.getFloat(KEY_EXPOSURE_COMPENSATION_STEP, 0.0f);
        }

        public void setAutoExposureLock(boolean toggle) {
            this.set(KEY_AUTO_EXPOSURE_LOCK, toggle ? TRUE : FALSE);
        }

        public boolean getAutoExposureLock() {
            String str = this.get(KEY_AUTO_EXPOSURE_LOCK);
            return TRUE.equals(str);
        }

        public boolean isAutoExposureLockSupported() {
            String str = this.get(KEY_AUTO_EXPOSURE_LOCK_SUPPORTED);
            return TRUE.equals(str);
        }

        public void setAutoWhiteBalanceLock(boolean toggle) {
            this.set(KEY_AUTO_WHITEBALANCE_LOCK, toggle ? TRUE : FALSE);
        }

        public boolean getAutoWhiteBalanceLock() {
            String str = this.get(KEY_AUTO_WHITEBALANCE_LOCK);
            return TRUE.equals(str);
        }

        public boolean isAutoWhiteBalanceLockSupported() {
            String str = this.get(KEY_AUTO_WHITEBALANCE_LOCK_SUPPORTED);
            return TRUE.equals(str);
        }

        public int getZoom() {
            return this.getInt(KEY_ZOOM, 0);
        }

        public void setZoom(int value) {
            this.set(KEY_ZOOM, value);
        }

        public boolean isZoomSupported() {
            String str = this.get(KEY_ZOOM_SUPPORTED);
            return TRUE.equals(str);
        }

        public int getMaxZoom() {
            return this.getInt(KEY_MAX_ZOOM, 0);
        }

        public List<Integer> getZoomRatios() {
            return this.splitInt(this.get(KEY_ZOOM_RATIOS));
        }

        public boolean isSmoothZoomSupported() {
            String str = this.get(KEY_SMOOTH_ZOOM_SUPPORTED);
            return TRUE.equals(str);
        }

        public void getFocusDistances(float[] output) {
            if (output == null || output.length != 3) {
                throw new IllegalArgumentException("output must be an float array with three elements.");
            }
            this.splitFloat(this.get(KEY_FOCUS_DISTANCES), output);
        }

        public int getMaxNumFocusAreas() {
            return this.getInt(KEY_MAX_NUM_FOCUS_AREAS, 0);
        }

        public List<Area> getFocusAreas() {
            return this.splitArea(this.get(KEY_FOCUS_AREAS));
        }

        public void setFocusAreas(List<Area> focusAreas) {
            this.set(KEY_FOCUS_AREAS, focusAreas);
        }

        public int getMaxNumMeteringAreas() {
            return this.getInt(KEY_MAX_NUM_METERING_AREAS, 0);
        }

        public List<Area> getMeteringAreas() {
            return this.splitArea(this.get(KEY_METERING_AREAS));
        }

        public void setMeteringAreas(List<Area> meteringAreas) {
            this.set(KEY_METERING_AREAS, meteringAreas);
        }

        public int getMaxNumDetectedFaces() {
            return this.getInt(KEY_MAX_NUM_DETECTED_FACES_HW, 0);
        }

        public void setRecordingHint(boolean hint) {
            this.set(KEY_RECORDING_HINT, hint ? TRUE : FALSE);
        }

        public boolean isVideoSnapshotSupported() {
            String str = this.get(KEY_VIDEO_SNAPSHOT_SUPPORTED);
            return TRUE.equals(str);
        }

        public void setVideoStabilization(boolean toggle) {
            this.set(KEY_VIDEO_STABILIZATION, toggle ? TRUE : FALSE);
        }

        public boolean getVideoStabilization() {
            String str = this.get(KEY_VIDEO_STABILIZATION);
            return TRUE.equals(str);
        }

        public boolean isVideoStabilizationSupported() {
            String str = this.get(KEY_VIDEO_STABILIZATION_SUPPORTED);
            return TRUE.equals(str);
        }

        private ArrayList<String> split(String str) {
            if (str == null) {
                return null;
            }
            StringTokenizer tokenizer = new StringTokenizer(str, ",");
            ArrayList<String> substrings = new ArrayList<String>();
            while (tokenizer.hasMoreElements()) {
                substrings.add(tokenizer.nextToken());
            }
            return substrings;
        }

        private ArrayList<Integer> splitInt(String str) {
            if (str == null) {
                return null;
            }
            StringTokenizer tokenizer = new StringTokenizer(str, ",");
            ArrayList<Integer> substrings = new ArrayList<Integer>();
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                substrings.add(Integer.parseInt(token));
            }
            if (substrings.size() == 0) {
                return null;
            }
            return substrings;
        }

        private void splitInt(String str, int[] output) {
            if (str == null) {
                return;
            }
            StringTokenizer tokenizer = new StringTokenizer(str, ",");
            int index = 0;
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                output[index++] = Integer.parseInt(token);
            }
        }

        private void splitFloat(String str, float[] output) {
            if (str == null) {
                return;
            }
            StringTokenizer tokenizer = new StringTokenizer(str, ",");
            int index = 0;
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                output[index++] = Float.parseFloat(token);
            }
        }

        private float getFloat(String key, float defaultValue) {
            try {
                return Float.parseFloat(this.mMap.get(key));
            }
            catch (NumberFormatException ex) {
                return defaultValue;
            }
        }

        private int getInt(String key, int defaultValue) {
            try {
                return Integer.parseInt(this.mMap.get(key));
            }
            catch (NumberFormatException ex) {
                return defaultValue;
            }
        }

        private ArrayList<Size> splitSize(String str) {
            if (str == null) {
                return null;
            }
            StringTokenizer tokenizer = new StringTokenizer(str, ",");
            ArrayList<Size> sizeList = new ArrayList<Size>();
            while (tokenizer.hasMoreElements()) {
                Size size = this.strToSize(tokenizer.nextToken());
                if (size == null) continue;
                sizeList.add(size);
            }
            if (sizeList.size() == 0) {
                return null;
            }
            return sizeList;
        }

        private Size strToSize(String str) {
            if (str == null) {
                return null;
            }
            int pos = str.indexOf(120);
            if (pos != -1) {
                String width = str.substring(0, pos);
                String height = str.substring(pos + 1);
                return new Size(Integer.parseInt(width), Integer.parseInt(height));
            }
            Log.e(Camera.TAG, "Invalid size parameter string=" + str);
            return null;
        }

        private ArrayList<int[]> splitRange(String str) {
            int endIndex;
            if (str == null || str.charAt(0) != '(' || str.charAt(str.length() - 1) != ')') {
                Log.e(Camera.TAG, "Invalid range list string=" + str);
                return null;
            }
            ArrayList<int[]> rangeList = new ArrayList<int[]>();
            int fromIndex = 1;
            do {
                int[] range = new int[2];
                endIndex = str.indexOf("),(", fromIndex);
                if (endIndex == -1) {
                    endIndex = str.length() - 1;
                }
                this.splitInt(str.substring(fromIndex, endIndex), range);
                rangeList.add(range);
                fromIndex = endIndex + 3;
            } while (endIndex != str.length() - 1);
            if (rangeList.size() == 0) {
                return null;
            }
            return rangeList;
        }

        private ArrayList<Area> splitArea(String str) {
            int endIndex;
            if (str == null || str.charAt(0) != '(' || str.charAt(str.length() - 1) != ')') {
                Log.e(Camera.TAG, "Invalid area string=" + str);
                return null;
            }
            ArrayList<Area> result = new ArrayList<Area>();
            int fromIndex = 1;
            int[] array2 = new int[5];
            do {
                if ((endIndex = str.indexOf("),(", fromIndex)) == -1) {
                    endIndex = str.length() - 1;
                }
                this.splitInt(str.substring(fromIndex, endIndex), array2);
                Rect rect = new Rect(array2[0], array2[1], array2[2], array2[3]);
                result.add(new Area(rect, array2[4]));
                fromIndex = endIndex + 3;
            } while (endIndex != str.length() - 1);
            if (result.size() == 0) {
                return null;
            }
            if (result.size() == 1) {
                Area area = result.get(0);
                Rect rect = area.rect;
                if (rect.left == 0 && rect.top == 0 && rect.right == 0 && rect.bottom == 0 && area.weight == 0) {
                    return null;
                }
            }
            return result;
        }

        private boolean same(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return true;
            }
            return s1 != null && s1.equals(s2);
        }
    }

    public static class Area {
        public Rect rect;
        public int weight;

        public Area(Rect rect, int weight) {
            this.rect = rect;
            this.weight = weight;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Area)) {
                return false;
            }
            Area a = (Area)obj;
            if (this.rect == null ? a.rect != null : !this.rect.equals(a.rect)) {
                return false;
            }
            return this.weight == a.weight;
        }
    }

    public class Size {
        public int width;
        public int height;

        public Size(int w, int h) {
            this.width = w;
            this.height = h;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Size)) {
                return false;
            }
            Size s = (Size)obj;
            return this.width == s.width && this.height == s.height;
        }

        public int hashCode() {
            return this.width * 32713 + this.height;
        }
    }

    public static interface ErrorCallback {
        public void onError(int var1, Camera var2);
    }

    public static class Face {
        public Rect rect;
        public int score;
        public int id = -1;
        public Point leftEye = null;
        public Point rightEye = null;
        public Point mouth = null;
    }

    public static interface FaceDetectionListener {
        public void onFaceDetection(Face[] var1, Camera var2);
    }

    public static interface OnZoomChangeListener {
        public void onZoomChange(int var1, boolean var2, Camera var3);
    }

    public static interface PictureCallback {
        public void onPictureTaken(byte[] var1, Camera var2);
    }

    public static interface ShutterCallback {
        public void onShutter();
    }

    public static interface AutoFocusCallback {
        public void onAutoFocus(boolean var1, Camera var2);
    }

    private class EventHandler
    extends Handler {
        private Camera mCamera;

        public EventHandler(Camera c, Looper looper) {
            super(looper);
            this.mCamera = c;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    if (Camera.this.mShutterCallback != null) {
                        Camera.this.mShutterCallback.onShutter();
                    }
                    return;
                }
                case 128: {
                    if (Camera.this.mRawImageCallback != null) {
                        Camera.this.mRawImageCallback.onPictureTaken((byte[])msg.obj, this.mCamera);
                    }
                    return;
                }
                case 256: {
                    if (Camera.this.mJpegCallback != null) {
                        Camera.this.mJpegCallback.onPictureTaken((byte[])msg.obj, this.mCamera);
                    }
                    return;
                }
                case 16: {
                    if (Camera.this.mPreviewCallback != null) {
                        PreviewCallback cb = Camera.this.mPreviewCallback;
                        if (Camera.this.mOneShot) {
                            Camera.this.mPreviewCallback = null;
                        } else if (!Camera.this.mWithBuffer) {
                            Camera.this.setHasPreviewCallback(true, false);
                        }
                        cb.onPreviewFrame((byte[])msg.obj, this.mCamera);
                    }
                    return;
                }
                case 64: {
                    if (Camera.this.mPostviewCallback != null) {
                        Camera.this.mPostviewCallback.onPictureTaken((byte[])msg.obj, this.mCamera);
                    }
                    return;
                }
                case 4: {
                    if (Camera.this.mAutoFocusCallback != null) {
                        Camera.this.mAutoFocusCallback.onAutoFocus(msg.arg1 != 0, this.mCamera);
                    }
                    return;
                }
                case 8: {
                    if (Camera.this.mZoomListener != null) {
                        Camera.this.mZoomListener.onZoomChange(msg.arg1, msg.arg2 != 0, this.mCamera);
                    }
                    return;
                }
                case 1024: {
                    if (Camera.this.mFaceListener != null) {
                        Camera.this.mFaceListener.onFaceDetection((Face[])msg.obj, this.mCamera);
                    }
                    return;
                }
                case 1: {
                    Log.e(Camera.TAG, "Error " + msg.arg1);
                    if (Camera.this.mErrorCallback != null) {
                        Camera.this.mErrorCallback.onError(msg.arg1, this.mCamera);
                    }
                    return;
                }
            }
            Log.e(Camera.TAG, "Unknown message type " + msg.what);
        }
    }

    public static interface PreviewCallback {
        public void onPreviewFrame(byte[] var1, Camera var2);
    }

    public static class CameraInfo {
        public static final int CAMERA_FACING_BACK = 0;
        public static final int CAMERA_FACING_FRONT = 1;
        public int facing;
        public int orientation;
    }
}

