/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.media.MediaPlayer;
import android.os.SystemProperties;
import android.util.Log;
import java.io.IOException;

public class CameraSound {
    private static final String TAG = "CameraSound";
    public static final int SHUTTER_CLICK = 0;
    public static final int FOCUS_COMPLETE = 1;
    public static final int START_VIDEO_RECORDING = 2;
    public static final int STOP_VIDEO_RECORDING = 3;
    private static final int NUM_SOUNDS = 4;
    private CameraSoundPlayer[] mCameraSoundPlayers;

    public void playSound(int soundId) {
        if (this.mCameraSoundPlayers == null) {
            this.mCameraSoundPlayers = new CameraSoundPlayer[4];
        }
        if (this.mCameraSoundPlayers[soundId] == null) {
            this.mCameraSoundPlayers[soundId] = new CameraSoundPlayer(soundId);
        }
        this.mCameraSoundPlayers[soundId].play();
    }

    public void release() {
        if (this.mCameraSoundPlayers != null) {
            for (CameraSoundPlayer csp : this.mCameraSoundPlayers) {
                if (csp == null) continue;
                csp.release();
            }
            this.mCameraSoundPlayers = null;
        }
    }

    private static class CameraSoundPlayer
    implements Runnable {
        private int mSoundId;
        private int mAudioStreamType;
        private MediaPlayer mPlayer;
        private Thread mThread;
        private boolean mExit;
        private int mPlayCount;
        private static final String mShutterSound = "/system/media/audio/ui/camera_click.ogg";
        private static final String mFocusSound = "/system/media/audio/ui/camera_focus.ogg";
        private static final String mVideoStartSound = "/system/media/audio/ui/VideoRecord.ogg";
        private static final String mVideoStopSound = "/system/media/audio/ui/VideoRecord.ogg";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String soundFilePath;
            switch (this.mSoundId) {
                case 0: {
                    soundFilePath = mShutterSound;
                    break;
                }
                case 1: {
                    soundFilePath = mFocusSound;
                    break;
                }
                case 2: {
                    soundFilePath = "/system/media/audio/ui/VideoRecord.ogg";
                    break;
                }
                case 3: {
                    soundFilePath = "/system/media/audio/ui/VideoRecord.ogg";
                    break;
                }
                default: {
                    Log.e(CameraSound.TAG, "Unknown sound " + this.mSoundId + " requested.");
                    return;
                }
            }
            this.mPlayer = new MediaPlayer();
            try {
                this.mPlayer.setAudioStreamType(this.mAudioStreamType);
                this.mPlayer.setDataSource(soundFilePath);
                this.mPlayer.setLooping(false);
                this.mPlayer.prepare();
            }
            catch (IOException e) {
                Log.e(CameraSound.TAG, "Error setting up sound " + this.mSoundId, e);
                return;
            }
            while (true) {
                try {
                    while (true) {
                        CameraSoundPlayer e = this;
                        synchronized (e) {
                            while (true) {
                                if (this.mExit) {
                                    return;
                                }
                                if (this.mPlayCount > 0) break;
                                this.wait();
                            }
                            --this.mPlayCount;
                        }
                        this.mPlayer.start();
                    }
                }
                catch (Exception e) {
                    Log.e(CameraSound.TAG, "Error playing sound " + this.mSoundId, e);
                    continue;
                }
                break;
            }
        }

        public CameraSoundPlayer(int soundId) {
            this.mSoundId = soundId;
            this.mAudioStreamType = SystemProperties.get("ro.camera.sound.forced", "0").equals("0") ? 3 : 7;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void play() {
            if (this.mThread == null) {
                this.mThread = new Thread(this);
                this.mThread.start();
            }
            CameraSoundPlayer cameraSoundPlayer = this;
            synchronized (cameraSoundPlayer) {
                ++this.mPlayCount;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            if (this.mThread != null) {
                CameraSoundPlayer cameraSoundPlayer = this;
                synchronized (cameraSoundPlayer) {
                    this.mExit = true;
                    this.notifyAll();
                }
                try {
                    this.mThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.mThread = null;
            }
            if (this.mPlayer != null) {
                this.mPlayer.release();
                this.mPlayer = null;
            }
        }

        protected void finalize() {
            this.release();
        }
    }
}

