/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.util.Log;
import java.nio.ByteBuffer;

public class UsbRequest {
    private static final String TAG = "UsbRequest";
    private int mNativeContext;
    private UsbEndpoint mEndpoint;
    private ByteBuffer mBuffer;
    private int mLength;
    private Object mClientData;

    public boolean initialize(UsbDeviceConnection connection, UsbEndpoint endpoint) {
        this.mEndpoint = endpoint;
        return this.native_init(connection, endpoint.getAddress(), endpoint.getAttributes(), endpoint.getMaxPacketSize(), endpoint.getInterval());
    }

    public void close() {
        this.mEndpoint = null;
        this.native_close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.mEndpoint != null) {
                Log.v(TAG, "endpoint still open in finalize(): " + this);
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public UsbEndpoint getEndpoint() {
        return this.mEndpoint;
    }

    public Object getClientData() {
        return this.mClientData;
    }

    public void setClientData(Object data) {
        this.mClientData = data;
    }

    public boolean queue(ByteBuffer buffer, int length) {
        boolean result;
        boolean out;
        boolean bl = out = this.mEndpoint.getDirection() == 0;
        if (buffer.isDirect()) {
            result = this.native_queue_direct(buffer, length, out);
        } else if (buffer.hasArray()) {
            result = this.native_queue_array(buffer.array(), length, out);
        } else {
            throw new IllegalArgumentException("buffer is not direct and has no array");
        }
        if (result) {
            this.mBuffer = buffer;
            this.mLength = length;
        }
        return result;
    }

    void dequeue() {
        boolean out;
        boolean bl = out = this.mEndpoint.getDirection() == 0;
        if (this.mBuffer.isDirect()) {
            this.native_dequeue_direct();
        } else {
            this.native_dequeue_array(this.mBuffer.array(), this.mLength, out);
        }
        this.mBuffer = null;
        this.mLength = 0;
    }

    public boolean cancel() {
        return this.native_cancel();
    }

    private native boolean native_init(UsbDeviceConnection var1, int var2, int var3, int var4, int var5);

    private native void native_close();

    private native boolean native_queue_array(byte[] var1, int var2, boolean var3);

    private native void native_dequeue_array(byte[] var1, int var2, boolean var3);

    private native boolean native_queue_direct(ByteBuffer var1, int var2, boolean var3);

    private native void native_dequeue_direct();

    private native boolean native_cancel();
}

