/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.app.PendingIntent;
import android.location.Criteria;
import android.location.GpsStatus;
import android.location.IGpsStatusListener;
import android.location.ILocationListener;
import android.location.ILocationManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationProvider;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.location.DummyLocationProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationManager {
    private static final String TAG = "LocationManager";
    private ILocationManager mService;
    private final HashMap<GpsStatus.Listener, GpsStatusListenerTransport> mGpsStatusListeners = new HashMap();
    private final HashMap<GpsStatus.NmeaListener, GpsStatusListenerTransport> mNmeaListeners = new HashMap();
    private final GpsStatus mGpsStatus = new GpsStatus();
    public static final String NETWORK_PROVIDER = "network";
    public static final String GPS_PROVIDER = "gps";
    public static final String PASSIVE_PROVIDER = "passive";
    public static final String KEY_PROXIMITY_ENTERING = "entering";
    public static final String KEY_STATUS_CHANGED = "status";
    public static final String KEY_PROVIDER_ENABLED = "providerEnabled";
    public static final String KEY_LOCATION_CHANGED = "location";
    public static final String GPS_ENABLED_CHANGE_ACTION = "android.location.GPS_ENABLED_CHANGE";
    public static final String PROVIDERS_CHANGED_ACTION = "android.location.PROVIDERS_CHANGED";
    public static final String GPS_FIX_CHANGE_ACTION = "android.location.GPS_FIX_CHANGE";
    public static final String EXTRA_GPS_ENABLED = "enabled";
    private HashMap<LocationListener, ListenerTransport> mListeners = new HashMap();

    public LocationManager(ILocationManager service) {
        this.mService = service;
    }

    private LocationProvider createProvider(String name, Bundle info) {
        DummyLocationProvider provider = new DummyLocationProvider(name, this.mService);
        provider.setRequiresNetwork(info.getBoolean(NETWORK_PROVIDER));
        provider.setRequiresSatellite(info.getBoolean("satellite"));
        provider.setRequiresCell(info.getBoolean("cell"));
        provider.setHasMonetaryCost(info.getBoolean("cost"));
        provider.setSupportsAltitude(info.getBoolean("altitude"));
        provider.setSupportsSpeed(info.getBoolean("speed"));
        provider.setSupportsBearing(info.getBoolean("bearing"));
        provider.setPowerRequirement(info.getInt("power"));
        provider.setAccuracy(info.getInt("accuracy"));
        return provider;
    }

    public List<String> getAllProviders() {
        try {
            return this.mService.getAllProviders();
        }
        catch (RemoteException ex) {
            Log.e(TAG, "getAllProviders: RemoteException", ex);
            return null;
        }
    }

    public List<String> getProviders(boolean enabledOnly) {
        try {
            return this.mService.getProviders(null, enabledOnly);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "getProviders: RemoteException", ex);
            return null;
        }
    }

    public LocationProvider getProvider(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        try {
            Bundle info = this.mService.getProviderInfo(name);
            if (info == null) {
                return null;
            }
            return this.createProvider(name, info);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "getProvider: RemoteException", ex);
            return null;
        }
    }

    public List<String> getProviders(Criteria criteria, boolean enabledOnly) {
        if (criteria == null) {
            throw new IllegalArgumentException("criteria==null");
        }
        try {
            return this.mService.getProviders(criteria, enabledOnly);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "getProviders: RemoteException", ex);
            return null;
        }
    }

    public String getBestProvider(Criteria criteria, boolean enabledOnly) {
        if (criteria == null) {
            throw new IllegalArgumentException("criteria==null");
        }
        try {
            return this.mService.getBestProvider(criteria, enabledOnly);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "getBestProvider: RemoteException", ex);
            return null;
        }
    }

    public void requestLocationUpdates(String provider, long minTime, float minDistance, LocationListener listener) {
        if (provider == null) {
            throw new IllegalArgumentException("provider==null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        this._requestLocationUpdates(provider, null, minTime, minDistance, false, listener, null);
    }

    public void requestLocationUpdates(String provider, long minTime, float minDistance, LocationListener listener, Looper looper) {
        if (provider == null) {
            throw new IllegalArgumentException("provider==null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        this._requestLocationUpdates(provider, null, minTime, minDistance, false, listener, looper);
    }

    public void requestLocationUpdates(long minTime, float minDistance, Criteria criteria, LocationListener listener, Looper looper) {
        if (criteria == null) {
            throw new IllegalArgumentException("criteria==null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        this._requestLocationUpdates(null, criteria, minTime, minDistance, false, listener, looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _requestLocationUpdates(String provider, Criteria criteria, long minTime, float minDistance, boolean singleShot, LocationListener listener, Looper looper) {
        if (minTime < 0L) {
            minTime = 0L;
        }
        if (minDistance < 0.0f) {
            minDistance = 0.0f;
        }
        try {
            HashMap<LocationListener, ListenerTransport> hashMap = this.mListeners;
            synchronized (hashMap) {
                ListenerTransport transport = this.mListeners.get(listener);
                if (transport == null) {
                    transport = new ListenerTransport(listener, looper);
                }
                this.mListeners.put(listener, transport);
                this.mService.requestLocationUpdates(provider, criteria, minTime, minDistance, singleShot, transport);
            }
        }
        catch (RemoteException ex) {
            Log.e(TAG, "requestLocationUpdates: DeadObjectException", ex);
        }
    }

    public void requestLocationUpdates(String provider, long minTime, float minDistance, PendingIntent intent) {
        if (provider == null) {
            throw new IllegalArgumentException("provider==null");
        }
        if (intent == null) {
            throw new IllegalArgumentException("intent==null");
        }
        this._requestLocationUpdates(provider, null, minTime, minDistance, false, intent);
    }

    public void requestLocationUpdates(long minTime, float minDistance, Criteria criteria, PendingIntent intent) {
        if (criteria == null) {
            throw new IllegalArgumentException("criteria==null");
        }
        if (intent == null) {
            throw new IllegalArgumentException("intent==null");
        }
        this._requestLocationUpdates(null, criteria, minTime, minDistance, false, intent);
    }

    private void _requestLocationUpdates(String provider, Criteria criteria, long minTime, float minDistance, boolean singleShot, PendingIntent intent) {
        if (minTime < 0L) {
            minTime = 0L;
        }
        if (minDistance < 0.0f) {
            minDistance = 0.0f;
        }
        try {
            this.mService.requestLocationUpdatesPI(provider, criteria, minTime, minDistance, singleShot, intent);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "requestLocationUpdates: RemoteException", ex);
        }
    }

    public void requestSingleUpdate(String provider, LocationListener listener, Looper looper) {
        if (provider == null) {
            throw new IllegalArgumentException("provider==null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        this._requestLocationUpdates(provider, null, 0L, 0.0f, true, listener, looper);
    }

    public void requestSingleUpdate(Criteria criteria, LocationListener listener, Looper looper) {
        if (criteria == null) {
            throw new IllegalArgumentException("criteria==null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        this._requestLocationUpdates(null, criteria, 0L, 0.0f, true, listener, looper);
    }

    public void requestSingleUpdate(String provider, PendingIntent intent) {
        if (provider == null) {
            throw new IllegalArgumentException("provider==null");
        }
        if (intent == null) {
            throw new IllegalArgumentException("intent==null");
        }
        this._requestLocationUpdates(provider, null, 0L, 0.0f, true, intent);
    }

    public void requestSingleUpdate(Criteria criteria, PendingIntent intent) {
        if (criteria == null) {
            throw new IllegalArgumentException("criteria==null");
        }
        if (intent == null) {
            throw new IllegalArgumentException("intent==null");
        }
        this._requestLocationUpdates(null, criteria, 0L, 0.0f, true, intent);
    }

    public void removeUpdates(LocationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener==null");
        }
        try {
            ListenerTransport transport = this.mListeners.remove(listener);
            if (transport != null) {
                this.mService.removeUpdates(transport);
            }
        }
        catch (RemoteException ex) {
            Log.e(TAG, "removeUpdates: DeadObjectException", ex);
        }
    }

    public void removeUpdates(PendingIntent intent) {
        if (intent == null) {
            throw new IllegalArgumentException("intent==null");
        }
        try {
            this.mService.removeUpdatesPI(intent);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "removeUpdates: RemoteException", ex);
        }
    }

    public void addProximityAlert(double latitude, double longitude, float radius, long expiration, PendingIntent intent) {
        try {
            this.mService.addProximityAlert(latitude, longitude, radius, expiration, intent);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "addProximityAlert: RemoteException", ex);
        }
    }

    public void removeProximityAlert(PendingIntent intent) {
        try {
            this.mService.removeProximityAlert(intent);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "removeProximityAlert: RemoteException", ex);
        }
    }

    public boolean isProviderEnabled(String provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider==null");
        }
        try {
            return this.mService.isProviderEnabled(provider);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "isProviderEnabled: RemoteException", ex);
            return false;
        }
    }

    public Location getLastKnownLocation(String provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider==null");
        }
        try {
            return this.mService.getLastKnownLocation(provider);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "getLastKnowLocation: RemoteException", ex);
            return null;
        }
    }

    public void addTestProvider(String name, boolean requiresNetwork, boolean requiresSatellite, boolean requiresCell, boolean hasMonetaryCost, boolean supportsAltitude, boolean supportsSpeed, boolean supportsBearing, int powerRequirement, int accuracy) {
        try {
            this.mService.addTestProvider(name, requiresNetwork, requiresSatellite, requiresCell, hasMonetaryCost, supportsAltitude, supportsSpeed, supportsBearing, powerRequirement, accuracy);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "addTestProvider: RemoteException", ex);
        }
    }

    public void removeTestProvider(String provider) {
        try {
            this.mService.removeTestProvider(provider);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "removeTestProvider: RemoteException", ex);
        }
    }

    public void setTestProviderLocation(String provider, Location loc) {
        try {
            this.mService.setTestProviderLocation(provider, loc);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "setTestProviderLocation: RemoteException", ex);
        }
    }

    public void clearTestProviderLocation(String provider) {
        try {
            this.mService.clearTestProviderLocation(provider);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "clearTestProviderLocation: RemoteException", ex);
        }
    }

    public void setTestProviderEnabled(String provider, boolean enabled) {
        try {
            this.mService.setTestProviderEnabled(provider, enabled);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "setTestProviderEnabled: RemoteException", ex);
        }
    }

    public void clearTestProviderEnabled(String provider) {
        try {
            this.mService.clearTestProviderEnabled(provider);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "clearTestProviderEnabled: RemoteException", ex);
        }
    }

    public void setTestProviderStatus(String provider, int status, Bundle extras, long updateTime) {
        try {
            this.mService.setTestProviderStatus(provider, status, extras, updateTime);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "setTestProviderStatus: RemoteException", ex);
        }
    }

    public void clearTestProviderStatus(String provider) {
        try {
            this.mService.clearTestProviderStatus(provider);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "clearTestProviderStatus: RemoteException", ex);
        }
    }

    public boolean addGpsStatusListener(GpsStatus.Listener listener) {
        boolean result;
        if (this.mGpsStatusListeners.get(listener) != null) {
            return true;
        }
        try {
            GpsStatusListenerTransport transport = new GpsStatusListenerTransport(listener);
            result = this.mService.addGpsStatusListener(transport);
            if (result) {
                this.mGpsStatusListeners.put(listener, transport);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in registerGpsStatusListener: ", e);
            result = false;
        }
        return result;
    }

    public void removeGpsStatusListener(GpsStatus.Listener listener) {
        try {
            GpsStatusListenerTransport transport = this.mGpsStatusListeners.remove(listener);
            if (transport != null) {
                this.mService.removeGpsStatusListener(transport);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in unregisterGpsStatusListener: ", e);
        }
    }

    public boolean addNmeaListener(GpsStatus.NmeaListener listener) {
        boolean result;
        if (this.mNmeaListeners.get(listener) != null) {
            return true;
        }
        try {
            GpsStatusListenerTransport transport = new GpsStatusListenerTransport(listener);
            result = this.mService.addGpsStatusListener(transport);
            if (result) {
                this.mNmeaListeners.put(listener, transport);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in registerGpsStatusListener: ", e);
            result = false;
        }
        return result;
    }

    public void removeNmeaListener(GpsStatus.NmeaListener listener) {
        try {
            GpsStatusListenerTransport transport = this.mNmeaListeners.remove(listener);
            if (transport != null) {
                this.mService.removeGpsStatusListener(transport);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in unregisterGpsStatusListener: ", e);
        }
    }

    public GpsStatus getGpsStatus(GpsStatus status) {
        if (status == null) {
            status = new GpsStatus();
        }
        status.setStatus(this.mGpsStatus);
        return status;
    }

    public boolean sendExtraCommand(String provider, String command, Bundle extras) {
        try {
            return this.mService.sendExtraCommand(provider, command, extras);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in sendExtraCommand: ", e);
            return false;
        }
    }

    public boolean sendNiResponse(int notifId, int userResponse) {
        try {
            return this.mService.sendNiResponse(notifId, userResponse);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in sendNiResponse: ", e);
            return false;
        }
    }

    private class GpsStatusListenerTransport
    extends IGpsStatusListener.Stub {
        private final GpsStatus.Listener mListener;
        private final GpsStatus.NmeaListener mNmeaListener;
        private static final int NMEA_RECEIVED = 1000;
        private ArrayList<Nmea> mNmeaBuffer;
        private final Handler mGpsHandler = new Handler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Message msg) {
                if (msg.what == 1000) {
                    ArrayList arrayList = GpsStatusListenerTransport.this.mNmeaBuffer;
                    synchronized (arrayList) {
                        int length = GpsStatusListenerTransport.this.mNmeaBuffer.size();
                        for (int i = 0; i < length; ++i) {
                            Nmea nmea = (Nmea)GpsStatusListenerTransport.this.mNmeaBuffer.get(i);
                            GpsStatusListenerTransport.this.mNmeaListener.onNmeaReceived(nmea.mTimestamp, nmea.mNmea);
                        }
                        GpsStatusListenerTransport.this.mNmeaBuffer.clear();
                    }
                }
                GpsStatus gpsStatus = LocationManager.this.mGpsStatus;
                synchronized (gpsStatus) {
                    GpsStatusListenerTransport.this.mListener.onGpsStatusChanged(msg.what);
                }
            }
        };

        GpsStatusListenerTransport(GpsStatus.Listener listener) {
            this.mListener = listener;
            this.mNmeaListener = null;
        }

        GpsStatusListenerTransport(GpsStatus.NmeaListener listener) {
            this.mNmeaListener = listener;
            this.mListener = null;
            this.mNmeaBuffer = new ArrayList();
        }

        public void onGpsStarted() {
            if (this.mListener != null) {
                Message msg = Message.obtain();
                msg.what = 1;
                this.mGpsHandler.sendMessage(msg);
            }
        }

        public void onGpsStopped() {
            if (this.mListener != null) {
                Message msg = Message.obtain();
                msg.what = 2;
                this.mGpsHandler.sendMessage(msg);
            }
        }

        public void onFirstFix(int ttff) {
            if (this.mListener != null) {
                LocationManager.this.mGpsStatus.setTimeToFirstFix(ttff);
                Message msg = Message.obtain();
                msg.what = 3;
                this.mGpsHandler.sendMessage(msg);
            }
        }

        public void onSvStatusChanged(int svCount, int[] prns, float[] snrs, float[] elevations, float[] azimuths, int ephemerisMask, int almanacMask, int usedInFixMask) {
            if (this.mListener != null) {
                LocationManager.this.mGpsStatus.setStatus(svCount, prns, snrs, elevations, azimuths, ephemerisMask, almanacMask, usedInFixMask);
                Message msg = Message.obtain();
                msg.what = 4;
                this.mGpsHandler.removeMessages(4);
                this.mGpsHandler.sendMessage(msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNmeaReceived(long timestamp, String nmea) {
            if (this.mNmeaListener != null) {
                ArrayList<Nmea> arrayList = this.mNmeaBuffer;
                synchronized (arrayList) {
                    this.mNmeaBuffer.add(new Nmea(timestamp, nmea));
                }
                Message msg = Message.obtain();
                msg.what = 1000;
                this.mGpsHandler.removeMessages(1000);
                this.mGpsHandler.sendMessage(msg);
            }
        }

        private class Nmea {
            long mTimestamp;
            String mNmea;

            Nmea(long timestamp, String nmea) {
                this.mTimestamp = timestamp;
                this.mNmea = nmea;
            }
        }
    }

    private class ListenerTransport
    extends ILocationListener.Stub {
        private static final int TYPE_LOCATION_CHANGED = 1;
        private static final int TYPE_STATUS_CHANGED = 2;
        private static final int TYPE_PROVIDER_ENABLED = 3;
        private static final int TYPE_PROVIDER_DISABLED = 4;
        private LocationListener mListener;
        private final Handler mListenerHandler;

        ListenerTransport(LocationListener listener, Looper looper) {
            this.mListener = listener;
            this.mListenerHandler = looper == null ? new Handler(){

                public void handleMessage(Message msg) {
                    ListenerTransport.this._handleMessage(msg);
                }
            } : new Handler(looper){

                public void handleMessage(Message msg) {
                    ListenerTransport.this._handleMessage(msg);
                }
            };
        }

        public void onLocationChanged(Location location) {
            Message msg = Message.obtain();
            msg.what = 1;
            msg.obj = location;
            this.mListenerHandler.sendMessage(msg);
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
            Message msg = Message.obtain();
            msg.what = 2;
            Bundle b = new Bundle();
            b.putString("provider", provider);
            b.putInt(LocationManager.KEY_STATUS_CHANGED, status);
            if (extras != null) {
                b.putBundle("extras", extras);
            }
            msg.obj = b;
            this.mListenerHandler.sendMessage(msg);
        }

        public void onProviderEnabled(String provider) {
            Message msg = Message.obtain();
            msg.what = 3;
            msg.obj = provider;
            this.mListenerHandler.sendMessage(msg);
        }

        public void onProviderDisabled(String provider) {
            Message msg = Message.obtain();
            msg.what = 4;
            msg.obj = provider;
            this.mListenerHandler.sendMessage(msg);
        }

        private void _handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Location location = new Location((Location)msg.obj);
                    this.mListener.onLocationChanged(location);
                    break;
                }
                case 2: {
                    Bundle b = (Bundle)msg.obj;
                    String provider = b.getString("provider");
                    int status = b.getInt(LocationManager.KEY_STATUS_CHANGED);
                    Bundle extras = b.getBundle("extras");
                    this.mListener.onStatusChanged(provider, status, extras);
                    break;
                }
                case 3: {
                    this.mListener.onProviderEnabled((String)msg.obj);
                    break;
                }
                case 4: {
                    this.mListener.onProviderDisabled((String)msg.obj);
                }
            }
            try {
                LocationManager.this.mService.locationCallbackFinished(this);
            }
            catch (RemoteException e) {
                Log.e(LocationManager.TAG, "locationCallbackFinished: RemoteException", e);
            }
        }
    }
}

