/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentValues;
import android.content.IContentProvider;
import android.net.Uri;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MediaInserter {
    private HashMap<Uri, List<ContentValues>> mRowMap = new HashMap();
    private IContentProvider mProvider;
    private int mBufferSizePerUri;

    public MediaInserter(IContentProvider provider, int bufferSizePerUri) {
        this.mProvider = provider;
        this.mBufferSizePerUri = bufferSizePerUri;
    }

    public void insert(Uri tableUri, ContentValues values) throws RemoteException {
        List<ContentValues> list = this.mRowMap.get(tableUri);
        if (list == null) {
            list = new ArrayList<ContentValues>();
            this.mRowMap.put(tableUri, list);
        }
        list.add(new ContentValues(values));
        if (list.size() >= this.mBufferSizePerUri) {
            this.flush(tableUri);
        }
    }

    public void flushAll() throws RemoteException {
        for (Uri tableUri : this.mRowMap.keySet()) {
            this.flush(tableUri);
        }
        this.mRowMap.clear();
    }

    private void flush(Uri tableUri) throws RemoteException {
        List<ContentValues> list = this.mRowMap.get(tableUri);
        if (!list.isEmpty()) {
            ContentValues[] valuesArray = new ContentValues[list.size()];
            valuesArray = list.toArray(valuesArray);
            this.mProvider.bulkInsert(tableUri, valuesArray);
            list.clear();
        }
    }
}

