/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.database.Cursor;
import android.database.SQLException;
import android.drm.DrmManagerClient;
import android.graphics.BitmapFactory;
import android.media.ExifInterface;
import android.media.MediaFile;
import android.media.MediaInserter;
import android.media.MediaScannerClient;
import android.mtp.MtpConstants;
import android.net.Uri;
import android.os.Environment;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.provider.MediaStore;
import android.provider.Settings;
import android.sax.Element;
import android.sax.ElementListener;
import android.sax.RootElement;
import android.text.TextUtils;
import android.util.Log;
import android.util.Xml;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MediaScanner {
    private static final String TAG = "MediaScanner";
    private static final String[] FILES_PRESCAN_PROJECTION;
    private static final String[] ID_PROJECTION;
    private static final int FILES_PRESCAN_ID_COLUMN_INDEX = 0;
    private static final int FILES_PRESCAN_PATH_COLUMN_INDEX = 1;
    private static final int FILES_PRESCAN_FORMAT_COLUMN_INDEX = 2;
    private static final int FILES_PRESCAN_DATE_MODIFIED_COLUMN_INDEX = 3;
    private static final String[] PLAYLIST_MEMBERS_PROJECTION;
    private static final int ID_PLAYLISTS_COLUMN_INDEX = 0;
    private static final int PATH_PLAYLISTS_COLUMN_INDEX = 1;
    private static final int DATE_MODIFIED_PLAYLISTS_COLUMN_INDEX = 2;
    private static final String RINGTONES_DIR = "/ringtones/";
    private static final String NOTIFICATIONS_DIR = "/notifications/";
    private static final String ALARMS_DIR = "/alarms/";
    private static final String MUSIC_DIR = "/music/";
    private static final String PODCAST_DIR = "/podcasts/";
    private static final String[] ID3_GENRES;
    private int mNativeContext;
    private Context mContext;
    private IContentProvider mMediaProvider;
    private Uri mAudioUri;
    private Uri mVideoUri;
    private Uri mImagesUri;
    private Uri mThumbsUri;
    private Uri mPlaylistsUri;
    private Uri mFilesUri;
    private boolean mProcessPlaylists;
    private boolean mProcessGenres;
    private int mMtpObjectHandle;
    private final String mExternalStoragePath;
    private static final boolean ENABLE_BULK_INSERTS = false;
    private int mOriginalCount;
    private boolean mWasEmptyPriorToScan = false;
    private boolean mDefaultRingtoneSet;
    private boolean mDefaultNotificationSet;
    private boolean mDefaultAlarmSet;
    private String mDefaultRingtoneFilename;
    private String mDefaultNotificationFilename;
    private String mDefaultAlarmAlertFilename;
    private static final String DEFAULT_RINGTONE_PROPERTY_PREFIX = "ro.config.";
    private boolean mCaseInsensitivePaths;
    private BitmapFactory.Options mBitmapOptions = new BitmapFactory.Options();
    private MediaInserter mMediaInserter;
    private HashMap<String, FileCacheEntry> mFileCache;
    private ArrayList<FileCacheEntry> mPlayLists;
    private DrmManagerClient mDrmManagerClient = null;
    private MyMediaScannerClient mClient = new MyMediaScannerClient();

    public MediaScanner(Context c) {
        this.native_setup();
        this.mContext = c;
        this.mBitmapOptions.inSampleSize = 1;
        this.mBitmapOptions.inJustDecodeBounds = true;
        this.setDefaultRingtoneFileNames();
        this.mExternalStoragePath = Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    private void setDefaultRingtoneFileNames() {
        this.mDefaultRingtoneFilename = SystemProperties.get("ro.config.ringtone");
        this.mDefaultNotificationFilename = SystemProperties.get("ro.config.notification_sound");
        this.mDefaultAlarmAlertFilename = SystemProperties.get("ro.config.alarm_alert");
    }

    private boolean isDrmEnabled() {
        String prop = SystemProperties.get("drm.service.enabled");
        return prop != null && prop.equals("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prescan(String filePath, boolean prescanFiles) throws RemoteException {
        Cursor c = null;
        String where = null;
        String[] selectionArgs = null;
        if (this.mFileCache == null) {
            this.mFileCache = new HashMap();
        } else {
            this.mFileCache.clear();
        }
        if (this.mPlayLists == null) {
            this.mPlayLists = new ArrayList();
        } else {
            this.mPlayLists.clear();
        }
        if (filePath != null) {
            where = "_data=?";
            selectionArgs = new String[]{filePath};
        }
        try {
            if (prescanFiles && (c = this.mMediaProvider.query(this.mFilesUri, FILES_PRESCAN_PROJECTION, where, selectionArgs, null)) != null) {
                boolean bl = this.mWasEmptyPriorToScan = c.getCount() == 0;
                while (c.moveToNext()) {
                    long rowId = c.getLong(0);
                    String path = c.getString(1);
                    int format = c.getInt(2);
                    long lastModified = c.getLong(3);
                    if (path == null || !path.startsWith("/")) continue;
                    String key = path;
                    if (this.mCaseInsensitivePaths) {
                        key = path.toLowerCase();
                    }
                    FileCacheEntry entry = new FileCacheEntry(rowId, path, lastModified, format);
                    this.mFileCache.put(key, entry);
                }
                c.close();
                c = null;
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        this.mOriginalCount = 0;
        c = this.mMediaProvider.query(this.mImagesUri, ID_PROJECTION, null, null, null);
        if (c != null) {
            this.mOriginalCount = c.getCount();
            c.close();
        }
    }

    private boolean inScanDirectory(String path, String[] directories) {
        for (int i = 0; i < directories.length; ++i) {
            String directory = directories[i];
            if (!path.startsWith(directory)) continue;
            return true;
        }
        return false;
    }

    private void pruneDeadThumbnailFiles() {
        String fullPathString;
        HashSet<String> existingFiles = new HashSet<String>();
        String directory = "/sdcard/DCIM/.thumbnails";
        String[] files = new File(directory).list();
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            fullPathString = directory + "/" + files[i];
            existingFiles.add(fullPathString);
        }
        try {
            Cursor c = this.mMediaProvider.query(this.mThumbsUri, new String[]{"_data"}, null, null, null);
            Log.v(TAG, "pruneDeadThumbnailFiles... " + c);
            if (c != null && c.moveToFirst()) {
                do {
                    fullPathString = c.getString(0);
                    existingFiles.remove(fullPathString);
                } while (c.moveToNext());
            }
            for (String fileToDelete : existingFiles) {
                try {
                    new File(fileToDelete).delete();
                }
                catch (SecurityException ex) {}
            }
            Log.v(TAG, "/pruneDeadThumbnailFiles... " + c);
            if (c != null) {
                c.close();
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private void postscan(String[] directories) throws RemoteException {
        Iterator<FileCacheEntry> iterator = this.mFileCache.values().iterator();
        while (iterator.hasNext()) {
            FileCacheEntry entry = iterator.next();
            String path = entry.mPath;
            boolean fileMissing = false;
            if (!entry.mSeenInFileSystem && !MtpConstants.isAbstractObject(entry.mFormat)) {
                if (this.inScanDirectory(path, directories)) {
                    fileMissing = true;
                } else {
                    File testFile = new File(path);
                    if (!testFile.exists()) {
                        fileMissing = true;
                    }
                }
            }
            if (!fileMissing) continue;
            ContentValues values = new ContentValues();
            values.put("_data", "");
            values.put("date_modified", 0);
            this.mMediaProvider.update(ContentUris.withAppendedId(this.mFilesUri, entry.mRowId), values, null, null);
            MediaFile.MediaFileType mediaFileType = MediaFile.getFileType(path);
            int fileType = mediaFileType == null ? 0 : mediaFileType.fileType;
            if (MediaFile.isPlayListFileType(fileType)) continue;
            this.mMediaProvider.delete(ContentUris.withAppendedId(this.mFilesUri, entry.mRowId), null, null);
            iterator.remove();
        }
        if (this.mProcessPlaylists) {
            this.processPlayLists();
        }
        if (this.mOriginalCount == 0 && this.mImagesUri.equals(MediaStore.Images.Media.getContentUri("external"))) {
            this.pruneDeadThumbnailFiles();
        }
        this.mPlayLists = null;
        this.mFileCache = null;
        this.mMediaProvider = null;
    }

    private void initialize(String volumeName) {
        this.mMediaProvider = this.mContext.getContentResolver().acquireProvider("media");
        this.mAudioUri = MediaStore.Audio.Media.getContentUri(volumeName);
        this.mVideoUri = MediaStore.Video.Media.getContentUri(volumeName);
        this.mImagesUri = MediaStore.Images.Media.getContentUri(volumeName);
        this.mThumbsUri = MediaStore.Images.Thumbnails.getContentUri(volumeName);
        this.mFilesUri = MediaStore.Files.getContentUri(volumeName);
        if (!volumeName.equals("internal")) {
            this.mProcessPlaylists = true;
            this.mProcessGenres = true;
            this.mPlaylistsUri = MediaStore.Audio.Playlists.getContentUri(volumeName);
            this.mCaseInsensitivePaths = true;
        }
    }

    public void scanDirectories(String[] directories, String volumeName) {
        try {
            long start = System.currentTimeMillis();
            this.initialize(volumeName);
            this.prescan(null, true);
            long prescan = System.currentTimeMillis();
            for (int i = 0; i < directories.length; ++i) {
                this.processDirectory(directories[i], this.mClient);
            }
            long scan = System.currentTimeMillis();
            this.postscan(directories);
            long end = System.currentTimeMillis();
        }
        catch (SQLException e) {
            Log.e(TAG, "SQLException in MediaScanner.scan()", e);
        }
        catch (UnsupportedOperationException e) {
            Log.e(TAG, "UnsupportedOperationException in MediaScanner.scan()", e);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in MediaScanner.scan()", e);
        }
    }

    public Uri scanSingleFile(String path, String volumeName, String mimeType) {
        try {
            this.initialize(volumeName);
            this.prescan(path, true);
            File file = new File(path);
            long lastModifiedSeconds = file.lastModified() / 1000L;
            return this.mClient.doScanFile(path, mimeType, lastModifiedSeconds, file.length(), false, true, false);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in MediaScanner.scanFile()", e);
            return null;
        }
    }

    private static boolean isNoMediaFile(String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            return false;
        }
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash >= 0 && lastSlash + 2 < path.length()) {
            if (path.regionMatches(lastSlash + 1, "._", 0, 2)) {
                return true;
            }
            if (path.regionMatches(true, path.length() - 4, ".jpg", 0, 4)) {
                if (path.regionMatches(true, lastSlash + 1, "AlbumArt_{", 0, 10) || path.regionMatches(true, lastSlash + 1, "AlbumArt.", 0, 9)) {
                    return true;
                }
                int length = path.length() - lastSlash - 1;
                if (length == 17 && path.regionMatches(true, lastSlash + 1, "AlbumArtSmall", 0, 13) || length == 10 && path.regionMatches(true, lastSlash + 1, "Folder", 0, 6)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isNoMediaPath(String path) {
        if (path == null) {
            return false;
        }
        if (path.indexOf("/.") >= 0) {
            return true;
        }
        int offset = 1;
        while (offset >= 0) {
            File file;
            int slashIndex = path.indexOf(47, offset);
            if (slashIndex > offset && (file = new File(path.substring(0, ++slashIndex) + ".nomedia")).exists()) {
                return true;
            }
            offset = slashIndex;
        }
        return MediaScanner.isNoMediaFile(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanMtpFile(String path, String volumeName, int objectHandle, int format) {
        this.initialize(volumeName);
        MediaFile.MediaFileType mediaFileType = MediaFile.getFileType(path);
        int fileType = mediaFileType == null ? 0 : mediaFileType.fileType;
        File file = new File(path);
        long lastModifiedSeconds = file.lastModified() / 1000L;
        if (!(MediaFile.isAudioFileType(fileType) || MediaFile.isVideoFileType(fileType) || MediaFile.isImageFileType(fileType) || MediaFile.isPlayListFileType(fileType))) {
            ContentValues values = new ContentValues();
            values.put("_size", file.length());
            values.put("date_modified", lastModifiedSeconds);
            try {
                String[] whereArgs = new String[]{Integer.toString(objectHandle)};
                this.mMediaProvider.update(MediaStore.Files.getMtpObjectsUri(volumeName), values, "_id=?", whereArgs);
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException in scanMtpFile", e);
            }
            return;
        }
        this.mMtpObjectHandle = objectHandle;
        try {
            if (MediaFile.isPlayListFileType(fileType)) {
                FileCacheEntry entry;
                this.prescan(null, true);
                String key = path;
                if (this.mCaseInsensitivePaths) {
                    key = path.toLowerCase();
                }
                if ((entry = this.mFileCache.get(key)) != null) {
                    this.processPlayList(entry);
                }
            } else {
                this.prescan(path, false);
                this.mClient.doScanFile(path, mediaFileType.mimeType, lastModifiedSeconds, file.length(), format == 12289, true, MediaScanner.isNoMediaPath(path));
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in MediaScanner.scanFile()", e);
        }
        finally {
            this.mMtpObjectHandle = 0;
        }
    }

    private int matchPaths(String path1, String path2) {
        int result = 0;
        int end1 = path1.length();
        int end2 = path2.length();
        while (end1 > 0 && end2 > 0) {
            int start2;
            int slash1 = path1.lastIndexOf(47, end1 - 1);
            int slash2 = path2.lastIndexOf(47, end2 - 1);
            int backSlash1 = path1.lastIndexOf(92, end1 - 1);
            int backSlash2 = path2.lastIndexOf(92, end2 - 1);
            int start1 = slash1 > backSlash1 ? slash1 : backSlash1;
            int n = start2 = slash2 > backSlash2 ? slash2 : backSlash2;
            start1 = start1 < 0 ? 0 : ++start1;
            start2 = start2 < 0 ? 0 : ++start2;
            int length = end1 - start1;
            if (end2 - start2 != length || !path1.regionMatches(true, start1, path2, start2, length)) break;
            ++result;
            end1 = start1 - 1;
            end2 = start2 - 1;
        }
        return result;
    }

    private boolean addPlayListEntry(String entry, String playListDirectory, Uri uri, ContentValues values, int index) {
        char ch1;
        boolean fullPath;
        int entryLength;
        for (entryLength = entry.length(); entryLength > 0 && Character.isWhitespace(entry.charAt(entryLength - 1)); --entryLength) {
        }
        if (entryLength < 3) {
            return false;
        }
        if (entryLength < entry.length()) {
            entry = entry.substring(0, entryLength);
        }
        boolean bl = fullPath = (ch1 = entry.charAt(0)) == '/' || Character.isLetter(ch1) && entry.charAt(1) == ':' && entry.charAt(2) == '\\';
        if (!fullPath) {
            entry = playListDirectory + entry;
        }
        FileCacheEntry bestMatch = null;
        int bestMatchLength = 0;
        for (FileCacheEntry cacheEntry : this.mFileCache.values()) {
            String path = cacheEntry.mPath;
            if (path.equalsIgnoreCase(entry)) {
                bestMatch = cacheEntry;
                break;
            }
            int matchLength = this.matchPaths(path, entry);
            if (matchLength <= bestMatchLength) continue;
            bestMatch = cacheEntry;
            bestMatchLength = matchLength;
        }
        if (bestMatch == null) {
            return false;
        }
        try {
            if (bestMatch.mRowId == 0L) {
                Cursor c = this.mMediaProvider.query(this.mAudioUri, ID_PROJECTION, "_data=?", new String[]{bestMatch.mPath}, null);
                if (c != null) {
                    if (c.moveToNext()) {
                        bestMatch.mRowId = c.getLong(0);
                    }
                    c.close();
                }
                if (bestMatch.mRowId == 0L) {
                    return false;
                }
            }
            values.clear();
            values.put("play_order", index);
            values.put("audio_id", bestMatch.mRowId);
            this.mMediaProvider.insert(uri, values);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in MediaScanner.addPlayListEntry()", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processM3uPlayList(String path, String playListDirectory, Uri uri, ContentValues values) {
        BufferedReader reader = null;
        try {
            File f = new File(path);
            if (f.exists()) {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)), 8192);
                String line = reader.readLine();
                int index = 0;
                while (line != null) {
                    if (line.length() > 0 && line.charAt(0) != '#') {
                        values.clear();
                        if (this.addPlayListEntry(line, playListDirectory, uri, values, index)) {
                            ++index;
                        }
                    }
                    line = reader.readLine();
                }
            }
        }
        catch (IOException e) {
            Log.e(TAG, "IOException in MediaScanner.processM3uPlayList()", e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                Log.e(TAG, "IOException in MediaScanner.processM3uPlayList()", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPlsPlayList(String path, String playListDirectory, Uri uri, ContentValues values) {
        BufferedReader reader = null;
        try {
            File f = new File(path);
            if (f.exists()) {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)), 8192);
                String line = reader.readLine();
                int index = 0;
                while (line != null) {
                    int equals;
                    if (line.startsWith("File") && (equals = line.indexOf(61)) > 0) {
                        values.clear();
                        if (this.addPlayListEntry(line.substring(equals + 1), playListDirectory, uri, values, index)) {
                            ++index;
                        }
                    }
                    line = reader.readLine();
                }
            }
        }
        catch (IOException e) {
            Log.e(TAG, "IOException in MediaScanner.processPlsPlayList()", e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                Log.e(TAG, "IOException in MediaScanner.processPlsPlayList()", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWplPlayList(String path, String playListDirectory, Uri uri) {
        FileInputStream fis = null;
        try {
            File f = new File(path);
            if (f.exists()) {
                fis = new FileInputStream(f);
                Xml.parse(fis, Xml.findEncodingByName("UTF-8"), new WplHandler(playListDirectory, uri).getContentHandler());
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                Log.e(TAG, "IOException in MediaScanner.processWplPlayList()", e);
            }
        }
    }

    private void processPlayList(FileCacheEntry entry) throws RemoteException {
        int fileType;
        Uri membersUri;
        String path = entry.mPath;
        ContentValues values = new ContentValues();
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash < 0) {
            throw new IllegalArgumentException("bad path " + path);
        }
        long rowId = entry.mRowId;
        String name = values.getAsString("name");
        if (name == null && (name = values.getAsString("title")) == null) {
            int lastDot = path.lastIndexOf(46);
            name = lastDot < 0 ? path.substring(lastSlash + 1) : path.substring(lastSlash + 1, lastDot);
        }
        values.put("name", name);
        values.put("date_modified", entry.mLastModified);
        if (rowId == 0L) {
            values.put("_data", path);
            Uri uri = this.mMediaProvider.insert(this.mPlaylistsUri, values);
            rowId = ContentUris.parseId(uri);
            membersUri = Uri.withAppendedPath(uri, "members");
        } else {
            Uri uri = ContentUris.withAppendedId(this.mPlaylistsUri, rowId);
            this.mMediaProvider.update(uri, values, null, null);
            membersUri = Uri.withAppendedPath(uri, "members");
            this.mMediaProvider.delete(membersUri, null, null);
        }
        String playListDirectory = path.substring(0, lastSlash + 1);
        MediaFile.MediaFileType mediaFileType = MediaFile.getFileType(path);
        int n = fileType = mediaFileType == null ? 0 : mediaFileType.fileType;
        if (fileType == 41) {
            this.processM3uPlayList(path, playListDirectory, membersUri, values);
        } else if (fileType == 42) {
            this.processPlsPlayList(path, playListDirectory, membersUri, values);
        } else if (fileType == 43) {
            this.processWplPlayList(path, playListDirectory, membersUri);
        }
    }

    private void processPlayLists() throws RemoteException {
        for (FileCacheEntry entry : this.mPlayLists) {
            if (!entry.mLastModifiedChanged) continue;
            this.processPlayList(entry);
        }
    }

    private native void processDirectory(String var1, MediaScannerClient var2);

    private native void processFile(String var1, String var2, MediaScannerClient var3);

    public native void setLocale(String var1);

    public native byte[] extractAlbumArt(FileDescriptor var1);

    private static final native void native_init();

    private final native void native_setup();

    private final native void native_finalize();

    public void release() {
        this.native_finalize();
    }

    protected void finalize() {
        this.mContext.getContentResolver().releaseProvider(this.mMediaProvider);
        this.native_finalize();
    }

    static {
        System.loadLibrary("media_jni");
        MediaScanner.native_init();
        FILES_PRESCAN_PROJECTION = new String[]{"_id", "_data", "format", "date_modified"};
        ID_PROJECTION = new String[]{"_id"};
        PLAYLIST_MEMBERS_PROJECTION = new String[]{"playlist_id"};
        ID3_GENRES = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A capella", "Euro-House", "Dance Hall", "Goa", "Drum & Bass", "Club-House", "Hardcore", "Terror", "Indie", "Britpop", "Negerpunk", "Polsk Punk", "Beat", "Christian Gangsta", "Heavy Metal", "Black Metal", "Crossover", "Contemporary Christian", "Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "JPop", "Synthpop"};
    }

    class WplHandler
    implements ElementListener {
        final ContentHandler handler;
        String playListDirectory;
        Uri uri;
        ContentValues values = new ContentValues();
        int index = 0;

        public WplHandler(String playListDirectory, Uri uri) {
            this.playListDirectory = playListDirectory;
            this.uri = uri;
            RootElement root = new RootElement("smil");
            Element body = root.getChild("body");
            Element seq = body.getChild("seq");
            Element media = seq.getChild("media");
            media.setElementListener(this);
            this.handler = root.getContentHandler();
        }

        public void start(Attributes attributes) {
            String path = attributes.getValue("", "src");
            if (path != null) {
                this.values.clear();
                if (MediaScanner.this.addPlayListEntry(path, this.playListDirectory, this.uri, this.values, this.index)) {
                    ++this.index;
                }
            }
        }

        public void end() {
        }

        ContentHandler getContentHandler() {
            return this.handler;
        }
    }

    private class MyMediaScannerClient
    implements MediaScannerClient {
        private String mArtist;
        private String mAlbumArtist;
        private String mAlbum;
        private String mTitle;
        private String mComposer;
        private String mGenre;
        private String mMimeType;
        private int mFileType;
        private int mTrack;
        private int mYear;
        private int mDuration;
        private String mPath;
        private long mLastModified;
        private long mFileSize;
        private String mWriter;
        private int mCompilation;
        private boolean mIsDrm;
        private boolean mNoMedia;
        private int mWidth;
        private int mHeight;

        private MyMediaScannerClient() {
        }

        public FileCacheEntry beginFile(String path, String mimeType, long lastModified, long fileSize, boolean isDirectory, boolean noMedia) {
            boolean wasModified;
            FileCacheEntry entry;
            this.mMimeType = mimeType;
            this.mFileType = 0;
            this.mFileSize = fileSize;
            if (!isDirectory) {
                MediaFile.MediaFileType mediaFileType;
                if (!noMedia && MediaScanner.isNoMediaFile(path)) {
                    noMedia = true;
                }
                this.mNoMedia = noMedia;
                if (mimeType != null) {
                    this.mFileType = MediaFile.getFileTypeForMimeType(mimeType);
                }
                if (this.mFileType == 0 && (mediaFileType = MediaFile.getFileType(path)) != null) {
                    this.mFileType = mediaFileType.fileType;
                    if (this.mMimeType == null) {
                        this.mMimeType = mediaFileType.mimeType;
                    }
                }
                if (MediaScanner.this.isDrmEnabled() && MediaFile.isDrmFileType(this.mFileType)) {
                    this.mFileType = this.getFileTypeFromDrm(path);
                }
            }
            String key = path;
            if (MediaScanner.this.mCaseInsensitivePaths) {
                key = path.toLowerCase();
            }
            long delta = (entry = (FileCacheEntry)MediaScanner.this.mFileCache.get(key)) != null ? lastModified - entry.mLastModified : 0L;
            boolean bl = wasModified = delta > 1L || delta < -1L;
            if (entry == null || wasModified) {
                if (wasModified) {
                    entry.mLastModified = lastModified;
                } else {
                    entry = new FileCacheEntry(0L, path, lastModified, isDirectory ? 12289 : 0);
                    MediaScanner.this.mFileCache.put(key, entry);
                }
                entry.mLastModifiedChanged = true;
            }
            entry.mSeenInFileSystem = true;
            if (MediaScanner.this.mProcessPlaylists && MediaFile.isPlayListFileType(this.mFileType)) {
                MediaScanner.this.mPlayLists.add(entry);
                return null;
            }
            this.mArtist = null;
            this.mAlbumArtist = null;
            this.mAlbum = null;
            this.mTitle = null;
            this.mComposer = null;
            this.mGenre = null;
            this.mTrack = 0;
            this.mYear = 0;
            this.mDuration = 0;
            this.mPath = path;
            this.mLastModified = lastModified;
            this.mWriter = null;
            this.mCompilation = 0;
            this.mIsDrm = false;
            this.mWidth = 0;
            this.mHeight = 0;
            return entry;
        }

        public void scanFile(String path, long lastModified, long fileSize, boolean isDirectory, boolean noMedia) {
            this.doScanFile(path, null, lastModified, fileSize, isDirectory, false, noMedia);
        }

        public Uri doScanFile(String path, String mimeType, long lastModified, long fileSize, boolean isDirectory, boolean scanAlways, boolean noMedia) {
            Uri result = null;
            try {
                FileCacheEntry entry = this.beginFile(path, mimeType, lastModified, fileSize, isDirectory, noMedia);
                if (entry != null && (entry.mLastModifiedChanged || scanAlways)) {
                    if (noMedia) {
                        result = this.endFile(entry, false, false, false, false, false);
                    } else {
                        boolean music;
                        String lowpath = path.toLowerCase();
                        boolean ringtones = lowpath.indexOf(MediaScanner.RINGTONES_DIR) > 0;
                        boolean notifications = lowpath.indexOf(MediaScanner.NOTIFICATIONS_DIR) > 0;
                        boolean alarms = lowpath.indexOf(MediaScanner.ALARMS_DIR) > 0;
                        boolean podcasts = lowpath.indexOf(MediaScanner.PODCAST_DIR) > 0;
                        boolean bl = music = lowpath.indexOf(MediaScanner.MUSIC_DIR) > 0 || !ringtones && !notifications && !alarms && !podcasts;
                        if (MediaFile.isAudioFileType(this.mFileType) || MediaFile.isVideoFileType(this.mFileType)) {
                            MediaScanner.this.processFile(path, mimeType, this);
                        }
                        if (MediaFile.isImageFileType(this.mFileType)) {
                            this.processImageFile(path);
                        }
                        result = this.endFile(entry, ringtones, notifications, alarms, music, podcasts);
                    }
                }
            }
            catch (RemoteException e) {
                Log.e(MediaScanner.TAG, "RemoteException in MediaScanner.scanFile()", e);
            }
            return result;
        }

        private int parseSubstring(String s, int start, int defaultValue) {
            char ch;
            int length = s.length();
            if (start == length) {
                return defaultValue;
            }
            if ((ch = s.charAt(start++)) < '0' || ch > '9') {
                return defaultValue;
            }
            int result = ch - 48;
            while (start < length) {
                if ((ch = s.charAt(start++)) < '0' || ch > '9') {
                    return result;
                }
                result = result * 10 + (ch - 48);
            }
            return result;
        }

        public void handleStringTag(String name, String value) {
            if (name.equalsIgnoreCase("title") || name.startsWith("title;")) {
                this.mTitle = value;
            } else if (name.equalsIgnoreCase("artist") || name.startsWith("artist;")) {
                this.mArtist = value.trim();
            } else if (name.equalsIgnoreCase("albumartist") || name.startsWith("albumartist;") || name.equalsIgnoreCase("band") || name.startsWith("band;")) {
                this.mAlbumArtist = value.trim();
            } else if (name.equalsIgnoreCase("album") || name.startsWith("album;")) {
                this.mAlbum = value.trim();
            } else if (name.equalsIgnoreCase("composer") || name.startsWith("composer;")) {
                this.mComposer = value.trim();
            } else if (MediaScanner.this.mProcessGenres && (name.equalsIgnoreCase("genre") || name.startsWith("genre;"))) {
                this.mGenre = this.getGenreName(value);
            } else if (name.equalsIgnoreCase("year") || name.startsWith("year;")) {
                this.mYear = this.parseSubstring(value, 0, 0);
            } else if (name.equalsIgnoreCase("tracknumber") || name.startsWith("tracknumber;")) {
                int num = this.parseSubstring(value, 0, 0);
                this.mTrack = this.mTrack / 1000 * 1000 + num;
            } else if (name.equalsIgnoreCase("discnumber") || name.equals("set") || name.startsWith("set;")) {
                int num = this.parseSubstring(value, 0, 0);
                this.mTrack = num * 1000 + this.mTrack % 1000;
            } else if (name.equalsIgnoreCase("duration")) {
                this.mDuration = this.parseSubstring(value, 0, 0);
            } else if (name.equalsIgnoreCase("writer") || name.startsWith("writer;")) {
                this.mWriter = value.trim();
            } else if (name.equalsIgnoreCase("compilation")) {
                this.mCompilation = this.parseSubstring(value, 0, 0);
            } else if (name.equalsIgnoreCase("isdrm")) {
                this.mIsDrm = this.parseSubstring(value, 0, 0) == 1;
            }
        }

        public String getGenreName(String genreTagValue) {
            if (genreTagValue == null) {
                return null;
            }
            int length = genreTagValue.length();
            if (length > 0 && genreTagValue.charAt(0) == '(') {
                char c;
                int i;
                StringBuffer number = new StringBuffer();
                for (i = 1; i < length - 1 && Character.isDigit(c = genreTagValue.charAt(i)); ++i) {
                    number.append(c);
                }
                if (genreTagValue.charAt(i) == ')') {
                    try {
                        short genreIndex = Short.parseShort(number.toString());
                        if (genreIndex >= 0) {
                            if (genreIndex < ID3_GENRES.length) {
                                return ID3_GENRES[genreIndex];
                            }
                            if (genreIndex == 255) {
                                return null;
                            }
                            if (genreIndex < 255 && i + 1 < length) {
                                return genreTagValue.substring(i + 1);
                            }
                            return number.toString();
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            return genreTagValue;
        }

        private void processImageFile(String path) {
            try {
                ((MediaScanner)MediaScanner.this).mBitmapOptions.outWidth = 0;
                ((MediaScanner)MediaScanner.this).mBitmapOptions.outHeight = 0;
                BitmapFactory.decodeFile(path, MediaScanner.this.mBitmapOptions);
                this.mWidth = ((MediaScanner)MediaScanner.this).mBitmapOptions.outWidth;
                this.mHeight = ((MediaScanner)MediaScanner.this).mBitmapOptions.outHeight;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void setMimeType(String mimeType) {
            if ("audio/mp4".equals(this.mMimeType) && mimeType.startsWith("video")) {
                return;
            }
            this.mMimeType = mimeType;
            this.mFileType = MediaFile.getFileTypeForMimeType(mimeType);
        }

        private ContentValues toValues() {
            ContentValues map = new ContentValues();
            map.put("_data", this.mPath);
            map.put("title", this.mTitle);
            map.put("date_modified", this.mLastModified);
            map.put("_size", this.mFileSize);
            map.put("mime_type", this.mMimeType);
            map.put("is_drm", this.mIsDrm);
            if (this.mWidth > 0 && this.mHeight > 0) {
                map.put("width", this.mWidth);
                map.put("height", this.mHeight);
            }
            if (!this.mNoMedia) {
                if (MediaFile.isVideoFileType(this.mFileType)) {
                    map.put("artist", this.mArtist != null && this.mArtist.length() > 0 ? this.mArtist : "<unknown>");
                    map.put("album", this.mAlbum != null && this.mAlbum.length() > 0 ? this.mAlbum : "<unknown>");
                    map.put("duration", this.mDuration);
                } else if (!MediaFile.isImageFileType(this.mFileType) && MediaFile.isAudioFileType(this.mFileType)) {
                    map.put("artist", this.mArtist != null && this.mArtist.length() > 0 ? this.mArtist : "<unknown>");
                    map.put("album_artist", this.mAlbumArtist != null && this.mAlbumArtist.length() > 0 ? this.mAlbumArtist : null);
                    map.put("album", this.mAlbum != null && this.mAlbum.length() > 0 ? this.mAlbum : "<unknown>");
                    map.put("composer", this.mComposer);
                    map.put("genre", this.mGenre);
                    if (this.mYear != 0) {
                        map.put("year", this.mYear);
                    }
                    map.put("track", this.mTrack);
                    map.put("duration", this.mDuration);
                    map.put("compilation", this.mCompilation);
                }
            }
            return map;
        }

        private Uri endFile(FileCacheEntry entry, boolean ringtones, boolean notifications, boolean alarms, boolean music, boolean podcasts) throws RemoteException {
            int lastSlash;
            String album;
            ContentValues values;
            String title;
            if (this.mArtist == null || this.mArtist.length() == 0) {
                this.mArtist = this.mAlbumArtist;
            }
            if ((title = (values = this.toValues()).getAsString("title")) == null || TextUtils.isEmpty(title.trim())) {
                title = MediaFile.getFileTitle(values.getAsString("_data"));
                values.put("title", title);
            }
            if ("<unknown>".equals(album = values.getAsString("album")) && (lastSlash = (album = values.getAsString("_data")).lastIndexOf(47)) >= 0) {
                int idx;
                int previousSlash = 0;
                while ((idx = album.indexOf(47, previousSlash + 1)) >= 0 && idx < lastSlash) {
                    previousSlash = idx;
                }
                if (previousSlash != 0) {
                    album = album.substring(previousSlash + 1, lastSlash);
                    values.put("album", album);
                }
            }
            long rowId = entry.mRowId;
            if (MediaFile.isAudioFileType(this.mFileType) && (rowId == 0L || MediaScanner.this.mMtpObjectHandle != 0)) {
                values.put("is_ringtone", ringtones);
                values.put("is_notification", notifications);
                values.put("is_alarm", alarms);
                values.put("is_music", music);
                values.put("is_podcast", podcasts);
            } else if (this.mFileType == 31 && !this.mNoMedia) {
                ExifInterface exif = null;
                try {
                    exif = new ExifInterface(entry.mPath);
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (exif != null) {
                    long time;
                    float[] latlng = new float[2];
                    if (exif.getLatLong(latlng)) {
                        values.put("latitude", Float.valueOf(latlng[0]));
                        values.put("longitude", Float.valueOf(latlng[1]));
                    }
                    if ((time = exif.getGpsDateTime()) != -1L) {
                        values.put("datetaken", time);
                    } else {
                        time = exif.getDateTime();
                        if (Math.abs(this.mLastModified * 1000L - time) >= 86400000L) {
                            values.put("datetaken", time);
                        }
                    }
                    int orientation = exif.getAttributeInt("Orientation", -1);
                    if (orientation != -1) {
                        int degree;
                        switch (orientation) {
                            case 6: {
                                degree = 90;
                                break;
                            }
                            case 3: {
                                degree = 180;
                                break;
                            }
                            case 8: {
                                degree = 270;
                                break;
                            }
                            default: {
                                degree = 0;
                            }
                        }
                        values.put("orientation", degree);
                    }
                }
            }
            Uri tableUri = MediaScanner.this.mFilesUri;
            MediaInserter inserter = MediaScanner.this.mMediaInserter;
            if (!this.mNoMedia) {
                if (MediaFile.isVideoFileType(this.mFileType)) {
                    tableUri = MediaScanner.this.mVideoUri;
                } else if (MediaFile.isImageFileType(this.mFileType)) {
                    tableUri = MediaScanner.this.mImagesUri;
                } else if (MediaFile.isAudioFileType(this.mFileType)) {
                    tableUri = MediaScanner.this.mAudioUri;
                }
            }
            Uri result = null;
            if (rowId == 0L) {
                if (MediaScanner.this.mMtpObjectHandle != 0) {
                    values.put("media_scanner_new_object_id", MediaScanner.this.mMtpObjectHandle);
                }
                if (tableUri == MediaScanner.this.mFilesUri) {
                    int format = entry.mFormat;
                    if (format == 0) {
                        format = MediaFile.getFormatCode(entry.mPath, this.mMimeType);
                    }
                    values.put("format", format);
                }
                if (inserter == null || entry.mFormat == 12289) {
                    result = MediaScanner.this.mMediaProvider.insert(tableUri, values);
                } else {
                    inserter.insert(tableUri, values);
                }
                if (result != null) {
                    entry.mRowId = rowId = ContentUris.parseId(result);
                }
            } else {
                result = ContentUris.withAppendedId(tableUri, rowId);
                values.remove("_data");
                MediaScanner.this.mMediaProvider.update(result, values, null, null);
            }
            if (notifications && MediaScanner.this.mWasEmptyPriorToScan && !MediaScanner.this.mDefaultNotificationSet) {
                if (TextUtils.isEmpty(MediaScanner.this.mDefaultNotificationFilename) || this.doesPathHaveFilename(entry.mPath, MediaScanner.this.mDefaultNotificationFilename)) {
                    this.setSettingIfNotSet("notification_sound", tableUri, rowId);
                    MediaScanner.this.mDefaultNotificationSet = true;
                }
            } else if (ringtones && MediaScanner.this.mWasEmptyPriorToScan && !MediaScanner.this.mDefaultRingtoneSet) {
                if (TextUtils.isEmpty(MediaScanner.this.mDefaultRingtoneFilename) || this.doesPathHaveFilename(entry.mPath, MediaScanner.this.mDefaultRingtoneFilename)) {
                    this.setSettingIfNotSet("ringtone", tableUri, rowId);
                    MediaScanner.this.mDefaultRingtoneSet = true;
                }
            } else if (alarms && MediaScanner.this.mWasEmptyPriorToScan && !MediaScanner.this.mDefaultAlarmSet && (TextUtils.isEmpty(MediaScanner.this.mDefaultAlarmAlertFilename) || this.doesPathHaveFilename(entry.mPath, MediaScanner.this.mDefaultAlarmAlertFilename))) {
                this.setSettingIfNotSet("alarm_alert", tableUri, rowId);
                MediaScanner.this.mDefaultAlarmSet = true;
            }
            return result;
        }

        private boolean doesPathHaveFilename(String path, String filename) {
            int filenameLength;
            int pathFilenameStart = path.lastIndexOf(File.separatorChar) + 1;
            return path.regionMatches(pathFilenameStart, filename, 0, filenameLength = filename.length()) && pathFilenameStart + filenameLength == path.length();
        }

        private void setSettingIfNotSet(String settingName, Uri uri, long rowId) {
            String existingSettingValue = Settings.System.getString(MediaScanner.this.mContext.getContentResolver(), settingName);
            if (TextUtils.isEmpty(existingSettingValue)) {
                Settings.System.putString(MediaScanner.this.mContext.getContentResolver(), settingName, ContentUris.withAppendedId(uri, rowId).toString());
            }
        }

        private int getFileTypeFromDrm(String path) {
            String drmMimetype;
            if (!MediaScanner.this.isDrmEnabled()) {
                return 0;
            }
            int resultFileType = 0;
            if (MediaScanner.this.mDrmManagerClient == null) {
                MediaScanner.this.mDrmManagerClient = new DrmManagerClient(MediaScanner.this.mContext);
            }
            if (MediaScanner.this.mDrmManagerClient.canHandle(path, null) && (drmMimetype = MediaScanner.this.mDrmManagerClient.getOriginalMimeType(path)) != null) {
                this.mMimeType = drmMimetype;
                resultFileType = MediaFile.getFileTypeForMimeType(drmMimetype);
            }
            return resultFileType;
        }
    }

    private static class FileCacheEntry {
        long mRowId;
        String mPath;
        long mLastModified;
        int mFormat;
        boolean mSeenInFileSystem;
        boolean mLastModifiedChanged;

        FileCacheEntry(long rowId, String path, long lastModified, int format) {
            this.mRowId = rowId;
            this.mPath = path;
            this.mLastModified = lastModified;
            this.mFormat = format;
            this.mSeenInFileSystem = false;
            this.mLastModifiedChanged = false;
        }

        public String toString() {
            return this.mPath + " mRowId: " + this.mRowId;
        }
    }
}

