/*
 * Decompiled with CFR 0.152.
 */
package android.media.videoeditor;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.media.videoeditor.Effect;
import android.media.videoeditor.EffectKenBurns;
import android.media.videoeditor.MediaArtistNativeHelper;
import android.media.videoeditor.MediaItem;
import android.media.videoeditor.MediaProperties;
import android.media.videoeditor.Overlay;
import android.media.videoeditor.VideoEditor;
import android.media.videoeditor.VideoEditorImpl;
import android.util.Log;
import android.util.Pair;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaImageItem
extends MediaItem {
    private static final String TAG = "MediaImageItem";
    private static final Paint sResizePaint = new Paint(2);
    private final int mWidth;
    private final int mHeight;
    private final int mAspectRatio;
    private long mDurationMs;
    private int mScaledWidth;
    private int mScaledHeight;
    private String mScaledFilename;
    private final VideoEditorImpl mVideoEditor;
    private String mDecodedFilename;
    private int mGeneratedClipHeight;
    private int mGeneratedClipWidth;
    private String mFileName;
    private final MediaArtistNativeHelper mMANativeHelper;

    private MediaImageItem() throws IOException {
        this(null, null, null, 0L, 0);
    }

    public MediaImageItem(VideoEditor editor, String mediaItemId, String filename, long durationMs, int renderingMode) throws IOException {
        super(editor, mediaItemId, filename, renderingMode);
        Bitmap imageBitmap;
        this.mMANativeHelper = ((VideoEditorImpl)editor).getNativeContext();
        this.mVideoEditor = (VideoEditorImpl)editor;
        try {
            MediaArtistNativeHelper.Properties properties = this.mMANativeHelper.getMediaProperties(filename);
            switch (this.mMANativeHelper.getFileType(properties.fileType)) {
                case 5: 
                case 8: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported Input File Type");
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported file or file not found: " + filename);
        }
        this.mFileName = filename;
        BitmapFactory.Options dbo = new BitmapFactory.Options();
        dbo.inJustDecodeBounds = true;
        BitmapFactory.decodeFile(filename, dbo);
        this.mWidth = dbo.outWidth;
        this.mHeight = dbo.outHeight;
        this.mDurationMs = durationMs;
        this.mDecodedFilename = String.format(this.mMANativeHelper.getProjectPath() + "/" + "decoded" + this.getId() + ".rgb", new Object[0]);
        try {
            this.mAspectRatio = this.mMANativeHelper.getAspectRatio(this.mWidth, this.mHeight);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Null width and height");
        }
        this.mGeneratedClipHeight = 0;
        this.mGeneratedClipWidth = 0;
        Pair<Integer, Integer>[] resolutions = MediaProperties.getSupportedResolutions(this.mAspectRatio);
        Pair<Integer, Integer> maxResolution = resolutions[resolutions.length - 1];
        if (this.mWidth > (Integer)maxResolution.first || this.mHeight > (Integer)maxResolution.second) {
            imageBitmap = this.scaleImage(filename, (Integer)maxResolution.first, (Integer)maxResolution.second);
            this.mScaledFilename = String.format(this.mMANativeHelper.getProjectPath() + "/" + "scaled" + this.getId() + ".JPG", new Object[0]);
            if (!new File(this.mScaledFilename).exists()) {
                this.mRegenerateClip = true;
                FileOutputStream f1 = new FileOutputStream(this.mScaledFilename);
                imageBitmap.compress(Bitmap.CompressFormat.JPEG, 50, f1);
                f1.close();
            }
            this.mScaledWidth = imageBitmap.getWidth() >> 1 << 1;
            this.mScaledHeight = imageBitmap.getHeight() >> 1 << 1;
        } else {
            this.mScaledFilename = filename;
            this.mScaledWidth = this.mWidth >> 1 << 1;
            this.mScaledHeight = this.mHeight >> 1 << 1;
            imageBitmap = BitmapFactory.decodeFile(this.mScaledFilename);
        }
        int newWidth = this.mScaledWidth;
        int newHeight = this.mScaledHeight;
        if (!new File(this.mDecodedFilename).exists()) {
            FileOutputStream fl = new FileOutputStream(this.mDecodedFilename);
            DataOutputStream dos = new DataOutputStream(fl);
            int[] framingBuffer = new int[newWidth];
            ByteBuffer byteBuffer = ByteBuffer.allocate(framingBuffer.length * 4);
            byte[] array2 = byteBuffer.array();
            for (int tmp = 0; tmp < newHeight; ++tmp) {
                imageBitmap.getPixels(framingBuffer, 0, this.mScaledWidth, 0, tmp, newWidth, 1);
                IntBuffer intBuffer = byteBuffer.asIntBuffer();
                intBuffer.put(framingBuffer, 0, newWidth);
                dos.write(array2);
            }
            fl.close();
        }
        imageBitmap.recycle();
    }

    @Override
    public int getFileType() {
        if (this.mFilename.endsWith(".jpg") || this.mFilename.endsWith(".jpeg") || this.mFilename.endsWith(".JPG") || this.mFilename.endsWith(".JPEG")) {
            return 5;
        }
        if (this.mFilename.endsWith(".png") || this.mFilename.endsWith(".PNG")) {
            return 8;
        }
        return 255;
    }

    String getScaledImageFileName() {
        return this.mScaledFilename;
    }

    int getGeneratedClipHeight() {
        return this.mGeneratedClipHeight;
    }

    int getGeneratedClipWidth() {
        return this.mGeneratedClipWidth;
    }

    String getDecodedImageFileName() {
        return this.mDecodedFilename;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    public int getScaledWidth() {
        return this.mScaledWidth;
    }

    public int getScaledHeight() {
        return this.mScaledHeight;
    }

    @Override
    public int getAspectRatio() {
        return this.mAspectRatio;
    }

    public void setDuration(long durationMs) {
        if (durationMs == this.mDurationMs) {
            return;
        }
        this.mMANativeHelper.setGeneratePreview(true);
        this.invalidateEndTransition();
        this.mDurationMs = durationMs;
        this.adjustTransitions();
        List<Overlay> adjustedOverlays = this.adjustOverlays();
        List<Effect> adjustedEffects = this.adjustEffects();
        this.invalidateBeginTransition(adjustedEffects, adjustedOverlays);
        this.invalidateEndTransition();
        if (this.getGeneratedImageClip() != null) {
            new File(this.getGeneratedImageClip()).delete();
            this.setGeneratedImageClip(null);
            super.setRegenerateClip(true);
        }
        this.mVideoEditor.updateTimelineDuration();
    }

    private void invalidateBeginTransition(List<Effect> effects, List<Overlay> overlays) {
        if (this.mBeginTransition != null && this.mBeginTransition.isGenerated()) {
            long transitionDurationMs = this.mBeginTransition.getDuration();
            for (Effect effect : effects) {
                if (effect.getStartTime() >= transitionDurationMs) continue;
                this.mBeginTransition.invalidate();
                break;
            }
            if (this.mBeginTransition.isGenerated()) {
                for (Overlay overlay : overlays) {
                    if (overlay.getStartTime() >= transitionDurationMs) continue;
                    this.mBeginTransition.invalidate();
                    break;
                }
            }
        }
    }

    private void invalidateEndTransition() {
        if (this.mEndTransition != null && this.mEndTransition.isGenerated()) {
            long transitionDurationMs = this.mEndTransition.getDuration();
            List<Effect> effects = this.getAllEffects();
            for (Effect effect : effects) {
                if (effect.getStartTime() + effect.getDuration() <= this.mDurationMs - transitionDurationMs) continue;
                this.mEndTransition.invalidate();
                break;
            }
            if (this.mEndTransition.isGenerated()) {
                List<Overlay> overlays = this.getAllOverlays();
                for (Overlay overlay : overlays) {
                    if (overlay.getStartTime() + overlay.getDuration() <= this.mDurationMs - transitionDurationMs) continue;
                    this.mEndTransition.invalidate();
                    break;
                }
            }
        }
    }

    private List<Effect> adjustEffects() {
        ArrayList<Effect> adjustedEffects = new ArrayList<Effect>();
        List<Effect> effects = this.getAllEffects();
        for (Effect effect : effects) {
            long effectStartTimeMs = effect.getStartTime() > this.getDuration() ? 0L : effect.getStartTime();
            long effectDurationMs = effectStartTimeMs + effect.getDuration() > this.getDuration() ? this.getDuration() - effectStartTimeMs : effect.getDuration();
            if (effectStartTimeMs == effect.getStartTime() && effectDurationMs == effect.getDuration()) continue;
            effect.setStartTimeAndDuration(effectStartTimeMs, effectDurationMs);
            adjustedEffects.add(effect);
        }
        return adjustedEffects;
    }

    private List<Overlay> adjustOverlays() {
        ArrayList<Overlay> adjustedOverlays = new ArrayList<Overlay>();
        List<Overlay> overlays = this.getAllOverlays();
        for (Overlay overlay : overlays) {
            long overlayStartTimeMs = overlay.getStartTime() > this.getDuration() ? 0L : overlay.getStartTime();
            long overlayDurationMs = overlayStartTimeMs + overlay.getDuration() > this.getDuration() ? this.getDuration() - overlayStartTimeMs : overlay.getDuration();
            if (overlayStartTimeMs == overlay.getStartTime() && overlayDurationMs == overlay.getDuration()) continue;
            overlay.setStartTimeAndDuration(overlayStartTimeMs, overlayDurationMs);
            adjustedOverlays.add(overlay);
        }
        return adjustedOverlays;
    }

    private int getWidthByAspectRatioAndHeight(int aspectRatio, int height) {
        int width = 0;
        switch (aspectRatio) {
            case 1: {
                if (height == 480) {
                    width = 720;
                    break;
                }
                if (height != 720) break;
                width = 1080;
                break;
            }
            case 2: {
                if (height == 360) {
                    width = 640;
                    break;
                }
                if (height == 480) {
                    width = 854;
                    break;
                }
                if (height == 720) {
                    width = 1280;
                    break;
                }
                if (height != 1080) break;
                width = 1920;
                break;
            }
            case 3: {
                if (height == 480) {
                    width = 640;
                }
                if (height != 720) break;
                width = 960;
                break;
            }
            case 4: {
                if (height != 480) break;
                width = 800;
                break;
            }
            case 5: {
                if (height != 144) break;
                width = 176;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal arguments for aspectRatio");
            }
        }
        return width;
    }

    @Override
    void setGeneratedImageClip(String generatedFilePath) {
        super.setGeneratedImageClip(generatedFilePath);
        this.mGeneratedClipHeight = this.getScaledHeight();
        this.mGeneratedClipWidth = this.getWidthByAspectRatioAndHeight(this.mVideoEditor.getAspectRatio(), this.mGeneratedClipHeight);
    }

    @Override
    String getGeneratedImageClip() {
        return super.getGeneratedImageClip();
    }

    @Override
    public long getDuration() {
        return this.mDurationMs;
    }

    @Override
    public long getTimelineDuration() {
        return this.mDurationMs;
    }

    @Override
    public Bitmap getThumbnail(int width, int height, long timeMs) throws IOException {
        if (this.getGeneratedImageClip() != null) {
            return this.mMANativeHelper.getPixels(this.getGeneratedImageClip(), width, height, timeMs, 0);
        }
        return this.scaleImage(this.mFilename, width, height);
    }

    @Override
    public void getThumbnailList(int width, int height, long startMs, long endMs, int thumbnailCount, int[] indices, MediaItem.GetThumbnailListCallback callback) throws IOException {
        if (this.getGeneratedImageClip() == null) {
            Bitmap thumbnail = this.scaleImage(this.mFilename, width, height);
            for (int i = 0; i < indices.length; ++i) {
                callback.onThumbnail(thumbnail, indices[i]);
            }
        } else {
            if (startMs > endMs) {
                throw new IllegalArgumentException("Start time is greater than end time");
            }
            if (endMs > this.mDurationMs) {
                throw new IllegalArgumentException("End time is greater than file duration");
            }
            this.mMANativeHelper.getPixelsList(this.getGeneratedImageClip(), width, height, startMs, endMs, thumbnailCount, indices, callback, 0);
        }
    }

    @Override
    void invalidateTransitions(long startTimeMs, long durationMs) {
        if (this.mBeginTransition != null && this.isOverlapping(startTimeMs, durationMs, 0L, this.mBeginTransition.getDuration())) {
            this.mBeginTransition.invalidate();
        }
        if (this.mEndTransition != null) {
            long transitionDurationMs = this.mEndTransition.getDuration();
            if (this.isOverlapping(startTimeMs, durationMs, this.getDuration() - transitionDurationMs, transitionDurationMs)) {
                this.mEndTransition.invalidate();
            }
        }
    }

    @Override
    void invalidateTransitions(long oldStartTimeMs, long oldDurationMs, long newStartTimeMs, long newDurationMs) {
        boolean newOverlap;
        boolean oldOverlap;
        long transitionDurationMs;
        if (this.mBeginTransition != null) {
            transitionDurationMs = this.mBeginTransition.getDuration();
            oldOverlap = this.isOverlapping(oldStartTimeMs, oldDurationMs, 0L, transitionDurationMs);
            newOverlap = this.isOverlapping(newStartTimeMs, newDurationMs, 0L, transitionDurationMs);
            if (newOverlap != oldOverlap) {
                this.mBeginTransition.invalidate();
            } else if (newOverlap && (oldStartTimeMs != newStartTimeMs || oldStartTimeMs + oldDurationMs <= transitionDurationMs || newStartTimeMs + newDurationMs <= transitionDurationMs)) {
                this.mBeginTransition.invalidate();
            }
        }
        if (this.mEndTransition != null) {
            transitionDurationMs = this.mEndTransition.getDuration();
            oldOverlap = this.isOverlapping(oldStartTimeMs, oldDurationMs, this.mDurationMs - transitionDurationMs, transitionDurationMs);
            newOverlap = this.isOverlapping(newStartTimeMs, newDurationMs, this.mDurationMs - transitionDurationMs, transitionDurationMs);
            if (newOverlap != oldOverlap) {
                this.mEndTransition.invalidate();
            } else if (newOverlap && (oldStartTimeMs + oldDurationMs != newStartTimeMs + newDurationMs || oldStartTimeMs > this.mDurationMs - transitionDurationMs || newStartTimeMs > this.mDurationMs - transitionDurationMs)) {
                this.mEndTransition.invalidate();
            }
        }
    }

    void invalidate() {
        if (this.getGeneratedImageClip() != null) {
            new File(this.getGeneratedImageClip()).delete();
            this.setGeneratedImageClip(null);
            this.setRegenerateClip(true);
        }
        if (this.mScaledFilename != null) {
            if (this.mFileName != this.mScaledFilename) {
                new File(this.mScaledFilename).delete();
            }
            this.mScaledFilename = null;
        }
        if (this.mDecodedFilename != null) {
            new File(this.mDecodedFilename).delete();
            this.mDecodedFilename = null;
        }
    }

    private MediaArtistNativeHelper.ClipSettings getKenBurns(EffectKenBurns effectKB) {
        int width = 0;
        int height = 0;
        Rect start = new Rect();
        Rect end = new Rect();
        MediaArtistNativeHelper.ClipSettings clipSettings = null;
        clipSettings = new MediaArtistNativeHelper.ClipSettings();
        effectKB.getKenBurnsSettings(start, end);
        width = this.getWidth();
        height = this.getHeight();
        if (start.left < 0 || start.left > width || start.right < 0 || start.right > width || start.top < 0 || start.top > height || start.bottom < 0 || start.bottom > height || end.left < 0 || end.left > width || end.right < 0 || end.right > width || end.top < 0 || end.top > height || end.bottom < 0 || end.bottom > height) {
            throw new IllegalArgumentException("Illegal arguments for KebBurns");
        }
        if (!(width - (start.right - start.left) != 0 && height - (start.bottom - start.top) != 0 || width - (end.right - end.left) != 0 && height - (end.bottom - end.top) != 0)) {
            this.setRegenerateClip(false);
            clipSettings.clipPath = this.getDecodedImageFileName();
            clipSettings.fileType = 5;
            clipSettings.beginCutTime = 0;
            clipSettings.endCutTime = (int)this.getTimelineDuration();
            clipSettings.beginCutPercent = 0;
            clipSettings.endCutPercent = 0;
            clipSettings.panZoomEnabled = false;
            clipSettings.panZoomPercentStart = 0;
            clipSettings.panZoomTopLeftXStart = 0;
            clipSettings.panZoomTopLeftYStart = 0;
            clipSettings.panZoomPercentEnd = 0;
            clipSettings.panZoomTopLeftXEnd = 0;
            clipSettings.panZoomTopLeftYEnd = 0;
            clipSettings.mediaRendering = this.mMANativeHelper.getMediaItemRenderingMode(this.getRenderingMode());
            clipSettings.rgbWidth = this.getScaledWidth();
            clipSettings.rgbHeight = this.getScaledHeight();
            return clipSettings;
        }
        int PanZoomXa = 1000 * start.width() / width;
        int PanZoomXb = 1000 * end.width() / width;
        clipSettings.clipPath = this.getDecodedImageFileName();
        clipSettings.fileType = this.mMANativeHelper.getMediaItemFileType(this.getFileType());
        clipSettings.beginCutTime = 0;
        clipSettings.endCutTime = (int)this.getTimelineDuration();
        clipSettings.beginCutPercent = 0;
        clipSettings.endCutPercent = 0;
        clipSettings.panZoomEnabled = true;
        clipSettings.panZoomPercentStart = PanZoomXa;
        clipSettings.panZoomTopLeftXStart = start.left * 1000 / width;
        clipSettings.panZoomTopLeftYStart = start.top * 1000 / height;
        clipSettings.panZoomPercentEnd = PanZoomXb;
        clipSettings.panZoomTopLeftXEnd = end.left * 1000 / width;
        clipSettings.panZoomTopLeftYEnd = end.top * 1000 / height;
        clipSettings.mediaRendering = this.mMANativeHelper.getMediaItemRenderingMode(this.getRenderingMode());
        clipSettings.rgbWidth = this.getScaledWidth();
        clipSettings.rgbHeight = this.getScaledHeight();
        return clipSettings;
    }

    MediaArtistNativeHelper.ClipSettings generateKenburnsClip(EffectKenBurns effectKB) {
        MediaArtistNativeHelper.EditSettings editSettings = new MediaArtistNativeHelper.EditSettings();
        editSettings.clipSettingsArray = new MediaArtistNativeHelper.ClipSettings[1];
        String output = null;
        MediaArtistNativeHelper.ClipSettings clipSettings = new MediaArtistNativeHelper.ClipSettings();
        this.initClipSettings(clipSettings);
        editSettings.clipSettingsArray[0] = this.getKenBurns(effectKB);
        if (this.getGeneratedImageClip() == null && this.getRegenerateClip()) {
            output = this.mMANativeHelper.generateKenBurnsClip(editSettings, this);
            this.setGeneratedImageClip(output);
            this.setRegenerateClip(false);
            clipSettings.clipPath = output;
            clipSettings.fileType = 0;
            this.mGeneratedClipHeight = this.getScaledHeight();
            this.mGeneratedClipWidth = this.getWidthByAspectRatioAndHeight(this.mVideoEditor.getAspectRatio(), this.mGeneratedClipHeight);
        } else if (this.getGeneratedImageClip() == null) {
            clipSettings.clipPath = this.getDecodedImageFileName();
            clipSettings.fileType = 5;
            clipSettings.rgbWidth = this.getScaledWidth();
            clipSettings.rgbHeight = this.getScaledHeight();
        } else {
            clipSettings.clipPath = this.getGeneratedImageClip();
            clipSettings.fileType = 0;
        }
        clipSettings.mediaRendering = this.mMANativeHelper.getMediaItemRenderingMode(this.getRenderingMode());
        clipSettings.beginCutTime = 0;
        clipSettings.endCutTime = (int)this.getTimelineDuration();
        return clipSettings;
    }

    MediaArtistNativeHelper.ClipSettings getImageClipProperties() {
        MediaArtistNativeHelper.ClipSettings clipSettings = new MediaArtistNativeHelper.ClipSettings();
        List<Effect> effects = null;
        EffectKenBurns effectKB = null;
        boolean effectKBPresent = false;
        effects = this.getAllEffects();
        for (Effect effect : effects) {
            if (!(effect instanceof EffectKenBurns)) continue;
            effectKB = (EffectKenBurns)effect;
            effectKBPresent = true;
            break;
        }
        if (effectKBPresent) {
            clipSettings = this.generateKenburnsClip(effectKB);
        } else {
            this.initClipSettings(clipSettings);
            clipSettings.clipPath = this.getDecodedImageFileName();
            clipSettings.fileType = 5;
            clipSettings.beginCutTime = 0;
            clipSettings.endCutTime = (int)this.getTimelineDuration();
            clipSettings.mediaRendering = this.mMANativeHelper.getMediaItemRenderingMode(this.getRenderingMode());
            clipSettings.rgbWidth = this.getScaledWidth();
            clipSettings.rgbHeight = this.getScaledHeight();
        }
        return clipSettings;
    }

    private Bitmap scaleImage(String filename, int width, int height) throws IOException {
        Bitmap srcBitmap;
        float bitmapHeight;
        float bitmapWidth;
        BitmapFactory.Options dbo = new BitmapFactory.Options();
        dbo.inJustDecodeBounds = true;
        BitmapFactory.decodeFile(filename, dbo);
        int nativeWidth = dbo.outWidth;
        int nativeHeight = dbo.outHeight;
        if (Log.isLoggable(TAG, 3)) {
            Log.d(TAG, "generateThumbnail: Input: " + nativeWidth + "x" + nativeHeight + ", resize to: " + width + "x" + height);
        }
        if (nativeWidth > width || nativeHeight > height) {
            float dx = (float)nativeWidth / (float)width;
            float dy = (float)nativeHeight / (float)height;
            if (dx > dy) {
                bitmapWidth = width;
                bitmapHeight = (float)nativeHeight / dx < (float)height ? (float)Math.ceil((float)nativeHeight / dx) : (float)Math.floor((float)nativeHeight / dx);
            } else {
                bitmapWidth = (float)nativeWidth / dy > (float)width ? (float)Math.floor((float)nativeWidth / dy) : (float)Math.ceil((float)nativeWidth / dy);
                bitmapHeight = height;
            }
            int sampleSize = (int)Math.ceil(Math.max((float)nativeWidth / bitmapWidth, (float)nativeHeight / bitmapHeight));
            sampleSize = MediaImageItem.nextPowerOf2(sampleSize);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inSampleSize = sampleSize;
            srcBitmap = BitmapFactory.decodeFile(filename, options);
        } else {
            bitmapWidth = width;
            bitmapHeight = height;
            srcBitmap = BitmapFactory.decodeFile(filename);
        }
        if (srcBitmap == null) {
            Log.e(TAG, "generateThumbnail: Cannot decode image bytes");
            throw new IOException("Cannot decode file: " + this.mFilename);
        }
        Bitmap bitmap = Bitmap.createBitmap((int)bitmapWidth, (int)bitmapHeight, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawBitmap(srcBitmap, new Rect(0, 0, srcBitmap.getWidth(), srcBitmap.getHeight()), new Rect(0, 0, (int)bitmapWidth, (int)bitmapHeight), sResizePaint);
        canvas.setBitmap(null);
        srcBitmap.recycle();
        return bitmap;
    }

    public static int nextPowerOf2(int n) {
        --n;
        n |= n >>> 16;
        n |= n >>> 8;
        n |= n >>> 4;
        n |= n >>> 2;
        n |= n >>> 1;
        return n + 1;
    }
}

