/*
 * Decompiled with CFR 0.152.
 */
package android.media.videoeditor;

public class VideoEditorProfile {
    public int maxInputVideoFrameWidth;
    public int maxInputVideoFrameHeight;
    public int maxOutputVideoFrameWidth;
    public int maxOutputVideoFrameHeight;

    public static VideoEditorProfile get() {
        return VideoEditorProfile.native_get_videoeditor_profile();
    }

    public static int getExportProfile(int vidCodec) {
        int profile = -1;
        switch (vidCodec) {
            case 1: 
            case 2: 
            case 3: {
                profile = VideoEditorProfile.native_get_videoeditor_export_profile(vidCodec);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported video codec" + vidCodec);
            }
        }
        return profile;
    }

    public static int getExportLevel(int vidCodec) {
        int level = -1;
        switch (vidCodec) {
            case 1: 
            case 2: 
            case 3: {
                level = VideoEditorProfile.native_get_videoeditor_export_level(vidCodec);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported video codec" + vidCodec);
            }
        }
        return level;
    }

    private VideoEditorProfile(int inputWidth, int inputHeight, int outputWidth, int outputHeight) {
        this.maxInputVideoFrameWidth = inputWidth;
        this.maxInputVideoFrameHeight = inputHeight;
        this.maxOutputVideoFrameWidth = outputWidth;
        this.maxOutputVideoFrameHeight = outputHeight;
    }

    private static final native void native_init();

    private static final native VideoEditorProfile native_get_videoeditor_profile();

    private static final native int native_get_videoeditor_export_profile(int var0);

    private static final native int native_get_videoeditor_export_level(int var0);

    static {
        System.loadLibrary("media_jni");
        VideoEditorProfile.native_init();
    }
}

