/*
 * Decompiled with CFR 0.152.
 */
package android.mtp;

import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.media.MediaScanner;
import android.mtp.MtpPropertyGroup;
import android.mtp.MtpPropertyList;
import android.mtp.MtpStorage;
import android.net.Uri;
import android.os.RemoteException;
import android.provider.MediaStore;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;

public class MtpDatabase {
    private static final String TAG = "MtpDatabase";
    private final Context mContext;
    private final IContentProvider mMediaProvider;
    private final String mVolumeName;
    private final Uri mObjectsUri;
    private final String mMediaStoragePath;
    private final String[] mSubDirectories;
    private String mSubDirectoriesWhere;
    private String[] mSubDirectoriesWhereArgs;
    private final HashMap<String, MtpStorage> mStorageMap = new HashMap();
    private final HashMap<Integer, MtpPropertyGroup> mPropertyGroupsByProperty = new HashMap();
    private final HashMap<Integer, MtpPropertyGroup> mPropertyGroupsByFormat = new HashMap();
    private boolean mDatabaseModified;
    private SharedPreferences mDeviceProperties;
    private static final int DEVICE_PROPERTIES_DATABASE_VERSION = 1;
    private static final String[] ID_PROJECTION = new String[]{"_id"};
    private static final String[] PATH_PROJECTION = new String[]{"_id", "_data"};
    private static final String[] PATH_SIZE_FORMAT_PROJECTION = new String[]{"_id", "_data", "_size", "format"};
    private static final String[] OBJECT_INFO_PROJECTION = new String[]{"_id", "storage_id", "format", "parent", "_data", "_size", "date_modified"};
    private static final String ID_WHERE = "_id=?";
    private static final String PATH_WHERE = "_data=?";
    private static final String STORAGE_WHERE = "storage_id=?";
    private static final String FORMAT_WHERE = "parent=?";
    private static final String PARENT_WHERE = "format=?";
    private static final String STORAGE_FORMAT_WHERE = "storage_id=? AND format=?";
    private static final String STORAGE_PARENT_WHERE = "storage_id=? AND parent=?";
    private static final String FORMAT_PARENT_WHERE = "parent=? AND parent=?";
    private static final String STORAGE_FORMAT_PARENT_WHERE = "storage_id=? AND format=? AND parent=?";
    private final MediaScanner mMediaScanner;
    static final int[] FILE_PROPERTIES;
    static final int[] AUDIO_PROPERTIES;
    static final int[] VIDEO_PROPERTIES;
    static final int[] IMAGE_PROPERTIES;
    static final int[] ALL_PROPERTIES;
    private int mNativeContext;

    public MtpDatabase(Context context, String volumeName, String storagePath, String[] subDirectories) {
        Locale locale;
        this.native_setup();
        this.mContext = context;
        this.mMediaProvider = context.getContentResolver().acquireProvider("media");
        this.mVolumeName = volumeName;
        this.mMediaStoragePath = storagePath;
        this.mObjectsUri = MediaStore.Files.getMtpObjectsUri(volumeName);
        this.mMediaScanner = new MediaScanner(context);
        this.mSubDirectories = subDirectories;
        if (subDirectories != null) {
            int i;
            StringBuilder builder = new StringBuilder();
            builder.append("(");
            int count = subDirectories.length;
            for (i = 0; i < count; ++i) {
                builder.append("_data=? OR _data LIKE ?");
                if (i == count - 1) continue;
                builder.append(" OR ");
            }
            builder.append(")");
            this.mSubDirectoriesWhere = builder.toString();
            this.mSubDirectoriesWhereArgs = new String[count * 2];
            int j = 0;
            for (i = 0; i < count; ++i) {
                String path = subDirectories[i];
                this.mSubDirectoriesWhereArgs[j++] = path;
                this.mSubDirectoriesWhereArgs[j++] = path + "/%";
            }
        }
        if ((locale = context.getResources().getConfiguration().locale) != null) {
            String language = locale.getLanguage();
            String country = locale.getCountry();
            if (language != null) {
                if (country != null) {
                    this.mMediaScanner.setLocale(language + "_" + country);
                } else {
                    this.mMediaScanner.setLocale(language);
                }
            }
        }
        this.initDeviceProperties(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.native_finalize();
        }
        finally {
            super.finalize();
        }
    }

    public void addStorage(MtpStorage storage) {
        this.mStorageMap.put(storage.getPath(), storage);
    }

    public void removeStorage(MtpStorage storage) {
        this.mStorageMap.remove(storage.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDeviceProperties(Context context) {
        String devicePropertiesName = "device-properties";
        this.mDeviceProperties = context.getSharedPreferences("device-properties", 0);
        File databaseFile = context.getDatabasePath("device-properties");
        if (databaseFile.exists()) {
            SQLiteDatabase db = null;
            Cursor c = null;
            try {
                db = context.openOrCreateDatabase("device-properties", 0, null);
                if (db != null && (c = db.query("properties", new String[]{"_id", "code", "value"}, null, null, null, null, null)) != null) {
                    SharedPreferences.Editor e = this.mDeviceProperties.edit();
                    while (c.moveToNext()) {
                        String name = c.getString(1);
                        String value = c.getString(2);
                        e.putString(name, value);
                    }
                    e.commit();
                }
            }
            catch (Exception e) {
                Log.e(TAG, "failed to migrate device properties", e);
            }
            finally {
                if (c != null) {
                    c.close();
                }
                if (db != null) {
                    db.close();
                }
            }
            databaseFile.delete();
        }
    }

    private boolean inStorageSubDirectory(String path) {
        if (this.mSubDirectories == null) {
            return true;
        }
        if (path == null) {
            return false;
        }
        boolean allowed = false;
        int pathLength = path.length();
        for (int i = 0; i < this.mSubDirectories.length && !allowed; ++i) {
            String subdir = this.mSubDirectories[i];
            int subdirLength = subdir.length();
            if (subdirLength >= pathLength || path.charAt(subdirLength) != '/' || !path.startsWith(subdir)) continue;
            allowed = true;
        }
        return allowed;
    }

    private boolean isStorageSubDirectory(String path) {
        if (this.mSubDirectories == null) {
            return false;
        }
        for (int i = 0; i < this.mSubDirectories.length; ++i) {
            if (!path.equals(this.mSubDirectories[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int beginSendObject(String path, int format, int parent, int storageId, long size, long modified) {
        if (!this.inStorageSubDirectory(path)) {
            return -1;
        }
        if (path != null) {
            Cursor c = null;
            try {
                c = this.mMediaProvider.query(this.mObjectsUri, ID_PROJECTION, PATH_WHERE, new String[]{path}, null);
                if (c != null && c.getCount() > 0) {
                    Log.w(TAG, "file already exists in beginSendObject: " + path);
                    int n = -1;
                    return n;
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException in beginSendObject", e);
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
        }
        this.mDatabaseModified = true;
        ContentValues values = new ContentValues();
        values.put("_data", path);
        values.put("format", format);
        values.put("parent", parent);
        values.put("storage_id", storageId);
        values.put("_size", size);
        values.put("date_modified", modified);
        try {
            Uri uri = this.mMediaProvider.insert(this.mObjectsUri, values);
            if (uri != null) {
                return Integer.parseInt(uri.getPathSegments().get(2));
            }
            return -1;
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in beginSendObject", e);
            return -1;
        }
    }

    private void endSendObject(String path, int handle, int format, boolean succeeded) {
        if (succeeded) {
            if (format == 47621) {
                String name = path;
                int lastSlash = name.lastIndexOf(47);
                if (lastSlash >= 0) {
                    name = name.substring(lastSlash + 1);
                }
                if (name.endsWith(".pla")) {
                    name = name.substring(0, name.length() - 4);
                }
                ContentValues values = new ContentValues(1);
                values.put("_data", path);
                values.put("name", name);
                values.put("format", format);
                values.put("date_modified", System.currentTimeMillis() / 1000L);
                values.put("media_scanner_new_object_id", handle);
                try {
                    Uri uri = this.mMediaProvider.insert(MediaStore.Audio.Playlists.EXTERNAL_CONTENT_URI, values);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "RemoteException in endSendObject", e);
                }
            } else {
                this.mMediaScanner.scanMtpFile(path, this.mVolumeName, handle, format);
            }
        } else {
            this.deleteFile(handle);
        }
    }

    private Cursor createObjectQuery(int storageID, int format, int parent) throws RemoteException {
        String[] whereArgs;
        String where;
        if (storageID == -1) {
            if (format == 0) {
                if (parent == 0) {
                    where = null;
                    whereArgs = null;
                } else {
                    if (parent == -1) {
                        parent = 0;
                    }
                    where = PARENT_WHERE;
                    whereArgs = new String[]{Integer.toString(parent)};
                }
            } else if (parent == 0) {
                where = FORMAT_WHERE;
                whereArgs = new String[]{Integer.toString(format)};
            } else {
                if (parent == -1) {
                    parent = 0;
                }
                where = FORMAT_PARENT_WHERE;
                whereArgs = new String[]{Integer.toString(format), Integer.toString(parent)};
            }
        } else if (format == 0) {
            if (parent == 0) {
                where = STORAGE_WHERE;
                whereArgs = new String[]{Integer.toString(storageID)};
            } else {
                if (parent == -1) {
                    parent = 0;
                }
                where = STORAGE_PARENT_WHERE;
                whereArgs = new String[]{Integer.toString(storageID), Integer.toString(parent)};
            }
        } else if (parent == 0) {
            where = STORAGE_FORMAT_WHERE;
            whereArgs = new String[]{Integer.toString(storageID), Integer.toString(format)};
        } else {
            if (parent == -1) {
                parent = 0;
            }
            where = STORAGE_FORMAT_PARENT_WHERE;
            whereArgs = new String[]{Integer.toString(storageID), Integer.toString(format), Integer.toString(parent)};
        }
        if (this.mSubDirectoriesWhere != null) {
            if (where == null) {
                where = this.mSubDirectoriesWhere;
                whereArgs = this.mSubDirectoriesWhereArgs;
            } else {
                int i;
                where = where + " AND " + this.mSubDirectoriesWhere;
                String[] newWhereArgs = new String[whereArgs.length + this.mSubDirectoriesWhereArgs.length];
                for (i = 0; i < whereArgs.length; ++i) {
                    newWhereArgs[i] = whereArgs[i];
                }
                for (int j = 0; j < this.mSubDirectoriesWhereArgs.length; ++j) {
                    newWhereArgs[i] = this.mSubDirectoriesWhereArgs[j];
                    ++i;
                }
                whereArgs = newWhereArgs;
            }
        }
        return this.mMediaProvider.query(this.mObjectsUri, ID_PROJECTION, where, whereArgs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getObjectList(int storageID, int format, int parent) {
        Cursor c = null;
        try {
            c = this.createObjectQuery(storageID, format, parent);
            if (c == null) {
                int[] nArray = null;
                return nArray;
            }
            int count = c.getCount();
            if (count > 0) {
                int[] result = new int[count];
                for (int i = 0; i < count; ++i) {
                    c.moveToNext();
                    result[i] = c.getInt(0);
                }
                int[] nArray = result;
                return nArray;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in getObjectList", e);
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumObjects(int storageID, int format, int parent) {
        Cursor c = null;
        try {
            c = this.createObjectQuery(storageID, format, parent);
            if (c != null) {
                int n = c.getCount();
                return n;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in getNumObjects", e);
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return -1;
    }

    private int[] getSupportedPlaybackFormats() {
        return new int[]{12288, 12289, 12292, 12293, 12296, 12297, 12299, 14337, 14338, 14343, 14344, 14347, 14349, 47361, 47362, 47363, 47490, 47491, 47492, 47621, 47632, 47633, 47636, 47746, 47366};
    }

    private int[] getSupportedCaptureFormats() {
        return null;
    }

    private int[] getSupportedObjectProperties(int format) {
        switch (format) {
            case 12296: 
            case 12297: 
            case 47361: 
            case 47362: 
            case 47363: {
                return AUDIO_PROPERTIES;
            }
            case 12299: 
            case 47489: 
            case 47492: {
                return VIDEO_PROPERTIES;
            }
            case 14337: 
            case 14340: 
            case 14343: 
            case 14347: {
                return IMAGE_PROPERTIES;
            }
            case 0: {
                return ALL_PROPERTIES;
            }
        }
        return FILE_PROPERTIES;
    }

    private int[] getSupportedDeviceProperties() {
        return new int[]{54273, 54274, 20483};
    }

    private MtpPropertyList getObjectPropertyList(long handle, int format, long property, int groupCode, int depth) {
        MtpPropertyGroup propertyGroup;
        if (groupCode != 0) {
            return new MtpPropertyList(0, 43015);
        }
        if (property == 0xFFFFFFFFL) {
            propertyGroup = this.mPropertyGroupsByFormat.get(format);
            if (propertyGroup == null) {
                int[] propertyList = this.getSupportedObjectProperties(format);
                propertyGroup = new MtpPropertyGroup(this, this.mMediaProvider, this.mVolumeName, propertyList);
                this.mPropertyGroupsByFormat.put(new Integer(format), propertyGroup);
            }
        } else {
            propertyGroup = this.mPropertyGroupsByProperty.get(property);
            if (propertyGroup == null) {
                int[] propertyList = new int[]{(int)property};
                propertyGroup = new MtpPropertyGroup(this, this.mMediaProvider, this.mVolumeName, propertyList);
                this.mPropertyGroupsByProperty.put(new Integer((int)property), propertyGroup);
            }
        }
        return propertyGroup.getPropertyList((int)handle, format, depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int renameFile(int handle, String newName) {
        Cursor c = null;
        String path = null;
        String[] whereArgs = new String[]{Integer.toString(handle)};
        try {
            c = this.mMediaProvider.query(this.mObjectsUri, PATH_PROJECTION, ID_WHERE, whereArgs, null);
            if (c != null && c.moveToNext()) {
                path = c.getString(1);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in getObjectFilePath", e);
            int n = 8194;
            return n;
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        if (path == null) {
            return 8201;
        }
        if (this.isStorageSubDirectory(path)) {
            return 8205;
        }
        File oldFile = new File(path);
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash <= 1) {
            return 8194;
        }
        String newPath = path.substring(0, lastSlash + 1) + newName;
        File newFile = new File(newPath);
        boolean success = oldFile.renameTo(newFile);
        if (!success) {
            Log.w(TAG, "renaming " + path + " to " + newPath + " failed");
            return 8194;
        }
        ContentValues values = new ContentValues();
        values.put("_data", newPath);
        int updated = 0;
        try {
            updated = this.mMediaProvider.update(this.mObjectsUri, values, ID_WHERE, whereArgs);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in mMediaProvider.update", e);
        }
        if (updated == 0) {
            Log.e(TAG, "Unable to update path for " + path + " to " + newPath);
            newFile.renameTo(oldFile);
            return 8194;
        }
        return 8193;
    }

    private int setObjectProperty(int handle, int property, long intValue, String stringValue) {
        switch (property) {
            case 56327: {
                return this.renameFile(handle, stringValue);
            }
        }
        return 43018;
    }

    private int getDeviceProperty(int property, long[] outIntValue, char[] outStringValue) {
        switch (property) {
            case 54273: 
            case 54274: {
                String value = this.mDeviceProperties.getString(Integer.toString(property), "");
                int length = value.length();
                if (length > 255) {
                    length = 255;
                }
                value.getChars(0, length, outStringValue, 0);
                outStringValue[length] = '\u0000';
                return 8193;
            }
            case 20483: {
                Display display = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay();
                int width = display.getMaximumSizeDimension();
                int height = display.getMaximumSizeDimension();
                String imageSize = Integer.toString(width) + "x" + Integer.toString(height);
                imageSize.getChars(0, imageSize.length(), outStringValue, 0);
                outStringValue[imageSize.length()] = '\u0000';
                return 8193;
            }
        }
        return 8202;
    }

    private int setDeviceProperty(int property, long intValue, String stringValue) {
        switch (property) {
            case 54273: 
            case 54274: {
                SharedPreferences.Editor e = this.mDeviceProperties.edit();
                e.putString(Integer.toString(property), stringValue);
                return e.commit() ? 8193 : 8194;
            }
        }
        return 8202;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getObjectInfo(int handle, int[] outStorageFormatParent, char[] outName, long[] outSizeModified) {
        Cursor c = null;
        try {
            c = this.mMediaProvider.query(this.mObjectsUri, OBJECT_INFO_PROJECTION, ID_WHERE, new String[]{Integer.toString(handle)}, null);
            if (c != null && c.moveToNext()) {
                outStorageFormatParent[0] = c.getInt(1);
                outStorageFormatParent[1] = c.getInt(2);
                outStorageFormatParent[2] = c.getInt(3);
                String path = c.getString(4);
                int lastSlash = path.lastIndexOf(47);
                int start = lastSlash >= 0 ? lastSlash + 1 : 0;
                int end = path.length();
                if (end - start > 255) {
                    end = start + 255;
                }
                path.getChars(start, end, outName, 0);
                outName[end - start] = '\u0000';
                outSizeModified[0] = c.getLong(5);
                outSizeModified[1] = c.getLong(6);
                boolean bl = true;
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in getObjectInfo", e);
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getObjectFilePath(int handle, char[] outFilePath, long[] outFileLengthFormat) {
        if (handle == 0) {
            this.mMediaStoragePath.getChars(0, this.mMediaStoragePath.length(), outFilePath, 0);
            outFilePath[this.mMediaStoragePath.length()] = '\u0000';
            outFileLengthFormat[0] = 0L;
            outFileLengthFormat[1] = 12289L;
            return 8193;
        }
        Cursor c = null;
        try {
            c = this.mMediaProvider.query(this.mObjectsUri, PATH_SIZE_FORMAT_PROJECTION, ID_WHERE, new String[]{Integer.toString(handle)}, null);
            if (c != null && c.moveToNext()) {
                String path = c.getString(1);
                path.getChars(0, path.length(), outFilePath, 0);
                outFilePath[path.length()] = '\u0000';
                outFileLengthFormat[0] = c.getLong(2);
                outFileLengthFormat[1] = c.getLong(3);
                int n = 8193;
                return n;
            }
            int path = 8201;
            return path;
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in getObjectFilePath", e);
            int n = 8194;
            return n;
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteFile(int handle) {
        int n;
        this.mDatabaseModified = true;
        String path = null;
        int format = 0;
        Cursor c = null;
        try {
            Uri uri;
            c = this.mMediaProvider.query(this.mObjectsUri, PATH_SIZE_FORMAT_PROJECTION, ID_WHERE, new String[]{Integer.toString(handle)}, null);
            if (c == null || !c.moveToNext()) {
                int n2 = 8201;
                return n2;
            }
            path = c.getString(1);
            format = c.getInt(3);
            if (path == null || format == 0) {
                int n3 = 8194;
                return n3;
            }
            if (this.isStorageSubDirectory(path)) {
                int n4 = 8205;
                return n4;
            }
            if (format == 12289) {
                uri = MediaStore.Files.getMtpObjectsUri(this.mVolumeName);
                int count = this.mMediaProvider.delete(uri, "_data LIKE ?", new String[]{path + "/%"});
            }
            if (this.mMediaProvider.delete(uri = MediaStore.Files.getMtpObjectsUri(this.mVolumeName, handle), null, null) > 0) {
                n = 8193;
                return n;
            }
            n = 8201;
            return n;
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in deleteFile", e);
            n = 8194;
            return n;
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getObjectReferences(int handle) {
        Uri uri = MediaStore.Files.getMtpReferencesUri(this.mVolumeName, handle);
        Cursor c = null;
        try {
            c = this.mMediaProvider.query(uri, ID_PROJECTION, null, null, null);
            if (c == null) {
                int[] nArray = null;
                return nArray;
            }
            int count = c.getCount();
            if (count > 0) {
                int[] result = new int[count];
                for (int i = 0; i < count; ++i) {
                    c.moveToNext();
                    result[i] = c.getInt(0);
                }
                int[] nArray = result;
                return nArray;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in getObjectList", e);
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return null;
    }

    private int setObjectReferences(int handle, int[] references) {
        this.mDatabaseModified = true;
        Uri uri = MediaStore.Files.getMtpReferencesUri(this.mVolumeName, handle);
        int count = references.length;
        ContentValues[] valuesList = new ContentValues[count];
        for (int i = 0; i < count; ++i) {
            ContentValues values = new ContentValues();
            values.put("_id", references[i]);
            valuesList[i] = values;
        }
        try {
            if (this.mMediaProvider.bulkInsert(uri, valuesList) > 0) {
                return 8193;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in setObjectReferences", e);
        }
        return 8194;
    }

    private void sessionStarted() {
        this.mDatabaseModified = false;
    }

    private void sessionEnded() {
        if (this.mDatabaseModified) {
            this.mContext.sendBroadcast(new Intent("android.provider.action.MTP_SESSION_END"));
            this.mDatabaseModified = false;
        }
    }

    private final native void native_setup();

    private final native void native_finalize();

    static {
        System.loadLibrary("media_jni");
        FILE_PROPERTIES = new int[]{56321, 56322, 56323, 56324, 56327, 56329, 56331, 56385, 56388, 56398};
        AUDIO_PROPERTIES = new int[]{56321, 56322, 56323, 56324, 56327, 56329, 56331, 56385, 56388, 56544, 56398, 56390, 56474, 56475, 56459, 56473, 56457, 56460, 56470};
        VIDEO_PROPERTIES = new int[]{56321, 56322, 56323, 56324, 56327, 56329, 56331, 56385, 56388, 56544, 56398, 56390, 56474, 56457, 56392};
        IMAGE_PROPERTIES = new int[]{56321, 56322, 56323, 56324, 56327, 56329, 56331, 56385, 56388, 56544, 56398, 56392};
        ALL_PROPERTIES = new int[]{56321, 56322, 56323, 56324, 56327, 56329, 56331, 56385, 56388, 56544, 56398, 56392, 56390, 56474, 56475, 56459, 56473, 56457, 56460, 56470, 56390, 56474, 56457, 56392, 56392};
    }
}

