/*
 * Decompiled with CFR 0.152.
 */
package android.mtp;

import android.os.storage.StorageVolume;

public class MtpStorage {
    private final int mStorageId;
    private final String mPath;
    private final String mDescription;
    private final long mReserveSpace;
    private final boolean mRemovable;
    private final long mMaxFileSize;

    public MtpStorage(StorageVolume volume) {
        this.mStorageId = volume.getStorageId();
        this.mPath = volume.getPath();
        this.mDescription = volume.getDescription();
        this.mReserveSpace = volume.getMtpReserveSpace();
        this.mRemovable = volume.isRemovable();
        this.mMaxFileSize = volume.getMaxFileSize();
    }

    public final int getStorageId() {
        return this.mStorageId;
    }

    public static int getStorageId(int index) {
        return (index + 1 << 16) + 1;
    }

    public final String getPath() {
        return this.mPath;
    }

    public final String getDescription() {
        return this.mDescription;
    }

    public final long getReserveSpace() {
        return this.mReserveSpace;
    }

    public final boolean isRemovable() {
        return this.mRemovable;
    }

    public long getMaxFileSize() {
        return this.mMaxFileSize;
    }
}

