/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.DhcpInfo;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkUtils;
import android.net.RouteInfo;
import android.text.TextUtils;
import android.util.Log;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DhcpInfoInternal {
    private static final String TAG = "DhcpInfoInternal";
    public String ipAddress;
    public int prefixLength;
    public String dns1;
    public String dns2;
    public String serverAddress;
    public int leaseDuration;
    private Collection<RouteInfo> mRoutes = new ArrayList<RouteInfo>();

    public void addRoute(RouteInfo routeInfo) {
        this.mRoutes.add(routeInfo);
    }

    public Collection<RouteInfo> getRoutes() {
        return Collections.unmodifiableCollection(this.mRoutes);
    }

    private int convertToInt(String addr) {
        if (addr != null) {
            try {
                InetAddress inetAddress = NetworkUtils.numericToInetAddress(addr);
                if (inetAddress instanceof Inet4Address) {
                    return NetworkUtils.inetAddressToInt(inetAddress);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return 0;
    }

    public DhcpInfo makeDhcpInfo() {
        DhcpInfo info = new DhcpInfo();
        info.ipAddress = this.convertToInt(this.ipAddress);
        for (RouteInfo route : this.mRoutes) {
            if (!route.isDefaultRoute()) continue;
            info.gateway = this.convertToInt(route.getGateway().getHostAddress());
            break;
        }
        try {
            InetAddress inetAddress = NetworkUtils.numericToInetAddress(this.ipAddress);
            info.netmask = NetworkUtils.prefixLengthToNetmaskInt(this.prefixLength);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        info.dns1 = this.convertToInt(this.dns1);
        info.dns2 = this.convertToInt(this.dns2);
        info.serverAddress = this.convertToInt(this.serverAddress);
        info.leaseDuration = this.leaseDuration;
        return info;
    }

    public LinkAddress makeLinkAddress() {
        if (TextUtils.isEmpty(this.ipAddress)) {
            Log.e(TAG, "makeLinkAddress with empty ipAddress");
            return null;
        }
        return new LinkAddress(NetworkUtils.numericToInetAddress(this.ipAddress), this.prefixLength);
    }

    public LinkProperties makeLinkProperties() {
        LinkProperties p = new LinkProperties();
        p.addLinkAddress(this.makeLinkAddress());
        for (RouteInfo route : this.mRoutes) {
            p.addRoute(route);
        }
        if (!TextUtils.isEmpty(this.dns1)) {
            p.addDns(NetworkUtils.numericToInetAddress(this.dns1));
        } else {
            Log.d(TAG, "makeLinkProperties with empty dns1!");
        }
        if (!TextUtils.isEmpty(this.dns2)) {
            p.addDns(NetworkUtils.numericToInetAddress(this.dns2));
        } else {
            Log.d(TAG, "makeLinkProperties with empty dns2!");
        }
        return p;
    }

    public void updateFromDhcpRequest(DhcpInfoInternal orig) {
        if (orig == null) {
            return;
        }
        if (TextUtils.isEmpty(this.dns1)) {
            this.dns1 = orig.dns1;
        }
        if (TextUtils.isEmpty(this.dns2)) {
            this.dns2 = orig.dns2;
        }
        if (this.mRoutes.size() == 0) {
            for (RouteInfo route : orig.getRoutes()) {
                this.addRoute(route);
            }
        }
    }

    public String toString() {
        String routeString = "";
        for (RouteInfo route : this.mRoutes) {
            routeString = routeString + route.toString() + " | ";
        }
        return "addr: " + this.ipAddress + "/" + this.prefixLength + " mRoutes: " + routeString + " dns: " + this.dns1 + "," + this.dns2 + " dhcpServer: " + this.serverAddress + " leaseDuration: " + this.leaseDuration;
    }
}

