/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.LinkCapabilities;
import android.net.LinkProperties;
import android.net.NetworkInfo;
import android.net.NetworkStateTracker;
import android.os.Handler;
import android.os.Message;
import android.util.Slog;

public class DummyDataStateTracker
implements NetworkStateTracker {
    private static final String TAG = "DummyDataStateTracker";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private NetworkInfo mNetworkInfo;
    private boolean mTeardownRequested = false;
    private Handler mTarget;
    private Context mContext;
    private LinkProperties mLinkProperties;
    private LinkCapabilities mLinkCapabilities;
    private boolean mPrivateDnsRouteSet = false;
    private boolean mDefaultRouteSet = false;
    private boolean mIsDefaultOrHipri = false;

    public DummyDataStateTracker(int netType, String tag) {
        this.mNetworkInfo = new NetworkInfo(netType);
    }

    public void startMonitoring(Context context, Handler target) {
        this.mTarget = target;
        this.mContext = context;
    }

    public boolean isPrivateDnsRouteSet() {
        return this.mPrivateDnsRouteSet;
    }

    public void privateDnsRouteSet(boolean enabled) {
        this.mPrivateDnsRouteSet = enabled;
    }

    public NetworkInfo getNetworkInfo() {
        return this.mNetworkInfo;
    }

    public boolean isDefaultRouteSet() {
        return this.mDefaultRouteSet;
    }

    public void defaultRouteSet(boolean enabled) {
        this.mDefaultRouteSet = enabled;
    }

    public void releaseWakeLock() {
    }

    public boolean isAvailable() {
        return true;
    }

    public String getTcpBufferSizesPropName() {
        return "net.tcp.buffersize.unknown";
    }

    public boolean teardown() {
        this.setDetailedState(NetworkInfo.DetailedState.DISCONNECTING, "disabled", null);
        this.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, "disabled", null);
        return true;
    }

    private void setDetailedState(NetworkInfo.DetailedState state, String reason, String extraInfo) {
        DummyDataStateTracker.log("setDetailed state, old =" + (Object)((Object)this.mNetworkInfo.getDetailedState()) + " and new state=" + (Object)((Object)state));
        this.mNetworkInfo.setDetailedState(state, reason, extraInfo);
        Message msg = this.mTarget.obtainMessage(1, this.mNetworkInfo);
        msg.sendToTarget();
    }

    public void setTeardownRequested(boolean isRequested) {
        this.mTeardownRequested = isRequested;
    }

    public boolean isTeardownRequested() {
        return this.mTeardownRequested;
    }

    public boolean reconnect() {
        this.setDetailedState(NetworkInfo.DetailedState.CONNECTING, "enabled", null);
        this.setDetailedState(NetworkInfo.DetailedState.CONNECTED, "enabled", null);
        this.setTeardownRequested(false);
        return true;
    }

    public boolean setRadio(boolean turnOn) {
        return true;
    }

    public void setUserDataEnable(boolean enabled) {
    }

    public void setPolicyDataEnable(boolean enabled) {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Dummy data state: none, dummy!");
        return sb.toString();
    }

    public LinkProperties getLinkProperties() {
        return new LinkProperties(this.mLinkProperties);
    }

    public LinkCapabilities getLinkCapabilities() {
        return new LinkCapabilities(this.mLinkCapabilities);
    }

    public void setDependencyMet(boolean met) {
    }

    private static void log(String s) {
        Slog.d(TAG, s);
    }

    private static void loge(String s) {
        Slog.e(TAG, s);
    }
}

