/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.DhcpInfoInternal;
import android.net.INetworkManagementEventObserver;
import android.net.InterfaceConfiguration;
import android.net.LinkCapabilities;
import android.net.LinkProperties;
import android.net.NetworkInfo;
import android.net.NetworkStateTracker;
import android.net.NetworkUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class EthernetDataTracker
implements NetworkStateTracker {
    private static final String NETWORKTYPE = "ETHERNET";
    private static final String TAG = "Ethernet";
    private AtomicBoolean mTeardownRequested = new AtomicBoolean(false);
    private AtomicBoolean mPrivateDnsRouteSet = new AtomicBoolean(false);
    private AtomicInteger mDefaultGatewayAddr = new AtomicInteger(0);
    private AtomicBoolean mDefaultRouteSet = new AtomicBoolean(false);
    private static boolean mLinkUp;
    private LinkProperties mLinkProperties;
    private LinkCapabilities mLinkCapabilities;
    private NetworkInfo mNetworkInfo = new NetworkInfo(9, 0, "ETHERNET", "");
    private InterfaceObserver mInterfaceObserver;
    private Handler mCsHandler;
    private Context mContext;
    private static EthernetDataTracker sInstance;
    private static String sIfaceMatch;
    private static String mIface;

    private EthernetDataTracker() {
        this.mLinkProperties = new LinkProperties();
        this.mLinkCapabilities = new LinkCapabilities();
        mLinkUp = false;
        this.mNetworkInfo.setIsAvailable(false);
        this.setTeardownRequested(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interfaceAdded(String iface) {
        if (!iface.matches(sIfaceMatch)) {
            return;
        }
        Log.d(TAG, "Adding " + iface);
        String string2 = mIface;
        synchronized (string2) {
            if (!mIface.isEmpty()) {
                return;
            }
            mIface = iface;
        }
        this.mNetworkInfo.setIsAvailable(true);
        Message msg = this.mCsHandler.obtainMessage(3, this.mNetworkInfo);
        msg.sendToTarget();
        this.runDhcp();
    }

    private void interfaceRemoved(String iface) {
        if (!iface.equals(mIface)) {
            return;
        }
        Log.d(TAG, "Removing " + iface);
        NetworkUtils.stopDhcp(mIface);
        this.mLinkProperties.clear();
        this.mNetworkInfo.setIsAvailable(false);
        this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, null);
        Message msg = this.mCsHandler.obtainMessage(3, this.mNetworkInfo);
        msg.sendToTarget();
        msg = this.mCsHandler.obtainMessage(1, this.mNetworkInfo);
        msg.sendToTarget();
        mIface = "";
    }

    private void runDhcp() {
        Thread dhcpThread = new Thread(new Runnable(){

            public void run() {
                DhcpInfoInternal dhcpInfoInternal = new DhcpInfoInternal();
                if (!NetworkUtils.runDhcp(mIface, dhcpInfoInternal)) {
                    Log.e(EthernetDataTracker.TAG, "DHCP request error:" + NetworkUtils.getDhcpError());
                    return;
                }
                EthernetDataTracker.this.mLinkProperties = dhcpInfoInternal.makeLinkProperties();
                EthernetDataTracker.this.mLinkProperties.setInterfaceName(mIface);
                EthernetDataTracker.this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.CONNECTED, null, null);
                Message msg = EthernetDataTracker.this.mCsHandler.obtainMessage(1, EthernetDataTracker.this.mNetworkInfo);
                msg.sendToTarget();
            }
        });
        dhcpThread.start();
    }

    public static synchronized EthernetDataTracker getInstance() {
        if (sInstance == null) {
            sInstance = new EthernetDataTracker();
        }
        return sInstance;
    }

    public Object Clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void setTeardownRequested(boolean isRequested) {
        this.mTeardownRequested.set(isRequested);
    }

    public boolean isTeardownRequested() {
        return this.mTeardownRequested.get();
    }

    public void startMonitoring(Context context, Handler target) {
        this.mContext = context;
        this.mCsHandler = target;
        IBinder b = ServiceManager.getService("network_management");
        INetworkManagementService service = INetworkManagementService.Stub.asInterface(b);
        this.mInterfaceObserver = new InterfaceObserver(this);
        sIfaceMatch = context.getResources().getString(17039384);
        try {
            String[] ifaces;
            for (String iface : ifaces = service.listInterfaces()) {
                if (!iface.matches(sIfaceMatch)) continue;
                mIface = iface;
                InterfaceConfiguration config = service.getInterfaceConfig(iface);
                mLinkUp = config.isActive();
                this.reconnect();
                break;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Could not get list of interfaces " + e);
        }
        try {
            service.registerObserver(this.mInterfaceObserver);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Could not register InterfaceObserver " + e);
        }
    }

    public boolean teardown() {
        this.mTeardownRequested.set(true);
        NetworkUtils.stopDhcp(mIface);
        return true;
    }

    public boolean reconnect() {
        this.mTeardownRequested.set(false);
        this.runDhcp();
        return true;
    }

    public boolean setRadio(boolean turnOn) {
        return true;
    }

    public synchronized boolean isAvailable() {
        return this.mNetworkInfo.isAvailable();
    }

    public int startUsingNetworkFeature(String feature, int callingPid, int callingUid) {
        return -1;
    }

    public int stopUsingNetworkFeature(String feature, int callingPid, int callingUid) {
        return -1;
    }

    public void setUserDataEnable(boolean enabled) {
        Log.w(TAG, "ignoring setUserDataEnable(" + enabled + ")");
    }

    public void setPolicyDataEnable(boolean enabled) {
        Log.w(TAG, "ignoring setPolicyDataEnable(" + enabled + ")");
    }

    public boolean isPrivateDnsRouteSet() {
        return this.mPrivateDnsRouteSet.get();
    }

    public void privateDnsRouteSet(boolean enabled) {
        this.mPrivateDnsRouteSet.set(enabled);
    }

    public synchronized NetworkInfo getNetworkInfo() {
        return this.mNetworkInfo;
    }

    public synchronized LinkProperties getLinkProperties() {
        return new LinkProperties(this.mLinkProperties);
    }

    public LinkCapabilities getLinkCapabilities() {
        return new LinkCapabilities(this.mLinkCapabilities);
    }

    public int getDefaultGatewayAddr() {
        return this.mDefaultGatewayAddr.get();
    }

    public boolean isDefaultRouteSet() {
        return this.mDefaultRouteSet.get();
    }

    public void defaultRouteSet(boolean enabled) {
        this.mDefaultRouteSet.set(enabled);
    }

    public String getTcpBufferSizesPropName() {
        return "net.tcp.buffersize.wifi";
    }

    public void setDependencyMet(boolean met) {
    }

    static {
        sIfaceMatch = "";
        mIface = "";
    }

    private static class InterfaceObserver
    extends INetworkManagementEventObserver.Stub {
        private EthernetDataTracker mTracker;

        InterfaceObserver(EthernetDataTracker tracker) {
            this.mTracker = tracker;
        }

        public void interfaceStatusChanged(String iface, boolean up) {
            Log.d(EthernetDataTracker.TAG, "Interface status changed: " + iface + (up ? "up" : "down"));
        }

        public void interfaceLinkStateChanged(String iface, boolean up) {
            if (mIface.equals(iface) && mLinkUp != up) {
                Log.d(EthernetDataTracker.TAG, "Interface " + iface + " link " + (up ? "up" : "down"));
                mLinkUp = up;
                if (up) {
                    this.mTracker.reconnect();
                } else {
                    NetworkUtils.stopDhcp(mIface);
                    this.mTracker.mNetworkInfo.setIsAvailable(false);
                    this.mTracker.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, null);
                }
            }
        }

        public void interfaceAdded(String iface) {
            this.mTracker.interfaceAdded(iface);
        }

        public void interfaceRemoved(String iface) {
            this.mTracker.interfaceRemoved(iface);
        }

        public void limitReached(String limitName, String iface) {
        }
    }
}

