/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkAddress;
import android.os.Parcel;
import android.os.Parcelable;

public class InterfaceConfiguration
implements Parcelable {
    public String hwAddr;
    public LinkAddress addr;
    public String interfaceFlags;
    public static final Parcelable.Creator<InterfaceConfiguration> CREATOR = new Parcelable.Creator<InterfaceConfiguration>(){

        @Override
        public InterfaceConfiguration createFromParcel(Parcel in) {
            InterfaceConfiguration info = new InterfaceConfiguration();
            info.hwAddr = in.readString();
            if (in.readByte() == 1) {
                info.addr = (LinkAddress)in.readParcelable(null);
            }
            info.interfaceFlags = in.readString();
            return info;
        }

        public InterfaceConfiguration[] newArray(int size) {
            return new InterfaceConfiguration[size];
        }
    };

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("ipddress ");
        str.append(this.addr != null ? this.addr.toString() : "NULL");
        str.append(" flags ").append(this.interfaceFlags);
        str.append(" hwaddr ").append(this.hwAddr);
        return str.toString();
    }

    public boolean isActive() {
        try {
            if (this.interfaceFlags.contains("up")) {
                for (byte b : this.addr.getAddress().getAddress()) {
                    if (b == 0) continue;
                    return true;
                }
            }
        }
        catch (NullPointerException e) {
            return false;
        }
        return false;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.hwAddr);
        if (this.addr != null) {
            dest.writeByte((byte)1);
            dest.writeParcelable(this.addr, flags);
        } else {
            dest.writeByte((byte)0);
        }
        dest.writeString(this.interfaceFlags);
    }
}

