/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.LinkCapabilities;
import android.net.LinkProperties;
import android.net.NetworkInfo;
import android.net.NetworkStateTracker;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.Phone;
import com.android.internal.util.AsyncChannel;
import java.io.CharArrayWriter;
import java.io.PrintWriter;

public class MobileDataStateTracker
implements NetworkStateTracker {
    private static final String TAG = "MobileDataStateTracker";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    private Phone.DataState mMobileDataState;
    private ITelephony mPhoneService;
    private String mApnType;
    private NetworkInfo mNetworkInfo;
    private boolean mTeardownRequested = false;
    private Handler mTarget;
    private Context mContext;
    private LinkProperties mLinkProperties;
    private LinkCapabilities mLinkCapabilities;
    private boolean mPrivateDnsRouteSet = false;
    private boolean mDefaultRouteSet = false;
    protected boolean mUserDataEnabled = true;
    protected boolean mPolicyDataEnabled = true;
    private Handler mHandler;
    private AsyncChannel mDataConnectionTrackerAc;
    private Messenger mMessenger;

    public MobileDataStateTracker(int netType, String tag) {
        this.mNetworkInfo = new NetworkInfo(netType, TelephonyManager.getDefault().getNetworkType(), tag, TelephonyManager.getDefault().getNetworkTypeName());
        this.mApnType = MobileDataStateTracker.networkTypeToApnType(netType);
    }

    public void startMonitoring(Context context, Handler target) {
        this.mTarget = target;
        this.mContext = context;
        this.mHandler = new MdstHandler(target.getLooper(), this);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.ANY_DATA_STATE");
        filter.addAction("android.intent.action.DATA_CONNECTION_FAILED");
        filter.addAction(DataConnectionTracker.ACTION_DATA_CONNECTION_TRACKER_MESSENGER);
        this.mContext.registerReceiver(new MobileDataStateReceiver(), filter);
        this.mMobileDataState = Phone.DataState.DISCONNECTED;
    }

    public boolean isPrivateDnsRouteSet() {
        return this.mPrivateDnsRouteSet;
    }

    public void privateDnsRouteSet(boolean enabled) {
        this.mPrivateDnsRouteSet = enabled;
    }

    public NetworkInfo getNetworkInfo() {
        return this.mNetworkInfo;
    }

    public boolean isDefaultRouteSet() {
        return this.mDefaultRouteSet;
    }

    public void defaultRouteSet(boolean enabled) {
        this.mDefaultRouteSet = enabled;
    }

    public void releaseWakeLock() {
    }

    private void getPhoneService(boolean forceRefresh) {
        if (this.mPhoneService == null || forceRefresh) {
            this.mPhoneService = ITelephony.Stub.asInterface(ServiceManager.getService("phone"));
        }
    }

    public boolean isAvailable() {
        return this.mNetworkInfo.isAvailable();
    }

    public String getTcpBufferSizesPropName() {
        String networkTypeStr = "unknown";
        TelephonyManager tm = new TelephonyManager(this.mContext);
        switch (tm.getNetworkType()) {
            case 1: {
                networkTypeStr = "gprs";
                break;
            }
            case 2: {
                networkTypeStr = "edge";
                break;
            }
            case 3: {
                networkTypeStr = "umts";
                break;
            }
            case 8: {
                networkTypeStr = "hsdpa";
                break;
            }
            case 9: {
                networkTypeStr = "hsupa";
                break;
            }
            case 10: {
                networkTypeStr = "hspa";
                break;
            }
            case 4: {
                networkTypeStr = "cdma";
                break;
            }
            case 7: {
                networkTypeStr = "1xrtt";
                break;
            }
            case 5: {
                networkTypeStr = "evdo";
                break;
            }
            case 6: {
                networkTypeStr = "evdo";
                break;
            }
            case 12: {
                networkTypeStr = "evdo";
                break;
            }
            case 11: {
                networkTypeStr = "iden";
                break;
            }
            case 13: {
                networkTypeStr = "lte";
                break;
            }
            case 14: {
                networkTypeStr = "ehrpd";
                break;
            }
            default: {
                this.loge("unknown network type: " + tm.getNetworkType());
            }
        }
        return "net.tcp.buffersize." + networkTypeStr;
    }

    public boolean teardown() {
        this.setTeardownRequested(true);
        return this.setEnableApn(this.mApnType, false) != 3;
    }

    private void setDetailedState(NetworkInfo.DetailedState state, String reason, String extraInfo) {
        if (state != this.mNetworkInfo.getDetailedState()) {
            boolean wasConnecting = this.mNetworkInfo.getState() == NetworkInfo.State.CONNECTING;
            String lastReason = this.mNetworkInfo.getReason();
            if (wasConnecting && state == NetworkInfo.DetailedState.CONNECTED && reason == null && lastReason != null) {
                reason = lastReason;
            }
            this.mNetworkInfo.setDetailedState(state, reason, extraInfo);
            Message msg = this.mTarget.obtainMessage(1, new NetworkInfo(this.mNetworkInfo));
            msg.sendToTarget();
        }
    }

    public void setTeardownRequested(boolean isRequested) {
        this.mTeardownRequested = isRequested;
    }

    public boolean isTeardownRequested() {
        return this.mTeardownRequested;
    }

    public boolean reconnect() {
        boolean retValue = false;
        this.setTeardownRequested(false);
        switch (this.setEnableApn(this.mApnType, true)) {
            case 0: {
                retValue = true;
                break;
            }
            case 1: {
                this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.IDLE, null, null);
                retValue = true;
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            default: {
                this.loge("Error in reconnect - unexpected response.");
            }
        }
        return retValue;
    }

    public boolean setRadio(boolean turnOn) {
        this.getPhoneService(false);
        for (int retry = 0; retry < 2; ++retry) {
            if (this.mPhoneService == null) {
                this.loge("Ignoring mobile radio request because could not acquire PhoneService");
                break;
            }
            try {
                return this.mPhoneService.setRadio(turnOn);
            }
            catch (RemoteException e) {
                if (retry != 0) continue;
                this.getPhoneService(true);
                continue;
            }
        }
        this.loge("Could not set radio power to " + (turnOn ? "on" : "off"));
        return false;
    }

    public void setUserDataEnable(boolean enabled) {
        AsyncChannel channel = this.mDataConnectionTrackerAc;
        if (channel != null) {
            channel.sendMessage(270365, enabled ? 1 : 0);
            this.mUserDataEnabled = enabled;
        }
    }

    public void setPolicyDataEnable(boolean enabled) {
        AsyncChannel channel = this.mDataConnectionTrackerAc;
        if (channel != null) {
            channel.sendMessage(270368, enabled ? 1 : 0);
            this.mPolicyDataEnabled = enabled;
        }
    }

    public void setDependencyMet(boolean met) {
        Bundle bundle = Bundle.forPair("apnType", this.mApnType);
        try {
            Message msg = Message.obtain();
            msg.what = 270367;
            msg.arg1 = met ? 1 : 0;
            msg.setData(bundle);
            this.mDataConnectionTrackerAc.sendMessage(msg);
        }
        catch (NullPointerException e) {
            this.loge("setDependencyMet: X mAc was null" + e);
        }
    }

    public String toString() {
        CharArrayWriter writer = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(writer);
        pw.print("Mobile data state: ");
        pw.println((Object)this.mMobileDataState);
        pw.print("Data enabled: user=");
        pw.print(this.mUserDataEnabled);
        pw.print(", policy=");
        pw.println(this.mPolicyDataEnabled);
        return writer.toString();
    }

    private int setEnableApn(String apnType, boolean enable) {
        this.getPhoneService(false);
        for (int retry = 0; retry < 2; ++retry) {
            if (this.mPhoneService == null) {
                this.loge("Ignoring feature request because could not acquire PhoneService");
                break;
            }
            try {
                if (enable) {
                    return this.mPhoneService.enableApnType(apnType);
                }
                return this.mPhoneService.disableApnType(apnType);
            }
            catch (RemoteException e) {
                if (retry != 0) continue;
                this.getPhoneService(true);
                continue;
            }
        }
        this.loge("Could not " + (enable ? "enable" : "disable") + " APN type \"" + apnType + "\"");
        return 3;
    }

    public static String networkTypeToApnType(int netType) {
        switch (netType) {
            case 0: {
                return "default";
            }
            case 2: {
                return "mms";
            }
            case 3: {
                return "supl";
            }
            case 4: {
                return "dun";
            }
            case 5: {
                return "hipri";
            }
            case 10: {
                return "fota";
            }
            case 11: {
                return "ims";
            }
            case 12: {
                return "cbs";
            }
        }
        MobileDataStateTracker.sloge("Error mapping networkType " + netType + " to apnType.");
        return null;
    }

    public LinkProperties getLinkProperties() {
        return new LinkProperties(this.mLinkProperties);
    }

    public LinkCapabilities getLinkCapabilities() {
        return new LinkCapabilities(this.mLinkCapabilities);
    }

    private void log(String s) {
        Slog.d(TAG, this.mApnType + ": " + s);
    }

    private void loge(String s) {
        Slog.e(TAG, this.mApnType + ": " + s);
    }

    private static void sloge(String s) {
        Slog.e(TAG, s);
    }

    private class MobileDataStateReceiver
    extends BroadcastReceiver {
        private MobileDataStateReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.ANY_DATA_STATE")) {
                String apnType = intent.getStringExtra("apnType");
                if (!TextUtils.equals(apnType, MobileDataStateTracker.this.mApnType)) {
                    return;
                }
                MobileDataStateTracker.this.mNetworkInfo.setSubtype(TelephonyManager.getDefault().getNetworkType(), TelephonyManager.getDefault().getNetworkTypeName());
                Phone.DataState state = Enum.valueOf(Phone.DataState.class, intent.getStringExtra("state"));
                String reason = intent.getStringExtra("reason");
                String apnName = intent.getStringExtra("apn");
                MobileDataStateTracker.this.mNetworkInfo.setRoaming(intent.getBooleanExtra("networkRoaming", false));
                MobileDataStateTracker.this.mNetworkInfo.setIsAvailable(!intent.getBooleanExtra("networkUnvailable", false));
                if (MobileDataStateTracker.this.mMobileDataState != state) {
                    MobileDataStateTracker.this.mMobileDataState = state;
                    switch (state) {
                        case DISCONNECTED: {
                            if (MobileDataStateTracker.this.isTeardownRequested()) {
                                MobileDataStateTracker.this.setTeardownRequested(false);
                            }
                            MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, reason, apnName);
                            break;
                        }
                        case CONNECTING: {
                            MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.CONNECTING, reason, apnName);
                            break;
                        }
                        case SUSPENDED: {
                            MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.SUSPENDED, reason, apnName);
                            break;
                        }
                        case CONNECTED: {
                            MobileDataStateTracker.this.mLinkProperties = (LinkProperties)intent.getParcelableExtra("linkProperties");
                            if (MobileDataStateTracker.this.mLinkProperties == null) {
                                MobileDataStateTracker.this.loge("CONNECTED event did not supply link properties.");
                                MobileDataStateTracker.this.mLinkProperties = new LinkProperties();
                            }
                            MobileDataStateTracker.this.mLinkCapabilities = (LinkCapabilities)intent.getParcelableExtra("linkCapabilities");
                            if (MobileDataStateTracker.this.mLinkCapabilities == null) {
                                MobileDataStateTracker.this.loge("CONNECTED event did not supply link capabilities.");
                                MobileDataStateTracker.this.mLinkCapabilities = new LinkCapabilities();
                            }
                            MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.CONNECTED, reason, apnName);
                        }
                    }
                } else if (TextUtils.equals(reason, "linkPropertiesChanged")) {
                    MobileDataStateTracker.this.mLinkProperties = (LinkProperties)intent.getParcelableExtra("linkProperties");
                    if (MobileDataStateTracker.this.mLinkProperties == null) {
                        MobileDataStateTracker.this.loge("No link property in LINK_PROPERTIES change event.");
                        MobileDataStateTracker.this.mLinkProperties = new LinkProperties();
                    }
                    MobileDataStateTracker.this.mNetworkInfo.setDetailedState(MobileDataStateTracker.this.mNetworkInfo.getDetailedState(), reason, MobileDataStateTracker.this.mNetworkInfo.getExtraInfo());
                    Message msg = MobileDataStateTracker.this.mTarget.obtainMessage(3, MobileDataStateTracker.this.mNetworkInfo);
                    msg.sendToTarget();
                }
            } else if (intent.getAction().equals("android.intent.action.DATA_CONNECTION_FAILED")) {
                String apnType = intent.getStringExtra("apnType");
                if (!TextUtils.equals(apnType, MobileDataStateTracker.this.mApnType)) {
                    return;
                }
                String reason = intent.getStringExtra("reason");
                String apnName = intent.getStringExtra("apn");
                MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.FAILED, reason, apnName);
            } else if (intent.getAction().equals(DataConnectionTracker.ACTION_DATA_CONNECTION_TRACKER_MESSENGER)) {
                MobileDataStateTracker.this.mMessenger = (Messenger)intent.getParcelableExtra(DataConnectionTracker.EXTRA_MESSENGER);
                AsyncChannel ac = new AsyncChannel();
                ac.connect(MobileDataStateTracker.this.mContext, MobileDataStateTracker.this.mHandler, MobileDataStateTracker.this.mMessenger);
            }
        }
    }

    static class MdstHandler
    extends Handler {
        private MobileDataStateTracker mMdst;

        MdstHandler(Looper looper, MobileDataStateTracker mdst) {
            super(looper);
            this.mMdst = mdst;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 69632: {
                    if (msg.arg1 != 0) break;
                    this.mMdst.mDataConnectionTrackerAc = (AsyncChannel)msg.obj;
                    break;
                }
                case 69636: {
                    this.mMdst.mDataConnectionTrackerAc = null;
                    break;
                }
            }
        }
    }
}

