/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.INetworkStatsService;
import android.net.NetworkStats;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.android.server.NetworkManagementSocketTagger;
import dalvik.system.SocketTagger;
import java.net.Socket;
import java.net.SocketException;

public class TrafficStats {
    public static final int UNSUPPORTED = -1;
    public static final int UID_REMOVED = -4;
    public static final int UID_TETHERING = -5;
    public static final int TAG_SYSTEM_DOWNLOAD = -255;
    public static final int TAG_SYSTEM_MEDIA = -254;
    public static final int TAG_SYSTEM_BACKUP = -253;
    private static NetworkStats sActiveProfilingStart;
    private static Object sProfilingLock;

    public static void setThreadStatsTag(int tag) {
        NetworkManagementSocketTagger.setThreadSocketStatsTag(tag);
    }

    public static int getThreadStatsTag() {
        return NetworkManagementSocketTagger.getThreadSocketStatsTag();
    }

    public static void clearThreadStatsTag() {
        NetworkManagementSocketTagger.setThreadSocketStatsTag(-1);
    }

    public static void setThreadStatsUid(int uid) {
        NetworkManagementSocketTagger.setThreadSocketStatsUid(uid);
    }

    public static void clearThreadStatsUid() {
        NetworkManagementSocketTagger.setThreadSocketStatsUid(-1);
    }

    public static void tagSocket(Socket socket) throws SocketException {
        SocketTagger.get().tag(socket);
    }

    public static void untagSocket(Socket socket) throws SocketException {
        SocketTagger.get().untag(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startDataProfiling(Context context) {
        Object object = sProfilingLock;
        synchronized (object) {
            if (sActiveProfilingStart != null) {
                throw new IllegalStateException("already profiling data");
            }
            sActiveProfilingStart = TrafficStats.getDataLayerSnapshotForUid(context);
        }
    }

    public static NetworkStats stopDataProfiling(Context context) {
        Object object = sProfilingLock;
        synchronized (object) {
            if (sActiveProfilingStart == null) {
                throw new IllegalStateException("not profiling data");
            }
            try {
                NetworkStats profilingStop = TrafficStats.getDataLayerSnapshotForUid(context);
                NetworkStats profilingDelta = profilingStop.subtract(sActiveProfilingStart);
                sActiveProfilingStart = null;
                return profilingDelta;
            }
            catch (NetworkStats.NonMonotonicException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void incrementOperationCount(int operationCount) {
        int tag = TrafficStats.getThreadStatsTag();
        TrafficStats.incrementOperationCount(tag, operationCount);
    }

    public static void incrementOperationCount(int tag, int operationCount) {
        INetworkStatsService statsService = INetworkStatsService.Stub.asInterface(ServiceManager.getService("netstats"));
        int uid = Process.myUid();
        try {
            statsService.incrementOperationCount(uid, tag, operationCount);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public static native long getMobileTxPackets();

    public static native long getMobileRxPackets();

    public static native long getMobileTxBytes();

    public static native long getMobileRxBytes();

    public static native long getTxPackets(String var0);

    public static native long getRxPackets(String var0);

    public static native long getTxBytes(String var0);

    public static native long getRxBytes(String var0);

    public static native long getTotalTxPackets();

    public static native long getTotalRxPackets();

    public static native long getTotalTxBytes();

    public static native long getTotalRxBytes();

    public static native long getUidTxBytes(int var0);

    public static native long getUidRxBytes(int var0);

    public static native long getUidTxPackets(int var0);

    public static native long getUidRxPackets(int var0);

    public static native long getUidTcpTxBytes(int var0);

    public static native long getUidTcpRxBytes(int var0);

    public static native long getUidUdpTxBytes(int var0);

    public static native long getUidUdpRxBytes(int var0);

    public static native long getUidTcpTxSegments(int var0);

    public static native long getUidTcpRxSegments(int var0);

    public static native long getUidUdpTxPackets(int var0);

    public static native long getUidUdpRxPackets(int var0);

    private static NetworkStats getDataLayerSnapshotForUid(Context context) {
        INetworkStatsService statsService = INetworkStatsService.Stub.asInterface(ServiceManager.getService("netstats"));
        int uid = Process.myUid();
        try {
            return statsService.getDataLayerSnapshotForUid(uid);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        sProfilingLock = new Object();
    }
}

