/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.net.dhcp.DhcpPacket;
import android.net.dhcp.DhcpStateMachine;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;

class DhcpDiscoverPacket
extends DhcpPacket {
    DhcpDiscoverPacket(int transId, byte[] clientMac, boolean broadcast) {
        super(transId, Inet4Address.ANY, Inet4Address.ANY, Inet4Address.ANY, Inet4Address.ANY, clientMac, broadcast);
    }

    public String toString() {
        String s = super.toString();
        return s + " DISCOVER " + (this.mBroadcast ? "broadcast " : "unicast ");
    }

    public ByteBuffer buildPacket(int encap, short destUdp, short srcUdp) {
        ByteBuffer result = ByteBuffer.allocate(1500);
        InetAddress destIp = Inet4Address.ALL;
        this.fillInPacket(encap, Inet4Address.ALL, Inet4Address.ANY, destUdp, srcUdp, result, (byte)1, true);
        result.flip();
        return result;
    }

    void finishPacket(ByteBuffer buffer) {
        this.addTlv(buffer, (byte)53, (byte)1);
        this.addTlv(buffer, (byte)55, this.mRequestedParams);
        this.addTlvEnd(buffer);
    }

    public void doNextOp(DhcpStateMachine machine) {
        machine.onDiscoverReceived(this.mBroadcast, this.mTransId, this.mClientMac, this.mRequestedParams);
    }
}

