/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.net.dhcp.DhcpAckPacket;
import android.net.dhcp.DhcpDeclinePacket;
import android.net.dhcp.DhcpDiscoverPacket;
import android.net.dhcp.DhcpInformPacket;
import android.net.dhcp.DhcpNakPacket;
import android.net.dhcp.DhcpOfferPacket;
import android.net.dhcp.DhcpRequestPacket;
import android.net.dhcp.DhcpStateMachine;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.nio.charset.Charsets;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DhcpPacket {
    protected static final String TAG = "DhcpPacket";
    public static final int ENCAP_L2 = 0;
    public static final int ENCAP_L3 = 1;
    public static final int ENCAP_BOOTP = 2;
    private static final byte IP_TYPE_UDP = 17;
    private static final byte IP_VERSION_HEADER_LEN = 69;
    private static final short IP_FLAGS_OFFSET = 16384;
    private static final byte IP_TOS_LOWDELAY = 16;
    private static final byte IP_TTL = 64;
    static final short DHCP_CLIENT = 68;
    static final short DHCP_SERVER = 67;
    protected static final byte DHCP_BOOTREQUEST = 1;
    protected static final byte DHCP_BOOTREPLY = 2;
    protected static final byte CLIENT_ID_ETHER = 1;
    protected static final int MAX_LENGTH = 1500;
    protected static final byte DHCP_SUBNET_MASK = 1;
    protected InetAddress mSubnetMask;
    protected static final byte DHCP_ROUTER = 3;
    protected InetAddress mGateway;
    protected static final byte DHCP_DNS_SERVER = 6;
    protected List<InetAddress> mDnsServers;
    protected static final byte DHCP_HOST_NAME = 12;
    protected String mHostName;
    protected static final byte DHCP_DOMAIN_NAME = 15;
    protected String mDomainName;
    protected static final byte DHCP_BROADCAST_ADDRESS = 28;
    protected InetAddress mBroadcastAddress;
    protected static final byte DHCP_REQUESTED_IP = 50;
    protected InetAddress mRequestedIp;
    protected static final byte DHCP_LEASE_TIME = 51;
    protected Integer mLeaseTime;
    protected static final byte DHCP_MESSAGE_TYPE = 53;
    protected static final byte DHCP_MESSAGE_TYPE_DISCOVER = 1;
    protected static final byte DHCP_MESSAGE_TYPE_OFFER = 2;
    protected static final byte DHCP_MESSAGE_TYPE_REQUEST = 3;
    protected static final byte DHCP_MESSAGE_TYPE_DECLINE = 4;
    protected static final byte DHCP_MESSAGE_TYPE_ACK = 5;
    protected static final byte DHCP_MESSAGE_TYPE_NAK = 6;
    protected static final byte DHCP_MESSAGE_TYPE_INFORM = 8;
    protected static final byte DHCP_SERVER_IDENTIFIER = 54;
    protected InetAddress mServerIdentifier;
    protected static final byte DHCP_PARAMETER_LIST = 55;
    protected byte[] mRequestedParams;
    protected static final byte DHCP_MESSAGE = 56;
    protected String mMessage;
    protected static final byte DHCP_RENEWAL_TIME = 58;
    protected static final byte DHCP_VENDOR_CLASS_ID = 60;
    protected static final byte DHCP_CLIENT_IDENTIFIER = 61;
    protected final int mTransId;
    protected final InetAddress mClientIp;
    protected final InetAddress mYourIp;
    private final InetAddress mNextIp;
    private final InetAddress mRelayIp;
    protected boolean mBroadcast;
    protected final byte[] mClientMac;

    public abstract void doNextOp(DhcpStateMachine var1);

    public abstract ByteBuffer buildPacket(int var1, short var2, short var3);

    abstract void finishPacket(ByteBuffer var1);

    protected DhcpPacket(int transId, InetAddress clientIp, InetAddress yourIp, InetAddress nextIp, InetAddress relayIp, byte[] clientMac, boolean broadcast) {
        this.mTransId = transId;
        this.mClientIp = clientIp;
        this.mYourIp = yourIp;
        this.mNextIp = nextIp;
        this.mRelayIp = relayIp;
        this.mClientMac = clientMac;
        this.mBroadcast = broadcast;
    }

    public int getTransactionId() {
        return this.mTransId;
    }

    protected void fillInPacket(int encap, InetAddress destIp, InetAddress srcIp, short destUdp, short srcUdp, ByteBuffer buf, byte requestCode, boolean broadcast) {
        byte[] destIpArray = destIp.getAddress();
        byte[] srcIpArray = srcIp.getAddress();
        int ipLengthOffset = 0;
        int ipChecksumOffset = 0;
        int endIpHeader = 0;
        int udpHeaderOffset = 0;
        int udpLengthOffset = 0;
        int udpChecksumOffset = 0;
        buf.clear();
        buf.order(ByteOrder.BIG_ENDIAN);
        if (encap == 1) {
            buf.put((byte)69);
            buf.put((byte)16);
            ipLengthOffset = buf.position();
            buf.putShort((short)0);
            buf.putShort((short)0);
            buf.putShort((short)16384);
            buf.put((byte)64);
            buf.put((byte)17);
            ipChecksumOffset = buf.position();
            buf.putShort((short)0);
            buf.put(srcIpArray);
            buf.put(destIpArray);
            endIpHeader = buf.position();
            udpHeaderOffset = buf.position();
            buf.putShort(srcUdp);
            buf.putShort(destUdp);
            udpLengthOffset = buf.position();
            buf.putShort((short)0);
            udpChecksumOffset = buf.position();
            buf.putShort((short)0);
        }
        buf.put(requestCode);
        buf.put((byte)1);
        buf.put((byte)this.mClientMac.length);
        buf.put((byte)0);
        buf.putInt(this.mTransId);
        buf.putShort((short)0);
        if (broadcast) {
            buf.putShort((short)Short.MIN_VALUE);
        } else {
            buf.putShort((short)0);
        }
        buf.put(this.mClientIp.getAddress());
        buf.put(this.mYourIp.getAddress());
        buf.put(this.mNextIp.getAddress());
        buf.put(this.mRelayIp.getAddress());
        buf.put(this.mClientMac);
        buf.position(buf.position() + (16 - this.mClientMac.length) + 64 + 128);
        buf.putInt(1669485411);
        this.finishPacket(buf);
        if ((buf.position() & 1) == 1) {
            buf.put((byte)0);
        }
        if (encap == 1) {
            short udpLen = (short)(buf.position() - udpHeaderOffset);
            buf.putShort(udpLengthOffset, udpLen);
            int udpSeed = 0;
            udpSeed += this.intAbs(buf.getShort(ipChecksumOffset + 2));
            udpSeed += this.intAbs(buf.getShort(ipChecksumOffset + 4));
            udpSeed += this.intAbs(buf.getShort(ipChecksumOffset + 6));
            udpSeed += this.intAbs(buf.getShort(ipChecksumOffset + 8));
            udpSeed += 17;
            buf.putShort(udpChecksumOffset, (short)this.checksum(buf, udpSeed += udpLen, udpHeaderOffset, buf.position()));
            buf.putShort(ipLengthOffset, (short)buf.position());
            buf.putShort(ipChecksumOffset, (short)this.checksum(buf, 0, 0, endIpHeader));
        }
    }

    private int intAbs(short v) {
        if (v < 0) {
            int r = v + 65536;
            return r;
        }
        return v;
    }

    private int checksum(ByteBuffer buf, int seed, int start, int end) {
        int sum = seed;
        int bufPosition = buf.position();
        buf.position(start);
        ShortBuffer shortBuf = buf.asShortBuffer();
        buf.position(bufPosition);
        short[] shortArray = new short[(end - start) / 2];
        shortBuf.get(shortArray);
        for (short s : shortArray) {
            sum += this.intAbs(s);
        }
        if (end != (start += shortArray.length * 2)) {
            short b = buf.get(start);
            if (b < 0) {
                b = (short)(b + 256);
            }
            sum += b * 256;
        }
        sum = (sum >> 16 & 0xFFFF) + (sum & 0xFFFF);
        sum = sum + (sum >> 16 & 0xFFFF) & 0xFFFF;
        int negated = ~sum;
        return this.intAbs((short)negated);
    }

    protected void addTlv(ByteBuffer buf, byte type, byte value) {
        buf.put(type);
        buf.put((byte)1);
        buf.put(value);
    }

    protected void addTlv(ByteBuffer buf, byte type, byte[] payload) {
        if (payload != null) {
            buf.put(type);
            buf.put((byte)payload.length);
            buf.put(payload);
        }
    }

    protected void addTlv(ByteBuffer buf, byte type, InetAddress addr) {
        if (addr != null) {
            this.addTlv(buf, type, addr.getAddress());
        }
    }

    protected void addTlv(ByteBuffer buf, byte type, List<InetAddress> addrs) {
        if (addrs != null && addrs.size() > 0) {
            buf.put(type);
            buf.put((byte)(4 * addrs.size()));
            for (InetAddress addr : addrs) {
                buf.put(addr.getAddress());
            }
        }
    }

    protected void addTlv(ByteBuffer buf, byte type, Integer value) {
        if (value != null) {
            buf.put(type);
            buf.put((byte)4);
            buf.putInt(value);
        }
    }

    protected void addTlv(ByteBuffer buf, byte type, String str) {
        if (str != null) {
            buf.put(type);
            buf.put((byte)str.length());
            for (int i = 0; i < str.length(); ++i) {
                buf.put((byte)str.charAt(i));
            }
        }
    }

    protected void addTlvEnd(ByteBuffer buf) {
        buf.put((byte)-1);
    }

    public static String macToString(byte[] mac) {
        String macAddr = "";
        for (int i = 0; i < mac.length; ++i) {
            String hexString = "0" + Integer.toHexString(mac[i]);
            macAddr = macAddr + hexString.substring(hexString.length() - 2);
            if (i == mac.length - 1) continue;
            macAddr = macAddr + ":";
        }
        return macAddr;
    }

    public String toString() {
        String macAddr = DhcpPacket.macToString(this.mClientMac);
        return macAddr;
    }

    private static InetAddress readIpAddress(ByteBuffer packet) {
        InetAddress result = null;
        byte[] ipAddr = new byte[4];
        packet.get(ipAddr);
        try {
            result = InetAddress.getByAddress(ipAddr);
        }
        catch (UnknownHostException ex) {
            result = null;
        }
        return result;
    }

    private static String readAsciiString(ByteBuffer buf, int byteCount) {
        byte[] bytes = new byte[byteCount];
        buf.get(bytes);
        return new String(bytes, 0, bytes.length, Charsets.US_ASCII);
    }

    public static DhcpPacket decodeFullPacket(ByteBuffer packet, int pktType) {
        DhcpPacket newPacket;
        InetAddress relayIp;
        InetAddress nextIp;
        InetAddress yourIp;
        InetAddress clientIp;
        ArrayList<InetAddress> dnsServers = new ArrayList<InetAddress>();
        InetAddress gateway = null;
        Integer leaseTime = null;
        InetAddress serverIdentifier = null;
        InetAddress netMask = null;
        String message = null;
        String vendorId = null;
        byte[] expectedParams = null;
        String hostName = null;
        String domainName = null;
        InetAddress ipSrc = null;
        InetAddress ipDst = null;
        InetAddress bcAddr = null;
        InetAddress requestedIp = null;
        int dhcpType = -1;
        packet.order(ByteOrder.BIG_ENDIAN);
        if (pktType == 0) {
            byte[] l2dst = new byte[6];
            byte[] l2src = new byte[6];
            packet.get(l2dst);
            packet.get(l2src);
            short l2type = packet.getShort();
            if (l2type != 2048) {
                return null;
            }
        }
        if (pktType == 0 || pktType == 1) {
            byte ipType = packet.get();
            byte ipDiffServicesField = packet.get();
            short ipTotalLength = packet.getShort();
            short ipIdentification = packet.getShort();
            byte ipFlags = packet.get();
            byte ipFragOffset = packet.get();
            byte ipTTL = packet.get();
            byte ipProto = packet.get();
            short ipChksm = packet.getShort();
            ipSrc = DhcpPacket.readIpAddress(packet);
            ipDst = DhcpPacket.readIpAddress(packet);
            if (ipProto != 17) {
                return null;
            }
            short udpSrcPort = packet.getShort();
            short udpDstPort = packet.getShort();
            short udpLen = packet.getShort();
            short udpChkSum = packet.getShort();
            if (udpSrcPort != 67 && udpSrcPort != 68) {
                return null;
            }
        }
        byte type = packet.get();
        byte hwType = packet.get();
        byte addrLen = packet.get();
        byte hops = packet.get();
        int transactionId = packet.getInt();
        short elapsed = packet.getShort();
        short bootpFlags = packet.getShort();
        boolean broadcast = (bootpFlags & 0x8000) != 0;
        byte[] ipv4addr = new byte[4];
        try {
            packet.get(ipv4addr);
            clientIp = InetAddress.getByAddress(ipv4addr);
            packet.get(ipv4addr);
            yourIp = InetAddress.getByAddress(ipv4addr);
            packet.get(ipv4addr);
            nextIp = InetAddress.getByAddress(ipv4addr);
            packet.get(ipv4addr);
            relayIp = InetAddress.getByAddress(ipv4addr);
        }
        catch (UnknownHostException ex) {
            return null;
        }
        byte[] clientMac = new byte[addrLen];
        packet.get(clientMac);
        packet.position(packet.position() + (16 - addrLen) + 64 + 128);
        int dhcpMagicCookie = packet.getInt();
        if (dhcpMagicCookie != 1669485411) {
            return null;
        }
        boolean notFinishedOptions = true;
        while (packet.position() < packet.limit() && notFinishedOptions) {
            byte optionType = packet.get();
            if (optionType == -1) {
                notFinishedOptions = false;
                continue;
            }
            int optionLen = packet.get();
            int expectedLen = 0;
            switch (optionType) {
                case 1: {
                    netMask = DhcpPacket.readIpAddress(packet);
                    expectedLen = 4;
                    break;
                }
                case 3: {
                    gateway = DhcpPacket.readIpAddress(packet);
                    expectedLen = 4;
                    break;
                }
                case 6: {
                    expectedLen = 0;
                    for (expectedLen = 0; expectedLen < optionLen; expectedLen += 4) {
                        dnsServers.add(DhcpPacket.readIpAddress(packet));
                    }
                    break;
                }
                case 12: {
                    expectedLen = optionLen;
                    hostName = DhcpPacket.readAsciiString(packet, optionLen);
                    break;
                }
                case 15: {
                    expectedLen = optionLen;
                    domainName = DhcpPacket.readAsciiString(packet, optionLen);
                    break;
                }
                case 28: {
                    bcAddr = DhcpPacket.readIpAddress(packet);
                    expectedLen = 4;
                    break;
                }
                case 50: {
                    requestedIp = DhcpPacket.readIpAddress(packet);
                    expectedLen = 4;
                    break;
                }
                case 51: {
                    leaseTime = packet.getInt();
                    expectedLen = 4;
                    break;
                }
                case 53: {
                    dhcpType = packet.get();
                    expectedLen = 1;
                    break;
                }
                case 54: {
                    serverIdentifier = DhcpPacket.readIpAddress(packet);
                    expectedLen = 4;
                    break;
                }
                case 55: {
                    expectedParams = new byte[optionLen];
                    packet.get(expectedParams);
                    expectedLen = optionLen;
                    break;
                }
                case 56: {
                    expectedLen = optionLen;
                    message = DhcpPacket.readAsciiString(packet, optionLen);
                    break;
                }
                case 60: {
                    expectedLen = optionLen;
                    vendorId = DhcpPacket.readAsciiString(packet, optionLen);
                    break;
                }
                case 61: {
                    byte[] id2 = new byte[optionLen];
                    packet.get(id2);
                    expectedLen = optionLen;
                    break;
                }
                default: {
                    for (int i = 0; i < optionLen; ++i) {
                        ++expectedLen;
                        byte throwaway = packet.get();
                    }
                }
            }
            if (expectedLen == optionLen) continue;
            return null;
        }
        switch (dhcpType) {
            case -1: {
                return null;
            }
            case 1: {
                newPacket = new DhcpDiscoverPacket(transactionId, clientMac, broadcast);
                break;
            }
            case 2: {
                newPacket = new DhcpOfferPacket(transactionId, broadcast, ipSrc, yourIp, clientMac);
                break;
            }
            case 3: {
                newPacket = new DhcpRequestPacket(transactionId, clientIp, clientMac, broadcast);
                break;
            }
            case 4: {
                newPacket = new DhcpDeclinePacket(transactionId, clientIp, yourIp, nextIp, relayIp, clientMac);
                break;
            }
            case 5: {
                newPacket = new DhcpAckPacket(transactionId, broadcast, ipSrc, yourIp, clientMac);
                break;
            }
            case 6: {
                newPacket = new DhcpNakPacket(transactionId, clientIp, yourIp, nextIp, relayIp, clientMac);
                break;
            }
            case 8: {
                newPacket = new DhcpInformPacket(transactionId, clientIp, yourIp, nextIp, relayIp, clientMac);
                break;
            }
            default: {
                System.out.println("Unimplemented type: " + dhcpType);
                return null;
            }
        }
        newPacket.mBroadcastAddress = bcAddr;
        newPacket.mDnsServers = dnsServers;
        newPacket.mDomainName = domainName;
        newPacket.mGateway = gateway;
        newPacket.mHostName = hostName;
        newPacket.mLeaseTime = leaseTime;
        newPacket.mMessage = message;
        newPacket.mRequestedIp = requestedIp;
        newPacket.mRequestedParams = expectedParams;
        newPacket.mServerIdentifier = serverIdentifier;
        newPacket.mSubnetMask = netMask;
        return newPacket;
    }

    public static DhcpPacket decodeFullPacket(byte[] packet, int pktType) {
        ByteBuffer buffer = ByteBuffer.wrap(packet).order(ByteOrder.BIG_ENDIAN);
        return DhcpPacket.decodeFullPacket(buffer, pktType);
    }

    public static ByteBuffer buildDiscoverPacket(int encap, int transactionId, byte[] clientMac, boolean broadcast, byte[] expectedParams) {
        DhcpDiscoverPacket pkt = new DhcpDiscoverPacket(transactionId, clientMac, broadcast);
        pkt.mRequestedParams = expectedParams;
        return ((DhcpPacket)pkt).buildPacket(encap, (short)67, (short)68);
    }

    public static ByteBuffer buildOfferPacket(int encap, int transactionId, boolean broadcast, InetAddress serverIpAddr, InetAddress clientIpAddr, byte[] mac, Integer timeout, InetAddress netMask, InetAddress bcAddr, InetAddress gateway, List<InetAddress> dnsServers, InetAddress dhcpServerIdentifier, String domainName) {
        DhcpOfferPacket pkt = new DhcpOfferPacket(transactionId, broadcast, serverIpAddr, clientIpAddr, mac);
        pkt.mGateway = gateway;
        pkt.mDnsServers = dnsServers;
        pkt.mLeaseTime = timeout;
        pkt.mDomainName = domainName;
        pkt.mServerIdentifier = dhcpServerIdentifier;
        pkt.mSubnetMask = netMask;
        pkt.mBroadcastAddress = bcAddr;
        return ((DhcpPacket)pkt).buildPacket(encap, (short)68, (short)67);
    }

    public static ByteBuffer buildAckPacket(int encap, int transactionId, boolean broadcast, InetAddress serverIpAddr, InetAddress clientIpAddr, byte[] mac, Integer timeout, InetAddress netMask, InetAddress bcAddr, InetAddress gateway, List<InetAddress> dnsServers, InetAddress dhcpServerIdentifier, String domainName) {
        DhcpAckPacket pkt = new DhcpAckPacket(transactionId, broadcast, serverIpAddr, clientIpAddr, mac);
        pkt.mGateway = gateway;
        pkt.mDnsServers = dnsServers;
        pkt.mLeaseTime = timeout;
        pkt.mDomainName = domainName;
        pkt.mSubnetMask = netMask;
        pkt.mServerIdentifier = dhcpServerIdentifier;
        pkt.mBroadcastAddress = bcAddr;
        return ((DhcpPacket)pkt).buildPacket(encap, (short)68, (short)67);
    }

    public static ByteBuffer buildNakPacket(int encap, int transactionId, InetAddress serverIpAddr, InetAddress clientIpAddr, byte[] mac) {
        DhcpNakPacket pkt = new DhcpNakPacket(transactionId, clientIpAddr, serverIpAddr, serverIpAddr, serverIpAddr, mac);
        pkt.mMessage = "requested address not available";
        pkt.mRequestedIp = clientIpAddr;
        return ((DhcpPacket)pkt).buildPacket(encap, (short)68, (short)67);
    }

    public static ByteBuffer buildRequestPacket(int encap, int transactionId, InetAddress clientIp, boolean broadcast, byte[] clientMac, InetAddress requestedIpAddress, InetAddress serverIdentifier, byte[] requestedParams, String hostName) {
        DhcpRequestPacket pkt = new DhcpRequestPacket(transactionId, clientIp, clientMac, broadcast);
        pkt.mRequestedIp = requestedIpAddress;
        pkt.mServerIdentifier = serverIdentifier;
        pkt.mHostName = hostName;
        pkt.mRequestedParams = requestedParams;
        ByteBuffer result = ((DhcpPacket)pkt).buildPacket(encap, (short)67, (short)68);
        return result;
    }
}

